Polymath definitions

Local
 6 integer variable msize
 1 integer variable bp
 0 integer variable stking
 5 integer variable nbuffers
   integer array(nbuffers) buff

: >> stking-1 max(0) --> stking      ;
: << stking+1        --> stking      ;
: ClrStacking      0 --> stking      ;

\ ********************  Matrix Class  ********************

Global
Polymath Class Matrix
Local

   Real Array(Msize,Msize) mat
   integer variable        nr
   integer variable        nc
   integer variable        mark

---
    integer array(21) S
 1  integer Variable  top
 1  integer Variable  bottom
 2  integer variable  form

: Circular -1 mod(21) +1 ;

Global
: stk >#
  If(#)
     Circular(top+1) --> top
     --> S(top)
     If(top=bottom)
        Circular(bottom+1) --> bottom
     endif
  else
     If(top=bottom)
        0
        Compile Real
     else
        S(top)
        Circular(top+20) --> top
     endif
  endif;

Local
Hide Circular

: Initialize
  0 --> nr
  0 --> nc
  0 --> mark ;

: Reading
  pointer
  If(stking=0)
    --> stk
  else
     drop
  endif;

: SetMark  1 --> mark ;
: UnMark   0 --> mark ;

Global
Polymath definitions
Local

   Matrix variable buff1  find buff1  --> buff(1)
   Matrix variable buff2  find buff2  --> buff(2)
   Matrix variable buff3  find buff3  --> buff(3)
   Matrix variable buff4  find buff4  --> buff(4)
   Matrix variable buff5  find buff5  --> buff(5)

Global Matrix variable evec

: Circular -1 mod(nbuffers) +1 ;

: z buff(bp) execute ;

: ClearMarks <<
  Do(1,nbuffers)
     execute(buff(i)) unmark
  Loop >>
  1 --> bp
  z ;

: Clear
  1 --> bottom
  1 --> top
  ClrStacking
  ClearMarks ;

: nextZ <<
  1 { k }
  begin
     z(Circular(bp+1) --> bp)
     If(mark=0)
        SetMark >> z
        return(true)
     endif
     k+1 --> k
  Until(k=nbuffers) >>
  Message('The matrix buffers are all marked.')
  ClearMarks
  stop(true);

: ShowMarks <<
  fix(0)
  Do(1,nbuffers)
     String(i) justify(5)
     buff(i) execute String(mark) justify(5) &
     message
  Loop >>
  z ;

Matrix definitions Polymath
Local

  0.000001 Real variable eps

   Integer variable ii
   Integer variable jj
   Integer variable kk
   Integer variable imax
   Real    variable xmax

: with  i --> ;

Global
: sto <<
  stk stk [[ y x ]]
  nr(x) --> nr(y)
  nc(x) --> nc(y)
  Do(1,nr) with ii
     Do(1,nc) with jj
        mat(x,ii,jj) --> mat(y,ii,jj)
     Loop
  Loop unmark(x) >> ;

: ==> find execute sto ;

\ ----------------  Matrix Initialization  --------------------

: Zeros
  Do(1,msize) Do(1,msize)
     0 --> mat(i,j)
  Loop Loop;

: Set
  Min(Msize) --> nc
  Min(Msize) --> nr
  zeros ;

Set(evec,msize,msize) zeros

: Ones
  Do(1,nc) Do(1,nr)
     1 --> mat(i,j)
  Loop Loop;

: Identity
  Do(1,nc) Do(1,nr)
     If(i=j) 1 --> mat(i,j) else 0 --> mat(i,j) endif
  Loop Loop;

: Diagonal { x }
  Do(1,nc) Do(1,nr)
     If(i=j) x --> mat(i,j) else 0 --> mat(i,j) endif
  Loop Loop;

: Row { r }
  Do(nc,1)
     --> mat(r,i)
  iLoop(--1);

: Column { c }
  Do(nr,1)
     --> mat(i,c)
  iLoop(--1);

: EnterMatrix
  --> nc --> nr
  Do(nr,1) Do(nc,1)
     --> mat(j,i)
  iLoop(--1) iLoop(--1);

: Format --> form ;

\ -------------  Show  -----------------

: Display
  unmark
  If(form>=0)
     Fix(form)
  else
     sci(abs(form))
  endif
  Do(1,nr)
     Do(1,nc)
        &(String(Mat(j,i)) Justify(13))
     Loop Message
  Loop ;


\ -------------  Addition  -----------------

Local
: AddError { x y }
  If(x<>y)
     ClrStacking
     Message('These two matrices are not compatible in size.')
     ClearMarks
     Stop(true)
  Endif;

Global
: + <<
  stk stk [[ y x ]]
  nextZ
  AddError( nr(x),nr(y) )
  AddError( nc(x),nc(y) )
   nr(x) --> nr(z)
   nc(x) --> nc(z)
   Do(1,nc) Do(1,nr)
      mat(x,i,j)+mat(y,i,j) --> mat(z,i,j)
   Loop Loop unmark(x) unmark(y) >>
   z ;

: - <<
  stk stk [[ y x ]]
  nextZ
  AddError( nr(x),nr(y) )
  AddError( nc(x),nc(y) )
  nr(x) --> nr(z)
  nc(x) --> nc(z)
  Do(1,nc) Do(1,nr)
     mat(x,i,j)-mat(y,i,j) --> mat(z,i,j)
  Loop Loop unmark(x) unmark(y) >>
  z ;

: Scalar <<
  { factor }
  stk [[ x ]]
  nextZ
  nr(x) --> nr(z)
  nc(x) --> nc(z)
  Do(1,nc) Do(1,nr)
     mat(x,i,j)*factor --> mat(z,i,j)
  Loop Loop unmark(x) >>
  z ;

\ -------------  Multiplication  -----------------

Local
: MultError { xc,yr }
  If( xc<>yr )
     ClrStacking
     Message('These two matrices are not compatible in size.')
     ClearMarks
     Stop(true)
  Endif;

Global polymath
: * <<
  stk stk [[ y x ]]
  nextZ
  MultError( nc(x),nr(y) )
  nr(x) --> nr(z)
  nc(y) --> nc(z)
  nr(x) nc(x) nc(y)  { a,b,c }

  Do(1,a) with ii
     Do(1,c) with jj
        0
        Do(1,b) with kk
           +( mat(x,ii,kk)*mat(y,kk,jj) )
        Loop
        --> mat(z,ii,jj)
     Loop
  Loop unmark(x) unmark(y) >>
  z  ;

\ -------------  Transpose  -----------------

: T <<
  stk [[ x ]]
  nextZ
  nr(x) nc(x) --> nr(z) --> nc(z)
  Do(1,nr(x)) with ii
     Do(1,nc(x)) with jj
        mat(x,ii,jj) --> mat(z,jj,ii)
     Loop
  Loop unmark(x) >>
  z ;

\ -------------  Solve Simultaneous Equations  -----------------

Local
: getMax { a i }
  If( abs(a)>abs(xmax) )
     a --> xmax
     i --> imax
  endif;

Global
: Solve nextZ sto   stk(z) [[ v ]]
        nextZ sto   stk(z) [[ u ]]

  <<

  If(u nr<>nc)
     Message('The first matrix entered is not a square matrix.')
     ClearMarks
     stop(true)
  endif

  nextZ

  nr(u) { n  }
  nc(v) { nq }

  n --> nr(z)
 nq --> nc(z)

\ Forward Solution

  Do(1,n) with kk
     u
     Eps --> xmax
     Do( kk,n ) with ii
        GetMax(mat(ii,kk),ii)
     Loop

     If(abs(xmax)<eps)
        Message('This matrix is singular!')
        ClearMarks
        Stop(true)
     endif

     Do(kk,n) with jj
            mat(imax,jj)/xmax        mat(kk,jj)
        --> mat(imax,jj)         --> mat(kk,jj)
     Loop

     v
     Do(1,nq) with jj
         mat(imax,jj)/xmax           mat(kk,jj)
     --> mat(imax,jj)            --> mat(kk,jj)
     Loop

     If(kk<>n)
        Do(kk+1,n) with ii
           u
           Do(kk+1,n) with jj
              mat(ii,jj)-(mat(ii,kk)*mat(kk,jj))
              --> mat(ii,jj)
           Loop
           Do(1,nq) with jj
              mat(v,ii,jj)-(mat(u,ii,kk)*mat(v,kk,jj))
              --> mat(v,ii,jj)
           Loop
        Loop
     endif

  Loop

\ Back Solution

  Do(1,nq) with kk
     mat(v,n,kk) --> mat(z,n,kk)
     Do(n-1,1) with ii
        mat(v,ii,kk) --> mat(z,ii,kk)
        Do(ii+1,n)  with jj
            mat(z,ii,kk)-(mat(u,ii,jj)*mat(z,jj,kk))
           --> mat(z,ii,kk)
        Loop
     iLoop(--1)
  Loop unmark(u) unmark(v) >>
  z  ;

\ ---------------  Inverse of Matrix  ----------------

: inv nr nr nextZ  --> nc --> nr identity solve;

\ ---------------  Eigenvalues -----------------------

integer variable ip
integer variable jp
: sq dup * ;
: invr 1/swap ;
: field string 10 justify ;

Polymath
: Eigen nextZ sto   stk(z) [[  a  ]]
        nextZ       stk(z) [[ val ]]
  <<

  nr(a) dup    Set(evec) Identity(evec)
  nr(a) 1      Set(val)

  0            { trace  }
  mat(a,1,2)   { thresh }
  nr(a)        { n      }

  do(1,n-1)
     mat(a,i,i)+trace --> trace
     i+1              { ip1 }
     do(ip1,n)
        Max(abs(mat(a,j,i)) thresh) --> thresh
     loop
  loop
  mat(a,n,n)+trace --> trace

  trace*0.000000000000000000001  { fod }

  begin while(thresh>fod)
     begin
        thresh/10 --> thresh
        If(thresh<fod)
           fod --> thresh
        endif
        begin
           0 { redo }
           do(1,n-1) with ip
              ip-1 { ipm1 }
              ip+1 { ipp1 }
              do(ipp1,n) with jp
                 If(abs(mat(a,ip,jp))>=thresh)
                    break
                    1 --> redo
                    mat(a,ip,ip)-mat(a,jp,jp)            { del }
                    sqrt(del*del +(4*sq(mat(a,ip,jp))))  { rad }
                    If(del<0)
                       --rad                          --> rad
                    endif
                    2*mat(a,ip,jp)/(del+rad)          { tn }
                    invr(sqrt(1+sq(tn)))              { cs }
                    tn*cs                             { sn }
                    jp-1 { jpm1 }
                    jp+1 { jpp1 }
                    If(ip<>1)
                       do(1,ipm1)
                            (mat(a,i,ip)*cs)+(mat(a,i,jp)*sn)
                          --(mat(a,i,ip)*sn)+(mat(a,i,jp)*cs)
                          --> mat(a,i,jp)
                          --> mat(a,i,ip)
                       loop
                    endif

                    If(ipp1<>jp)
                       do(ipp1,jpm1)
                            (mat(a,ip,i)*cs)+(mat(a,i,jp)*sn)
                          --(mat(a,ip,i)*sn)+(mat(a,i,jp)*cs)
                          --> mat(a,i,jp)
                          --> mat(a,ip,i)
                       loop
                    endif

                    If(jp<>n)
                       do(jpp1,n)
                            (mat(a,ip,i)*cs)+(mat(a,jp,i)*sn)
                          --(mat(a,ip,i)*sn)+(mat(a,jp,i)*cs)
                          --> mat(a,jp,i)
                          --> mat(a,ip,i)
                       loop
                    endif

                    mat(a,ip,ip)          { aipip }
                    mat(a,jp,jp)          { ajpjp }
                    sq(cs)                { cs2   }
                    sq(sn)                { sn2   }
                    2*mat(a,ip,jp)*sn*cs  { asc   }

                    (aipip*cs2)+(ajpjp*sn2)+asc  -->  mat(a,ip,ip)
                    (aipip*sn2)+(ajpjp*cs2)-asc  -->  mat(a,jp,jp)
                    0                            -->  mat(a,ip,jp)

                    do(1,n)
                         (mat(evec,i,ip)*cs)+(mat(evec,i,jp)*sn)
                       --(mat(evec,i,ip)*sn)
                        +(mat(evec,i,jp)*cs)
                       --> mat(evec,i,jp)
                       --> mat(evec,i,ip)
                    loop
                 endif
              loop
           loop
        until(redo=0)
     until(thresh<=fod)
  repeat

  do(1,n)
     mat(a,i,i) --> mat(val,i,1)
  loop
  unmark(a) unmark(val) unmark(evec) >> evec val ;

Polymath definitions

: MCalc
  Compile Matrix
  11 assign("Mcalc")
  12 assign("Display")
  Compile Polymath
  explanation ; invisible

Localize

: Startup
  11 assign("Mcalc")
  blk("Matrix")
  MCalc ; invisible

11 assign Mcalc

Matrix definitions

Document Matrix
This application package offers up a matrix calculator.  It would be
somewhat slow for serious number crunching, but it does provide a
convenient environment for solving smaller matrix problems
interactively.  Matrix operations that are supported here are:

          Addition           Subtraction
          Multiplication     Multiplication by a scalar
          Inversion          Solve simultaneous equations
          Transpose          Eigenvalues and vectors

Once the contents of the matrices are defined, they are then manipulated
as you would simple variables.  For example, if we had defined matrices
[a] and [b], then a particular transformation of [a] might be obtained
by multiplying the inverse of [b] by [a], and then multiplying the
resulting product by [b].  With this application package, this triple
product would be obtained by typing:

          (a,inv)*b*a
.BRE
Matrix "objects" are first created just as you would a simple variable:

             Matrix variable a   Matrix variable b

To define the contents of a matrix, it is necessary to define the size,
or dimensions, of the matrix as well as the actual terms.  The following
words all set the dimensions of a matrix and also initialize the contents:

     Identity  -  Constructs an "identity" matrix, which consists of one
                  along the diagonal, a values of zero everywhere else.
                  Example:  Identity(a,3,3)
     Diagonal  -  Similar to the identity matrix, this word allows you
                  to set the diagonal to any value.
                  Example:  Diagonal(b,pi,3,3)
     Ones      -  All terms of the matrix are set to a value of one.
                  Example:  Ones(a,3,2)
     Zeros     -  All terms of the matrix are set to a value of zero.
                  Example:  Zeros(b,3,6)
.BRE
The following are words which operate on the matrices:

    Inv   - Inversion (e.g. Inv(a)   or  (a,inv) )
    Solve - Solve the matrix equation  [a][x] = [b] for the matrix [x]
            Simply type: Solve(a,b)
    T     - Transpose (e.g. T(a), or (a,t))
    *     - Matrix multiplication.  The matrix objects a & b know to
            use matrix multiplication and not ordinary multiplication.
            For example: a*b.
   Scalar - Scalar multiplication - Multiply every term of a matrix by
            a single real value.  (e.g. Scalar(0.5,a) or Scalar(a,0.5))
   -      - Subtraction (e.g. a-b)
   +      - Addition (e.g. a+b)
.BRE
All the examples so far will not result in anything being displayed on
the screen.  This is easily accomplished, however, with the word
"Display."  For example, to display the product of matrices [x] & [y],
you would type:

          Display(x*y)

Remember that this application is designed so that matrices are never
destroyed by any of the matrix operations.  This means that the
following statements may be entered:

          Display((x,inv)*y*x)
          Display((x,t)*y*x)
          Display(x*y)

and the matrices [x] and [y] do not need to be redefined to their
initial values.
.BRE
The word "format" is provided to control the appearance of the display.
If positive, then it designates the number of digits to be displayed
after the decimal point in a "fixed" format.  If negative, then it
designates the number of digits to be displayed after the decimal point
in scientific notation.  It is initially set to -4.

So far matrix variables look just like normal variables when they are
read from.  They also look the same when writing.  For example, if we
want to calculate the inverse of a matrix and store the result in a new
matrix, it might look something like this:

          Matrix variable xi
          Inv(x)  sto(xi)

Then, the following two statements would result in the same display:

          Display( inv(x) )
          Display(  xi    )$

Document Eigen
Eigen (Ma --- Mb Evec)

Calculate the eigenvalues and eigenvectors using the Jacobi method.  The
input matrix should be symmetric.  Only the upper half is used.

A column vector of eigenvalues is left on the matrix stack and may be
displayed on the screen with DISPLAY.  The eigenvectors are written
directly to a matrix by the name of EVEC.$

Document Inv
Inv  ( Ma --- Mb )
Return the inverse of a matrix.  This can be accomplished only for
square matrices, or matrices where the number of rows is equal to the
number of columns.  The inverse of a matrix ([a] in this example) is
defined by the following equation where the inverse of [a] is
represented by [b]:

          [a][b] = [I]

[I] is the identity matrix.  A 3x3 identity matrix would look like this:

          |  1   0   0  |
          |  0   1   0  |
          |  0   0   1  |

Restrictions:

     This operation can only be performed on a square matrix.$

Document Solve
Solve  ( Ma Mb --- mx )

This solves the following matrix equation where the matrices [a] & [b]
are known and the matrix [x] is unknown:

          [a][x] = [b]

This particular example would be entered as:

          Solve(a,b)      or,     Display(solve(a,b))

Restrictions:

     Matrix [a] must be square (# rows = # columns)
     The row dimension of [b] must match that of [a].  The column
     dimension can be any size.$

Document T
T  ( Ma --- Mb )

This calculates the transpose of a matrix which can be of any
dimension.$

Document *
*  ( Ma Mb --- Mc )

Matrix multiplication.  For example, Display(a*b).

Restrictions:

     Columns(a) = Rows(b)

The resulting matrix will have the following dimensions:

     Rows     = Rows(a)
     Columns  = Columns(b)$

Document Scalar
Scalar  ( Ma x --- Mb )

Scalar multiplication - Each term in matrix [a] is multiplied by the
scalar quantity x.

Restrictions:

     If x is produced by a real variable, enter it before the matrix
     [a].  In other words,

               Scalar(x,a)     and not as     Scalar(a,x)$

Document -
-  ( Ma Mb --- Mc )

Matrix subtraction.  Each term in [b] is subtracted from the
corresponding term in [a].  For example,

          Display(a-b)

Restrictions:

     The matrices [a] & [b] must have the same number of rows and
     columns.$

Document +
+  ( Ma Mb --- Mc )

Matrix addition.  Each term in [b] is added to the corresponding term in
[a].  For example,

          Display(a+b)

Restrictions:

     The matrices [a] & [b] must have the same number of rows and
     columns.$

Document Display
Display  ( Ma --- Ma )

Whatever matrix is "current" is displayed in the message area.  Note
that when a matrix is displayed, it is still current.  This allows a
matrix to be looked at, and then processed further.  Here are a few
examples:

          a Display
          Display(a)
          Display(a*b)
          Display(a+b) sto(c)$

Document EnterMatrix
EnterMatrix  ( x x x x
               . . .
               x x x x  nr nc Ma --- Ma )

Matrix [a] is dimensioned to nr by nc.  The entire contents of the matrix are
then taken from the stack.  For example,


              1 5 3
              3 4 9
              2 4 8 EnterMatrix(a,3,3)$

Document Column
Column  ( ? Ma c --- )

Enter a column of numbers into a matrix.  The dimensions of the matrix
must have already been defined.  (This can be done with:  Diagonal,
Identity, Ones, or Zeros.)  Here is an example where a matrix variable
is created, dimensioned, and the terms of the matrix set to various
values:

     Matrix variable vector

     Zeros(vector,3,1)

     Vector   1 2 3 Column(1)

In this example, the top term of the matrix is "1" and the bottom term
is "3".$

Document Row
Row  ( ? Ma r )

Very similar to "Column," this word enters a row of numbers into a
matrix.  The dimensions of the matrix must have already been defined.
(This can be done with:  Diagonal, Identity, Ones, or Zeros.)  Here is
an example where a matrix variable is created, dimensioned, and the
terms of the matrix set to various values:

     Matrix variable stiff

     Zeros(stiff,3,3)

     stiff     .9   1.4    2.8   row(1)
              1.4   2.7     .8   row(2)
              2.8    .8    1.5   row(3)$

Document Diagonal
Diagonal  ( x Ma --- Mb )

Each term along the diagonal of [a] is set to the real value of x, with all
other terms set to zero.$

Document Identity
Identity  ( Ma --- Mb )

Each term along the diagonal of [a] is set to the value of 1, with all other
terms set to zero.$

Document Ones
Ones  ( Ma --- Mb )

Each term in the matrix [a] is set to 1.$

Document Zeros
Zeros  ( Ma --- Mb )

Each term in the matrix [a] is set to 0.$

Document Set
Set  ( nr nc Ma --- Ma )

The matrix [a] is dimensioned to nr rows by nc columns.  Each term in the
matrix is then set to 0.$

Document Sto
Sto  ( Ma --- )

The matrix [a] is replaced by the contents of the current matrix.  It is
also redimensioned in the process.  Here are a few examples:

          a*b          sto(c)
          Display(x+y) sto(z)
          x-y          sto(x)$

Document Format
Format  ( n --- )

This sets the format of the numbers displayed in a matrix.  N represents
the number of digits to be displayed after the decimal point.  If it is
negative, then the terms are displayed in scientific notation.  Otherwise,
the terms are displayed in a fixed format.  Here are some examples:

                 Command               Display
             --------------          -----------

               4 --> format          3.1416
             --5 --> format          3.14159e+00$

Document MCalc
.cmd Matrix Explain ___ Message(".bre") MCalc
~Exit - Exit to the Polymath command screen

These are the words that are provided with the matrix calculator:

              ~Matrix   - A general introduction

~Column   - Input a column         ~Row         - Input a row
~Diagonal - Diagonal matrix.       ~Identity    - Identity matrix.
~Ones     - A matrix of ones.      ~Zeros       - A matrix of zeros.
~Set      - Initialize a matrix    ~EnterMatrix - Enter an entire matrix

~+        - Addition               ~Solve       - Solve a system of equations
~-        - Subtraction            ~Inv         - Matrix inverse
~*        - Multiplication         ~Eigen       - Eigenvalue solution
~Scalar   - Scalar multiplication  ~Sto         - Write to a matrix
~T        - Transpose

~Display  - Display a matrix.      ~Format      - Set the display format$

