*EXPENSE.PRG (09-26.a)

SWITCH TALK OFF
SWITCH ECHO OFF

DROP VARIABLE ALL
RESET DATABASE
RESET FORM
FORM TEXT 'Type:' 			AT 4  5
FORM TEXT 'Date:' 			AT 4 14
FORM TEXT '$ Amount:' 			AT 4 29
FORM TEXT 'Description:' 		AT 6  5
FORM TEXT '1 - office    3 - mileage    5 - travel      7 - publications' AT 8 5
FORM TEXT '2 - auto      4 - meals      6 - utilities' AT 9 5
FORM FIELD exptype PICTURE '#>'         AT 4 11
FORM FIELD expdate PICTURE '##/##/##>'  AT 4 19
FORM FIELD expamt  PICTURE '##########' AT 4 39
FORM FIELD expdesc WIDTH 50             AT 6 18

DOWHILE true
  CLEAR SCREEN
  DOMENU
    MENUTYPE VERT
    MENUTITLE '[ Expense Accounting Main Menu ]'
    MENUOPTION 'Add new records'
    MENUOPTION 'View and edit records'
    MENUOPTION 'Report Expenses in DATE SEQUENCE'
    MENUOPTION 'Report Expenses in TYPE SEQUENCE'
    MENUOPTION 'Total Expenses by TYPE'
    MENUOPTION 'Backup (EXPORT)'
    MENUOPTION 'Initialize Database'
    MENUOPTION 'Quit'
    MENUCHOICE choice
    ENDMENU
  CLEAR SCREEN
  DROP VARIABLE LIKE 'exp?????'
  DOCASE
    CASE choice = 1
      CREATE CURSOR 1 FOR personal
      USE CURSOR 1
      FORM HEADING '[ Expense Accounting ADD Data Records ]'
      FORM SHOW TEXT
      FORM SHOW FIELD ALL
      SHOW MESSAGE 'F1 - Help   F2 - Options'
      DOWHILE true
        FORM READ FIELD ALL
        DOCASE
	  CASE KEYPRESS() = 315
	    CREATE WINDOW 1 19 1 4 78 112 1 '[ ADD Help ]'
	    USE WINDOW 1
	    PAUSE
	    DROP WINDOW 1
	  CASE KEYPRESS() = 316
	    DOMENU
	      MENUTYPE VERT
	      MENUTITLE '[ ADD Options ]'
	      MENUOPTION 'Accept'
	      MENUOPTION 'Continue'
	      MENUOPTION 'Quit to Main Menu'
	      MENUCHOICE choice
	      ENDMENU
	    DOCASE
	      CASE choice = 1
		FORM INSERT INTO expense
		FORM CLEAR FIELD ALL
	      CASE choice = 2
	      CASE choice = 3
		CLEAR MESSAGE
		DROP FORM
		DROP CURSOR 1
		EXIT
	      ENDCASE	
	  OTHERWISE
	    SOUND
          ENDCASE
        ENDWHILE
    CASE choice = 2
      CREATE CURSOR 1 FOR personal
      USE CURSOR 1
      DOWHILE true
	FORM HEADING '[ Expense Accounting SEARCH Data Records ]'
	FORM SHOW TEXT
	FORM SHOW FIELD ALL
	SHOW MESSAGE 'Enter search criteria... F1 - Help   F2 - Options'
	FORM READ FIELD ALL
	CLEAR MESSAGE
	DOCASE
	  CASE KEYPRESS() = 315
	    CREATE WINDOW 1 19 1 4 78 112 1 '[ SEARCH Help ]'
	    USE WINDOW 1
	    PAUSE
	    DROP WINDOW 1
	  CASE KEYPRESS() = 316
	    DOMENU
	      MENUTYPE VERT
	      MENUTITLE '[ SEARCH Options ]'
	      MENUOPTION 'Search'
	      MENUOPTION 'Continue'
	      MENUOPTION 'Quit to Main Menu'
	      MENUCHOICE choice
	      ENDMENU
	    DOCASE
	      CASE choice = 1
		FORM SELECT FROM expense
		DROP FORM
		FORM HEADING '[ Expense Accounting EDIT Data Records ]'
		FORM SHOW TEXT
		SHOW MESSAGE 'Edit data... F1 - Help   F2 - Options'
		DOWHILE true
		  FETCH
		  IF ISEOF()
		    FORM CLEAR FIELD ALL
		    DROP FORM
		    EXIT
		    ENDIF
		  FORM SHOW FIELD ALL
		  FORM READ FIELD ALL
		  DOCASE
		    CASE KEYPRESS() = 315
		      CREATE WINDOW 1 19 1 4 78 112 1 '[ EDIT Help ]'
		      USE WINDOW 1
		      PAUSE
		      DROP WINDOW 1
		    CASE KEYPRESS() = 316
		      DOMENU
		        MENUTYPE VERT
		        MENUTITLE '[ EDIT Options ]'
		        MENUOPTION 'Next'
		        MENUOPTION 'Return to SEARCH'
		        MENUOPTION 'Update'
		        MENUOPTION 'Delete'
		        MENUCHOICE choice
		        ENDMENU
		      DOCASE
		        CASE choice = 1
		        CASE choice = 2
			  FORM CLEAR FIELD ALL
		          DROP FORM
		          EXIT
		        CASE choice = 3
		          FORM UPDATE expense
			  FORM CLEAR FIELD ALL
		          DROP FORM
		          EXIT
		        CASE choice = 4
		          FORM DELETE FROM expense
			  FORM CLEAR FIELD ALL
		          DROP FORM
		          EXIT
		        ENDCASE
		      ENDCASE
		  ENDWHILE
	      CASE choice = 2
		DROP FORM
	      CASE choice = 3
		CLEAR MESSAGE
		DROP FORM
		DROP CURSOR 1
		EXIT
	      ENDCASE	
	  OTHERWISE
	    SOUND
	  ENDCASE
	ENDWHILE
    CASE choice = 3
      CREATE CURSOR 1 FOR personal
      USE CURSOR 1
      CLEAR SCREEN
      SELECT exptype,expdate,expamt,expdesc FROM expense;
	ORDER BY expdate,exptype
      DOREPORT
	REPORT PAGE HEADING
	  PRINT SYSDATE SYSTIME ' Expenses in DATE Sequence' TAB 60 'Page ' SYSPAGE SKIP;
	    'Type   Date    $Amount Description'
	  END
	REPORT PAGE DETAIL
	  PRINT TAB 3 exptype TAB 6 expdate PICTURE '^^/^^/^^' TAB 15 expamt PICTURE '^,^^^.^^' TAB 24 expdesc
	  ASSIGN exptot+expamt TO exptot
	  END
	REPORT FINAL FOOTING
	  PRINT SKIP 'Total:' TAB 13 exptot PICTURE '$^^,^^^.^^'
	  END
	ENDREPORT
      DROP CURSOR 1
      PAUSE 'All done ... Press a key to continue ...'
      CLEAR SCREEN
    CASE choice = 4
      CREATE CURSOR 1 FOR personal
      USE CURSOR 1
      CLEAR SCREEN
      SELECT exptype,expdate,expamt,expdesc FROM expense;
	ORDER BY exptype,expdate
      DOREPORT
	REPORT PAGE HEADING
	  PRINT SYSDATE SYSTIME ' Expenses in TYPE Sequence' TAB 60 'Page ' SYSPAGE SKIP;
	    'Type   Date    $Amount Description'
	  END
	REPORT FOOTING BREAK AT exptype
	  PRINT 'Subtotal:' TAB 13 expstot PICTURE '$^^,^^^.^^'
	  ASSIGN 0 to expstot
	  END
	REPORT HEADING BREAK AT exptype
	  PRINT SKIP
	  END
	REPORT PAGE DETAIL
	  PRINT TAB 3 exptype TAB 6 expdate PICTURE '^^/^^/^^' TAB 15 expamt PICTURE '^,^^^.^^' TAB 24 expdesc
	  ASSIGN exptot+expamt TO exptot
	  ASSIGN expstot+expamt TO expstot
	  END
	REPORT FINAL FOOTING
	  PRINT SKIP 'Total:' TAB 13 exptot PICTURE '$^^,^^^.^^'
	  END
	ENDREPORT
      DROP CURSOR 1
      PAUSE 'All done ... Press a key to continue ...'
      CLEAR SCREEN
    CASE choice = 5
      CREATE CURSOR 1 FOR personal
      USE CURSOR 1
      CLEAR SCREEN
      SELECT exptype,expamt FROM expense ORDER BY exptype
      DOREPORT
	REPORT PAGE HEADING
	  PRINT SYSDATE SYSTIME ' Expense Summary by TYPE' TAB 60 'Page ' SYSPAGE
	  END
	REPORT FOOTING BREAK AT exptype
	  PRINT TAB 22 expstot PICTURE '$^^,^^^.^^'
	  ASSIGN 0 to expstot
	  END
	REPORT HEADING BREAK AT exptype
	  PRINT SKIP 'Subtotal for type ' exptype SKIP 0
	  END
	REPORT PAGE DETAIL
	  ASSIGN exptot+expamt TO exptot
	  ASSIGN expstot+expamt TO expstot
	  END
	REPORT FINAL FOOTING
	  PRINT SKIP 'Total for all types: ' TAB 22 exptot PICTURE '$^^,^^^.^^'
	  END
	ENDREPORT
      DROP CURSOR 1
      PAUSE 'All done ... Press a key to continue ...'
      CLEAR SCREEN
    CASE choice = 6
      CREATE CURSOR 1 FOR personal
      USE CURSOR 1
      CLEAR SCREEN
      PAUSE 'Insert backup discette into drive a ... press a key'
      SHOW 'EXPORTing table expense to a:expense.dat'
      SELECT exptype,expdate,expamt,expdesc FROM expense
      EXPORT TO a:expense.dat
      DROP CURSOR 1
      CLEAR SCREEN
    CASE choice = 7
       IF ISYES("Are you sure?")
         CLEAR SCREEN
         SHOW 'Creating database PERSONAL'
         CREATE DATABASE personal
         SHOW 'Creating table EXPENSE'
         CREATE CURSOR 1 FOR personal
         USE CURSOR 1
         CREATE TABLE expense;
           (exptype CHAR(1),expdate CHAR(8),expamt NUMBER,expdesc CHAR(50))
         DROP CURSOR 1
         ENDIF
      CLEAR SCREEN
    CASE choice = 8
      RETURN
    ENDCASE
  ENDWHILE
