#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <conio.h>

#include <pal.h>

void main (int argc, char * argv[])
{
   DBDESC *pDD;
   void   *pData, *pField;
   int     r,f, page =1, error;

   if(argc < 2) FatalExit("\nUSAGE: show <dbfile>\n",1);

   /* open database */
   pDD = OpenDatabase(argv[1], &error);

   if(!pDD) {
      TextMode();
      fprintf(stderr,"\aFatal Error #%d opening database.\n", error);
      exit(1);
   }


   /* show all records */
   for(r=0; r<pDD->NumDataRec; r++) {

      /* read a record */
      pData = ReadRecord(pDD, TYPE_DATA, r);

      /* show the record */
      if(pData) {

         /* show all fields */
         for(f=0;f<pDD->NumFields;f++) {

            /* get field data */
            pField = GetField(pDD, f, pData);
            if(pField) printf("%s = %s\n",pDD->pFDEF[f]->Name, pField);
            free(pField);
         }

         getch();

         /* discard record */
         free(pData);
      }
   }

    /* close database */
   CloseDatabase(pDD);


}
