/*
 * BMPPCX.H -- headers for BMP and PCX format
 *             for EScan.exm
 *                                    Toshiki
 *                                    <toshiki@j.email.ne.jp>
 */

/* BMP Header*/

typedef struct BMPHEADERs {
								/* === BITMAPFILEHEADER (14 bytes) */
UINT			bfType; 		/* 'B'+ 'M'*0x100 =BitMap*/
unsigned long	bfSize;			/*file size: header + table + data */
int				bfReserved1;
int				bfReserved2;
unsigned long	bfOffBits;		/* 14+40+ table length */
								/* === END BITMAPFILEHEADER */
								/* === BITMAPINFOHEADER (40 bytes) */
unsigned long	biSize;			/* =40 */
unsigned long	biWidth;		/* w */
unsigned long	biHeight;		/* h */
int				biPlanes;		/* =1 */
int				biBitCount;		/* =24, 8 ,4 or 1 bpp */
unsigned long	biCompression;	/* BI_RGB(=0L) for no compression */
unsigned long	biSizeImage;	/* bytes */
unsigned long	biXPelsPerMeter;/* */
unsigned long	biYPelsPerMeter;/* */
unsigned long	biClrUsed;		/* 0 for max allowed by biBitCount */
unsigned long	biClrImportant;	/* 0 for all */
								/* === END BITMAPINFOHEADER */
} BMPHEADER;

/*
 *  pColor = ((LPSTR) pBitmapInfo + (WORD) (pBitmapInfo -> biSize))
 */



typedef struct PCXHEADERS {
  char Manufacturer;	/* =10 (Constant) */
  char Version;			/* =5 for Ver 3.0 */
  char Encoding;		/* =1 for PCX run length encoding */
  char BitsPerPixel;	/* bits/pixel per plane */
  int Window[4];		/* Xmin, Ymin, Xmax, Ymax (inclusive) */
  int HRes;				/* Horizontal Resolution */
  int VRes;				/* Vertical Resolution */
  UCHAR Colormap[48];	/* Color Pallet Setting (3 x 16 colors) */
  						/* 0,0,0, 255,255,255, 0,170,0, 0,170,170...*/
  char Reserved;		/* =0 */
  char NPlanes;			/* Number of Color Plane */
  int BytesPerLine;		/* Number of Bytes per scan line per */
  						/* color plane */
  int PaletteInfo;		/* 1 for Color/BW, 2 for grayscale */
  char Filler[58];
} PCXHEADER;

/* ICN Header */
typedef struct ICNHEADERs {
 int x1, y1, x2, y2;
} ICNHEADER;
