//	mkems24.c - Make ems file for Hp200LX 4Mb model
//	Copyright (c) 1999 David Becher (davidb@netmedia.net.il)

#include <sys\stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <io.h>
#include <ctype.h>
#include <dos.h>
#include <dosdisk.h>

/*#define _DEBUG */
#define SECT_SIZE  512

char *cpMessage1 = "MkEms24 ver1.00 Copyright(C) 1999 David Becher";
char *cpMessage2 = "Usage: mkems24 <page>\n"
				   "Page = 1..2048\n\n";
char *cpFileName   	= "C:\\EMM240.DAT";
int  idDrive = 'C' - 'A';
const WORD wClstPerPage	= 16 * 1024 / SECT_SIZE; /* page size is 16k */
FP_DPB     fpDPB = 0;
P_DIRENT   pDir = NULL;
P_FAT      pFAT = NULL;

void Fatal (char *Msg)
{
	printf ("MKEMS24 ERROR: %s\n", Msg);
	exit (1);
}

int FExist (char *Name)
{
	FILE *f;
	int iRet;

	if ((f = fopen (Name, "r")) != NULL)
	{
		iRet = 1;
		fclose (f);
	}
	else
		iRet = 0;
	return iRet;
}


int EMMExists (void)
/* returns 1 if an EMS device driver is already loaded */
{
	return FExist("EMMXXXX0") || FExist("$MMXXXX0");
}


void CheckDiskSize (void)
/* checks if chipset issupported by this program version */
{
	/* ---- previous version removed ----------
	int currsize, growsize, shrnksize, ramsize;
	_DX = 1;
	_AX = 0xff02;
	geninterrupt (0x13);
	currsize  = _CX;
	growsize  = _BX;
	shrnksize = _AX;
	ramsize = currsize + growsize * 8 + 640 + 32;
	return (ramsize == 4096);
	------- end previous version -------------*/
	static char far *fpChipset = (char far *)0x04c8L;
	int chipArr[4];

	if ( (chipArr[0] = fpChipset[0]) == 8)
		if ( (chipArr[1] = fpChipset[1]) == 0)
			if ((chipArr[2] = fpChipset[2]) != 0)
				if ( (chipArr[3] = fpChipset[3]) == 0)
					return;
	printf ("Chipset: %d, %d, %d, %d\n", 
			chipArr[0], chipArr[1], chipArr[2], chipArr[3]);
	Fatal ("This memory chip setup is not supported");
}


WORD searchFreeBlock (WORD wTopClst, WORD wEndClst, WORD wLen)
{
	WORD i;

	while (wTopClst < wEndClst - wClstPerPage)
	{
		for (i = 0; i < wLen; i++)
			if (pFAT[wTopClst + i] != 0)
				goto NEXT_BLOCK;
		return wTopClst;
	  NEXT_BLOCK:
		wTopClst += wClstPerPage;
	}
	return 0;
}


void linkClst(WORD wTopClst, WORD wLen)
{
	WORD i;

	for (i = 0; i < wLen; i++)
		pFAT[wTopClst + i] = wTopClst + i + 1;
	pFAT[wTopClst + wLen - 1] = 0xffff;  /* EOF marker */
}


int searchDir (WORD wMaxEnt, char *cpName)
{
	WORD w;
	int  i;

	for (w = 0; w < wMaxEnt; w++)
	{
		for (i = 0; i< FILENAME_LEN; i++)
		{
			if (pDir[w].cpName[i] != cpName [i])
				goto NEXT_DIRENT;
		}
		return w;
	  NEXT_DIRENT:
		;
	}
	return -1;
}


void flushDiskBuffers ()
/* Flushes all DOS disk buffers */
{
	_AH = 0x0d;
	geninterrupt (0x21);
}


int getDPB (int idDrive, FP_DPB *pfpDPB)
{
	int ir;

	asm {
		mov		si, ds;
		mov	    es, si;
		mov		dx, idDrive
		mov		ah, 0x32;
		int		0x21
		mov		ir, ax
		push	ds
		mov     di, [pfpDPB]
		mov		es:[di], bx
		pop     bx
		mov     es:[di+2], bx
		mov		ds, si
	}
	return (ir == 0xFF) ? 0 : 1;
}


#ifdef _DEBUG
int printDPB (FILE *f, FP_DPB fpDPB)
{
	fprintf (f, "Device Parameter Block\n"
				"~~~~~~~~~~~~~~~~~~~~~~\n");
	fprintf (f, "Drive No:                         %d\n", fpDPB->driveNo);
	fprintf (f, "Unit No:                          %d\n", fpDPB->unitNo);
	fprintf (f, "Bytes per Sector :                %d\n", fpDPB->bytesPerSector);
	fprintf (f, "Sectors per Cluster :             %d\n", fpDPB->sectorsPerCluster);
	fprintf (f, "Shift Count:                      %d\n", fpDPB->shift);
	fprintf (f, "Boot Sectors:                     %d\n", fpDPB->bootSectors);
	fprintf (f, "No of FATs:                       %d\n", fpDPB->copiesFAT);
	fprintf (f, "Max No of Root Directory Entries: %d\n", fpDPB->maxRootDir);
	fprintf (f, "First sector with user data:      %d\n", fpDPB->firstDataSector);
	fprintf (f, "Number of Data clusters:          %d\n", fpDPB->highestClst - 1);
	fprintf (f, "No of Sectors per FAT:            %d\n", fpDPB->sectorsPerFAT);
	fprintf (f, "First Directory Sector            %d\n", fpDPB->firstDirSector);
	fprintf (f, "Media Descriptor Byte:            %0x\n\n", fpDPB->mediaDescriptor);
	return 0;
}
#endif


int main (int argc, char *argv[])
{
	static char cpYN[200];

	WORD wEmsPages, wFirstCluster, emsSize, wDirLen;
	FILE *f;
	int iDirEnt, i;

	printf ("%s\n", cpMessage1);
	if (argc != 2)
	{
		printf (cpMessage2);
		return 1;
	}

	if (_osmajor < 5)
		Fatal ("This program is valid for DOS 5.00 +");

	CheckDiskSize ();

	wEmsPages = atoi (argv[1]);
	if (wEmsPages < 1 || wEmsPages >= 2048)
	{
		printf (cpMessage2);
		return 1;
	}

	emsSize = wEmsPages * wClstPerPage;
	if (EMMExists ())
		Fatal ("EMS Driver is currently active, please deactivate it");

	printf ("Create EMM240.DAT? ");
	gets (cpYN);
	if (toupper (cpYN[0]) != 'Y')
		Fatal("Program aborted");

	if ( (f = fopen (cpFileName, "rb")) != NULL)
	{
		if (!(i = fclose (f)))
			if (!(i = chmod (cpFileName, S_IREAD | S_IWRITE)))
				i = unlink (cpFileName);
		if (i != 0)
			Fatal ("Unable to delete current EMM240.Dat");
	}

	if (!getDPB (idDrive + 1, &fpDPB))
		Fatal ("Illegal drive");

#ifdef _DEBUG
	printDPB (stdout, fpDPB); 
#endif

	if (fpDPB->bytesPerSector != SECT_SIZE || fpDPB->sectorsPerCluster != 0)
		Fatal ("Cluster size must be 512 bytes");
	pFAT = (P_FAT) malloc (fpDPB->sectorsPerFAT * SECT_SIZE);
	wDirLen = fpDPB->firstDataSector - fpDPB->firstDirSector;
	pDir = (P_DIRENT) malloc ((wDirLen + 1) * SECT_SIZE);
	if (pFAT == NULL || pDir == NULL)
		Fatal("Not enough memory");

	if ((f = fopen (cpFileName, "w")) == NULL)
		Fatal("File creation error");
	else
		fclose (f);
	flushDiskBuffers ();

	if (absread (idDrive, fpDPB->sectorsPerFAT, fpDPB->bootSectors, pFAT) != 0)
	{
		remove (cpFileName);
		Fatal("FAT read error");
	}

	if (absread (idDrive, wDirLen, fpDPB->firstDirSector, pDir) != 0)
	{
		remove (cpFileName);
		Fatal("Directory read error");
	}

	/* we want wFirstCluster to be on a page (32 cluster) boundary, but in 
	   the FAT, it is an offset from firstDataSector
	 */

	wFirstCluster = (fpDPB->firstDataSector - 1 + wClstPerPage) / wClstPerPage * wClstPerPage
					- (fpDPB->firstDataSector - 1) + 1;
	wFirstCluster = searchFreeBlock (wFirstCluster, fpDPB->highestClst, emsSize);
	if (wFirstCluster == 0)
	{
		remove (cpFileName);
		Fatal ("Not enough free contiguous blocks");
	}
	linkClst (wFirstCluster, emsSize);

	iDirEnt = searchDir (fpDPB->maxRootDir, "EMM240  DAT");
	if (iDirEnt == -1)
	{
		remove (cpFileName);
		Fatal ("Directory not found");
	}
	pDir[iDirEnt].wTopClst = wFirstCluster;
	pDir[iDirEnt].lSize    = (long)wClstPerPage * SECT_SIZE * wEmsPages;

	for (i = 0; i < fpDPB->copiesFAT; i++)
	{
		if (abswrite (idDrive, fpDPB->sectorsPerFAT, 
					  fpDPB->bootSectors + fpDPB->sectorsPerFAT * i, pFAT) 
			!= 0)
		{
			remove (cpFileName);
			Fatal("FAT write error");
		}
	}

	if (abswrite (idDrive, wDirLen, fpDPB->firstDirSector, pDir) != 0)
	{
		remove (cpFileName);
		Fatal("Directory write error");
	}
	flushDiskBuffers ();
	chmod (cpFileName, S_IREAD);
	printf("%s created, use CHKDSK %s to check if contiguous\n", cpFileName, cpFileName);
	return 0;
}
