'/* TFNO.BAS  Find multiple occurrences of text in selected files */
'/*           By: Dale Thorn                                      */
'/*           Rev. 13.10.2000                                     */

'$include: 'basdef.h'
'$include: 'filekill.h'
'$include: 'getdir.h'
'$include: 'longname.h'
'$include: 'messages.h'
'$include: 'midchar.h'
'$include: 'parmstr1.h'
'$include: 'string.h'
'$include: 'tfind.h'
'$include: 'basdef.bas'
'$include: 'filekill.bas'
'$include: 'getdir.bas'
'$include: 'longname.bas'
'$include: 'messages.bas'
'$include: 'midchar.bas'
'$include: 'parmstr1.bas'
'$include: 'string.bas'
'$include: 'tfind.bas'
'$include: 'scrnparm.bas'

dim ilen(9)                          'used to store string lengths of cprm(1-9)
dim iofp(9)                      'used to store offsets of cprm(0) in cprm(1-9)

ccmd = rtrim$(command$)                'get trimmed command parameters (if any)
if ccmd = "" then                              'a command line was NOT supplied
   cls                                                'clear the display screen
   cmsg = "Usage:  TFNO  filespec  text1,  text2, ...     "'set initial message
   ipos1 = len(cmsg) - 3                   'display position for '/' parameters
   ctmp = space$(4)                        'initialize the messages left margin
   locate 1, 1, 1                         'move display cursor to screen row #1
   print ctmp; cmsg                                'display first usage message
   mid$(cmsg, ipos1) = "/C  "                   'add '/C' spec to usage message
   print ctmp; cmsg                               'display second usage message
   mid$(cmsg, ipos1) = "/D  "                   'add '/D' spec to usage message
   print ctmp; cmsg                                'display third usage message
   mid$(cmsg, ipos1) = "/Exx"                   'add '/E' spec to usage message
   print ctmp; cmsg                               'display fourth usage message
   mid$(cmsg, ipos1) = "/L  "                   'add '/L' spec to usage message
   print ctmp; cmsg                                'display fifth usage message
   mid$(cmsg, ipos1) = "/N  "                   'add '/N' spec to usage message
   print ctmp; cmsg                                'display sixth usage message
   mid$(cmsg, ipos1) = "/O  "                   'add '/O' spec to usage message
   print ctmp; cmsg                              'display seventh usage message
   mid$(cmsg, ipos1) = "/Pnn"                   'add '/P' spec to usage message
   print ctmp; cmsg                               'display eighth usage message
   mid$(cmsg, ipos1) = "/Q  "                   'add '/Q' spec to usage message
   print ctmp; cmsg                                'display ninth usage message
   mid$(cmsg, ipos1) = "/S  "                   'add '/S' spec to usage message
   print ctmp; cmsg                                'display tenth usage message
   mid$(cmsg, ipos1) = "/W  "                   'add '/S' spec to usage message
   print ctmp; cmsg                             'display eleventh usage message
   mid$(cmsg, ipos1) = "/1  "                   'add '/1' spec to usage message
   print ctmp; cmsg                             'display twelveth usage message
   print                                           'blank line between messages
   print ctmp; "If '/C' specified, set search method to case sensitive"
   print ctmp; "If '/D' specified, write search results to output file"
   print ctmp; "If '/E' specified, exclude char(s) 'xx' in '/N' search"
   print ctmp; "If '/L' specified, show line numbers in search results"
   print ctmp; "If '/N' specified, skip over characters if <= ASCII 32"
   print ctmp; "If '/O' specified, show file offsets in search results"
   print ctmp; "If '/P' specified, show result text from -nn positions"
   print ctmp; "If '/Q' specified, remove quotes around text to search"
   print ctmp; "If '/S' specified, set search to literal (string) mode"
   print ctmp; "If '/W' specified, set search to match whole word only"
   print ctmp; "If '/1' specified, show one (1) search result per file";
   close                              'close all files in case not closed above
   system                                   'return control to operating system
end if

idsk = 0                                     'initialize the write-to-disk flag
ioff = 0                                    'initialize show-text-location flag
ione = 0                                      'initialize the one-hit-only flag
ipre = 39                                    'default text hit preload position
iqot = 0                                     'initialize the remove-quotes flag
istr = 0                                       'initialize the string-mode flag
tf.csen = 0                                   'initialize case-sensitivity flag
tf.lcnt = 0                                   'initialize show-line-number flag
tf.nosp = 0                                      'initialize the no-spaces flag
tf.wwrd = 0                                     'initialize the whole-word flag
do                                 'begin loop to process command-line switches
   ipos = instr(ucase$(ccmd), "/E")    'possible exclude-chars. switch position
   if ipos > 1 then                         'possible exclude-characters switch
      if midchar(ccmd, ipos - 1) <> 47 then    '/E' is not a substring of '//E'
         ibeg = istr.lcsp(ipos + 2, ccmd, " ")  'excl.-character begin position
         iend = istr.lcfn(ibeg + 0, ccmd, " ")    'excl.-character end position
         itst = istr.lcfn(ibeg + 0, ccmd, "/")     'exclude "test" end position
         if iend > itst then                         '/' encountered before ' '
            iend = itst                              'set end posn. to '/' posn.
         end if
         if ibeg < iend then               'first valid exclude character found
            tf.chr1 = midchar(ccmd, ibeg)   'put first character to pass-struct.
         end if
         if ibeg + 1 < iend then             '2nd valid exclude character found
            tf.chr2 = midchar(ccmd, ibeg + 1) 'put 2nd character to pass-struct.
         end if
         ccmd = rtrim$(left$(ccmd, ipos - 1) + mid$(ccmd, iend))   'remove '/E'
         tf.nosp = not 0                             'set the no-spaces flag ON
         istr = not 0                              'set the string-mode flag ON
      end if
   end if
   ipos = instr(ucase$(ccmd), "/P")  'possible text hit preload switch position
   if ipos > 1 then                           'possible text hit preload switch
      if midchar(ccmd, ipos - 1) <> 47 then    '/P' is not a substring of '//P'
         ibeg = istr.lcsp(ipos + 2, ccmd, " ")  'preload # bytes begin position
         iend = istr.lcfn(ibeg + 0, ccmd, " ")    'preload # bytes end position
         itst = istr.lcfn(ibeg + 0, ccmd, "/")     'preload "test" end position
         if iend > itst then                         '/' encountered before ' '
            iend = itst                              'set end posn. to '/' posn.
         end if
         ipre = pdqvali(mid$(ccmd, ibeg, iend - ibeg)) 'preload no. bytes count
         ccmd = rtrim$(left$(ccmd, ipos - 1) + mid$(ccmd, iend))   'remove '/P'
      end if
   end if
   select case ucase$(right$(ccmd, 2))        'select on a possible User switch
      case "/C"                                'case-sensitive switch specified
         ccmd = rtrim$(left$(ccmd, len(ccmd) - 2))   'remove the '/C' parameter
         tf.csen = not 0                        'set the case-sensitive flag ON
      case "/D"                                 'write-to-disk switch specified
         ccmd = rtrim$(left$(ccmd, len(ccmd) - 2))   'remove the '/D' parameter
         idsk = not 0                            'set the write-to-disk flag ON
      case "/L"                              'show-line-number switch specified
         ccmd = rtrim$(left$(ccmd, len(ccmd) - 2))   'remove the '/L' parameter
         tf.lcnt = not 0                      'set the show-line-number flag ON
      case "/N"                                     'no-spaces switch specified
         ccmd = rtrim$(left$(ccmd, len(ccmd) - 2))   'remove the '/N' parameter
         tf.nosp = not 0                             'set the no-spaces flag ON
         istr = not 0                              'set the string-mode flag ON
      case "/O"                            'show-text-location switch specified
         ccmd = rtrim$(left$(ccmd, len(ccmd) - 2))   'remove the '/O' parameter
         ioff = not 0                       'set the show-text-location flag ON
      case "/Q"                                 'remove-quotes switch specified
         ccmd = rtrim$(left$(ccmd, len(ccmd) - 2))   'remove the '/Q' parameter
         iqot = not 0                            'set the remove-quotes flag ON
      case "/S"                                   'string-mode switch specified
         ccmd = rtrim$(left$(ccmd, len(ccmd) - 2))   'remove the '/S' parameter
         istr = not 0                              'set the string-mode flag ON
      case "/W"                                    'whole-word switch specified
         ccmd = rtrim$(left$(ccmd, len(ccmd) - 2))   'remove the '/W' parameter
         tf.wwrd = not 0                            'set the whole-word flag ON
      case "/1"                                    'single-hit switch specified
         ccmd = rtrim$(left$(ccmd, len(ccmd) - 2))   'remove the '/1' parameter
         ione = not 0                               'set the single-hit flag ON
      case else                              'no (more) User switches specified
         exit do                            'no (more) User switches; exit loop
   end select
loop
if not tf.csen then                             'the case-sensitive flag is OFF
   lset ccmd = ucase$(ccmd)                   'uppercase the command parameters
end if

ipos = instr(ccmd, " ")            'separator between filespec and parameter(s)
if ipos = 0 then                      'user did NOT input any search parameters
   i = ifn.msgs("Invalid number of parameters", iofs, irow, icol, 1, 1)
end if                              'display the error message [above] and exit
cdir = left$(ccmd, ipos - 1)         'extract filespec from user's command line
ccmd = ltrim$(mid$(ccmd, ipos + 1))   'extract parameters minus user's filespec

if istr then                                 'the string-mode flag is set to ON
   cprm(0) = ccmd                          'put string into the first parameter
   iprm = 0                                'set the number of parameters to one
else                                        'the string-mode flag is set to OFF
   iprm = parmstr1(" " + ccmd, cfil, cnam, cext, cprm()) 'parse user parameters
   if iprm > 9 then                             'user input too many parameters
      i = ifn.msgs("Invalid number of parameters", iofs, irow, icol, 1, 1)
   end if                           'display the error message [above] and exit
   for indx = 1 to iprm                        'loop thru the exclusion strings
      ilen(indx) = len(cprm(indx))           'save length of current exclusion$
      iofp(indx) = instr(cprm(indx), cprm(0)) - 1 'search$ offset in exclusion$
      if iofp(indx) = -1 then                  'search$ NOT found in exclusion$
         i = ifn.msgs("Search string #1 must be a substring of all others", _
         iofs, irow, icol, 1, 1)
      end if    'display the substring-inclusion error message [above] and exit
   next
end if

if iqot then                                      'the remove-quotes flag is ON
   for i = 0 to iprm                               'loop thru user's parameters
      ilen = len(cprm(i))                          'length of current parameter
      if  midchar(cprm(i), 1) = 34 _               'leftmost character is quote
      and midchar(cprm(i), ilen) = 34 _           'rightmost character is quote
      and ilen > 2 then                            'parameter NOT 1 or 2 quotes
         cprm(i) = mid$(cprm(i), 2, ilen - 2)     'remove quotes from parameter
      end if
   next
end if

ifl2 = freefile                         'next file channel/unit for output file
if idsk then                                      'the write-to-disk flag is ON
   i = ifn.msgs("Filename:                Hits:         Total:       ", _
   iofs, irow, icol, 0, 0)                   'display the statistics header row
   open "tfno.out" for output as ifl2      'open the User-data disk-output file
else                                             'the write-to-disk flag is OFF
   i = ifn.msgs("Please standby", iofs, irow, icol, 0, 0)
end if          'display standby message [above] while loading filespec entries

i = ifn.gdir("dsrc.dir", cfil, cfsp, chdr, cdir, ifl1, lsiz, 0)
if len(cfil) = 0 then             'no files were found in User-entered filespec
   i = ifn.kill(ifl1, "dsrc.dir")            'kill the temporary directory file
   i = ifn.msgs("Source file(s) not found", iofs, irow, icol, 1, 1)
end if                  'display the 'files not found' message and exit [above]

ibuflen = (fre("") - 4096) \ 2            'allocation size for main file buffer
cbuf = space$(ibuflen)                           'allocate the main file buffer
itxtlen = len(cprm(0))                        'length of the main search string
tf.fnum = freefile                      'next file channel/unit for input files
itmplen = 235 - abs(tf.lcnt) * 7 - abs(ioff) * 10 'size of temp. compare buffer
ctmp = space$(itmplen)                    'allocate the temp. comparison buffer
cdt1 = space$(12)                        'initialize the single-filename buffer
cdt2 = space$(6)                       'initialize the current-file hits buffer
cdt3 = space$(7)                          'initialize the all-files hits buffer
cdt4 = space$(9)                           'initialize the text-location buffer
ltot = 0                                   'initialize the total 'hits' counter

do                         'begin loop to process the directory (filename) list
   open chdr + cfil for binary access read as tf.fnum    'open the current file
   tf.llof = lof(tf.fnum)                        'get the current file's length
   lcnt = 0                           'initialize the current-file hits counter
   if idsk then                                   'the write-to-disk flag is ON
      lset cdt1 = cfil          'put current filename to single-filename buffer
      locate 5, iofs + 10, 0                'locate cursor for filename display
      print cdt1;                                 'display the current filename
      lset cdt2 = ""                        'clear the current-file hits buffer
      locate 5, iofs + 30, 0            'locate cursor for current hits display
      print cdt2;                         'display the current-file hits buffer
   end if
   tf.bbeg = 1                        'initialize begin search position in cbuf
   tf.fbeg = 1                        'initialize begin search position in file
   tf.ltot = 1                        'initialize the current-file line counter
   tf.load = not 0                   'OK to load initial buffer inside function
   ikey = ifn.tfnd(tf, cbuf, cprm(0))        'get the first text match (if any)
   do while tf.bbeg > 0 and ikey <> 27      'begin loop to process text matches
      for indx = 1 to iprm                     'loop thru the exclusion strings
         if tf.bbeg > iofp(indx) then           'test valid cbuf positions only
            if mid$(cbuf, tf.bbeg - iofp(indx), ilen(indx)) = cprm(indx) then
               exit for       'current find is actually an exclusion; exit loop
            end if
         end if
      next
      if indx > iprm then           'search string(s) were found in temp buffer
         lcnt = lcnt + 1               'increment the current-file hits counter
         ltot = ltot + 1                'increment the total-files hits counter
         ltmp = tf.fbeg + tf.bbeg + itxtlen \ 2 - ipre          'set begin posn.
         if ltmp < 1 then                 'text position is < beginning of file
            ltmp = 1                   'set begin position at beginning of file
         end if
         get tf.fnum, ltmp, ctmp                    'reload non-uppercased data
         lspn = ltmp - tf.llof + itmplen - 1     '#bytes temp buffer beyond EOF
         if lspn < 0 then                        'temp buffer does NOT span EOF
            lspn = 0                             '#bytes temp buffer beyond EOF
         elseif lspn > 0 then                     'temp buffer spans beyond EOF
            mid$(ctmp, itmplen - lspn + 1) = space$(lspn)'clear area beyond EOF
         end if
         for ipos = 1 to itmplen - lspn              'loop thru the temp buffer
            if midchar(ctmp, ipos) < 32 then     'current character is 'binary'
               mid$(ctmp, ipos) = "."      'replace character for display/print
            end if
         next
         if idsk then                             'the write-to-disk flag is ON
            rset cdt2 = str$(lcnt)           'fill the current-file hits buffer
            locate 5, iofs + 30, 0      'locate cursor for current hits display
            print cdt2;                   'display the current-file hits buffer
            rset cdt3 = str$(ltot)            'fill the total-files hits buffer
            locate 5, iofs + 45, 0        'locate cursor for total hits display
            print cdt3;                    'display the total-files hits buffer
            print #ifl2, cdt1; " ";                 'print the current filename
            if tf.lcnt then                    'the show-line-number flag is ON
               rset cdt2 = ltrim$(str$(tf.ltot))      'fill current-line buffer
               print #ifl2, cdt2; " ";           'print the current line number
            end if
            if ioff then                     'the show-text-location flag is ON
               rset cdt4 = ltrim$(str$(tf.fbeg + tf.bbeg - 1)) 'fill loc.buffer
               print #ifl2, cdt4; " ";         'print the current text location
            end if
            print #ifl2, left$(ctmp, itmplen - lspn) 'print current-line buffer
            if ione then                           'the single-hit switch is ON
               exit do                  'single hit recorded; skip to next file
            end if
         else                                    'the write-to-disk flag is OFF
            print                             'display a blank (separator) line
            print left$(ctmp, 79)              'display the current-line buffer
            print                             'display a blank (separator) line
            print "(S)kip "; cfil; ";  (Q)uit program;  ";
            print "any other key to continue"    'display the procedure message
            locate irow, icol, 0              '"hide" the cursor at lower right
            do while len(inkey$)                  'loop to strip the key buffer
            loop
            do                             'begin loop to get the User response
               ckey = ucase$(inkey$)         'get the User-pressed key (if any)
            loop while len(ckey) = 0         'loop until the User presses a key
            select case ckey              'select on the User-pressed key value
               case "Q", char(27)              'the User pressed an 'abort' key
                  ikey = 27           'set the User-response key to the ESC key
                  exit do                'abort selected; terminate the program
               case "S"                   'the User pressed the 'S'kip-file key
                  exit do             'skip selected; exit processing this file
               case else
            end select
         end if
      end if
      tf.bbeg = tf.bbeg + 1               'move search to next position in cbuf
      ikey = ifn.tfnd(tf, cbuf, cprm(0))          'get next text match (if any)
   loop
   if ikey = 27 then                           'the User pressed an 'abort' key
      ltot = 0                              'clear ltot to bypass ltot messages
      exit do                            'abort selected; terminate the program
   end if
   close tf.fnum          'close current file; get next directory entry [below]
   i = ifn.gdir("dsrc.dir", cfil, cfsp, chdr, cdir, ifl1, lsiz, 0)
loop while len(cfil)                           'loop until end of filename list

i = ifn.kill(ifl1, "dsrc.dir")          'kill the source-files (directory) list
if ltot then                       'lines were written to User-data output file
   if idsk then                                   'the write-to-disk flag is ON
      print #ifl2, ""                          'output a blank (pre-total) line
      print #ifl2, "Total Hits: "; ltrim$(str$(ltot))    'output the total hits
      close ifl2                               'close the User-data output file
      shell "brow tfno.out"                   'browse the User-data output file
      i = ifn.msgs("", iofs, irow, icol, 0, 1)   'display User message and exit
   else                                          'the write-to-disk flag is OFF
      locate irow, icol, 1                     'un-"hide" cursor at lower right
      print                                   'display a blank (separator) line
   end if
else                           'lines were NOT written to User-data output file
   i = ifn.kill(ifl2, "tfno.out")         'kill the empty User-data output file
   if ikey = 27 then                           'the User pressed an 'abort' key
      i = ifn.msgs("Abort selected - Program terminated", _
      iofs, irow, icol, 0, 1)      'display abort message and terminate program
   else                                  'the User did NOT press an 'abort' key
      i = ifn.msgs("No matches found in any file(s)", iofs, irow, icol, 1, 1)
   end if
end if                         'display the no-matches message [above] and exit

close                                 'close all files in case not closed above
system                                   'exit program in case not exited above
