'/* FILECOMP.BAS  19.06.1998 */

'  IN: csrcfil - first file to compare (including path).
'      cdstfil - second file to compare (including path).
'      istatus - +1 = OK to display all messages in this routine.
'              -  0 = don't display any messages in this routine.
'              - -1 = don't display message if file is not found.
'
' OUT: itstkey - ESC = user aborted compare function.
'      istatus -   0 = files compare OK.
'                 -1 = files compare OK, but EOF byte missing from one file.
'                 -2 = files differ at position returned in 'lbyteno' value.
'                 -3 = files are different sizes - cannot compare file data.
'                 -4 = second file to compare (including path) was not found.
'      lbyteno - first difference byte # (only when not displaying messages).

function ifn.fcmp(csrcfil, cdstfil, itstkey, istatus, lbyteno) 'compare 2 files
   ibeeper = 0                           'initialize file-difference beep-alert
   idifbuf = 0                                 'initialize file-difference flag
   idifeof = 0                                'initialize EOF-byte-missing flag
   csrcbuf = space$(1)         'set source-file buffer to read last (EOF?) byte
   cdstbuf = space$(1)    'set destination-file buffer to read last (EOF?) byte
   idstfil = freefile       'initialize the destination-file handle/unit number
   open cdstfil for binary access read as idstfil    'open the destination file
   ldstsiz = lof(idstfil)                      'get the destination file's size
   if ldstsiz then                'destination file has a valid (non-zero) size
      isrcfil = freefile         'initialize the source-file handle/unit number
      open csrcfil for binary access read as isrcfil      'open the source file
      lsrcsiz = lof(isrcfil)                        'get the source file's size
      if abs(lsrcsiz - ldstsiz) = 1 then 'source/dest. file lengths differ by 1
         get isrcfil, lsrcsiz, csrcbuf    'get the last (EOF?) source-file byte
         get idstfil, ldstsiz, cdstbuf     'get the last (EOF?) dest.-file byte
         if lsrcsiz > ldstsiz _             'source file 1 byte g.t. dest. file
         and csrcbuf = char(26) _           'source file DOES end with EOF byte
         and csrcbuf <> cdstbuf then     'dest. file does NOT end with EOF byte
            idifeof = not 0                   'set the EOF-byte-missing flag ON
            cdifeof = cdstfil                'set the EOF-byte-missing filespec
         elseif ldstsiz > lsrcsiz _         'dest. file 1 byte g.t. source file
         and cdstbuf = char(26) _            'dest. file DOES end with EOF byte
         and cdstbuf <> csrcbuf then    'source file does NOT end with EOF byte
            idifeof = not 0                   'set the EOF-byte-missing flag ON
            cdifeof = csrcfil                'set the EOF-byte-missing filespec
         end if
      end if
   else                                        'destination file does NOT exist
      lsrcsiz = -1                     'set source-file size to skip below test
   end if
   if istatus then                       'user said OK to display messages here
      print                'display separator line between each file comparison
      print csrcfil; " and "; cdstfil                'display the compare files
   end if
   if lsrcsiz = ldstsiz or idifeof then       'source/dest. files are same size
      lmemfre = fre("") - 2048                'total free memory less exclusion
      if lmemfre > 97920 then               'maximum memory for compare buffers
         lmemfre = 97920              'reset maximum memory for compare buffers
      end if
      ibuflen = lmemfre \ 3              'set the maximum compare-buffer length
      if lsrcsiz > ldstsiz then    'source file is 1 byte g.t. destination file
         lsrcsiz = ldstsiz        'set source file length to destination length
      end if
      if ibuflen > lsrcsiz then       'compare-buffer length g.t. source length
         ibuflen = lsrcsiz        'reset compare-buffer length to source length
      end if
      csrcbuf = space$(ibuflen)    'set source-file buffer to full compare size
      cdstbuf = space$(ibuflen)     'set dest.-file buffer to full compare size
      ircdlen = ibuflen       'set current 'record' length to full compare size
      itstkey = 0                           'initialize user-response key value
      for lfilptr = 1 to lsrcsiz step ibuflen  'loop thru the source file bytes
         if lfilptr + ibuflen - 1 > lsrcsiz then 'last buffer is l.t. full size
            csrcbuf = ""                     'deallocate the source-file buffer
            cdstbuf = ""                      'deallocate the dest.-file buffer
            ircdlen = lsrcsiz mod ibuflen    'record' length = last buffer size
            csrcbuf = space$(ircdlen)    'source-file buffer = last buffer size
            cdstbuf = space$(ircdlen)     'dest.-file buffer = last buffer size
         end if
         get isrcfil, lfilptr, csrcbuf             'load the source-file buffer
         get idstfil, lfilptr, cdstbuf        'load the destination-file buffer
         if csrcbuf <> cdstbuf then    'source/dest.files do NOT have same data
            idifbuf = not 0                        'set file-difference flag ON
            ilowptr = 0                  'low pointer for binary search-compare
            while ilowptr < ircdlen          'loop thru the current file buffer
               itopptr = ircdlen + 1     'top pointer for binary search-compare
               while itopptr - ilowptr > 1     'loop to compare difference-data
                  icmplen = (itopptr - ilowptr) \ 2     'current compare length
                  if mid$(csrcbuf, ilowptr + 1, icmplen) _     'current segment
                   = mid$(cdstbuf, ilowptr + 1, icmplen) then  '....compares OK
                     ilowptr = ilowptr + icmplen  'move search-compare floor UP
                  else                     'current segment does NOT compare OK
                     itopptr = ilowptr + icmplen'move search-comp. ceiling DOWN
                  end if
               wend
               if ilowptr < ircdlen then            'search-compare still valid
                  if istatus then        'user said OK to display messages here
                     print "Files differ at byte number "; _ 'curr.byte differs
                           ltrim$(str$(lfilptr + itopptr - 1))'in compare files
                     if not ibeeper then'file-difference warning hasn't sounded
                        ibeeper = not 0 'set file-difference beep-alert flag ON
                        beep            'sound first (and only) audible warning
                     end if
                     itstkey = io.kget(0)      'get the user's current response
                     ilowptr = itopptr    'terminate the current search-compare
                     istatus = -2       'return the 'files differ at...' status
                     if itstkey = KEY.ESC or itstkey = 32 then 'ESC or spacebar
                        exit for                    'exit the file-compare loop
                     end if
                  else                  'user said do NOT display messages here
                     lbyteno = lfilptr + itopptr - 1'return the difference pos.
                     istatus = -2       'return the 'files differ at...' status
                     exit for                      'exit the buffer-search loop
                  end if
               end if
            wend
         else                   'current source/dest. buffers DO have same data
            itstkey = io.ktst(0)             'test for user interrupt or ESCape
            if itstkey = 32 then                    'user pressed the space bar
               itstkey = io.kget(0)     'stop and wait for user's next keypress
            end if
            if itstkey = KEY.ESC then                 'user pressed the ESC key
               exit for                             'exit the file-compare loop
            end if
         end if
      next
      if lfilptr > lsrcsiz and (not idifbuf) then'current file-compare complete
         if istatus then                 'user said OK to display messages here
            print "Files compare OK"              'display completed-OK message
         end if
         if idifeof then            'EOF byte missing from source or dest. file
            if istatus then              'user said OK to display messages here
               print "EOF byte missing from "; cdifeof'EOF-byte-missing message
            end if
            istatus = -1                  'return the 'EOF byte missing' status
         else                                   'EOF byte(s) NOT missing or n/a
            istatus = 0                   'return the 'files compare OK' status
         end if
      end if
   else                               'source/dest. files are NOT the same size
      if ldstsiz then             'destination file has a valid (non-zero) size
         if istatus then                 'user said OK to display messages here
            print "Files are different sizes"  'display size-difference message
            beep                         'sound the files-not-same-size warning
            itstkey = io.kget(0)        'stop and wait for user's next keypress
         end if
         istatus = -3            'return the 'files are different sizes' status
      else                                     'destination file does NOT exist
         if istatus = 1 then             'user said OK to display messages here
            print cdstfil; " not found"       'display 'file not found' message
            beep                         'sound the files-not-same-size warning
            itstkey = io.kget(0)        'stop and wait for user's next keypress
         end if
         istatus = -4                       'return the 'file not found' status
         i = ifn.kill(idstfil, cdstfil)      'kill zero-length destination file
      end if
   end if
   close isrcfil                                 'close the current source file
   close idstfil                            'close the current destination file
end function                                         'return to calling program
