/*
 * 123copy.c
 * Copyright(C) 1996 Hiroyuki Sekiya
 */

#include <lxapi.h>
#include <bridge.h>
#include <limits.h>
#include <stdlib.h>
#include <string.h>
#include "morelib.h"	/* MoreEXMɕtĂ܂ */

const char copyright[] = "123CUT/COPY Copyright(C) 1996 Hiroyuki Sekiya";

/*
 * TC2.0̃RpC(98p){BC++5.0̃Cu(PCp)ƂϑIȑgݍ킹
 * ŊJĂ邽߁Aȉ̂悤ȕϐ/֐KvɂȂĂ܂܂BBC++
 * ̕_CułOQƂĂ̂ɁANKIT̃X^[gAbv
 * ɂ͂炪܂܂ĂȂ߂łB
 */
#if 1
unsigned int _version = 0x0500;
void _terminate(int retcode) { exit(1); }
void _checknull(void) {}
void _restorezero(void) {}
void _cleanup() {}
#endif

EVENT Event;
BOOL cb_opened = FALSE;

/*
 * vOI
 * retcode0Ȃ琳IA0ȂُI(r[v)
 */
void exit(int retcode)
{
	if (retcode)
		m_thud();
	if (cb_opened) {
		if (retcode) {
			m_fini_rep();
			m_reset_cb("MemUtil");
			m_new_rep("TEXT");
		}
		m_fini_rep();
		m_close_cb();
	}
	DeactivateFloat();		/* NKIT̕_Z𖳌 */
	if (MoreInit() == 0) MoreVoidNextCls();
	m_fini();
}

/*
 * 1-2-3 Bridge ServiceR[
 * ߂lBridge ServicẽUgR[h
 */
int BridgeServ(BRIDGE_BP *Bridge)
{
#if 1
	bridge_serv(Bridge);
	return Bridge->bpb_retcode;
#else
	/* ̂ł͂Ȃ܂s܂ */
	Event.norm.bridge = Bridge;
	Event.norm.do_event = DO_BRIDGE;
	m_action(&Event);
	return Bridge->bpb_retcode;
#endif
}

void main(void)
{
	static LHAPIBLOCK LHAPIData;
	static BRIDGE_BP Bridge;
	static char LineBuffer[10*1024];
	static char ClipBuffer[10*1024];
	char *src, *dst;
	int i, EndRow;

	/* 񑩂̏ */
	m_init_app(SYSTEM_MANAGER_VERSION);
	m_reg_app_name("123PASTE");
	InitializeLHAPI(&LHAPIData);
	ActivateFloat();		/* NKIT̕_ZL */

	cb_opened = (m_open_cb() == 0);
	if (!cb_opened) exit(1);
	m_reset_cb("MemUtil");
	m_new_rep("TEXT");

	/* Bridge Servicepł邩ǂmF */
	Bridge.bpb_funcode = BRIDGE_TEST;
	if (BridgeServ(&Bridge) != 1) exit(1);

	/* Rs[͈͂[U[ɑI */
#ifdef _CUT_
	Bridge.bpb_buffer = "Range to cut: ";
#else
	Bridge.bpb_buffer = "Range to copy: ";
#endif
	Bridge.bpb_order = 0; /*BRIDGE_GETRANGE_STARTANCHORED;*/
	Bridge.bpb_funcode = BRIDGE_GETRANGE;
	switch (BridgeServ(&Bridge)) {
	case 0: exit(0);		/* abort by ESC */
	case 1: break;			/* successful */
	default: exit(1);		/* error */
	}

	/* 1-2-31sǂݎClipboardɃRs[ */
	EndRow = Bridge.bpb_endrow;
	do {
		/* 1-2-31s̃f[^擾 */
		Bridge.bpb_endrow = Bridge.bpb_startrow;
		Bridge.bpb_buffer = LineBuffer;
		Bridge.bpb_bufsize = sizeof(LineBuffer);
		Bridge.bpb_order = 0;
		Bridge.bpb_funcode = BRIDGE_GETRANGE_DATA;
		if (BridgeServ(&Bridge) < 0) exit(1);

		/* CSVɕϊ */
		src = LineBuffer;
		dst = ClipBuffer;
		for (i=Bridge.bpb_startcol; i<=Bridge.bpb_endcol; ++i) {
			switch (*src++) {
			case 'B': 								/* Blank */
			/*	lstrcpy(dst, "\"\""); dst += 2; */
				break;
			case 'I': 								/* Integer */
				itoa(*(int *)src, dst, 10);
				src += sizeof(int);
				while (*dst) ++dst;
				break;
			case 'N': 								/* Numelic */
				gcvt(*(double *)src, 12, dst);
				src += sizeof(double);
				while (*dst) ++dst;
				break;
			case 'S': 								/* String */
				*dst++ = '"';
				while (*dst++ = *src++)
					if (*(dst-1) == '"') *dst++ = '"';
				*(dst-1) = '"';
				break;
			case 'F': 								/* Formula */
				while (*dst++ = *src++)
					;
				--dst;
				break;
			default:								/* Unknown */
				lstrcpy(dst, "ERR"); dst += 3;
				goto DONE;
			}
			if (i != Bridge.bpb_endcol) *dst++ = ',';
		}
	DONE:
		*dst++ = '\r';

		/* Clipboardɒǉ */
		m_cb_write(ClipBuffer, dst - ClipBuffer);

#ifdef _CUT_
		/* 1-2-31s̃f[^폜 */
		Bridge.bpb_bufsize = Bridge.bpb_endcol - Bridge.bpb_startcol + 1;
		memset(LineBuffer, 'B', Bridge.bpb_bufsize);
		Bridge.bpb_buffer = LineBuffer;
		Bridge.bpb_order = 0;
		Bridge.bpb_funcode = BRIDGE_SETRANGE_DATA;
		if (BridgeServ(&Bridge) < 0) exit(1);
#endif
	} while (++Bridge.bpb_startrow <= EndRow);

	exit(0);
}
