{*
 *  USEAPI.PAS
 *
 *  Shows the use of the XFSAPI: XFSLIB & XFSFMX
 *
 *}

uses
  WinCrt, WinProcs, XfsApi;

var
  opt:  TMOUNTOPT;
  info: TXFSINFO;
  dev, res: array[0..127] of Char;
  i: Integer;


begin
  if not XfsInstalled then exit;

  { Login }
  WriteLn(XfsLogin(nil, 'speedy', 'guest', 'guest'));

  { Get XFS info }
  XfsNetStat(info);
  WriteLn('Hostname ... ', info.hostname);
  WriteLn('User ....... ', info.username);
  WriteLn('UID ........ ', info.uid );
  WriteLn('GID ........ ', info.gid );
  WriteLn('Umask ...... ', info.umask );

  opt.rsize := 1024;
  opt.wsize := 1024;
  opt.retry := MOUNT_DEF_RETRY;
  opt.flags := MOUNT_DEF_OPT;

  { Mount }
  WriteLn(XfsMountDrive('R:', 'speedy', '/', opt));
  WriteLn(XfsMountPrinter('LPT2:', 'speedy', 'lp'));

  { Drive Login }
  WriteLn(XfsLogin('R:', 'speedy', 'admin', 'xyz'));

  XfsNetStat(info);
  WriteLn('User ....... ', info.username);
  WriteLn('UID ........ ', info.uid );
  WriteLn('GID ........ ', info.gid );

  { Show used resources }
  i := 0;
  while WGetRedirection(i, dev, res) = 0 do
  begin
    WriteLn( dev, ' ', res);
    inc(i)
  end;

  { Init the File Manager Extension }
  if InitFMX = 0 then exit;

  { Show the mount dialog }
  XfsFMXCall(0, CM_MOUNT);

  { Show the unmount dialog }
  XfsFMXCall(0, CM_UMOUNT);

  DoneFMX;

end.
