; This file is a part of SecureDevice 1.4
; Copyright (C) 1994 by Max Loewenthal and Arthur Helwig

; This program is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.

; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.

; You should have received a copy of the GNU General Public License
; along with this program; if not, write to the Free Software
; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


IDEAL
MODEL       TINY,C

CODESEG

PUBLIC      MovePart,InitScreen,Write,ScreenHeight,ScreenWidth,Graphic

PROC        MovePart
            ASSUME      DS:@CODE,ES:NOTHING,SS:@CODE,CS:@CODE
            ARG         ToScreen:BYTE           ; <>0 = buffer->screen, 0 = screen->buffer
            ARG         Buffer:WORD,X1:WORD,Y1:WORD,X2:WORD,Y2:WORD

                        PUSH        DS ES SI DI CX DX BX AX
                        MOV         SI,0
                        MOV         DS,[ScreenBase]
            ASSUME      DS:NOTHING
                        MOV         DI,[Buffer]

                        MOV         CX,[Y2]
                        SUB         CX,[Y1]       ; cx = # of lines
                        INC         CX

                        MOV         AX,[Y1]
                        MOV         BX,[ScreenWidth]
                        MUL         BX
                        SHL         AX,1
                        ADD         SI,AX         ; ds:si-> 1st line

                        MOV         BX,[X2]
                        SUB         BX,[X1]       ; bx = # of words to be moved
                        INC         BX
                        MOV         DX,[X1]
                        SHL         DX,1          ; dx = offset from beginning of line
                        MOV         AX,[ScreenWidth]
                        SHL         AX,1          ; ax = size of one line

                        CLD

                        JCXZ        @@Exit

            @@NextLine: PUSH        CX
                        PUSH        SI
                        ADD         SI,DX
                        MOV         CX,BX

                        CMP         [ToScreen],0
                        JE          @@1

                        PUSH        DS ES
                        POP         DS ES
                        XCHG        DI,SI

            @@1:        REP         MOVSW

                        CMP         [ToScreen],0
                        JE          @@2

                        PUSH        DS ES
                        POP         DS ES
                        XCHG        DI,SI

            @@2:        POP         SI
                        ADD         SI,AX
                        POP         CX
                        LOOP        @@NextLine

            @@Exit:     POP         AX BX DX CX DI SI ES DS
                        RET
ENDP        MovePart

PROC        InitScreen
            LOCAL       VideoPage:BYTE
                        PUSH        ES AX BX CX DX
                        MOV         AH,0Fh
                        INT         10h
                        MOV         [ScreenBase],0B000h
                        MOV         [VideoPage],BH
                        AND         AL,7Fh
                        CMP         AL,7
                        JZ          @@1
                        MOV         [ScreenBase],0B800h

            @@1:        MOV         AL,AH
                        MOV         AH,0
                        MOV         [ScreenWidth],AX
                        MOV         AX,1130h
                        MOV         BH,0
                        MOV         DL,0
                        PUSH        BP
                        INT         10h
                        POP         BP
                        CMP         DL,0
                        JNE         @@2
                        MOV         DL,24

            @@2:        INC         DL
                        MOV         AL,DL
                        MOV         AH,0
                        MOV         [ScreenHeight],AX

            @@NoDV:     XOR         AX,AX
                        MOV         ES,AX
                        MOV         AX,[ES:44Eh]
                        ADD         [ScreenBase],AX

                        MOV         [Graphic],1
                        MOV         ES,[ScreenBase]
                        MOV         DL,[ES:0]
                        PUSH        DX
                        MOV         [BYTE PTR ES:0],'A'
                        CMP         [BYTE PTR ES:0],'A'
                        JNE         @@3

                        MOV         BH,[VideoPage]
                        MOV         AH,3
                        INT         10h
                        MOV         CX,DX                   ; save cursor pos in CX
                        MOV         AH,2
                        MOV         DX,0
                        INT         10h                     ; move cursor to (0,0)
                        MOV         AH,8
                        INT         10h                     ; read char
                        MOV         DX,CX                   ; put old cursor pos in DX
                        MOV         CX,AX                   ; save char in CX
                        MOV         AH,2
                        INT         10h                     ; restore cursor pos
                        CMP         AL,'A'
                        JNE         @@3
                        MOV         [Graphic],0
                        
            @@3:        POP         DX
                        MOV         [ES:0],DL

                        POP         DX CX BX AX ES
                        RET
ENDP        InitScreen

PROC        Write
            ARG         X:WORD,Y:WORD,Attr:BYTE,String:WORD

                        PUSH        DS ES AX BX SI DI
                        MOV         ES,[ScreenBase]
                        MOV         DI,0
                        MOV         SI,[String]
                        MOV         AX,[ScreenWidth]
                        MOV         BX,[Y]
                        MUL         BL
                        ADD         AX,[X]
                        SHL         AX,1
                        ADD         DI,AX

                        MOV         AH,[Attr]
                        CLD

            @NextChar:  LODSB
                        CMP         AL,0
                        JE          @Exit
                        STOSW
                        JMP         @NextChar

            @Exit:      POP         DI SI BX AX ES DS
                        RET
ENDP        Write

            ScreenBase  DW          0
            ScreenWidth DW          0
            ScreenHeight DW         0
            Graphic     DB          0
END
