/* Common.h - common declarations in MKVOLUME.C and RESIZE.C
   Depends on Usuals.h and Globals.h
*/

#define rand8  ((byte)random(0x100))
#define rand16 ((word16)rand8 << 8 | (word16)rand8)
#define rand32 ((word32)rand16 << 16 | (word32)rand16)

#define low16(x) (x & 0xFFFF)
#define hi16(x)  (x >> 16)
#define odd(x)   (x & 1)

struct FILE_INFO
  { char fullname[MAXPATH];
    char drive[MAXDRIVE];
    char dir[MAXDIR];
    char file[MAXFILE];
    char ext[MAXEXT];
  };
struct SETUP_INFO
  { word16 sectsize;
    word16 rootentries;
    byte   rootsects;
    byte   noffats;
  };
struct DISK_INFO
  { byte   FAT12;
    byte   sectspfat;
    byte   clustsize;
    word32 totalsects;
    word32 datasects;
    word32 dataclust;
    word16 IV[4];
  };
struct BOOT
  { byte jmp[3],oem[8];
    word16 sectsize;
    byte clustsize;
    word16 ressects;
    byte fatcnt;
    word16 rootsize,totsects;
    byte meddesc;
    word16 sectspfat,sectsptrack,nofheads;
    word32 hidden,totsectsl;
    byte physdrv,reserved,signature;
    word32 serial;
    char label[11],fatid[8];
    word16 iv[4],check[4];
  };
struct DPB
  { char Drv;
    byte SubUnit;
    word16 sectsize;
    byte SectpClust;
    byte pSectpClust;
    word16 ReservedSects;
    byte Fatcnt;
    word16 MaxDir;
    word16 DataSect;
    word16 NofClust;
    byte SectspFat;
    word16 Rootoffset;
    char *DevicePtr;
    byte MedDesc;
    byte Accessed;
    char *NextDev;
  };
struct DTA
  { char Drv;
    char Name[8];
    char Ext[3];
    byte Attr;
    byte Filler[10];
    word16 Time;
    word16 Date;
    word16 Clust;
  };
typedef byte sectortype[SectorSize];

