code=3500
nowarnings
/******************    IMP SHELL   ********************************/
/*                                                                */
/*                                                                */
/*     THE IMP SHELL EXPERT SYSTEM DEVELOPMENT ENVIRONMENT        */
/*                  VERSION 1.0                                   */
/*                                                                */
/*                                                                */
/******************************************************************/

domains
   file = descriptor
   infrec = imp(string,string,string,string,string,string,string,real)
   reallist = real*

database
   adjustflag    
   convstack(string)        /*  Used in the relnevl1 module.  */
   danswer(string,real)
   dbimp(string,string,string,string,string,string,string,real)
   define(symbol,string)   /* Used in the relnevl1 module.  */
   evidence(string,real)   
   hypothesis_node(string)
   imp(string,string,string,string,string,string,string,real)
   infer_summary(infrec,real)
   stackvalue(real)         /* Used in the relnevl1 module.   */
   tdbimp(string,string,string,string,string,string,string,real)
   terminal_node(string)
   varvalue(symbol,real)    /*  Used in the relnevl1 module.  */

predicates
   absvalue(real,real)
   adjuststack
   allinfer(string,real)
   and_go_on
   answer(string,real)
   append(reallist,reallist,reallist)
   cleanerx
   cleanery
   cleanerz
   cleanit1
   cleanit2
   cleanit3
   cleanit4
   cleanit5
   cleanit6
   cleanit7
   cleanit9
   cleanit10
   cleanit11
   cleanit12
   cleanit13
   cleanit14
   clearall
   combine(reallist,real)
   cond_multiplier(string,real)
   defs_go_on
   display_one_answer
   displayall
   edit_rs
   exsys_driver   
   find_multiplier(string,real,string,real)
   form_go_on
   form_describer(string,real)
   get_name(string)
   getallans
   getmode1(string,string)
   getmode2(string,string)
   gettype1(string,string) 
   gettype2(string,string)
   getsense(string,string)
   how_explain(string)
   how_describer(string)
   infer(string,real)
   more_defs
   make_rules
   make_imps
   make_defs
   make_terms
   make_hypos
   make_simples
   make_ands
   make_ors
   make_forms
   max(real,real,real)
   min(real,real,real)
   or_go_on
   pauser
   prepare_answer
   purgeit
   putadjustflag 
   process(integer)
   pick_exsys(string)
   qualifier(string,real,real)
   reloadit
   reply_to_input(string,string,real)
   repeat
   record_it(char,string,string)
   seerules
   seeimps
   seedefs
   seehypos
   seeterms
   showresults
   shell_driver
   simple_go_on
   supercombine(reallist,real)
   why_describer(string,string,string,string,string,string,string,real)

   
/*  Borland's add-on menu module.                                 */
include "menu.pro"
/*  The relational expression evaluator from this book.              */
include "relnevl1.pro"

clauses

/******************************************************************/
/*                                                                */
/*       Principal Driver Code for Whole System is Here.          */
/*                                                                */
/******************************************************************/
   shell_driver if 
      makewindow(1,112,7,"IMP -- Expert System Development Shell",
         0,0,25,80),
      repeat,shiftwindow(1),clearwindow,
      menu(6,15,
         [ "Help Information",
           "Make Rules for a New Expert System",
           "Inspect the Rule Set that is Loaded",
           "Save the Rule Set that is Loaded",
           "Load an Existing Rule Set",
           "Run the Presently Loaded Expert System",
           "Edit an Existing Rule Set",
           "Print an Existing Rule Set",
           "DOS Access",
           "End this program."],CHOICE),
      process(CHOICE),CHOICE=10,!.

/*   High level definition of the menu choices.                 */
   process(1) if file_str("impshell.hlp",ZZ),display(ZZ),!.
   process(2) if clearall,make_rules,!.
   process(3) if seerules,!.
   process(4) if get_name(Rulefile),save(Rulefile),!.
   process(5) if clearall,pick_exsys(Rulefile),consult(Rulefile),!.
   process(6) if cleanerx,cleanerz,exsys_driver,!.
   process(7) if clearall,edit_rs,!.
   process(8) if pick_exsys(Rulefile),concat("copy ",Rulefile,Z),
      concat(Z," prn:",ZZ),system(ZZ),!.
   process(9) if system(""),!.
   process(10) if !.
/*******************************************************************/

/*  Note, processes 1,4,5,8,9 and 10, except for a few auxilliary
   predicates, are completely defined by the code you see immediately
   above here.  Processes with more detailed definitions are given
   below.                                                         */
   

/******************************************************************/
/*                                                                */
/*       Menu Process Number 2                                    */
/*       Collecting an Initial Set of Rules.                      */
/*                                                                */
/******************************************************************/
/*  Section asks questions about possible rules and casts
    the answers in the proper rule format.                        */  
   make_rules if clearwindow,make_imps,make_defs,
      make_terms,make_hypos,
      clearwindow,nl,nl,
      write(" To make these rules permanent, save them "),
      write("to a file (see main menu)."),nl,nl,
      write(" The rules can be changed, after saving,"),nl,
      write("     by using the edit function (see main menu)."),
      nl,pauser.
  
   make_terms if clearwindow,nl,
      write(" DEFINING THE TERMINAL NODES IN THIS RULE SET."),
      repeat,nl,nl,
      write(" Enter the text that defines one terminal node: "),
      nl,write(" "),readln(X),assert(terminal_node(X)),more_defs,!.

   make_hypos if clearwindow,nl,
      write(" DEFINING THE HYPOTHESIS NODES IN THIS RULE SET."),
      repeat,nl,nl,
      write(" Enter the string that defines one hypothesis node: "),
      nl,write(" "),readln(X),assert(hypothesis_node(X)),more_defs,!.
  
   make_imps if make_simples,make_ands, make_ors, make_forms.

   make_simples if clearwindow,simple_go_on,
      repeat,clearwindow,nl,
      write(" DEFINING A SIMPLE IMPLICATION RULE "),nl,nl,
      write(" What is to be Concluded from this implication?  "),nl,
      write(" "),readln(Z),nl,
      write(" What is in the premise (state it in positive form) ?"),
      nl,write(" "),readln(X),nl,
      write(" Should the premise be preceded by NOT (type y/n)?  "),
      write(" "),readln(XX),getsense(XX,Xsign),nl,
      write(" Is the rule to be reversible or not (type r/n)?   "),
      write(" "),readln(R1),nl,
      write(" What is the certainty?   "),
      readreal(C),
      assert(imp(s,R1,Z,Xsign,X,dummy,dummy,C)),more_defs,!.
   make_simples if !.
     
   make_ands if clearwindow,and_go_on,
      repeat,clearwindow,nl,
      write(" DEFINING AN AND IMPLICATION RULE "),nl,nl,
      write(" What is to be Concluded from this implication?  "),
      nl,write(" "),readln(Z),nl,
      write(" What is the first condition in the premise?  "),nl,
      write(" "),readln(X),nl,
      write(" Should this condition be preceded by NOT (type y/n)?  "),
      write(" "),readln(XX),getsense(XX,Xsign),nl,
      write(" What is the second condition in the premise?  "),nl,
      write(" "),readln(Y),nl,
      write(" Should this condition be preceded by NOT (type y/n)?  "),
      write(" "),readln(YY),getsense(YY,Ysign),nl,
      write(" Is the rule to be reversible or not (type r/n)?   "),
      write(" "),readln(R1),nl,
      write(" What is the certainty?   "),
      readreal(C),
      assert(imp(a,R1,Z,Xsign,X,Ysign,Y,C)),more_defs,!.
   make_ands if !.

   make_ors if clearwindow,or_go_on,
      repeat,clearwindow,nl,
      write(" DEFINING AN OR IMPLICATION RULE "),nl,nl,
      write(" What is to be Concluded from this implication?  "),
      nl,write(" "),readln(Z),nl,
      write(" What is the first condition in the premise?  "),nl,
      write(" "),readln(X),nl,
      write(" Should this condition be preceded by NOT (type y/n)?  "),
      write(" "),readln(XX),getsense(XX,Xsign),nl,
      write(" What is the second condition in the premise?  "),nl,
      write(" "),readln(Y),nl,
      write(" Should this condition be preceded by NOT (type y/n)?  "),
      write(" "),readln(YY),getsense(YY,Ysign),nl,
      write(" Is the rule to be reversible or not (type r/n)?   "),
      write(" "),readln(R1),nl,
      write(" What is the certainty?   "),
      readreal(C),
      assert(imp(o,R1,Z,Xsign,X,Ysign,Y,C)),more_defs,!.
   make_ors if !.  

   make_forms if clearwindow,form_go_on,
      repeat,clearwindow,nl,
      write(" DEFINING A RELATIONAL EXPRESSION RULE"),
      nl,nl,write(" What is to be Concluded from this implication?  "),
      nl,write(" "),readln(Z),nl,
      write(" State the relational expression"),
      write(" to be used in the premise?  "),nl,
      write(" "),readln(X),nl,
      write(" Should the expression be preceded by NOT (type y/n)?  "),
      write(" "),readln(XX),getsense(XX,Xsign),nl,
      write(" Is the rule to be reversible or not (type r/n)?   "),
      write(" "),readln(R1),nl,
      write(" What is the certainty?   "),
      readreal(Ct),
      assert(imp(f,R1,Z,Xsign,X,dummy,dummy,Ct)),more_defs,!.
   make_forms if !.  


   make_defs if clearwindow,defs_go_on,
      repeat,clearwindow,nl,
      write(" SETTING UP A GENERAL PURPOSE DEFINITION."),
      nl,nl,write(" What is name of the variable being defined?  "),
      nl,write(" "),readln(Z),nl,
      write(" What is the expression that defines the variable?  "),
      nl,write(" "),readln(ZZ),nl,
      assert(define(Z,ZZ)),more_defs,!.
   make_defs if !.  


   simple_go_on if nl,write(" COLLECTING RULES"),nl,nl,
      write(" Do you need simple implication rules?"),
      write(" -- type y/n  "),readchar(T),T='y',!.

   and_go_on if nl,write(" COLLECTING RULES"),nl,nl,
      write(" Do you need AND implication rules?"),
      write(" -- type y/n  "),readchar(T),T='y',!.
  
   or_go_on if nl,write(" COLLECTING RULES"),nl,nl,
      write(" Do you need OR implication rules?"),
      write(" -- type y/n  "),readchar(T),T='y',!.

   form_go_on if nl,write(" COLLECTING RULES"),nl,nl,
      write(" Do you need relational expression rules?"),
      write(" -- type y/n  "),readchar(T),T='y',!.

   defs_go_on if nl,write(" COLLECTING DEFINITIONS"),nl,nl,
      write(" Do you want to define any formulas?"),
      write(" -- type y/n  "),readchar(T),T='y',!.
        
   more_defs if 
      nl,write(" ************  More entries of this kind? -- type y/n.  "),
      readchar(T),T='n',!.

/*  Used in setting up the negation of premises.  */
   getsense("y","neg").
   getsense("n","pos").
/*******************************************************************/



/******************************************************************/
/*                                                                */
/*       Menu Process Number 3                                    */
/*       Inspecting the Rules                                     */
/*                                                                */
/******************************************************************/
   seerules if clearwindow,not(seeimps),not(seedefs),
      not(seeterms),not(seehypos),nl,pauser.

   seeimps if imp(A,B,C,D,D1,E,F,F1),
      write("imp(",A,",",B,",",C,",",D,",",D1,",",E,",",F,",",F1,")"),
      nl,fail.

   seedefs if define(X,Y),write("define(",X,",",Y,")"),nl,fail.

   seeterms if terminal_node(X),write("terminal_node(",X,")."),nl,fail.

   seehypos if hypothesis_node(X),write("hypothesis_node(",X,")."),
      nl,fail.
/*******************************************************************/



/******************************************************************/
/*                                                                */
/*       Menu Process Number 6                                    */
/*       This code actually runs an existing expert system.       */
/*                                                                */
/******************************************************************/
/*  The driver rule for all inferencing operations.                */
   exsys_driver if 
      makewindow(10,7,7,"RUNNING EXPERT SYSTEM",2,5,19,65),  
      getallans,           
      makewindow(11,7,7,"RESULT SUMMARY",4,9,19,65),
      showresults,!.

   getallans if not(prepare_answer).

   showresults if not(displayall).

   prepare_answer if answer(X,Y),fail.

   answer(X,Y) if hypothesis_node(X),allinfer(X,Y),
      assert(danswer(X,Y)).

   displayall if display_one_answer,fail.
    
   display_one_answer if danswer(X,Y),clearwindow,
      write("For this hypothesis: "),nl,write("    ",X),nl,
      write("The certainty is:  ",Y),nl,nl,not(how_describer(X)).
/*  End of driver for all inferencing operations.                */       


/*    Inference Rules and Mechanisms Used by a Running System     */
/*  Simple implication rules.                                     */
   infer(Node1,Ct) if imp(s,Use,Node1,Sign,Node2,_,_,C1),
      asserta(dbimp(s,Use,Node1,Sign,Node2,dummy,dummy,C1 )),
      asserta(tdbimp(s,Use,Node1,Sign,Node2,dummy,dummy,C1 )),
      allinfer(Node2,C2),qualifier(Use,C2,Qmult),
      find_multiplier(Sign,Mult,dummy,0),Ct = Mult*C1*C2*Qmult,
      assertz(infer_summary(
         imp(s,Use,Node1,Sign,Node2,dummy,dummy,C1),Ct)),
      retract(dbimp(s,Use,Node1,Sign,Node2,dummy,dummy,C1 )),
      retract(tdbimp(s,Use,Node1,Sign,Node2,dummy,dummy,C1 )).

/*  Inference involving an AND implication.                      */
   infer(Node1,Ct) if imp(a,Use,Node1,SignL,Node2,SignR,Node3,C1),
      asserta(dbimp(a,Use,Node1,SignL,Node2,SignR,Node3,C1 )),
      asserta(tdbimp(a,Use,Node1,SignL,Node2,SignR,Node3,C1 )),
      allinfer(Node2,C2),allinfer(Node3,C3),
      find_multiplier(SignL,MultL,SignR,MultR),
      C2S = MultL*C2,C3S = MultR*C3,min(C2S,C3S,CE),
      qualifier(Use,CE,Qmult),Ct = CE*C1*Qmult,
      assertz(infer_summary(
         imp(a,Use,Node1,SignL,Node2,SignR,Node3,C1),Ct)),
      retract(dbimp(a,Use,Node1,SignL,Node2,SignR,Node3,C1 )),
      retract(tdbimp(a,Use,Node1,SignL,Node2,SignR,Node3,C1 )).

/*  Inference involving an OR implication.                       */
   infer(Node1,Ct) if imp(o,Use,Node1,SignL,Node2,SignR,Node3,C1),
      asserta(dbimp(o,Use,Node1,SignL,Node2,SignR,Node3,C1 )),
      asserta(tdbimp(o,Use,Node1,SignL,Node2,SignR,Node3,C1 )),
      allinfer(Node2,C2),allinfer(Node3,C3),
      find_multiplier(SignL,MultL,SignR,MultR),
      C2S = MultL*C2,C3S = MultR*C3,max(C2S,C3S,CE),
      qualifier(Use,CE,Qmult),Ct = CE*C1*Qmult,
      assertz(infer_summary(
         imp(o,Use,Node1,SignL,Node2,SignR,Node3,C1),Ct)),
      retract(dbimp(o,Use,Node1,SignL,Node2,SignR,Node3,C1 )),
      retract(tdbimp(o,Use,Node1,SignL,Node2,SignR,Node3,C1 )).

/**  Inference Processing for relational expressions (formulas).  */
   infer(Node1,Ct) if imp(f,Use,Node1,Csign,Cond,dummy,dummy,C),
      asserta(dbimp(f,Use,Node1,Csign,Cond,dummy,dummy,C )),
      asserta(tdbimp(f,Use,Node1,Csign,Cond,dummy,dummy,C )),
      clearwindow,
      write("Need to ask some questions to evaluate a formula."),
      nl,nl,cleanerz,expr_eval(Cond,TF),cond_multiplier(Csign,Cmult),
      XXX=TF*Cmult,qualifier(Use,XXX,Qmult),Ct = XXX*C*Qmult,
      assertz(infer_summary(
         imp(f,Use,Node1,Csign,Cond,dummy,dummy,C),Ct)),
      form_describer(Node1,Ct),
      retract(dbimp(f,Use,Node1,Csign,Cond,dummy,dummy,C )),
      retract(tdbimp(f,Use,Node1,Csign,Cond,dummy,dummy,C )).

/**  Inference Processing for terminal nodes.                    */
   infer(Node1,Ct) if terminal_node(Node1),evidence(Node1,Ct),!.

   infer(Node1,Ct) if terminal_node(Node1),repeat,nl,clearwindow,
      write("For this condition:"),nl,nl,write("    ",Node1),nl,nl,
      write("Type y(yes), n(no), or w(why),"),nl,
      write(" or give a certainty (-1.0 to +1.0)."),nl,
      nl,readln(Reply),reply_to_input(Node1,Reply,Ct),!.

/*  Used to arbitrate reversibility of rules.                    */
   qualifier(Use,C,Qmult) if Use="r",Qmult=1,!.
   qualifier(Use,C,Qmult) if Use="n",C >= 0,Qmult=1,!.
   qualifier(Use,C,Qmult) if Use="n",C < 0,Qmult=0,!.

/*  Used to provide for negation of the premise of a rule when
     that premise is a relational expression (i.e. a formula.)   */  
   cond_multiplier( pos,1 ).
   cond_multiplier( neg,-1).
      
/*  Used to provide sign changes where needed for negation.       */   
/*  This is used for simple implication.                          */
   find_multiplier(pos,1,dummy,0) .
   find_multiplier(neg,-1,dummy,0) .
/*  This is used for AND and OR                                   */
   find_multiplier(pos, 1,pos, 1) .
   find_multiplier(pos, 1,neg,-1) .
   find_multiplier(neg,-1,pos, 1) .
   find_multiplier(neg,-1,neg,-1) .

/*  Collects the results of all applicable rules at a node.       */     
   allinfer(Node,Ct) if findall(C1,infer(Node,C1),Ctlist),
      supercombine(Ctlist,Ct).           
      
/*  Implements updating with a two at a time combination rule.    */      
   supercombine([Ct],Ct) if !.
   supercombine([C1,C2],Ct) if combine([C1,C2],Ct),!.
   supercombine([C1,C2|T],Ct) if combine([C1,C2],C3),
      append([C3],T,TL),supercombine(TL,Ct),!.
                   
/* This predicate combines evidence from two
   rules when they each apply to a single conclusion.
   First argument is a list of certainties. Second is
   what they all resolve too.                                      */

   combine([-1,1],0.0).
   combine([1,-1],0.0).

   combine([C1,C2],Ct) if C1 >= 0, C2 >= 0,
      Ct = C1 + C2 - C1*C2.
   combine([C1,C2],Ct) if C1 < 0, C2 < 0,
      Ct = C1 + C2 + C1*C2.
   combine([C1,C2],Ct) if C1 < 0, C2 >= 0,
      absvalue(C1,Z1), absvalue(C2,Z2),min(Z1,Z2,Z3),
      Ct = (C1 + C2)/(1.0 - Z3).
   combine([C1,C2],Ct) if C2 < 0, C1 >= 0,
      absvalue(C1,Z1), absvalue(C2,Z2),min(Z1,Z2,Z3),
      Ct = (C1 + C2)/(1.0 - Z3).

   
/**     Administers Terminal Node input and Why Questions.        */
/*  Note, all data for system comes in at terminal nodes. 
    Possible input is a certainty figure, or yes, or no, or why.  */
   reply_to_input(Node,Reply,Ct) if not(isname(Reply)),
      adjuststack,str_real(Reply,Ct),asserta(evidence(Node,Ct)),!.

   reply_to_input(Node,Reply,Ct) if isname(Reply),Reply = "y",
      adjuststack,Ct=1.0,asserta(evidence(Node,Ct)),!.

   reply_to_input(Node,Reply,Ct) if isname(Reply),Reply = "n",
      adjuststack,Ct=-1.0,asserta(evidence(Node,Ct)),!.

   reply_to_input(_,Reply,_) if isname(Reply),Reply = "w",nl,
      dbimp(U,V,R,S,S1,X,Y,Y1),
      why_describer(U,V,R,S,S1,X,Y,Y1),
      retract(dbimp(U,V,R,S,S1,X,Y,Y1)),
      putadjustflag,
      pauser,!,fail.

   reply_to_input(_,Reply,_) if
      isname(Reply),Reply = "c",adjuststack,!.


/**** Administers Special why explanations from an inference that
      involves the a relational expression in the premise.  *****/
   form_describer(Node,Ct) if       
      repeat,nl,nl,
      write("To see the reason for these questions, "),
      write("or for this processing."),
      nl,write("type w(why).  Otherwise type c(continue)."),
      nl,readln(Reply),reply_to_input(Node,Reply,Ct),!.


/*  Answers why questions for and/or rules.                       */
   why_describer(U,U1,V,R,S,X,Y,Z) if clearwindow,nl,
      U <> "s",U <> "f",gettype2(U,UU), 
      write("I am trying to use an inference rule of the "),nl,
      write(UU),write(" type, to support the conclusion: "),nl,
      write("    ",V),nl,write("Premise 1 is: ",S),nl,getmode1(R,RR),
      write("    This premise will be used ",RR),nl,
      write("Premise 2 is: ",Y),nl,getmode1(X,XX),
      write("    This premise will be used ",XX),nl,
      write("The certainty of the implication is: ",Z),nl,!.

/*  Answers why questions for simple implications.                 */
   why_describer("s",V1,V,R,S,X,Y,Z) if clearwindow,nl,
      write("I am trying to use an inference rule of the "),nl,
      write("SIMPLE type, to support the conclusion: "),nl,
      write("    ",V),nl,write("Premise 1 is: ",S),nl,getmode1(R,RR),
      write("    This premise will be used ",RR),nl,
      write("The certainty of the implication is: ",Z),nl,!.

/*  Answers why questions for relational expression rules.        */
   why_describer("f",V1,V,R,S,X,Y,Z) if clearwindow,nl,
      write("I am trying to use an inference rule of the "),
      nl,write("RELATIONAL EXPRESSION type, "),
      write("to support the conclusion: "),nl,
      write("    ",V),nl,write("Premise 1 is:  ",S),nl,getmode1(R,RR),
      write("    This premise will be used ",RR),nl,
      write("The certainty of the implication is: ",Z),nl,!.
     
/*  Used to expand terse rule format for user friendlyness.       */      
   gettype1("a"," an and implication").
   gettype1("o"," an or implication").
   gettype1("s"," a simple implication").
   gettype1("f"," a relational expression implication").

   gettype2("a","AND").
   gettype2("o","OR").
  
   getmode1("pos","just as you see it.").
   getmode1("neg","prefaced by not.").    

   getmode2("pos"," ").
   getmode2("neg"," NOT ").
   getmode2("dummy"," ").
 
/*  Restores stack as was before why questions.                  */
   adjuststack if adjustflag,retract(adjustflag),purgeit,reloadit,!.
   adjuststack.

   purgeit  if retract(dbimp(_,_,_,_,_,_,_,_)),fail.
   purgeit.

   reloadit if tdbimp(X,Y,Z,R,R1,S,V,V1),
      assertz(dbimp(X,Y,Z,R,R1,S,V,V1)),fail.
   reloadit.

/* Makes sure just one flag is on stack after it's called.        */
/*  Flag is used to show when why stack needs restoration.        */
   putadjustflag if not(adjustflag),asserta(adjustflag).
   putadjustflag.
/*   End of Administration of Terminal Questions and Why's        */


/*  Administers how explanations.                                 */
   how_describer(Node) if hypothesis_node(Node),repeat,nl,
      write("Type h(how) conclusion, or c(continue)."),
      nl,readln(Reply),nl,how_explain(Reply),!.
    
   how_explain(X) if X = "c".
 
 /*  Used for all reasoned conclusions.                           */
   how_explain(Reply) if 
      fronttoken(Reply,_,X1),fronttoken(X1,X2,Y),concat(X2,Y,X),
      infer_summary(imp(_,_,X,_,_,_,_,_),_),clearwindow,!,
      write("The rule(s) that bear upon this conclusion are: "),nl,nl,
      infer_summary(imp(A,A1,X,R,S,C,D,E),F),
      write("Concluded:  ",X),nl,gettype1(A,Z),write(" from",Z),nl,
      getmode2(R,RR),write(" premise 1 was:",RR,"(",S,")"),nl,
      getmode2(C,CC),write(" premise 2 was:",CC,"(",D,")"),nl,
      write("The certainty from use of this rule alone was: ",F), 
      nl,nl,fail.
            
/*  To explain terminal facts.                                    */            
   how_explain(Reply) if 
      fronttoken(Reply,_,X1),fronttoken(X1,X2,Y),concat(X2,Y,X),
      terminal_node(X),evidence(X,C),
      write("You told me that: "),nl,write("   ",X),nl,
      write("with a certainty of: ",C),nl,fail.
/******************************************************************/
/*******  End of Inference Rules and Mechanisms Section     *******/



/******************************************************************/
/*                                                                */
/*       Menu Process Number 7                                    */
/*       Editing an Existing Rule Set                             */
/*                                                                */
/******************************************************************/
   edit_rs if
      pick_exsys(Filename),file_str(Filename,Inputstring),
      edit(Inputstring,Outputstring),clearwindow,
      write("Save this Rule Set? (type y/n) "),
      readchar(Ans),record_it(Ans,Outputstring,Filename).

   record_it('y',Data,Filename) if
      openwrite(descriptor,Filename),writedevice(descriptor),
      write(Data),closefile(descriptor),clearall,consult(Filename).

   record_it('n',_,_).
/******************************************************************/



/******************************************************************/
/*                                                                */
/*       Various Auxilliary Predicates                            */
/*                                                                */
/******************************************************************/
/*  Low level predicates used in multiple places in the system. ***/
   get_name(Name) if makewindow(10,7,7,"GET FILE NAME",10,10,10,60),
      nl,write("State a DOS filename for this Rule Set."),
      nl,write("Do not use a file extension."),
      nl,readln(Z),concat(Z,".rul",Name),removewindow,!.
  
   pauser if nl,nl,
        write(" **********  Hit any key to continue."),readchar(T).

   pick_exsys(Rules) if 
      makewindow(10,7,7,"PICK A RULE SET",10,10,10,60),
      dir("//","*.rul",Rules),removewindow.

/*  Predicates for initialization and reinitialization.           */
/*  Used to clean up  results of one run with a given rule set.   */
   cleanerx if not(cleanit1),not(cleanit2),not(cleanit3),
      not(cleanit4),not(cleanit5),not(cleanit10),not(cleanit13).
      
      cleanit1 if retract(evidence(_,_)),fail.
      cleanit2 if retract(dbimp(_,_,_,_,_,_,_,_)),fail.
      cleanit3 if retract(tdbimp(_,_,_,_,_,_,_,_)),fail.
      cleanit4 if retract(infer_summary(_,_)),fail.
      cleanit5 if retract(adjustflag),fail.           
      cleanit10 if retract(danswer(_,_)),fail.
      cleanit13 if retract(varvalue(_,_)),fail.
 
/*  Used for completely changing a rule set.                      */ 
   cleanery if not(cleanit6),not(cleanit7),
      not(cleanit9),not(cleanit14).

      cleanit6 if retract(imp(_,_,_,_,_,_,_,_)),fail.
      cleanit7 if retract(terminal_node(_)),fail.
      cleanit9 if retract(hypothesis_node(_)),fail.
      cleanit14 if retract(define(_,_)),fail.

/*  Used to clean up after one use of the expression evaluator.   */
   cleanerz if not(cleanit11),not(cleanit12).

      cleanit11 if retract(convstack(_)),fail.
      cleanit12 if retract(stackvalue(_)),fail.

/*  Used to reinitialize -- cleans everything.                    */
   clearall if cleanerx,cleanery,cleanerz.
/****End of low level predicates used in multiple places.*********/

 
/* General Purpose Predicates normally kept in a library module. */ 
/* Standard minimum and maximum predicates.                      */
   max(C1,C2,C2 ) if C2 >= C1,!.
   max(C1,C2,C1) if C2 < C1,!.
   min(C1,C2,C2) if C2 <= C1,!.
   min(C1,C2,C1) if C2 > C1,!.

/*  New absolute value expression.                               */
   absvalue(X,Y) if X = 0,Y = 0, !.
   absvalue(X,Y) if X > 0, Y = X, !.
   absvalue(X,Y) if X < 0, Y = -X, !.

   repeat.
   repeat if repeat.
 
   append([],List,List).
   append([X|L1],List2,[X|L3]) if append(L1,List2,L3).
/******************************************************************/


goal
   shell_driver.
             