; ICon Exchanger
; ICE Version 1.00
; Copyright (C) 1995 Hiroyuki Sekiya

		IDEAL
		P186
		INCLUDE "tsr.inc"

ICN_W		EQU	44
ICN_H		EQU	32
ICN_LEN		EQU	%((ICN_W+7)/8*ICN_H)
CMP_LEN		EQU	20
CMP_OFS		EQU	%((ICN_W+7)/8*9)
MAX_SWAP	EQU	18

STRUC _icn
  planes	DW	?
  bits		DW	?
  w		DW	?
  h		DW	?
  img		DB	ICN_LEN DUP (?)
ENDS

STRUC _swap
  match		DB	CMP_LEN DUP (?)
  subst		_icn	?
ENDS


;
;	TSR segment
;
SEGMENT		_TSR
		ASSUME	cs:_TSR, ds:_TSR

; Cougar Graphic BIOS
PROC		int5F
		pushf
		sti
		cmp	ah, 0Eh
		jne	@@jmpold
		cmp	[(_icn es:di).w], ICN_W
		jne	@@jmpold
		cmp	[(_icn es:di).h], ICN_H
	IF 0
		jne	@@jmpold
		cmp	[(_icn es:di).planes], 1
		jne	@@jmpold
		cmp	[(_icn es:di).bits], 1
	ENDIF
		je	@@func0E
	@@jmpold:
		popf
		DB	0EAh
old5F		DD	?

	; cx	X
	; dx	Y
	; es:di	image
	; al	reprule
	@@func0E:
		pushm	si, ds
		movseg	ds, cs
		mov	si, OFFSET _TSR:swap_icns
		push	cx
		mov	cx, [ds:swap_count]
		cld
		add	di, OFFSET (_icn 0).img + CMP_OFS
		jmp	@@entry
	@@loop:
		add	si, SIZE _swap
	@@entry:
		pushm	cx, si, di	;{
		mov	cx, CMP_LEN/2
		rep cmpsw
		popm	di, si, cx	;}
		loopne	@@loop
		je	@@found
	@@not_found:
		sub	di, OFFSET (_icn 0).img + CMP_OFS
		pop	cx
		popm	ds, si
		jmp	@@jmpold
	@@found:
		pop	cx
		sub	di, OFFSET (_icn 0).img + CMP_OFS
		add	si, CMP_LEN
		push	es		;{
		movseg	es, cs
		xchg	si, di
		mov	ah, 0Eh
		pushf
		cli
		call	[ds:old5F]
		xchg	si, di
		pop	es		;}
		popm	ds, si
		popf
		iret
ENDP

		EVENDATA
swap_count	DW	0
swap_icns	_swap	MAX_SWAP DUP (?)

ENDS		_TSR


;
;	Data segment
;
SEGMENT		_DATA

		EXTRN	app_inf		: WORD
		EXTRN	app_count	: WORD
		EXTRN	usage		: BYTE
		PUBLIC	progname, vectors

vectors		DW	_TSR:old5F, _TSR:int5F, 5Fh
		DW	-1

LABEL		progname	BYTE
copyright	DB	"ICE Version 1.00 Copyright(C) 1995 by H.Sekiya", NWL, EOS
msgStay		DB	"Installed.", NWL, EOS
msgRel		DB	"Removed.", NWL, EOS
msgNotStay	DB	"Not installed.", NWL, EOS
msgAlready	DB	"Already installed.", NWL, EOS
msgStayErr	DB	"Not enough memory.", NWL, EOS
msgRelErr	DB	"Cannot remove.", NWL, EOS
msgNoIni	DB	"INI file not found.", NWL, EOS
msgNoIcn	DB	"ICN file not found.", NWL, EOS
relFlag		DB	OFF
ini_path	DB	0, 127 DUP (?)

ENDS		_DATA

SEGMENT		_BSS

		EXTRN	tsrSize		: WORD

LINE_BUF_LEN	EQU	160
line_buf	DB	LINE_BUF_LEN DUP (?)
FILE_BUF_LEN	EQU	4096
file_buf	DB	FILE_BUF_LEN DUP (?)

ENDS		_BSS

;
;	PSP
;
SEGMENT		_PSP

		EXTRN	argv		: BYTE

ENDS		_PSP

;
;	Code segment
;
SEGMENT		_TEXT

		ASSUME	cs:DGROUP, ds:DGROUP, es:_TSR

		EXTRN	stayCheck	: PROC
		EXTRN	stayTsr		: PROC
		EXTRN	releaseTsr	: PROC
		EXTRN	check_machine	: PROC
		PUBLIC	main

PROC		parseOption
		mov	si, OFFSET argv
		cld
	@@loop:
		lodsb
		cmp	al, CR
		clc
		je	@@exit
		cmp	al, ' '
		jbe	@@loop
		cmp	al, '-'
		je	@@loop
		cmp	al, '/'
		je	@@loop
		and	al, NOT 20h	; to upper
		cmp	al, 'F'
		je	@@F
		cmp	al, 'R'
		je	@@R
		stc
		jmp	@@exit

	@@F:
		movseg	es, cs
		mov	di, OFFSET ini_path
	@@f_loop:
		lodsb
		cmp	al, ' '
		jbe	@@f_end
		stosb
		jmp	@@f_loop
	@@f_end:
		clr	al
		stosb
		dec	si
		jmp	@@loop

	@@R:
		mov	[relFlag], ON
		jmp	@@loop

	@@exit:
		ret
ENDP

; AṽACRC[W̃|C^Ԃ
; ->	ds:si	AvP[V (ASCIIZ)
; <-	zr	
;		ds:bx	ACRC[W̃AhX
;	nz	Ȃ
; ><	bx
PROC		get_icn_img
		pushm	ax, cx, di, es
		movseg	es, cs
		mov	bx, OFFSET app_inf
		mov	cx, [app_count]
		jmp	@@entry
	@@app_loop:
		add	bx, 4
	@@entry:
		mov	di, [bx]
		push	si
	@@cmp_loop:
		lodsb
		cmp	al, 'a'
		jb	@@cmp
		cmp	al, 'z'
		ja	@@cmp
		add	al, 'A'-'a'
	@@cmp:
		scasb
		jne	@@cmp_end
		cmp	al, '='
		jne	@@cmp_loop
	@@cmp_end:
		pop	si
		loopne	@@app_loop
		mov	bx, [bx+2]
		popm	es, di, cx, ax
		ret
ENDP

; ->	ds:si	source
;	es:di	destination
;	cx	maximum length
; <-	al	0, EOF or CR
; ><	ax
PROC		strncpy
		pushm	cx, di
		dec	cx
		jmp	@@1
	@@loop:
		stosb
	@@1:
		cmp	[BYTE si], EOF
		je	@@exit
		lodsb
		cmp	al, CR
		loopne	@@loop
		cmp	[BYTE si], LF
		jne	@@exit
		inc	si
	@@exit:
		clr	al
		stosb
		popm	di, cx
		ret
ENDP

PROC		load_ini_file
		mov	dx, OFFSET ini_path
		mov	ax, 3D00h
		int	21h		; open handle
		jc	@@exit
		mov	bx, ax
		mov	dx, OFFSET file_buf
		mov	cx, FILE_BUF_LEN - 1
		mov	ah, 3Fh
		int	21h		; read handle
		jc	@@close
		xchg	ax, bx
		mov	[file_buf+bx], EOF	; sentinel
		xchg	ax, bx
	@@close:
		pushf
		mov	ah, 3Eh
		int	21h		; close handle
		popf
	@@exit:
		ret
ENDP

PROC		parse_ini_file
		movseg	es, cs
		mov	si, OFFSET file_buf

	@@loop:
	; t@C1sǂݍ
		mov	di, OFFSET line_buf
		mov	cx, LINE_BUF_LEN
		call	strncpy
		push	si
		mov	si, di

	; ACRC[W풓ɃRs[
		call	get_icn_img
		jnz	@@next_line
		mov	ax, SIZE _swap
		mul	[swap_count]
		mov	di, OFFSET swap_icns
		add	di, ax
		mov	si, bx
		mov	cx, CMP_LEN / 2
		rep movsw

	; =̌(t@C)܂ňړ
		mov	si, OFFSET line_buf
	@@equal_loop:
		lodsb
		cmp	al, '='
		jne	@@equal_loop

	; t@CACRC[Wǂ
		mov	dx, si
		mov	ax, 3D00h
		int	21h		; open handle
		jc	@@next_line
		mov	bx, ax
		mov	dx, di
		mov	cx, SIZE _icn
		mov	ah, 3Fh
		int	21h		; read handle
		pushf
		mov	ah, 3Eh
		int	21h
		popf
		jc	@@next_line
		inc	[swap_count]
	@@next_line:
		pop	si
		cmp	[swap_count], MAX_SWAP
		ja	@@exit
		cmp	[BYTE si], EOF
		jne	@@loop
	@@exit:
		ret
ENDP

PROC		main
		mov	dx, OFFSET copyright
		mov	ah, 09h
		int	21h

		call	parseOption
		mov	dx, OFFSET usage
		jc	@@ret

		call	check_machine

		cmp	[relFlag], ON
		je	@@release

	; Install TSR
	@@stay:
		mov	dx, OFFSET usage
		cmp	[ini_path], 0
		stc
		je	@@ret

		call	stayCheck
		mov	dx, OFFSET msgAlready
		stc
		jz	@@ret

	; INIt@Cǂ
		call	load_ini_file
		mov	dx, OFFSET msgNoIni
		jc	@@ret
		call	parse_ini_file
		mov	dx, OFFSET msgNoIcn
		mov	cx, [swap_count]
		stc
		jcxz	@@ret

	; uACRɉď풓TCY؂l߂
		mov	ax, SIZE _swap
		mul	cx
		add	ax, OFFSET _TSR:swap_icns
		dec	ax
		shrm	ax, 4
		inc	ax
		mov	[tsrSize], ax

		call	stayTsr
		mov	dx, OFFSET msgStay
		jnc	@@ret
		mov	dx, OFFSET msgStayErr
		jmp	@@ret

	; Remove TSR
	@@release:
		call	stayCheck
		mov	dx, OFFSET msgNotStay
		stc
		jnz	@@ret
		call	releaseTsr
		mov	dx, OFFSET msgRel
		jnc	@@ret
		mov	dx, OFFSET msgRelErr
	@@ret:
		sbb	al, al
		ret
ENDP

ENDS		_TEXT

		END
