#include <stdio.h>
#include <stdlib.h>
#include <dos.h>

#include <pal.h>

void main (int argc, char * argv[])
{
   DBDESC *pDD;
   void   *pData;
   int     f, page =1, error;

   if(argc < 2) FatalExit("\nUSAGE: view <dbfile>\n",1);

   if(!PalInit(1)) FatalExit("Init failed - CGAGRAPH not loaded ?", 1);

   /* open database */
   pDD = OpenDatabase(argv[1], &error);

   if(!pDD) {
      TextMode();
      fprintf(stderr,"\aFatal Error #%d opening database.\n", error);
      exit(1);
   }

   /* show all records */
   for(f=0; f<pDD->NumDataRec; f++) {
      printf("\r(%d/%d)", f, pDD->NumDataRec);   /* show record number */

      /* read a record */
      pData = ReadRecord(pDD, TYPE_DATA, f);

      /* show the record */
      if(pData) {
         ShowCard(pDD, page);           /* show card */
         ShowRecord(pDD, page, pData);  /* show record data */

         GetKey();
         if(inportb(0x60)==1) break;    /* ESC key quits */

         /* discard record */
         free(pData);
      }
   }

    /* close database */
   CloseDatabase(pDD);

   PalDeInit(1);

}
