/* dox.h  The support file for dox and all its contributary files. */ 
/* Definitions */
#define PRESERVED 3
#define MAXSTYLES 10
#define MAXSTATES 20
#define MAXBRACKETS 20

#ifndef TRUE
#define TRUE -1
#define FALSE 0
#endif
#define FAIL -1

#define dox "dox"
#define dox16 "dox16"
#define dox32 "dox32"
#define doxw32 "doxw32"

#define COMPILE COMP

#define VERSION "1.10"

/* Document independent types. */
enum style_code
	{
        st_begin,
	st_break,
        st_paragraph,
        st_centre,
	st_normal,
	st_fonttable,
	st_fontsize,
	st_bold,
	st_italic,
	st_underline
	};

enum doc_code
        {
        doc_rtf,
        doc_html,
        doc_text
        };

struct state_struct
{
short current[MAXSTYLES];
short new[MAXSTYLES];
short font_sensitive;
short indoc, outdoc;
short cur_line_len;
FILE *in;
FILE *out;
};

typedef struct state_struct state_type;


/* Function prototypes. */
void help(unsigned level);
void paragraph(state_type *state, char *word);
void default_style(state_type *state, unsigned init);
short nextchar(FILE *instream);

/* Remapping functions */
void convert(state_type *state);
void update_style(state_type *state);
void output(state_type *state, char *word);



/* Html format functions. In html.c */
void html_convert(state_type *state);
void html_update_style(state_type *state);
void html_output(state_type *state, char *word);

/* Rtf format functions. In rtf.c */
void rtf_convert(state_type *state);
void rtf_update_style(state_type *state);
void rtf_output(state_type *state, char *word);

/* Text format functions. In text.c */
void text_convert(state_type *state);
void text_update_style(state_type *state);
void text_output(state_type *state, char *word);
