/***********************************************************************
RIE-EX1.C: Remote Import/Export example program #1
by MSW
Copyright (c) 1992 by cc:Mail, Inc.  All rights reserved.

This source code, any derivatives of it, and the resulting object code
may be freely used and/or copied, so long as this copyright notice is
included and remains unmodified.  cc:Mail, Inc. does not make any
representation or warranty, express or implied with respect to this
source code.  cc:Mail, Inc. disclaims any liability whatsoever for any
use of such code.

************************************************************************

    This program is an example of how to execute the RImport, RExport,
    or RConnect program from a C program.  It simply exports the
    headings of all the Inbox messages to the specified file.  The usage
    is:
        rie-ex1 pswd file

            where pswd is the user's password
                  file is the output file

    RIE-EX1 returns an ERRORLEVEL of 0 for success and 1 for any error.

    REXPORT.EXE is assumed to be in the DOS PATH when this program is
    run.  The mailbox files (e.g., MBOXDATA) are assumed to be in the
    current directory.

    Build with Microsoft C version 5.1 or later using any memory model.
***********************************************************************/


// Include file(s)
#include <process.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>


/***********************************************************************
RIE-EX1 main routine (described above)
***********************************************************************/
int main(int argc, char *argv[])
{
    char filearg[_MAX_PATH + 2];
    int rtn;

    // Verify number of arguments
    if (argc != 3) {
        printf("Usage: rie-ex1 pswd file\n");
        return  1;
    }

    // Build the filename argument for REXPORT
    filearg[0] = '@';
    strcpy(filearg + 1, argv[2]);

    // Do it
    rtn = spawnlp(P_WAIT, "REXPORT.EXE", "REXPORT", argv[1], filearg,
        "NAME/1", "HEADINGS/ALL", NULL);

    // Handle errors and exit
    if (rtn == -1) {
        printf("rie-ex1: Cannot call the RExport program; errno = %d\n",
            errno);
        return  1;
    }
    printf("rie-ex1: RExport program return code is = %d\n", rtn);
    return  0;
} // main

// End of RIE-EX1.C

