'/* WCNT.BAS  Count the occurrences of a string in a file */
'/*           By: Dale Thorn                              */
'/*           Rev. 11.05.2000                             */

'$include: 'basdef.h'
'$include: 'filekill.h'
'$include: 'fileopen.h'
'$include: 'longname.h'
'$include: 'messages.h'
'$include: 'midchar.h'
'$include: 'parmstr1.h'
'$include: 'string.h'
'$include: 'tfind.h'
'$include: 'basdef.bas'
'$include: 'filekill.bas'
'$include: 'fileopen.bas'
'$include: 'longname.bas'
'$include: 'messages.bas'
'$include: 'midchar.bas'
'$include: 'parmstr1.bas'
'$include: 'tfind.bas'
'$include: 'scrnparm.bas'
'$include: 'string.bas'

ctxt = rtrim$(command$)                  'save in case of case-sensitive search
ccmd = ucase$(ctxt)                     'get the user's command-line parameters
if ccmd = "" then                              'a command line was NOT supplied
   i = ifn.msgs("Usage:  WCNT  filename  searchtext  [/c]", iofs, irow, icol, 0, 1)
end if                              'display the usage message [above] and exit

iprm = parmstr1(ccmd, cfil, cnam, cext, cprm())  'parse command-line parameters
if iprm < 0 or iprm > 1 then                  'no. of parameters was zero or >2
   i = ifn.msgs("Invalid number of parameters", iofs, irow, icol, 1, 1)
end if                      'display no.-of-parameters message [above] and exit

if cnam = "" or len(cnam) > 8 or len(cext) > 3 or instr(cext, ".") then
   i = ifn.msgs("Invalid filename", iofs, irow, icol, 1, 1)   'invalid filename
end if                       'display invalid-filename message [above] and exit

if iprm = 1 then                        'case-sensitive parameter was specified
   if cprm(1) = "C" then          'case-sensitive parameter specified correctly
      ctxt = rtrim$(left$(ctxt, len(ctxt) - 2))'remove '/C' from command params
      cprm(0) = right$(ctxt, len(cprm(0)))      'restore original search string
      tf.csen = not 0                               'set case-sensitive flag ON
   else                       'case-sensitive parameter NOT specified correctly
      i = ifn.msgs("Invalid CASE parameter", iofs, irow, icol, 1, 1)
   end if                   'display invalid-parameter message [above] and exit
else                                'case-sensitive parameter was NOT specified
   tf.csen = 0                                     'set case-sensitive flag OFF
end if

tf.fnum = 1                      'file channel/unit number for binary-mode file
i = ifn.open(tf.fnum, cfil, "B", tf.llof)  'open the source file in binary mode
if tf.llof < 0 then                             'user input a wildcard filespec
   i = ifn.msgs("Invalid filename", iofs, irow, icol, 1, 1)      'beep and exit
elseif tf.llof = 0 then                       'source file nonexistent or empty
   i = ifn.kill(tf.fnum, cfil)                       'kill the zero-length file
   i = ifn.msgs(cfil + " not found", iofs, irow, icol, 1, 1)     'beep and exit
end if

i = ifn.msgs("Please standby", iofs, irow, icol, 0, 0) 'display standby message
ibuflen = (fre("") - 4096) \ 2      'get available memory for buffer allocation
itxtlen = len(cprm(0))                        'length of the search-text string
cbuf = space$(ibuflen)                           'allocate the main file buffer
cbeg = space$(1)                             'allocate the pre-buffer character
cend = space$(1)                            'allocate the post-buffer character
tf.bbeg = 1                           'initialize begin search position in cbuf
tf.fbeg = 1                           'initialize begin search position in file
tf.load = not 0                      'OK to load initial buffer inside function
lstr = 0                                      'initialize the sub-strings total
lwrd = 0                                      'initialize the whole-words total

do                                    'begin the loop to count the text matches
   if ifn.tfnd(tf, cbuf, cprm(0)) = 27 then       'the User pressed the ESC key
      i = ifn.msgs("Esc pressed - Program aborted", iofs, irow, icol, 0, 1)
   end if                  'ESC pressed; display abort message [above] and exit
   if tf.bbeg then                            'a matching text string was found
      if tf.bbeg = 1 then                'text position is at beginning of cbuf
         if tf.fbeg = 1 then           'cbuf begin-byte is at beginning of file
            lset cbeg = ""           'no prior text; clear pre-buffer character
         else                           'cbuf begin-byte is > beginning of file
            get tf.fnum, tf.fbeg - 1, cbeg 'load pre-buffer character from file
         end if
      else                                'text position is > beginning of cbuf
         lset cbeg = char(midchar(cbuf, tf.bbeg - 1))'load pre-buffer from cbuf
      end if
      iloc = tf.bbeg + itxtlen               'position of post-buffer character
      if iloc > ibuflen then            'post-buffer character is > end of cbuf
         lloc = tf.fbeg + iloc - 1   'position of post-buffer character in file
         if lloc > tf.llof then         'post-buffer character is > end of file
            lset cend = ""     'no subsequent text; clear post-buffer character
         else                          'post-buffer character is <= end of file
            get tf.fnum, lloc, cend       'load post-buffer character from file
         end if
      else                             'post-buffer character is <= end of cbuf
         lset cend = char(midchar(cbuf, iloc))      'load post-buffer from cbuf
      end if
      ich1 = asc(cbeg)                     'ASCII value of pre-buffer character
      ich2 = asc(cend)                    'ASCII value of post-buffer character
      if ich1 >= 48 and ich1 <= 57 _                'character is numeric (0-9)
      or ich1 >= 65 and ich1 <= 90 _              'character is uppercase (A-Z)
      or ich1 >= 97 and ich1 <= 122 _             'character is lowercase (a-z)
      or ich2 >= 48 and ich2 <= 57 _                'character is numeric (0-9)
      or ich2 >= 65 and ich2 <= 90 _              'character is uppercase (A-Z)
      or ich2 >= 97 and ich2 <= 122 then          'character is lowercase (a-z)
         lstr = lstr + 1                       'increment the sub-strings total
      else                           'pre/post characters are none of the above
         lwrd = lwrd + 1                       'increment the whole-words total
      end if
      tf.bbeg = tf.bbeg + 1               'move search to next position in cbuf
   else                                   'a matching text string was NOT found
      exit do            'text not found in file; search complete; exit routine
   end if
loop

locate 5, iofs, 0                                  'position the display cursor
print "Whole words = "; ltrim$(str$(lwrd))           'display the first message
locate 7, iofs, 0                                  'position the display cursor
print "Sub-strings = "; ltrim$(str$(lstr))          'display the second message
locate 9, iofs, 0                                  'position the display cursor
print "Grand total = "; ltrim$(str$(lwrd + lstr))    'display the third message
locate 10, 1, 1                          'position the cursor for return to DOS

close                                 'close all files in case not closed above
system                                              'return to operating system
