'/* PARMSTR2.BAS  Rev. 02.04.2003                 */
'/*                                               */
'/* NOTE: To parse parameters only (no filename), */
'/*       send ccmd as [" " + ccmd].              */

dim cprm(12)                         'parameters passed back to calling program

function parmstr1(ccmd, cfil, cnam, cext, cprm())'parse command-line parameters
   ipos1 = 0                           'initialize '/' position in command line
   do                                   'loop to blank out '/'s in command line
      ipos1 = instr(ipos1 + 1, ccmd, "/")    'first or next '/' in command line
      if ipos1 then                         '/' character found in command line
         if mid$(ccmd, ipos1, 2) = "//" then        'retain '/' character macro
            ccmd = left$(ccmd, ipos1 - 1) + mid$(ccmd, ipos1 + 1)   'remove '/'
         else                              'no macro; OK to substitute with ' '
            mid$(ccmd, ipos1) = " "                       'replace '/' with ' '
         end if
      end if
   loop while ipos1                    'loop until all '/' characters processed
   ccmd = rtrim$(ccmd)                'remove trailing blanks from command line
   iquo1 = instr(ccmd, char(34)) 'initialize 1st quote position in command line
   iquo2 = instr(iquo1 + 1, ccmd, char(34)) '2nd quote position in command line
   ipos1 = 1                          'initialize '  ' position in command line
   do                                   'loop to compress '  's in command line
      ipos1 = instr(ipos1, ccmd, "  ")      'first or next '  ' in command line
      while iquo2 > 0 and (iquo2 < ipos1 or ipos1 = 0)'quotes precede '  ' posn
         iquo1 = instr(iquo2 + 1, ccmd, char(34))'next quote #1 in command line
         if iquo1 then         'first quote character was found in command line
            iquo2 = instr(iquo1 + 1, ccmd, char(34))  'quote #2 in command line
         else                  'first quote character NOT found in command line
            iquo2 = 0          'first quote not found, so set the 2nd quote OFF
         end if
      wend
      if iquo2 = 0 and iquo1 > 0 and iquo1 < len(ccmd) then'uneven no.of quotes
         ccmd = ccmd + char(34)              'add the balancing quote character
         iquo2 = len(ccmd)               'set position of final quote character
      end if
      if ipos1 > iquo1 and ipos1 < iquo2 then 'text string surrounded by quotes
         ipos1 = iquo2                   'move position to end of quoted string
      elseif ipos1 then                      'surrounding quotes were NOT found
         ccmd = left$(ccmd, ipos1 - 1) + mid$(ccmd, ipos1 + 1)  'remove one ' '
         if iquo1 > ipos1 then             'quotes follow current text position
            iquo1 = iquo1 - 1               'decrement the first quote position
            iquo2 = iquo2 - 1              'decrement the second quote position
         end if
      end if
   loop while ipos1                      'loop until all '  ' strings processed
   if left$(ccmd, 1) > " " then                 'a file path/name was indicated
      iquo1 = 1                  'initialize 1st quote position in command line
      iquo2 = 0                  'initialize 2nd quote position in command line
      ipos1 = 0                        'initialize ' ' position in command line
      do                              'loop to get position at end of path/name
         ipos1 = instr(ipos1 + 1, ccmd, " ")      'position at end of path/name
         while iquo1 > 0 and iquo2 < ipos1 'loop while quotes precede " " posn.
            iquo1 = instr(iquo2 + 1, ccmd, char(34)) 'get next quote #1 in ccmd
            iquo2 = instr(iquo1 + 1, ccmd, char(34)) 'get next quote #2 in ccmd
            if iquo1 = len(ccmd) then       'quote #1 is last character in ccmd
               iquo2 = iquo1              'set quote #2 posn. to quote #1 posn.
            end if
         wend
      loop while ipos1 > iquo1 and ipos1 < iquo2   'loop to find non-quoted ' '
      if ipos1 = 0 then                     'no data follows the file path/name
         ipos1 = len(ccmd) + 1             'set position to end of command line
      end if
      ilen = ipos1 - 1                   'save the length of the file path/name
      cfil = left$(ccmd, ilen)            'initialize the actual file path/name
      i = parm.flpath(cfil, cnam, cext) 'parse path/file names from 'cfil' text
      ipos1 = ilen + 2                      'first character of first parameter
   else                                     'a file path/name was NOT indicated
      cfil = ""                           'set the path plus filename to "null"
      cnam = ""                          'set filename less extension to "null"
      cext = ""                          'set filename extension only to "null"
      ipos1 = 2                             'first character of first parameter
   end if
   iprm = -1                               'initialize the number of parameters
   ilen = len(ccmd)                       'set length of command line (RTRIM'd)
   while ipos1 <= ilen and iprm < 12    'loop to trimmed length of command line
      if midchar(ccmd, ipos1) = 34 then   'current parameter is a quoted string
         ipos2 = instr(ipos1 + 1, ccmd, char(34)) + 1 'end of current parameter
         if ipos2 = 1 then             'closing quote not found in command line
            ipos2 = ilen + 1         'set quote position to end of command line
         end if
      else                               'current parameter NOT a quoted string
         ipos2 = instr(ipos1 + 1, ccmd, " ") 'posn. at end of current parameter
         if ipos2 = 0 then                   'no data follows current parameter
            ipos2 = ilen + 1               'set position to end of command line
         end if
      end if
      iprm = iprm + 1                       'increment the number of parameters
      cprm(iprm) = mid$(ccmd, ipos1, ipos2 - ipos1)  'get the current parameter
      ipos1 = ipos2 + 1                      'first character of next parameter
   wend
   parmstr1 = iprm              'return number of parameters to calling program
end function

function parm.flpath(cfil, cnam, cext)  'parse path/file names from 'cfil' text
   lset cfil = lcase$(cfil)            'first, lowercase the entire text string
   idsk = instr(cfil, ":")             'drive letter found in this header line?
   if idsk then                        'drive letter found in this header line!
      mid$(cfil, 1) = ucase$(mid$(cfil, 1, 1))  'uppercase the DOS drive letter
   end if
   ipos2 = len(cfil) + 1          'set segment end position to end of path/file
   do                             'loop to process segment (subdirectory) names
      ipos1 = iprm.rcfn(ipos2 - 1, cfil, "\") 'begin ('\') character of segment
      if ipos1 = 0 then             'begin ('\') character of segment NOT found
         ipos1 = idsk              'set begin to (possible) ':' drive separator
      end if
      if ipos2 > ipos1 + 1 then              'next (prev.) segment begin found!
         if midchar(cfil, ipos1 + 1) = 34 then  'segm.name surrounded by quotes
            cseg = mid$(cfil, ipos1 + 2, ipos2 - ipos1 - 3)  'remove the quotes
         else                               'segm.name NOT surrounded by quotes
            cseg = mid$(cfil, ipos1 + 1, ipos2 - ipos1 - 1)'get current segname
         end if
         if cseg <> ".." then          'current segment contains an actual name
            if ipos2 > len(cfil) then     'this is the final segment (filename)
              'i = ifn.longname(cseg, cnam, cext)  'change longname to DOS name
            else                      'this is NOT the final segment (filename)
              'i = ifn.longname(cseg, "", "") 'change poss.longname to DOS name
            end if
            mid$(cseg, 1) = ucase$(mid$(cseg, 1, 1)) 'uprc.1st char. of segname
            cfil = left$(cfil, ipos1) + cseg + mid$(cfil, ipos2)'replace segname
         end if
      else                                     'next (prev.) segment NOT found!
         exit do                     'next (prev.) segment NOT found; exit loop
      end if
      ipos2 = ipos1          'reset segment end position to last begin position
   loop                       'loop until end (beginning) of path-segment names
end function

function iprm.rcfn(iofs, cstr1, cchr)    'get position of first cchr from right
   ichr = asc(cchr)                                    'get ASCII value of cchr
   for ipos = iofs to 1 step -1                     'loop thru cstr1 from right
      if midchar(cstr1, ipos) = ichr then         'match found at position ipos
         exit for                                         'exit the search loop
      end if
   next
   iprm.rcfn = ipos                                   'return matching position
end function
