'/* GETTIME.BAS  16.09.1994 */


function ifn.tbeg(cbeg, cend, cexp, ltic)   'set begin time and no. tics/second
   ltic = 0                              'initialize the no. of tics per second
   cexp = "00:00:00.00"                            'initialize the expired time
   cend = "00:00:00"                                'initialize the ending time
   cbeg = time$                                      'initialize the begin time
   do while cbeg = time$                   'loop until beginning of next second
   loop
   lset cbeg = time$                'set begin time at beginning of next second
   do while cbeg = time$                         'loop until end of next second
      ltic = ltic + 1                     'increment the no. of tics per second
   loop
   lset cbeg = time$             'set begin time at beginning of current second
end function


function ifn.tend(cbeg, cend, cexp, ltic)     'set ending time and expired time
   lfrc = 0                           'initialize no. of tics in partial second
   lset cend = time$                              'reinitialize the ending time
   do while cend = time$                      'loop until end of current second
      lfrc = lfrc + 1                  'increment no. of tics in partial second
   loop
   ihr1 = pdqvali(mid$(cbeg, 1, 2))                          'begin hour number
   ihr2 = pdqvali(mid$(cend, 1, 2))                         'ending hour number
   imn1 = pdqvali(mid$(cbeg, 4, 2))                        'begin minute number
   imn2 = pdqvali(mid$(cend, 4, 2))                       'ending minute number
   isc1 = pdqvali(mid$(cbeg, 7, 2))                        'begin second number
   isc2 = pdqvali(mid$(cend, 7, 2))                       'ending second number
   ifrc = abs(ltic - lfrc) * 100 \ ltic    'no. of hundredths in partial second
   if isc2 < isc1 then                 'ending second is less than begin second
      isc2 = isc2 + 60                                 'add 60 to ending second
      imn2 = imn2 - 1                            'subtract 1 from ending minute
   end if
   if imn2 < imn1 then                 'ending minute is less than begin minute
      imn2 = imn2 + 60                                 'add 60 to ending minute
      ihr2 = ihr2 - 1                              'subtract 1 from ending hour
   end if
   if ihr2 < ihr1 then                     'ending hour is less than begin hour
      ihr2 = ihr2 + 24                                   'add 24 to ending hour
   end if
   mid$(cexp,  1) = right$("0" + ltrim$(str$(ihr2 - ihr1)), 2)   'expired hours
   mid$(cexp,  4) = right$("0" + ltrim$(str$(imn2 - imn1)), 2) 'expired minutes
   mid$(cexp,  7) = right$("0" + ltrim$(str$(isc2 - isc1)), 2) 'expired seconds
   mid$(cexp, 10) = right$("0" + ltrim$(str$(ifrc)), 2)     'expired hundredths
end function
