'/* GETDIR9X.BAS  03.07.2002 */

function ifn.gdir(cdir, cfil, cfsp, chdr, cprm, ifno, lsiz, idir)'get filespecs
   if cprm <> "" then           'first time this function called for this entry
      ifno = freefile                     'set the work file handle/unit number
      open cdir for input as ifno         'open the directory entries work file
      chdr = ""                           'initialize the directory name header
      while chdr = "" and (not eof(ifno))      'loop until dirname header found
         line input #ifno, chdr               'get 'header' line from work file
         i = ifn.gdirhdr(chdr)               'extract full DOS path from 'chdr'
      wend
   end if
   lsiz = 0                                 'initialize the file size parameter
   while lsiz = 0 and (not eof(ifno))   'loop until file found or no more files
      line input #ifno, cfsp                   'get the next available filespec
      lset cfsp = ucase$(left$(cfsp, 1)) + lcase$(mid$(cfsp, 2)) 'set fsp. case
      if instr(cfsp, "<dir>") = 0 then      'this is NOT a directory/pipe entry
         i = ifn.gdirfsp(cfsp)                  'get the new formatted filespec
         if cfsp <> "" then                      'a valid filespec was returned
            i = ifn.gdirfil(cfil, cfsp)             'get filename from filespec
            if (instr("Dsrc.di|Ddst.di|Dexc.di|Dexc.dx", left$(cfil, 7)) = 0 _
            or len(cfil) <> 8) and cfil <> "" then  'a valid filename was found
               lsiz = pdqvall&(mid$(cfsp, 13, 10))  'set the file size in bytes
            end if
         end if
      elseif midchar(cfsp, 1) <> 46 and idir then    'this IS a directory entry
         i = ifn.gdirfil(cfil, cfsp)                 'get dirname from filespec
         lsiz = -1                    'set file size to exit and return dirname
      end if
   wend
   if lsiz = 0 then                              'EOF - no more files available
      cfil = ""                                'set the return filename to null
   end if
   cprm = ""                               'clear the 'first time in' parameter
end function                                         'return to calling routine

function ifn.gdirfil(cfil, cfsp)                 'return filename from filespec
   idot = istr.rcfn(9, cfsp, ".")                'file-ext.position in filespec
   if idot > 1 then                                   'compressed-name filespec
      cfil = rtrim$(left$(cfsp, 12))                  'set cfil to the filename
      mid$(cfsp, 1) = left$(cfil, idot - 1) + _  'reset the filename portion of
      space$(10 - idot) + mid$(cfil, idot + 1)   'the filespec to look like DOS
   else                                                'possible MSDOS filespec
      cfil = rtrim$(left$(cfsp, 8))             'set to filename-less-extension
      if midchar(cfsp, 10) <> 32 then              'extension found in filespec
         cfil = cfil + "." + rtrim$(mid$(cfsp, 10, 3)) 'add extension->filename
      end if
   end if
end function                                         'return to calling routine

function ifn.gdirfsp(cfsp)                           'return formatted filespec
   ipos3 = istr.rcfn(len(cfsp), cfsp, ":")    'position of ':' in filespec time
   ipos2 = istr.rcfn(ipos3 - 1, cfsp, "/")    'pos. of 2nd '/' in filespec date
   ipos1 = istr.rcfn(ipos2 - 1, cfsp, "/")    'pos. of 1st '/' in filespec date
   if not(ipos1 > 0 and ipos2 = ipos1 + 3 and ipos3 > ipos2) then 'invalid spec
      ipos2 = istr.rcfn(ipos3 - 1, cfsp, "-") 'pos. of 2nd '-' in filespec date
      ipos1 = istr.rcfn(ipos2 - 1, cfsp, "-") 'pos. of 1st '-' in filespec date
   end if
   if not(ipos1 > 0 and ipos2 = ipos1 + 3 and ipos3 > ipos2) then 'invalid spec
      ipos2 = istr.rcfn(ipos3 - 1, cfsp, ".") 'pos. of 2nd '.' in filespec date
      ipos1 = istr.rcfn(ipos2 - 1, cfsp, ".") 'pos. of 1st '.' in filespec date
   end if
   if ipos1 > 0 and ipos2 = ipos1 + 3 and ipos3 > ipos2 then 'valid spec found!
      if midchar(cfsp, ipos1) = 46 then                  'yy.mm.dd' date format
         mid$(cfsp, ipos1 - 2) = mid$(cfsp, ipos1 + 1, 6) + mid$(cfsp, ipos1 - 2, 2)
      end if                                 'reformat 'yy.mm.dd' to 'mm.dd.yy'
      mid$(cfsp, ipos1) = "-"                        'replace date '/' with '-'
      mid$(cfsp, ipos2) = "-"                        'replace date '/' with '-'
      ipos4 = istr.rcfn(ipos1 - 3, cfsp, ",")    'position of comma in filesize
      while ipos4 >= 13                    'loop to remove commas from filesize
         mid$(cfsp, 13) = " " + mid$(cfsp, 13, ipos4 - 13)    'remove the comma
         ipos4 = istr.rcfn(ipos4 - 1, cfsp, ",")        'next comma in filesize
      wend
      if ipos1 >= 30 then                                'DOS6 / Win9x filespec
         cfsp = left$(cfsp, 12) + mid$(cfsp, 17, 27) 'adjust length of filespec
         ipos1 = ipos1 - 4             'adjust pos. of 1st '-' in filespec date
         ipos2 = ipos2 - 4             'adjust pos. of 2nd '-' in filespec date
         ipos3 = ipos3 - 4             'adjust position of ':' in filespec time
      end if
      iapm = midchar(cfsp, ipos3 + 3)        'filespec time A.M./P.M. indicator
      cfsp = mid$(cfsp,        1, 22) + "   " + _                'filename/size
             mid$(cfsp, ipos1 + 4, 2) + "-" + _                  'filespec year
             mid$(cfsp, ipos1 - 2, 2) + "-" + _                 'filespec month
             mid$(cfsp, ipos1 + 1, 2) + " " + _                   'filespec day
             mid$(cfsp, ipos3 - 2, 5)                            'filespec time
      ipos3 = istr.rcfn(len(cfsp), cfsp, ":") 'position of ':' in filespec time
      ipos2 = istr.rcfn(ipos3 - 1, cfsp, "-") 'pos. of 2nd '-' in filespec date
      ipos1 = istr.rcfn(ipos2 - 1, cfsp, "-") 'pos. of 1st '-' in filespec date
      if mid$(cfsp, ipos1 - 2, 2) < "80" then             'year is '00' to '79'
         mid$(cfsp, ipos1 - 4) = "20"             'set year to '2000' to '2079'
      else                                                'year is '80' to '99'
         mid$(cfsp, ipos1 - 4) = "19"             'set year to '1980' to '1999'
      end if
      ihrs = pdqvali(mid$(cfsp, ipos3 - 2, 2))   'get hours value from filespec
      if (iapm = 80 or iapm = 112) and ihrs <> 12 then   'filespec time is P.M.
         mid$(cfsp, ipos3 - 2) = ltrim$(str$(ihrs + 12))  'change to 24-hr time
      elseif (iapm = 65 or iapm = 97) then               'filespec time is A.M.
         if ihrs = 12 then                                 'time is < 0100 A.M.
            mid$(cfsp, ipos3 - 2) = " 0"                  'add poss.missing '0'
         elseif ihrs < 10 then                             'time is < 1000 A.M.
            mid$(cfsp, ipos3 - 2) = " "                   'blank redundant zero
         end if
      end if
   else                                                   'not a valid filespec
      cfsp = ""                                       'set the filespec to null
   end if
end function                                         'return to calling routine

function ifn.gdirhdr(chdr)              'extract full DOS path from 'chdr' text
   ipos1 = instr(chdr, ":\")            'posn. of (example: 'c:\dir1\dir2\...')
   if ipos1 = 0 then                    'directory header n/a to this text line
      chdr = ""                         'no directory header; exit this process
      exit function                      'return control to the calling routine
   end if
   chdr = lcase$(rtrim$(mid$(chdr, ipos1 - 1)))    'extract the full DOS header
   if right$(chdr, 1) <> "\" then   'header returned by DOS does not contain...
      chdr = chdr + "\"             '..."\" unless (example) 'A:\', 'C:\', etc.
   end if
   mid$(chdr, 1) = ucase$(mid$(chdr, 1, 1))     'uppercase the DOS drive letter
   ipos2 = len(chdr)             'set segment end position to end '\' character
   do                             'loop to process segment (subdirectory) names
      ipos1 = istr.rcfn(ipos2 - 1, chdr, "\") 'begin ('\') character of segment
      if ipos1 = 0 then                   'next (prev.) segment begin NOT found
         exit do                             'all segments processed; exit loop
      end if
      cseg = mid$(chdr, ipos1 + 1, ipos2 - ipos1 - 1) 'get current segment name
      i = ifn.longname(cseg, "", "")        'change poss. long name to DOS name
      mid$(cseg, 1) = ucase$(mid$(cseg, 1, 1)) 'uppercase first char.of dirname
      chdr = left$(chdr, ipos1) + cseg + mid$(chdr, ipos2)'replace segment name
      ipos2 = ipos1          'reset segment end position to last begin position
   loop
end function
