;name   wpfunc.inc
;title  equates/structures for functions
;
;  Copyright (C) 1988 WordPerfect Corp., All Rights Reserved
;  COMPANY CONFIDENTIAL -- NOT FOR DISTRIBUTION
;------------------------------------------------------------
;

eqtm    equ 1200         ;top margin
eqbm    equ 1200         ;bottom margin
eqpl1   equ 11*1200      ;form length default for letter size
eqtl1   equ eqpl1-eqtm-eqbm  ;text space in 1200ths for letter size
eqpw1   equ 8*1200+600       ;page width 8 1/2 inches
eqlm    equ 1200         ;left margin
eqrmw   equ 1200         ;right margin width
eqrm    equ eqpw1-eqrmw      ;right margin
eqrjst  equ 1            ;default for justification (1=full)

hzlpct  equ 10           ;percent for left hot zone
hzrpct  equ 4            ;percent for right left zone
eqhzlct equ hzlpct*256/100   ;width of left hotzone
eqhzrct equ hzrpct*256/100   ;width of right hotzone

mxtcol  equ 24           ;max # of text columns
maxtab  equ 40           ;max # of tabs in reset function
mxften  equ 20           ;max length of footnote/endnote strings

;Control characters

yhrt    equ 00Ah    ;Hrt
yspg    equ 00Bh    ;Spg
yhpg    equ 00Ch    ;Hpg
ysrt    equ 00Dh    ;Srt

;Single byte functions

ydel    equ 080h    ;Always deleted (for files with word length)
yrtjon  equ 081h    ;Right just on
yrtjof  equ 082h    ;Right just off
yecnal  equ 083h    ;End center/align
yexhyf  equ 084h    ;Exited hyphenation
ytemp   equ 085h    ;Temp place saver in math, also when formatting
            ;   footnotes to fix-up graph boxes
ycenpg  equ 086h    ;Center page top to bottom
yclon   equ 087h    ;Col on
ycloff  equ 088h    ;Col off (at top of page)
yscan   equ 089h    ;Marker used by the formatter (USSCN)
yworon  equ 08Ah    ;Widow/orphan on
yworof  equ 08Bh    ;Widow/orphan off
yhrtpg  equ 08Ch    ;Hrt-spg
yftref  equ 08Dh    ;Ftn # (inside ftn/end)
yfgref  equ 08Eh    ;Figure # (inside caption)

yirdel  equ 090h    ;Deletable Return-eol
yirdep  equ 091h    ;Deletable Return-eop
ydleop  equ 092h    ;EOP that is deleted when forward formatted
yiryil  equ 093h    ;Invisible Return In Line
yiryel  equ 094h    ;Invisible Return-eol
yiryep  equ 095h    ;Invisible Return-eop
yblkon  equ 096h    ;Block on
yblkof  equ 097h    ;Block off
ytocph  equ 098h    ;Table of Contents page # place holder
ydhrt   equ 099h    ;Dormant hard return
ycanhy  equ 09Ah    ;Cancel hypenation
yegen   equ 09Bh    ;end of generated text

yhypof  equ 09Eh    ;Hyphenation off
yhypon  equ 09Fh    ;Hyphenation on

yhrdsp  equ 0A0h    ;Hard space
ydost   equ 0A1h    ;Do sub-total
ysten   equ 0A2h    ;Sub-total entry
ydotl   equ 0A3h    ;Do total
ytlen   equ 0A4h    ;Total entry
ydogt   equ 0A5h    ;Do grand total
ycalc   equ 0A6h    ;Calculation column
ymthon  equ 0A7h    ;Math on
ymthof  equ 0A8h    ;Math off
yhhyil  equ 0A9h    ;Hard hyphen in line
yhhyel  equ 0AAh    ;Hard hyphen-eol
yhhyep  equ 0ABh    ;Hard hyphen-eop
yshyil  equ 0ACh    ;Soft hyphen in line
yshyel  equ 0ADh    ;Soft hyphen-eol
yshyep  equ 0AEh    ;Soft hyphen-eop
ycofel  equ 0AFh    ;Col off-eol
ycofep  equ 0B0h    ;Col off-eop
ymtneg  equ 0B1h    ;Math Negate
youtof  equ 0B2h    ;outline off

;Reserved unknown
yunksb  equ 0BFh    ;reserved unknown single byte function

;*** fixed length multi-byte functions ***

yexchr  equ 0C0h    ;Extended char
            ;size = 4
            ;character (word)

ycatab  equ 0C1h    ;Center/align/tab/left mar rel
            ;size = 9
            ;flag byte
            ;  bits 7 & 6
            ;    0 = tab
            ;    2 = left margin release
            ;    1 = align   > bit 6 set if center or align
            ;    3 = center /
            ;  bit 5 = 1 for center between margins, flush right
            ;  bit 4 = 1 for dot leader
            ;  bit 3 = 0 for align on alcar
            ;        also for center on column
            ;    = 1 for right justified tab
            ;        also for centered tab
            ;  bit 2 = 1 for positioning within table cell (5.1)
            ;  bit 1 = 0 if the type (tab, align, etc.) is sticky,
            ;        otherwise it uses the tab set def type
            ;starting absolute col position (word,1200ths)
            ;absolute center/align/tab column (word,1200ths)
            ;starting text screen col position (word,text screen units)

yindt   equ 0C2h    ;Indent
            ;size = 11
            ;flag byte
            ;  bit 0 = 0 for left indent
            ;    = 1 for left/right indent
            ;  bit 4 = 1 for dot leader
            ;difference between old and new left temp margins
            ;  (word,1200ths)
            ;starting absolute col position (word,1200ths)
            ;absolute indent column (word,1200ths)
            ;starting text screen col position (word,text screen units)

yatton  equ 0C3h    ;Attribute on
            ;size = 3
            ;attribute (byte)

;------ text attributes (for the byte in the function)
fat_chdg    equ 0        ;extra large (chapter heading)
fat_hdg     equ 1        ;very large (heading)
fat_shdg    equ 2        ;large (sub-heading)
fat_sprt    equ 3        ;small print
fat_fprt    equ 4        ;fine print
fat_sups    equ 5        ;superscript
fat_subs    equ 6        ;subscript
fat_outl    equ 7        ;outline
fat_ital    equ 8        ;italics
fat_shad    equ 9        ;shadow
fat_redl    equ 0ah      ;redline
fat_dund    equ 0bh      ;double underline
fat_bold    equ 0ch      ;bold
fat_strk    equ 0dh      ;strike-out
fat_und     equ 0eh      ;underline
fat_scap    equ 0fh      ;small caps
fat_blnk    equ 10h      ;blink
fat_revs    equ 11h      ;reverse video

;------ text attributes (in decreasing order of precedence)

at_chdg equ 1 shl fat_chdg   ;chapter heading
at_hdg  equ 1 shl fat_hdg    ;heading
at_shdg equ 1 shl fat_shdg   ;sub-heading
at_sprt equ 1 shl fat_sprt   ;small print
at_fprt equ 1 shl fat_fprt   ;fine print
at_sups equ 1 shl fat_sups   ;superscript
at_subs equ 1 shl fat_subs   ;subscript
at_outl equ 1 shl fat_outl   ;outline
at_ital equ 1 shl fat_ital   ;italics
at_shad equ 1 shl fat_shad   ;shadow
at_redl equ 1 shl fat_redl   ;redline
at_dund equ 1 shl fat_dund   ;double underline
at_bold equ 1 shl fat_bold   ;bold
at_strk equ 1 shl fat_strk   ;strike-out
at_und  equ 1 shl fat_und    ;underline
at_scap equ 1 shl fat_scap   ;small caps

;------ start of second word of attributes

at_blnk equ 1 shl (fat_blnk-10h) ;blink
at_revs equ 1 shl (fat_revs-10h) ;reverse video

;------ attributes which imply a point size change

at_size equ at_chdg+at_hdg+at_shdg+at_sprt+at_fprt+at_sups+at_subs

;------ display attributes

at2_sund  equ   01h ;space underline (display only)
at2_tund  equ   02h ;tab underline (display only)
at2_rev   equ   80h ;reverse video (display only)

yattof  equ 0C4h    ;Attribute off
            ;size = 3
            ;attribute (byte) (same as yatton)

yblkpr  equ 0C5h    ;Block protect
            ;size = 5
            ;def byte:
            ;  bit 0=0 for on, =1 for off (byte)
            ;  bit 1=1 if the [BlockPro:On] occurred in columns
            ;        (only set if bit 0=1) 
            ;# of vertical 1200ths in block (word,1200ths)

yeindt  equ 0C6h    ;End of indent
            ;size = 6
            ;old right temp margin (word,1200ths)
            ;old left temp margin (word,1200ths)

ydchyf  equ 0C7h    ;Different display character when hyphenated
            ;size = 7
            ;def byte (byte)
            ;  bit 0 = 1 if word is hyphenated next to function
            ;        = 0 if no hyphenation next to function
            ;  bit 1 = 1 if this function preceeds the hyphenation
            ;        = 0 if this function is after the hyphenation
            ;char when inline (word)
            ;char when hyphenated (word)
            ;  if char is a null, then nothing is displayed

;***** The following functions are UNDEFINED but HAVE a DEFINED SIZE *****

yrfu_1  equ 0C8h    ;Reserved For Future Use
            ;size = 4
            

yrfu_2  equ 0C9h    ;Reserved For Future Use
            ;size = 5
            

yrfu_3  equ 0CAh    ;Reserved For Future Use
            ;size = 6

yrfu_4  equ 0CBh    ;Reserved For Future Use
            ;size = 6

yrfu_5  equ 0CCh    ;Reserved For Future Use
            ;size = 8

yrfu_6  equ 0CDh    ;Reserved For Future Use
            ;size = 10
            

yrfu_7  equ 0CEh    ;Reserved For Future Use
            ;size = 10

yrfu_8  equ 0CFh    ;Reserved For Future Use
            ;size = 12

;*** variable length multi-byte functions ***

;wild is used by search routines to find all subfunctions within a function
;group.
wild        equ 0ffh     ;subfunction wild card

;Unknown is reserved unknown
unk_        equ 0FEh     ;Unknown
unk_unk     equ 0FEh     ;Unknown
            ; length = variable

pfm_        equ 0D0h     ;Page format group
pfm_lpi     equ 000h     ;Set line height
            ;length word = 8
            ;old value (word,1200ths)
            ;new value (word,1200ths)
            ;if value is 0, then auto line height

pfm_hmar    equ 001h     ;Horizontal margin set
            ;length word = 12
            ;old left and right (words,1200ths)
            ;new left and right (words,1200ths)
            ;Note that right margin is now an offset from the
            ;  right edge of the paper.

s_hmar  struc
lmr dw eqlm     ;left margin
rmrw    dw eqrmw    ;right margin width
s_hmar  ends

pfm_spcst   equ 002h     ;Spacing set
            ;length word = 8
            ;old spacing (word, binary point between bytes)
            ;new spacing (word, binary point between bytes)

pfm_hzone   equ 003h     ;H-zone set
            ;length word = 8
            ;old left and right (bytes)
            ;new left and right (bytes)
            ;the bytes are binary fractions which are converted
            ;  to a percentage when displayed and entered.  For
            ;  example, a value of 64 would be 25%, since
            ;  64/256=.25

s_hzone struc
hzl db eqhzlct  ;hot zone left
hzr db eqhzrct  ;hot zone right
s_hzone ends

pfm_tabst   equ 004h     ;Tab set
            ;length word = 208
            ;old tabs (max 40 tabs, each a word,1200ths)
            ;  old tab types (40 nibbles)
            ;new tabs (max 40 tabs, each a word,1200ths)
            ;  new tab types (40 nibbles)
            ;tab type bits:
            ;   wxyz
            ;     w = not used
            ;     x = add a dot leader
            ;     yz = type, as follows:
            ;   00 = Normal left justified tab
            ;   01 = Centered tab
            ;   10 = Right justified tab
            ;   11 = Decimal aligned tab
            ;old "M" value (word)
            ;new "M" value (word; -1 = tabs are absolute otherwise
            ;       relative from "M" value)

pfm_vmar    equ 005h     ;Vertical margin set
            ;length word = 12
            ;old top and bottom (words,1200ths)
            ;new top and bottom (words,1200ths)

s_vmar  struc
tmr dw eqtm     ;top margin
bmr dw eqbm     ;bottom margin
s_vmar  ends

pfm_just    equ 006h     ;Justification
            ;length word = 6
            ;old justification mode (byte)
            ;new justification mode (byte)
            ; 0 = left
            ; 1 = full
            ; 2 = center
            ; 3 = right
            ; 4 = decimal aligned (selectable only in tables)

pfm_pgsup   equ 007h     ;Suppress page characteristics
            ;length word = 6
            ;old suppress code (byte)
            ;new suppress code (byte)
            ; 1 = suppress page numbering
            ; 2 = suppress current page numbering &
            ;   print page number at bottom center
            ; 4 = suppress hdr A
            ; 8 = suppress hdr B
            ;10 = suppress ftr A
            ;20 = suppress ftr B
            ;80 = this code is NOT at top of page

pfm_pgpos   equ 008h     ;Page number position
            ;length word = 10
            ;old position (byte)
            ;old font height (word,1200ths)
            ;new position (byte)
            ;   0 = None
            ;   1 = Top Left
            ;   2 = Top Center
            ;   3 = Top Right
            ;   4 = Top L & R
            ;   5 = Bottom Left
            ;   6 = Bottom Center
            ;   7 = Bottom Right
            ;   8 = Bottom L & R
            ;new font height (word,1200ths)

s_pgpos struc
pgp db 0        ;position
pgh dw 200      ;font height
s_pgpos ends

pfm_ftyp   equ  009h        ;THIS IS AN OLD CODE THAT CAN BE REUSED!
               ;It has never been used by a shipping 5.0 version.
               ;See pfm_form for this functionality

pfm_sfbin  equ  pfm_ftyp   ;THIS IS AN OLD EQUATE THAT CAN BE REUSED!
               ;It has never been used by a shipping 5.0 version.
               ;See pfm_form for this functionality

pfm_fori   equ  00Ah        ;THIS IS AN OLD CODE THAT CAN BE REUSED!
               ;It has never been used by a shipping 5.0 version.
               ;See pfm_form for this functionality

frmsz_d equ (6+41)       ;desired form info
frmsz_e equ (6+41+1)         ;effective form info
frmsz_t equ (frmsz_d+frmsz_e)    ;total old form info
frmlb_p equ ((frmsz_d+frmsz_e)*2)+3+8+17 ;offset in function of new label info

pfm_form    equ 00Bh     ;Form
            ;length word = ((6+41)+(6+41+1))*2+3+8+17*2+8+4 (=247)
            ;old desired length (word,1200ths)
            ;old desired width (word,1200ths)
            ;old desired type (byte)
            ;old desired type name length (byte)
            ;old desired type name (41 bytes)
            ;old effective length (word,1200ths)
            ;old effective width (word,1200ths)
            ;old effective type (byte)
            ;old effective type name length (byte)
            ;old effective type name (41 bytes)
            ;old effective orientation (byte: 0=port, 1=land)
            ;new desired length (word,1200ths)
            ;new desired width (word,1200ths)
            ;new desired type (byte)
            ;new desired type name length (byte)
            ;new desired type name (41 bytes)
            ;new effective length (word,1200ths)
            ;new effective width (word,1200ths)
            ;new effective type (byte)
            ;new effective type name length (byte)
            ;new effective type name (41 bytes)
            ;new effective orientation (byte: 0=port, 1=land)
            ;matched form # (byte)
            ;matched form hash value (word)
;added for WP 5.1
            ;old left margin (word,1200ths)
            ;old right margin (word,1200ths)
            ;old top margin (word,1200ths)
            ;old bottom margin (word,1200ths)

            ;old flag indicating label form (byte)
            ;  see new flag for description
            ;old page where labels form is defined (word)
            ;old # of rows per page (byte)
            ;old # of columns per page (byte)
            ;old left offset - top left corner (word,1200ths)
            ;old top offset - top left corner (word,1200ths)
            ;old logical page width (word,1200ths)
            ;old logical page length (word,1200ths)
            ;old distance between label rows (word,1200ths)
            ;old distance between label columns (word,1200ths)

            ;new flag indicating label form (byte)
            ;  bit 0 - set if in label form
            ;  bit 1 - set if label matched all others
            ;       this means labels are disabled
            ;new page where labels form is defined (word)
            ;new # of rows per page (byte)
            ;new # of columns per page (byte)
            ;new left offset - top left corner (word,1200ths)
            ;new top offset - top left corner (word,1200ths)
            ;new logical page width (word,1200ths)
            ;new logical page length (word,1200ths)
            ;new distance between label rows (word,1200ths)
            ;new distance between label columns (word,1200ths)
            ;label left margin (word,1200ths)
            ;label right margin (word,1200ths)
            ;label top margin (word,1200ths)
            ;label bottom margin (word,1200ths)


s_form  struc
dfrmv   dw eqpl1    ;desired length (word,1200ths)
dfrmw   dw eqpw1    ;desired width (word,1200ths)
dfrmt   db 1        ;desired type (byte)
dfrmln  db 0        ;desired type name length (byte)
dfrmnm  db 41 dup (0)    ;desired type name (41 bytes)
efrml   dw eqpl1    ;effective length (word,1200ths)
efrmw   dw eqpw1    ;effective width (word,1200ths)
efrmt   db 1        ;effective type (byte)
    db 0        ;effective type name length (byte)
    db 41 dup (0)   ;effective type name (41 bytes)
efrmo   db 0        ;effective orientation (byte: 0=port, 1=land)
s_form  ends

;structure for labels
s_label struc
labflg  db 0        ;label flag
            ;  bit 0 - set if in label form
            ;  bit 1 - set if matched "all others" form
labpag  dw 0        ;page where label for is defined
labrow  db 0        ;# of rows per page
labcol  db 0        ;# of columns per page
lablft  dw 0        ;left offset - top left corner
labtop  dw 0        ;top offset - top left corner
labwid  dw 0        ;logical page width
lablen  dw 0        ;logical page length
labdrw  dw 0        ;distance between label rows
labdcl  dw 0        ;distance between label columns
s_label ends

fnt_        equ 0D1h     ;Font group
fnt_color   equ 000h     ;Color
            ;length word = 10
            ;old print colors (3 bytes) (RGB values, 0-255)
            ;new print colors (3 bytes) (RGB values, 0-255)

fnt_font    equ 001h     ;Font change
            ;length word = 35
            ;old font # (byte)
            ;desired font description (24 bytes, 5.0 size)
            ;matched font # (byte)
            ;matched font hash value (word)
            ;extra font description (3 bytes) (5.1 only)
fnt_font_ln equ 35
fnt_color2  equ 002h     ;Color (DrawPerfect)
            ;length word = 6
fnt_color2_ln   equ 6
            ;old print colors (byte) (color value, 0-255)
            ;new print colors (byte) (color value, 0-255)

fnt_pattr   equ 003h     ;Font Pattern attributes (DrawPerfect)
            ;length word = 10
fnt_pattr_ln    equ 10
            ;Old Pattern type (byte)
            ;Old Pattern Bcolor (byte)
            ;Old Pattern Fcolor (byte)
            ;New Pattern Fcolor (byte)
            ;New Pattern Bcolor (byte)
            ;New Pattern type (byte)

def_        equ 0D2h     ;Definition group
def_mth     equ 000h     ;Define math columns
            ;length word = 212
            ;old def     (24)
            ;old calc 0  (20)
            ;old calc 1  (20)
            ;old calc 2  (20)
            ;old calc 3  (20)    (104)
            ;new def     (24)
            ;new calc 0  (20)
            ;new calc 1  (20)
            ;new calc 2  (20)
            ;new calc 3  (20)    (208)

s_mth   struc
mthd    db 24 dup (0)    ;definition
mthc0   db 20 dup (0)    ;calc 0
mthc1   db 20 dup (0)    ;calc 1
mthc2   db 20 dup (0)    ;calc 2
mthc3   db 20 dup (0)    ;calc 3
s_mth   ends

def_col     equ 001h     ;Define newspaper columns
            ;length word = 2*(1+4*24)+4  (=198)
            ;old # cols (byte)
            ;  Bits 0-4 = # of cols (2-24)
            ;  Bit 5 = unused
            ;  Bit 6 = 1 for extended parallel columns
            ;  Bit 7 = 1 for parallel columns with block protect
            ;old column margins (2*24 words)
            ;new # cols (byte)
            ;new column margins (2*24 words)

;-----------------------------------------------------------------------------    
def_par     equ 002h     ;Paragraph number def
            ;length word = 84+56 = 140
            ;old 8 definitions (each 3 bytes)
            ;old 8 level numbers (words)
            ;new 8 definitions (each 3 bytes)
            ;   2nd byte:
            ;   I = caps roman
            ;   i = l.c. roman
            ;   A = caps letter
            ;   a = l.c. letter
            ;   1 = arabic
            ;   1st & 3rd bytes:
            ;   ASCII punctuation characters
            ;   Spaces are not included in paragraph numbers
            ;   If first byte is 0, then 2nd and 3rd bytes are
            ;       a character to be used as a bullet.
            ;new 8 level numbers (words)
            ;*** NEW FOR 5.1 ***
            ;old "attach" flag (1 byte)
            ;  if bit set, it means attach previous level
            ;old outline flag (1 byte)
            ;  bit 0 clear - enter key inserts para num
            ;  bit 1 clear - tab to level of previous para num
            ;old outline style name (SNAMSZ-SPCLSZ = 18 bytes)
            ;new "attach" flags (1 byte)
            ;new outline flag (1 byte)
            ;new outline style name (if null, not using styles)
            ;old 8 level #'s from previous def (16 bytes)

s_par   struc
pardf   db " I. A. 1. a.(1)(a) i) a)";8 definitions (3 bytes each)
parlv   dw 8 dup (0)             ;8 level numbers
s_par   ends

spclnam struc
    spclch  db ?         ;character identifying style as special
    spcltp  db ?         ;special type i.e. outline, column etc.
    spcllv  db ?         ;level # or column # etc.
spclnam ends

SPCLSZ  equ size spclnam     ;length of "special" part in name of a special style
SNAMSZ  equ 21  ;max length of a style name

;structure for "new" stuff in function (new since 5.0)
s_parn  struc
parat   db 0             ;"attach" flag byte
parof   db 0             ;outline flag byte
                ;bit 0 clear - enter key inserts new para num
                ;bit 1 clear - tab automatically to current level
parnm   db SNAMSZ-SPCLSZ dup(0)  ;name of outline style to use (null if none)
s_parn  ends

;flag bits for outline flag byte
PNNOETR equ 1       ;don't insert para num when enter key pressed
PNNOTAB equ 2       ;don't tab to current level either

;-----------------------------------------------------------------------------

def_ftnop   equ 003h     ;Footnote options function
            ;length word = (38 + mxften*2)*2 + 4
            ;old values
            ;new values
            ;  spacing in ftns (word, binary point between bytes)
            ;  space between footnotes (word, 1200ths)
            ;  amount of footnote to keep together (word, 1200ths)
            ;  flag byte (bits: x ln b c n ft) (byte)
            ;  ft:  0 = use numbers
            ;   1 = use characters
            ;   2 = use letters
            ;   n:  1 = numbering starts on each page
            ;   c:  1 = footnote continued message
            ;   b:  0 = footnotes after text
            ;   1 = footnotes at bottom of page
            ;  ln:  0 = no line separator
            ;   1 = 2" line
            ;   2 = line from left to right margin
            ;  # of chars used in place of footnote #'s (byte)
            ;  chars used in place of footnote #'s (5 words)
            ;   null terminated if < 5
            ;  string for footnote-text (mxften bytes)
            ;  string for footnote-note (mxften bytes)
            ;  left margin for footnotes (word,1200ths)
            ;  right margin width for footnotes (word,1200ths)
            ;  line height for footnotes (word,1200ths)
            ;  character width for footnotes, 0 = auto (word,1200ths)
            ;  space width for footnotes (word,1200ths)
            ;  % space minimum for footnotes (word)
            ;  % space maximum for footnotes (word)
            ;  attribute for footnotes (word)
            ;  color for footnotes (3 bytes)
            ;  font for footnotes (byte)

s_ntop  struc
ntspi   dw 100h     ;spacing in footnotes (*256)
ntspb   dw 200      ;spacing between footnotes (1200ths)
ntmin   dw 600      ;amount of footnote to keep together (1200ths)
ntflg   db 30h      ;flag byte: x LN B C N FT
ntchn   db 1        ;# of chars in ftchr
ntchr   dw "1",0,0,0,0   ;footnote chars (5)
nttst   db mxften dup(0) ;text string (setup at startup)
ntnst   db mxften dup(0) ;note string (setup at startup)
            ;start of format information
ntfin   dw eqlm     ;left margin for footnote
    dw eqrmw    ;right margin width for footnote
    dw 0        ;not used
    dw 0        ;not used
    dw 0        ;not used
    dw 0        ;not used
    dw 0        ;not used
    dw 0        ;attribute for footnote
    db 0,0,0    ;not used
    db 0        ;font for footnote
s_ntop  ends

def_endop   equ 004h     ;Endnote options function
            ;length word = (38 + mxften*2)*2 + 4
            ;old values
            ;new values
            ;  spacing in endns (word, binary point between bytes)
            ;  space between endnotes (word, 1200ths)
            ;  amount of endnote to keep together (word, 1200ths)
            ;  flag byte (bits: xx xx xx en) (byte)
            ;  en:  0 = use numbers
            ;   1 = use characters
            ;   2 = use letters
            ;  # of chars used in place of endnote #'s (byte)
            ;  chars used in place of endnote #'s (5 words)
            ;   null terminated if < 5
            ;  string for endnote-text (mxften bytes)
            ;  string for endnote-note (mxften bytes)
            ;  left margin for endnotes (word,1200ths)
            ;  right margin width for endnotes (word,1200ths)
            ;  line height for endnotes (word,1200ths)
            ;  character width for endnotes, 0 = auto (word,1200ths)
            ;  space width for endnotes (word,1200ths)
            ;  % space minimum for endnotes (word)
            ;  % space maximum for endnotes (word)
            ;  attribute for endnotes (word)
            ;  color for endnotes (3 bytes)
            ;  font for endnotes (byte)
;structure is the same as footnote options (see above) except for the flag byte

def_list1op equ 005h     ;Define graph box options for figures
def_list2op equ 006h     ;Define graph box options for tables
def_list3op equ 007h     ;Define graph box options for text
def_list4op equ 008h     ;Define graph box options for user boxes
def_list5op equ 009h     ;Define graph box options for equations
            ;length word = (42 + mxften)*2 + 4
            ;old values
            ;new values
            ;  flag byte (bits: xx i p n2 n1) (byte)
            ;    i: 0 = position caption outside borders (above or below for equations)
            ;   1 = position caption inside windows
            ;       (for equations, signals left or right)
            ;    p: 0 = position caption below window
            ;       (or left centered for equations if inside)
            ;   1 = position caption above window
            ;       (or right centered for equations if inside)
            ;    n2:numbering style for box #, level 2
            ;   0 = this level not used
            ;   1 = use numbers
            ;   2 = use letters (lower case)
            ;   3 = use roman numerals (lower case)
            ;    n1:numbering style for box #, level 1
            ;   0 = this level not used
            ;   1 = use numbers
            ;   2 = use letters (upper case)
            ;   3 = use roman numerals (upper case)
            ;  shading (byte)
            ;   shading intensity (0-100%)  0 = don't shade
            ;  border style word (bits: LEFT RGHT TOPP BOTM) (word)
            ;   0 = none
            ;   1 = single
            ;   2 = double
            ;   3 = dashed
            ;   4 = dotted
            ;   5 = wide
            ;   6 = not used
            ;   7 = not used
            ;  minimum offset from start of paragraph (word,1200ths)
            ;  spacing between border & text (4 words,1200ths)
            ;   1 word each left, right, top & bottom
            ;  spacing between border & figure (4 words,1200ths)
            ;   1 word each left, right, top & bottom
            ;  string for box number in caption (mxften bytes)
            ;  old box # (no meaning in new values) (word)
            ;       this is used to backward format across a change
            ;       in figure numbering modes (2-level to 1-level, etc.)
            ;  spacing for captions (word,binary point between bytes)
            ;  line height for captions (word,1200ths)
            ;  character width for captions (word,1200ths)
            ;  space width for captions (word,1200ths)
            ;  % space minimum for captions (word)
            ;  % space maximum for captions (word)
            ;  attribute for captions (word)
            ;  color for captions (3 bytes)
            ;  font for captions (byte)
s_boxop struc
bxflg   db 1        ;graph box options, figures (see WPFUNC.INC)
    db 0        ;shading for box (0-100) (byte)
    dw 1111h    ;border styles (default = single)
    dw 0        ;minimum offset
    dw 200      ;outside left margin (1200's)
    dw 200      ;outside right margin
    dw 200      ;outside top margin
    dw 200      ;outside bottom margin
    dw 0        ;inside left margin
    dw 0        ;inside right margin
    dw 0        ;inside top margin
    dw 0        ;inside bottom margin
bxcst   db mxften dup(0);box # string for caption
    dw 0        ;old box # (numbering mode change)
    dw 0,0,0,0,0,0  ;not used
    dw 0        ;attribute for captions
    db 0,0,0    ;not used
    db 0        ;font for captions
s_boxop ends


            ;00Ah not used (reserve for other box types?)

def_tbl     equ 00Bh     ;Define table (Table On)
            ;(dw) length word (variable)
            ;OLD VALUES:
            ;(db) table flags:
            ;   bits 0-2: table position options:
            ;          0 = align with left margin
            ;          1 = align with right margin
            ;          2 = center between margins
            ;          3 = full (adjust col widths to fit margins)
            ;          4 = absolute offset from left margin
            ;   bits 3-4: available
            ;   bit 5:   1 = display negative results with parens
            ;       0 = minus signs
            ;   bit 6:   1 = auto adjust col widths to fit margins
            ;   bit 7:   1 = expand col widths to fit margins if bit 6 set
            ;(db) shading % (0-100)
            ;(dw) # of columns (max = 32)
            ;(dw) table # (same # sequence as table boxes, set by formatter)
            ;(dw) position of left edge of table (wpu's)
            ;(dw) left gutter space (wpu's)
            ;(dw) right gutter space (wpu's)
            ;(dw) top gutter space (wpu's)
            ;(dw) bottom gutter space (wpu's)
            ;(dw) row # after header rows (0 = no header rows)
            ;(dw) formatter lines start of table (wpu's) (for calculating size of header rows)
            ;(dw) page # at start of table (used for calculating size of header rows in formatter)
            ;(dw) offset from left edge of paper (for absolute position option)
            ;(..) column widths (1 word/column)
            ;   widths in 1200ths, left of left border to left
            ;   of right border.  Width includes left border
            ;   width and gutter space.widths in 1200ths
            ;(..) column attributes (1 word/column)
            ;(..) column alignments (1 byte/column)
            ;   bits 0-2: horizontal alignment for column
            ;       0 = left
            ;       1 = full (left & right)
            ;       2 = center
            ;       3 = flush right
            ;       4 = decimal align
            ;       5 = (available)
            ;       6 = (available)
            ;       7 = (available)
            ;   bit 3: available
            ;   bit 4-7: # of chars to right of decimal alignment for align cells
            ;NEW VALUES:
            ; (same as old values)
            ;(dw) length of column formula info (in bytes)
            ;(..) column formulas (# bytes given in fixed length info above)
            ;each table is a maximum of 368 (+ formulas) bytes long
            ;            & a minimum of 58 bytes long (not counting 8 bytes for gates)

            ;00Ch not used

            
def_links   equ 00Dh     ;Define link start
            ;(dw)   length word = variable
            ;(dw)   old ufcur
            ;(db)   number of lines of text to display
            ;(db)   type (spreadsheet text or table, database, graphic, etc)
            ;(dw)   date of file when last linked
            ;(dw)   time of file when last linked
            ;(dw)   beginning col of range
            ;(dw)   beginning row of range
            ;(dw)   ending col of range
            ;(dw)   ending row of range
            ;(..)   filename /w len byte (max 81)
            ;(..)   range name /w len byte (max 21)
            ;(..)   range refrence /w len byte (max 16)
            ;(dw)   length word = variable

def_linke   equ 00Eh     ;Define link end
            ;(dw)   length word = variable
            ;(dw)   old ufcur
            ;(db)   number of lines of text to display
            ;(dw)   beginning col of range
            ;(dw)   beginning row of range
            ;(dw)   ending col of range
            ;(dw)   ending row of range
            ;(..)   filename /w len byte (max 81)
            ;(dw)   length word = variable

;Note:  def_ddes and def_ddee are used in WP for OS/2's Presentation Manager
;   WP for DOS can safely ignore (skip over) these functions.

def_ddes    equ 00Fh     ;Define dynamic data exchange link start
            ;(dw)   length word = variable
            ;(..)   link information (see OS/2 code for details)
            ;(dw)   length word = variable

def_ddee    equ 010h     ;Define dynamic data exchange link end
            ;(dw)   length word = variable
            ;(..)   link information (see OS/2 code for details)
            ;(dw)   length word = variable

def_brdr    equ 011h     ;NOTE: platforms with more graphics capability
                ;      may want to add more line styles or 
                ;      provide other capabilities such as 
                ;      rounded corners, etc.  This info should
                ;      be added in the "other" section
                ;(word) - length (variable)
                ;(byte) - size of other info (0 initially)
                ;---the following variable length stuff has
                ;---length = ((6*3)+8 bytes)
                ;(variable) - old stuff for backward formatter (26 bytes initially)
                ;(variable) - new stuff for forward formatter
                ;  format:
                ;        (word) - single width
                ;        (byte) - single shade
                ;        (word) - double width
                ;        (byte) - double shade
                ;        (word) - dashed width
                ;        (byte) - dashed shade
                ;        (word) - dotted width
                ;        (byte) - dotted shade
                ;        (word) - thick width
                ;        (byte) - thick shade
                ;        (word) - extra thick width
                ;        (byte) - extra thick shade
                ;        (word) - double inside spacing
                ;        (word) - dash spacing
                ;        (word) - dash length
                ;        (word) - dot spacing
                ;(variable) other info old - none initially
                ;(variable) other info new - none initially

                ;(word) - length (variable)

single_width    equ 0
single_shade    equ single_width+2
double_width    equ single_shade+1
double_shade    equ double_width+2
dashed_width    equ double_shade+1
dashed_shade    equ dashed_width+2
dotted_width    equ dashed_shade+1
dotted_shade    equ dotted_width+2
thick_width equ dotted_shade+1
thick_shade equ thick_width+2
ethick_width    equ thick_shade+1
ethick_shade    equ ethick_width+2
double_space    equ ethick_shade+1
dash_space  equ double_space+2
dash_length equ dash_space+2
dot_space   equ dash_length+2
lbrdrop     equ dot_space+2      ;length of border options info


set_        equ 0D3h     ;Set group
set_alchr   equ 000h     ;Set alignment char
            ;length word = 12
            ;old align char (word)
            ;old separator char (word)
            ;new align char (word)
            ;new separator char (word)

s_alchr struc
alc dw "."      ;alignment character
tsc dw ","      ;thousands separator character
s_alchr ends

set_unmod   equ 001h     ;Set underline mode
            ;length word = 6
            ;old def (byte)
            ;new def (byte)
            ;bit 0: 1 = underline spaces
            ;bit 1: 1 = underline tabs, indents, aligns, etc.

set_ftnum   equ 002h     ;Set footnote number
            ;length word = 8
            ;old number (word)
            ;new number (word)

set_ennum   equ 003h     ;Set endnote number
            ;length word = 8
            ;old number (word)
            ;new number (word)

set_pgnum   equ 004h     ;Set page number
            ;length word = 10
            ;old page number (word)
            ;new page number (word)
            ;  Bit 15 = 1 if roman numerals
            ;old page number type
            ;  (bit 0 -- 0 = arabic, 1 = roman)
            ;  (bit 1 -- 0 = lower case, 1 = upper)
            ;new page number type

set_lnum    equ 005h     ;Line numbering
            ;length word = 14
            ;old interval (byte)
            ;old position (word,1200ths)
            ;old starting number (word)
            ;new interval (byte)
            ;new position (word,1200ths)
            ;new starting number (word)
            ;interval = STR00000:
            ;   bit 7 (S) = Status (1 = line numbering on)
            ;   bit 6 (T) = Number only Text lines (1 = on)
            ;   bit 5 (R) = Restart numbering on each page (1 = on)
            ;   00000 = line numbering interval (1-30)
            ;position = distance from left edge of paper
            ;    to right edge of line number in 1200ths

s_lnum  struc
intv    db 21h      ;interval
pos dw 720      ;position
slnm    dw 1        ;starting line number
s_lnum  ends

set_adv     equ 006h     ;Advance to page position
            ;length word = 9
            ;Def byte
            ;   bit 0:  0=relative, 1=absolute
            ;   bit 1:  0=vertical, 1=horizontal
            ;old position (word,1200ths)
            ;new position (word,1200ths)

set_foe     equ 007h     ;Force odd/even
            ;length word = 7
            ;old page # (word)
            ;def byte (0=even, 1=odd)

set_bline   equ 008h     ;characters at baseline in fixed line height
            ;length word = 6
            ;old def byte
            ;new def byte
            ;bit 0: 0=baseline down 3/4 of line height
            ;   1=baseline at top of cell

;NOTE:  9 is unused and available

set_cwid    equ 00Ah     ;Character/space width
            ;length word = 12
            ;old % of character width (word)
            ;old % of space width (word)
            ;new % of character width (word)
            ;new % of space width (word)
s_cwid  struc
pcwid   dw 100      ;% of character width
pswid   dw 100      ;% of space width
s_cwid  ends

set_sexp    equ 00Bh     ;Space expansion
            ;length word = 12
            ;old minimum % of space width (word)
            ;old maximum % of space width (word)
            ;new minimum % of space width (word)
            ;new maximum % of space width (word)

s_sexp  struc
smin    dw 60       ;minimum % of space width (word)
smax    dw 400      ;maximum % of space width (word)
s_sexp  ends

set_box1n   equ 00Ch     ;Set graph box number, figures
set_box2n   equ 00Dh     ;Set graph box number, tables
set_box3n   equ 00Eh     ;Set graph box number, text
set_box4n   equ 00Fh     ;Set graph box number, miscellaneous
set_box5n   equ 010h     ;Set graph box number, equations
            ;length word = 8
            ;old graph box number (word)
            ;new graph box number (word)
            ;   11 bits = 1st level #, 5 bits = 2nd level #

set_lang    equ 0011h    ;Set language
            ;length word = 8
            ;old language 2 char ID (2 bytes) (ASCII only)
            ;new language 2 char ID (2 bytes) (ASCII only)
            ;  following are the default two character ID's
            ;    for different languages:
            ;     EN = English
            ;     DA = Danish
            ;     NE = Dutch
            ;     SU = Finnish
            ;     FR = French
            ;     DE = German
            ;     IC = Icelandic
            ;     IT = Italian
            ;     NO = Norwegian
            ;     PO = Portuguese
            ;     ES = Spanish
            ;     SV = Swedish
            ;     UK = British English
            ;     CA = Canadian French
            ;    all possible languages should be in this list

set_pgsty   equ 0012h    ;set page number style
            ;length word = 64
            ;old page number style (30 bytes)
            ;new page number style (30 bytes)
xpstsz  equ 30  ;size of string for page number style

fmt_        equ 0D4h     ;Format group
fmt_eopfn   equ 000h     ;End of page function (only group 0 required)
            ;length word = variable
            ;group 0 marker (byte)
            ;group 0 length (byte)(22 bytes)
            ;  # of formatter lines at end of page (uflin)(word)
            ;  page number (rpage)(word)
            ;  # of formatter lines used for footnotes (ftnln)(word)
            ;  # of pages used for footnotes (ftnpg)(byte)
            ;  # footnotes on this page (footn)(byte)
            ;  ceop flag (cepfg)(byte)
            ;  suppress code (suprs)(byte)
            ;  center page (cpgfg)(byte)
            ;  page flags (pgflg)(byte)
            ;  page length (linlm)(word)
            ;  odd page size (upglo)(word)
            ;  even page size (upgle)(word)
            ;  odd top margin (ttmro)(word)
            ;  even top margin (ttmre)(word)
            ;group 1 marker (byte)
            ;group 1 length (byte)( 6*(#_cols-1) + 20 )
            ;  max formatter lines for #_cols-1 (#_cols-1 words)
            ;  max formatter pages for #_cols-1 (#_cols-1 words)
            ;  max screen lines from col on for #_cols-1 (#_cols-1 words)
            ;  starting formatter line for last column (word,1200ths)
            ;  starting page for last column (word)
            ;  screen lines from col on for last line of last col (word)
            ;  screen lines from col on top of page (word)
            ;  # of formatter lines used for footnotes at col on (tcftnln)(word)
            ;  # of pages used for footnotes at col on (tcftnpg)(word)
            ;  odd page size at col on (tcupglo)(word)
            ;  even page size at col on (tcupgle)(word)
            ;  odd top margin at col on (tcttmro)(word)
            ;  even top margin at col on (tcttmre)(word)
            ;group 2 marker (byte)
            ;group 2 length (word)
            ;  # of window functions in formatter table (byte)
            ;  formatter table for windows (#_of_windows * FGRSIZ)

fmt_bolfn   equ 001h     ;Beginning of line function
            ;length word = variable
            ;group 0 marker (byte)
            ;group 0 length (byte) (6 bytes)
            ;   group 0 is only inserted if the max values are
            ;   set and are different than the current values
            ;  maximum top shoulder height on the line (word,1200ths)
            ;  maximum bottom shoulder height on the line (word,1200ths)
            ;  old uflin (word,1200ths)
            ;group 1 marker (byte)
            ;group 1 length (byte) (6 bytes)
            ;   group 1 is only inserted if in WYSIWYG and
            ;   FULL JUSTIFY
            ;  # of spaces on line (word)
            ;  space adjustment (word,+/- amount from margin)
            ;  justify margin (word,abs pos to begin justifying)

fmt_box     equ 002h     ;Graph Box info function
            ;length word = variable
            ;group 0 marker (byte)
            ;group 0 length (byte) (20 bytes)
            ;  old lmar (word)
            ;  old tmar (word)
            ;  old rmar (word)
            ;  old trmar (word)
            ;  old uflin (word)
            ;  new lmar (word)
            ;  new tmar (word)
            ;  new rmar (word)
            ;  new trmar (word)
            ;  signed change in uflin (word)
            ;group 1 marker (byte)
            ;group 1 length (byte)
            ;   These 8 bytes can be repeated!!
            ;   Length/8 is the number of boxes  affecting
            ;     the line
            ;  flags for graphic box (byte)
            ;   bit 0 = top of box falls on this line
            ;   bit 1 = middle of box falls on this line
            ;   bit 2 = bottom of box falls on this line
            ;   bits 3-5 = box type
            ;       0 = figure
            ;       1 = table
            ;       2 = text box
            ;       3 = usr def box
            ;       4 = equation
            ;   bits 6-7 available
            ;  numbering mode (byte)
            ;  graphic box # (word)
            ;  graphic box left col (word,wpu)
            ;  graphic box right col (word,wpu)

fmt_mrk     equ 003h     ;Marker for repositioning
            ;length word = 6
            ;mask of marker (word)

fmt_txt     equ 004h     ;Function to contain non-editable/displayable text
                ;  (used to hide additional text in non-wrapping table cells)
            ;length word = variable
            ;hash value (word)
            ;text

fmt_jst     equ 005h     ;Justification information
                ; inserted when in center, right, or
                ; decimal align justification
            ;length word = 8
            ;  starting position (word,screen units)
            ;  starting position (word,1200ths)

hf_     equ 0D5h    ;Header/footer group
hf_hdra     equ 000h     ;Header A
hf_hdrb     equ 001h     ;Header B
hf_ftra     equ 002h     ;Footer A
hf_ftrb     equ 003h     ;Footer B
            ;length word = variable
            ;old occurrence (byte)
            ;   0 = never
            ;   1 = all pages
            ;   2 = odd pages
            ;   4 = even pages
            ;old vertical size (word,1200ths)
            ;old position of last header/footer def (LWCNT) (word)
            ;old position of last header/footer def (HICNT) (word)
            ;new occurrence (byte)
            ;new vertical size (word,1200ths)
            ;new position of last header/footer def (NOT USED) (word)
            ;new position of last header/footer def (NOT USED) (word)
            ;# of graph boxes inside header/footer (word)
            ;format info hash value (word)
            ;text -- variable

s_hdft  struc
hfocr   db 0        ;occurrence
hfver   dw 0        ;vertical size
hfplw   dw 0        ;position of last header/footer def (LWCNT)
hfphi   dw 0        ;position of last header/footer def (HICNT)
s_hdft  ends

ftn_        equ 0D6h     ;Footnote/endnote group
ftn_ftn     equ 000h     ;Footnote
            ;length word = variable
            ;Def byte:   Bit 7: 0 = use numbers, 1 = use chars
            ;       low nibble - # of chars if char mode
            ;word:  If def bit 7 = 0, then footnote #
            ;   If def bit 7 = 1, then char
            ;# of additional pages in footnote (byte)
            ;# of 1200ths on pages of footnote (words,1200ths)
            ;uflin (word) \
            ;ftnln (word)  > when footnote last formatted
            ;ftnpg (byte) /
            ;# of graph boxes inside footnote (word)
            ;format hash word (same as hdr/ftr)
            ;text

ftn_end     equ 001h     ;Endnote
            ;length word = variable
            ;Def byte:   Bit 7: 0 = use numbers, 1 = use chars
            ;       low nibble - # of chars if char mode
            ;word:  If def bit 7 = 0, then endnote #
            ;   If def bit 7 = 1, then char
            ;# of graph boxes inside endnote (word)
            ;format hash word (same as hdr/ftr)
            ;text

gen_        equ 0D7h     ;Generate group

;Begin and End marked text functions surround text that is to be included
;in a table of contents or list
;<Begin marked text> - text - <End marked text>
gen_begmt   equ 000h     ;Begin marked text
            ;length word = 5
            ;def,info byte (byte)

        ;Definition (high nibble)        Info (low nibble)
        ;   0 = table of contents        level (0-4)
        ;   2 = list             list # (0-4)

gen_endmt   equ 001h     ;End marked text
            ;length word = 5
            ;def,info byte (same as begin marked text)


gen_mtdef   equ 002h     ;Define marked text (variable length)
            ;length word = variable
            ;def, info (byte)
            ;definition bytes (5 bytes)
            ;concordance filename (optional, variable)

;<start gate><def,info><5 bytes definition><concordance file name><end gate>
;Def, info byte:
;   Definition (high nibble) Information (low nibble)
;   0 = table of contents        level (0-4)
;   1 = index            concordance file flag
;   2 = list             list # (0-4)
;   3 = ToA              ToA section # (0-15)
;
;For Index the low nibble of the def, info byte is:
;   0 = no concordance file
;   1 = concordance file name included in function
;For ToC, 5 Definition bytes represent the five levels
;   if a level is in wrapped format, bit 4 is set for that byte
;For index and lists only first definition byte is significant
;   Definition bytes for ToC, index, and lists:
;       0 = no page numbers
;       1 = page # after text, preceded by two spaces
;       2 = page # after text, in parentheses, preceded by one space
;       3 = page # flush right
;       4 = page # flush right with dot leader
;For ToA, just first def byte is significant
;   Def byte=xxxBxxDU
;       B=1 if blank line should be inserted between authorities
;       D=1 if dot leader before page numbers
;       U=1 if underlining allowed

gen_index   equ 003h     ;Index entry (variable length)
            ;length word = variable
            ;heading (variable)
            ;separator (null)
            ;subheading (variable)

gen_toa     equ 004h     ;Table of authority entry (variable length)
            ;length word = variable
            ;section number (byte) = 0-15 or 32
            ;<separator(null)> short form
            ;<separator(null)> long form

            ;0 thru 15 are valid section numbers
            ;A section number of 32 is used to indicate that the
            ;function contains only a short form and no full form


gen_eph     equ 005h     ;Endnotes Print Here
            ;length word = 19
            ;old ufcur (word)
            ;number of lines of text to display (byte)
            ;old uflin (word)
            ;number of pages in endnote (word)
            ;number of 1200ths on last page (word)
            ;position of last "endnotes print here" function (LWCNT) (word)
            ;position of last "endnotes print here" function (HICNT) (word)
            ;old ENDNOT -- # of endnotes to here (word)


gen_spg     equ 006h     ;Save Page Information
    ;this function is used only during generate to remember page information
    ;about an endnote. all values are the current settings at the place
    ;that the endnote will be printed in the document.
            ;length word = 13
            ;uflin (word)
            ;xpage (word)
            ;upglo (word)
            ;upgle (word)
            ;pgsty (byte)


gen_ref     equ 007h     ;auto reference definition (RefDef)
    ;this function is tied to gen_tag through a common tag id.
            ;length word = variable
            ;def byte (byte)
            ;tag id (variable length text)
            ;separator (null)
            ;text of number being referenced (variable
            ;   length text, NOT null terminated)

            ;def byte (type of reference):
            ;   0 - page number
            ;   1 - paragraph number
            ;   2 - footnote number
            ;   3 - endnote number
            ;   4 - figure number
            ;   5 - table number
            ;   6 - text box number
            ;   7 - user defined box number
            ;   8 - equation box number

gen_tag     equ 008h     ;auto reference tag (RefTag)
    ;this function is tied to gen_ref through a common tag id.
            ;length word = variable
            ;tag id (variable length text)
            ;separator (null)

gen_incl    equ 009h     ;include sub document
    ;this function contains the filename of a sub doc to be included,
    ;along with number of lines to display (displays like comment)
            ;length word = variable
            ;old ufcur (word)
            ;number of lines of text to display (byte)
            ;filename (variable length text, null terminated)

gen_incs    equ 00ah     ;start of included sub document
    ;this function contains the filename of the sub document that
    ;has been retrieved into a master document
            ;length word = variable
            ;old ufcur (word)
            ;number of lines of text to display (byte)
            ;filename (variable length text, null terminated)
            ;password structure if subdoc is encrypted

gen_ince    equ 00bh     ;end of included sub document
    ;this function contains the filename of the sub document that
    ;has been retrieved into a master document
            ;length word = variable
            ;old ufcur (word)
            ;number of lines of text to display (byte)
            ;filename (variable length text, null terminated)

gen_pfnm    equ 00ch     ;packetized merge file name for VAX
    ;this function contains the packetized filename of the merge file
    ;(primary or secondary) that merge chains or nests
            ;length word = variable
            ;old ufcur (word)
            ;number of lines of text to display (byte)
            ;filename (packetized)

dsp_        equ 0D8h     ;Display group
dsp_date    equ 000h     ;Date function
            ;length word = variable
            ;format string (30? bytes)

dsp_parnm   equ 001h     ;Paragraph number
            ;length word = variable
            ;new level # (byte)
            ;   bottom 7 bits are level #
            ;   if high bit is set, level # is fixed
            ;old 8 level numbers (words)
            ;WP format text of the mark for display and printer

dsp_ovrst   equ 002h     ;Overstrike
            ;length word = variable
            ;max character width (word,screen units)
            ;characters to overstrike (variable)
            ;   functions that may be in the character string:
            ;       extended char
            ;       attributes

dsp_pgins   equ 003h     ;page number style insert
            ;length word = variable
            ;style string (variable)

msc_        equ 0D9h     ;Miscellaneous group
msc_prcmd   equ 000h     ;Embedded printer command
            ;length word = variable
            ;def byte =0 for command, =1 for filename (byte)

msc_ceop    equ 001h     ;Conditional end of page
            ;length word = 5
            ;number of single spaced lines not to be broken (byte)

msc_commt   equ 002h     ;Comment
            ;length word = variable
            ;old ufcur (word)
            ;number of lines (byte)
            ;text

msc_kern    equ 003h     ;Kerning
            ;length word = 6
            ;old kerning value (byte: 0=off, 1=on)
            ;new kerning value (byte)

msc_outon   equ 004h     ;outline on
            ;length word = 20
            ;old level #'s for paragrph numbering (8 words) 

msc_lead    equ 005h     ;leading adjustment
            ;length word = 12
            ;old [SRt] and [HRt] leading adjustment (words, signed 1200ths)
            ;new [SRt] and [HRt] leading adjustment (words, signed 1200ths)

s_lead  struc
sftlead dw 0        ;[SRt] leading adjustment
hrdlead dw 0        ;[HRt] leading adjustment
s_lead  ends

msc_kern2   equ 006h     ;Kerning
            ;length word = 6
            ;kerning value (kv) where:
            ; 100/kv * (width of a space char)=desired kern
msc_kern2_ln    equ 6

msc_hide    equ 007h     ;Hide function
            ;length word = variable
            ;Four bytes:  Product type, File type,
            ;         Major version, Minor version
            ;Variable length information to be hidden from WP, but
            ;  to be preserved for subsequent format conversions.
            ;Used extensively by Macintosh WP, but so far not
            ;  used by PC-DOS WP
win_        equ 0DAh     ;Window Group
                ;subfunction defines which list (1-5) the
                ;  graph box belongs to
win_list1   equ 000h     ;list 1 (figures)
win_list2   equ 001h     ;list 2 (tables)
win_list3   equ 002h     ;list 3 (text boxes)
win_list4   equ 003h     ;list 4 (user boxes)
win_list5   equ 004h     ;list 5 (equations)

        ;length word = 117 + length of caption (variable)
        ;window # (11 bits 1st level, 5 bits 2nd level)
        ;position options (byte)
        ;   relative to: (2 bits -- low order)
        ;       0 = paragraph
        ;       1 = page
        ;       2 = character (in-line)
        ;   page position options: (3 bits)
        ;       0 = full page (default)
        ;       1 = top
        ;       2 = middle
        ;       3 = bottom
        ;       4 = absolute
        ;   bumped bit: (1 bit)
        ;       0 = not bumped to next page
        ;       1 = bumped to next page
        ;   page offset bit (1 bit)
        ;       0 = not offset
        ;       1 = page box appears after page defined on
        ;   print equation as text or graphic flag (1 bit)
        ;       0 = print as graphics
        ;       1 = print as text
        ;flags (byte)
        ;   alignment: (2 bits -- low order)
        ;       0 = left
        ;       1 = right
        ;       2 = centered
        ;       3 = left and right (justified)
        ;   aligned with: (2 bit) (used for page position)
        ;       0 = margin
        ;       1 = columns X-Y
        ;       2 = absolute
        ;   width: (1 bit)
        ;       0 = scale to figure
        ;       1 = fixed width
        ;   height: (1 bit)
        ;       0 = scale to figure
        ;       1 = fixed height
        ;   unused (1 bit)
        ;   wrap text around window: (1 bit)
        ;       0 = wrap
        ;       1 = don't wrap
        ;window width in wpu (word) (calculated)
        ;window height in wpu (word) (calculated)
        ;window x position in wpu (word) (calculated)
        ;window y position in wpu (word) (calculated)
        ;outside left spacing between window and text wpu (calculated)
        ;outside right spacing between window & text in wpu (calculated)
        ;outside top spacing between window & text in wpu (calculated)
        ;outside bottom spacing between window & text in wpu (calculated)
        ;inside left spacing between window and image in wpu (calculated)
        ;inside right spacing between window & image in wpu (calculated)
        ;inside top spacing between window & image in wpu (calculated)
        ;inside bottom spacing between window & image in wpu (calculated)
        ;horizontal offset in wpu (word)
        ;vertical offset in wpu (word)
        ;alignment column 1 (byte)
        ;alignment column 2 (byte)
        ;source image width in wpu (word)
        ;source image height in wpu (word)
        ;  for text windows = # of lines in 1200's for text
        ;orientation (rotation, mirroring) (word)
        ;figure width scale factor (word) (100 = 100%)
        ;figure height scale factor (word)
        ;figure x offset in wpu (word) (for cropping)
        ;  for text windows = formatter info hash word
        ;figure y offset in wpu (word) (for cropping)
        ;  for text windows = rotation
        ;       0 = 0 degrees
        ;   1 = 90 degrees (text from bottom to top)
        ;   2 = 180 degrees (text upside down)
        ;   3 = 270 degrees (text from top to bottom)
        ;source format (contents) (byte)
        ;   0 = empty box
        ;   1 - 63 considered to contain embedded text
        ;   Graphic on Disk:
        ;   2 = graphics on disk format (wfile contains name of 
        ;           graphics file in either graphics directory or
        ;           current directory).
        ;   3 ... 7 available
        ;   Equations:
        ;   8 = equation text (WP format)
        ;   9 ... 15 available
        ;   Text:
        ;   16 = text (WP format)
        ;   17 ... 63 available
        ;   64 and above considered to NOT contain embeded text:
        ;   Not used:
        ;   64 ... 127 available
        ;   Graphics:
        ;   128 = Internal GIF format
        ;   129 = Lotus .PIC
        ;   130 = TIFF format
        ;   131 = PC Paintbrush
        ;   132 = Windows Paint
        ;   133 = CGI Metafile
        ;   134 = AutoCAD format (DXF)
        ;   135 = not used
        ;   136 = not used
        ;   137 = Mac PNTG file (Mac Paint)
        ;   138 = HPGL (Plotter)
        ;   139 = Dr Halo & Halo DPE
        ;   140 = PC Paint normal format
        ;   141 = PC Paint BSAVE format
        ;   142 = GEM .IMG files
        ;   143 = Encapsulated Postscript files
        ;   144 = Postscript files
        ;   145... 255 available
        ;filename for source file -- ASCIIZ string (21 bytes)
        ;   a null string indicates an empty window
        ;available -- 28 bytes
        ;caption flags (byte)
        ;   bit 0 = 1: equation left/right caption forced to
        ;          be inside bottom
        ;   bits 1-7: available 
        ;absolute page # box appears on (word) (def. page + bumped + 
        ;       page offset)
        ;# of pages box is bumped from page it is defined on (byte)
        ;# of pages page type box is offset from page it is 
        ;   defined on (byte)
        ;desired width as entered by user (word) (wpu)
        ;desired height as entered by user (word) (wpu)
        ;extra spacing between caption and box (word)
        ;image index # for graphic images (word) (calculated by formatter)
        ;# of lines in 1200's taken by caption (word)
        ;formatter info hash value for caption (word)
        ;length of caption in bytes (word)
        ;caption text (variable)
        ;text (if text window) (variable)

win_rule    equ 005h     ;special:  horizontal line
win_vline   equ 006h     ;special:  vertical line

        ;length word = 117
        ;   NOTE:  THESE FUNCTIONS MUST HAVE SAME LENGTH AND BASIC
        ;   STRUCTURE AS THE OTHER WINDOW TYPES ABOVE, BUT MUCH OF
        ;   THE FUNCTION IS UNUSED.  ONLY THE INDICATED ENTRIES ARE
        ;   USED:
        ;unused (word)
        ;position options (byte)
        ;   2 bits available -- low order
        ;   vertical position options: (3 bits)
        ;     vertical lines:        horizontal lines:
        ;     0 = full page (default)    0 = baseline (default)
        ;     1 = top            1 = not used
        ;     2 = middle             2 = not used
        ;     3 = bottom             3 = not used
        ;     4 = absolute           4 = absolute
        ;   bumped bit (must = 0) (1 bit)
        ;   2 bits available -- high order
        ;flags (byte)
        ;   alignment: (3 bits -- low order)
        ;          for horizontal lines:
        ;       0 = left
        ;       1 = right
        ;       2 = centered
        ;       3 = left and right (justified)
        ;       4 = absolute horizontal position
        ;          for vertical lines (uses 2 bits only):
        ;       0 = left margin
        ;       1 = right margin
        ;       2 = between columns
        ;       3 = absolute position
        ;   unused (5 bits)
        ;rectangle width in wpu (word)
        ;rectangle height in wpu (word)
        ;rectangle x position in wpu (word)
        ;rectangle y position in wpu (word)
        ;unused (20 bytes)
        ;shading (% of black) (byte)
        ;column # (for vertical lines only) (byte)
        ;unused (4 bytes)
        ;unused (must = 0 -- orientation) (word)
        ;unused (must = 100 -- width scale factor) (word)
        ;unused (must = 100 -- height scale factor) (word)
        ;unused (must = 0 -- figure x offset) (word)
        ;unused (must = 0 -- figure y offset) (word)
        ;unused (must = 0 -- source format) (byte)
        ;unused (50 bytes)
        ;appearance page (word)
        ;unused (14 bytes)
        ;unused (must = 0 -- caption length) (word)

sty_        equ 0DBh     ;Style Group

sty_begon   equ 000h     ;Begin ON
        ;(dw) length word = variable (12+?+4) (max 37)
        ;(dd) old: file position of begin_on
        ;(dw) old: hash of old_values at begin
        ;(db) old: style_info  (hrt type)
        ;(db) old: unique#
        ;(db) new: style_info  (hrt type)
        ;(db) new: unique#
        ;(dw) hash of WPtext in this Begin_Style
        ;(..) name of this style (max 21 bytes)

sty_endon   equ 001h     ;End ON
        ;(dw) length word = variable (14+?+4) (max 39)
        ;(dd) old: file position of begin_on
        ;(dw) old: hash of old_values at begin
        ;(db) old: style_info  (hrt type)
        ;(db) old: unique#
        ;(dd) new: file pos of begin_on matching this style
        ;(dw) new: hash of old_values
        ;(db) new: style_info  (hrt type)
        ;(db) new: unique#
        ;(dw) hash of old_values in end_text (which follows)
        ;(..) name of this style (max 21 bytes)

sty_gloon   equ 002h     ;Global ON
        ;(dw) length word = variable (3+?+4) (max 29)
        ;(db) new: unique#
        ;(dw) hash of WPtext in this Global_Style
        ;(..) name of this style (max 21 bytes)

sty_off     equ 003h     ;Style OFF
        ;(dw) length word = 5 (1+4)
        ;(db) flag:  text was modified by the formatter

teol_       equ 0DCh     ;Table End of Line Codes Group

teol_tcol   equ 000h     ;Beginning of Column (Cell) at end of line
            ;(dw) length word (variable)
            ;(db) flags:
            ;   bit 0: 1 = use cell justification instead of col defaults
            ;   bit 1: 1 = use cell attributes instead of col defaults
            ;   bits 2-3: vertical alignment for cell
            ;       0 = top
            ;       1 = bottom
            ;       2 = center
            ;   bit 4: 1 = text type, 0 = numeric type
            ;   bit 5: 1 = cell has a formula
            ;   bit 6: 1 = cell is locked
            ;   bit 7: available (zero for now)
            ;(db) column # (0 origin)
            ;(db) column spanning info
            ;   bits 0-5: # of columns this cell spans
            ;   bit 6: available
            ;   bit 7: 1 = cell is continued from row above
            ;(db) row spanning info (# of rows this cell spans)
            ;(dw) old max # formatter lines for row (uflin) (wpu's)
            ;(dw) old max # screen lines for row (screen units)
            ;(dw) cell attributes (if bit above is set to not use col attributes)
            ;(db) cell justification (if bit above is set to not use col justification)
            ;   bits 0-2: horizontal justification for cell
            ;       0 = left
            ;       1 = flush right
            ;       2 = center
            ;       3 = justified (left & right)
            ;       4 = decimal align
            ;       5-7 = available
            ;   bits 3-7: available
            ;(..) variable length subgroup info:
            ;     (if function length = 15 then no subgroups exist)
            ;     (db)  sub group code
            ;     (..)  sub group length (max = 255)
            ;     currently the only valid subgroups are:
            ;       1 = cell formula

teol_trow   equ 0001h    ;Beginning of Row at end of line
            ;(dw) length word (14)
            ;(db) old: row height flags:
            ;   bit 0:
            ;       0 = single line of text (no wrap)
            ;       1 = multi-line text (wrapping)
            ;   bit 1:
            ;       0 = fixed height
            ;       1 = auto height
            ;   bits 2-7: available
            ;(dw) old: row height (wpu's)
            ;(db) old: # bytes border info for this row
            ;   if high bit set, then 1 word per column (newer format)
            ;   else 1 byte per column (pre-release 5.1 format -- these
            ;      are converted to newer format when found by formatter)
            ;(..) old: border info (# columns * 2 bytes at most)
            ;   1 word per cell border style:
            ;     low byte:
            ;   bits 0-2: def for top border for cell
            ;   bits 3-5: def for left border for cell
            ;   bit 6 & 7: available
            ;     high byte:
            ;   bits 0-2: def for bottom border for cell
            ;   bits 3-5: def for right border for cell
            ;   bit 6: = 1 if shaded cell
            ;   bit 7: = 1 if this word is really a count word
            ;       indicating next style applies to # words
            ;       where # is stored in bits 0-14.  This 
            ;       allows a compressed storage of border defs
            ;(db) new: row height flags:
            ;(dw) new: row height (wpu's)
            ;(db) new: # bytes border info
            ;(..) new: border info
            ;(dw) old # formatter lines at top of row (wpu's)

teol_toff   equ 002h     ;Table Off at end of line
            ;(dw) length word (variable)
            ;(db) flags:
            ;   bits 0-1: old row height option flags
            ;   bits 2-7: available
            ;(dw) old: row height (wpu's)
            ;(db) old: # bytes border info for row
            ;(..) old: border info for row
            ;(dw) old # rows (# row of last row in table (0 origin)
            ;(dw) old # formatter lines at top of row (wpu's)
            ;(dw) old size of header rows (wpu's)
            ;(db) old # of columns
            ;(for tables created with pre-beta and 1st beta of WP 5.1:
            ;   the # of bytes of bottom border info followed here,
            ;    together with the variable length bottom border info
            ;   anyone who adds stuff here should know that!)
            ;size = 11 bytes + row border info
            ;    (max = 11 + 64)

;003h cannot be used -- (since it is used in teop_ group for special hard page case)
teol_tgrf   equ 003h     ;Used for temporary graphics info in table edit.

teop_       equ 0DDh     ;Table End of Page Codes Group

;teop_tcol  equ 000h     ;NOT USED!!!

teop_trow   equ 0001h    ;Beginning of Row at end of page
            ;same as eol_trow

teop_toff   equ 002h     ;Table Off at end of page
            ;same as eol_toff

teop_throw  equ 003h     ;Beginning of Row/Hard Page break
            ;(only used in teop_ group)
            ;same format as eol_trow

mrg_        equ 0DEh     ;Enhanced Merge Command Codes Group
            ;length word = 4
            ;Note:  Entire function = 
            ;   <mrg_><mrg_?><length wrd><length wrd><mrg_?><mrg_>,
            ;   where mrg_? is one of the following sub-functions.
            ;(Except where noted)

mrg_asgn    equ 020h     ;{ASSIGN}var~expr~
mrg_bell    equ 021h     ;{BELL}
mrg_brk     equ 022h     ;{BREAK}
mrg_call    equ 023h     ;{CALL}label~
mrg_cnclf   equ 024h     ;{CANCEL OFF}
mrg_cnclo   equ 025h     ;{CANCEL ON}
mrg_case    equ 026h     ;{CASE}exp~case1~label~...~{ELSE}~label~~
mrg_casec   equ 027h     ;{CASE CALL}exp~case1~label~...~{ELSE}~label~~
mrg_chnm    equ 028h     ;{CHAIN MACRO}macroname~    ;Old ^G
mrg_chnp    equ 029h     ;{CHAIN PRIMARY}filename~
mrg_chns    equ 02Ah     ;{CHAIN SECONDARY}filename~
mrg_char    equ 02Bh     ;{CHAR}var~message~
mrg_comt    equ 02Ch     ;{COMMENT}comment~
mrg_cton    equ 02Dh     ;{CTON}character~
mrg_date    equ 02Eh     ;{DATE}                 ;Old ^D
mrg_doc     equ 02Fh     ;{DOCUMENT}filename~
mrg_else    equ 030h     ;{ELSE}
mrg_endfld  equ 031h     ;{END FIELD}                ;Old ^R
mrg_endfor  equ 032h     ;{END FOR}
mrg_endif   equ 033h     ;{END IF}
mrg_endrec  equ 034h     ;{END RECORD}               ;Old ^E
            ;length word = 6
            ;number of fields in record (word)
mrg_endwhl  equ 035h     ;{END WHILE}
mrg_field   equ 036h     ;{FIELD}field~              ;Old ^F
mrg_for     equ 037h     ;{FOR}var~start~stop~step~
mrg_freach  equ 038h     ;{FOR EACH}var~expr~expr~...~~
mrg_go      equ 039h     ;{GO}label~
mrg_if      equ 03Ah     ;{IF}expr~
mrg_ifb     equ 03Bh     ;{IF BLANK}field~
mrg_ifexst  equ 03Ch     ;{IF EXISTS}var~
mrg_ifnotb  equ 03Dh     ;{IF NOT BLANK}field~
mrg_kybd    equ 03Eh     ;{KEYBOARD}             ;Old ^C
mrg_label   equ 03Fh     ;{LABEL}label~
mrg_local   equ 040h     ;{LOCAL}var~expr~
mrg_look    equ 041h     ;{LOOK}var~
mrg_mid     equ 042h     ;{MID}expr~offset~count~
mrg_mrcmd   equ 043h     ;{MRG CMND}codes{MRG CMND}       ;Old ^V
mrg_nestm   equ 044h     ;{NEST MACRO}macroname~
mrg_nestp   equ 045h     ;{NEST PRIMARY}filename~    ;Old ^P
mrg_nests   equ 046h     ;{NEST SECONDARY}filename~
mrg_next    equ 047h     ;{NEXT}
mrg_nextr   equ 048h     ;{NEXT RECORD}              ;Old ^N
mrg_ntoc    equ 049h     ;{NTOC}number~
mrg_proc    equ 04Ah     ;{PROCESS}codes{PROCESS}
mrg_oncan   equ 04Bh     ;{ON CANCEL}action~
mrg_onerr   equ 04Ch     ;{ON ERROR}action~
mrg_pagef   equ 04Dh     ;{PAGE OFF}
mrg_pagen   equ 04Eh     ;{PAGE ON}
mrg_prnt    equ 04Fh     ;{PRINT}                ;Old ^T
mrg_prompt  equ 050h     ;{PROMPT}message~           ;Old ^O
mrg_quit    equ 051h     ;{QUIT}                 ;Old ^Q
mrg_ret     equ 052h     ;{RETURN}
mrg_retcan  equ 053h     ;{RETURN CANCEL}
mrg_reterr  equ 054h     ;{RETURN ERROR}
mrg_rwrite  equ 055h     ;{REWRITE}              ;Old ^U
mrg_stepf   equ 056h     ;{STEP OFF}
mrg_stepo   equ 057h     ;{STEP ON}
mrg_subp    equ 058h     ;{SUBST PRIMARY}filename~
mrg_subs    equ 059h     ;{SUBST SECONDARY}filename~      ;Old ^S
mrg_sys     equ 05Ah     ;{SYSTEM}sysvar~
mrg_text    equ 05Bh     ;{TEXT}var~message~
mrg_var     equ 05Ch     ;{VARIABLE}var~
mrg_wait    equ 05Dh     ;{WAIT}10ths~
mrg_while   equ 05Eh     ;{WHILE}expr~
mrg_sprmt   equ 05Fh     ;{STATUS PROMPT}message~
mrg_input   equ 060h     ;{INPUT}message~
mrg_len     equ 061h     ;{LEN}expr~
mrg_fldnm   equ 062h     ;{FIELD NAME}name1~...~nameN~~
mrg_stop    equ 063h     ;{STOP}
mrg_other   equ 064h     ;{OTHERWISE}
mrg_end     equ 065h     ;end of merge commands (inc for new commands)

;This function is used to hide equation text, etc. from WP 5.0
;It is constructed for future expansion - add things needed in the future
;between the word giving the offset of equation text and the word giving
;the length of equation text.
equ_        equ 0DFh     ;equation nested function
equ_equ     equ 000h     ;subfunction
                ;word - length (variable)
                ;word - flags
                ;     bits 0-2 - horizontal alignment
                ;             0 = left alignment
                ;             1 = right alignment
                ;             2 = center alignment
                ;     bits 3-5 - vertical alignment
                ;             1 = top alignment
                ;             2 = center alignment
                ;             3 = bottom alignment
                ;     bits 6-15 - reserved
                ;word - equation base font size (for graphics)
                ;word - offset from this location of equation
                ;       text (0 in WP 5.1)
                ;word - equation markup text length in bytes
                ;variable - equation markup text
                ;variable - equation compact stream
                ;word - function length (variable)
                ;byte subfunction
                ;byte function (0DFh)
