;name	wpgiequ.inc
;title	graphic structure equates
;
;  Copyright (C) 1991 WordPerfect Corp., All Rights Reserved
;  COMPANY CONFIDENTIAL -- NOT FOR DISTRIBUTION
;------------------------------------------------------------
;description
;	Equates for GI, structure defs, etc.
;

GIQLSKIP = 1

IF1			;if pass 1
IFNDEF	GIQLINC1
GIQLSKIP = 0
ENDIF
ELSE			;if pass 2
IFNDEF	GIQLINC2
GIQLSKIP = 0
ENDIF
ENDIF

IF GIQLSKIP EQ 0



;--- The following is necessary because FixedPoint is also
;--- defined in WPDEF.INC
;--- The wierdness with IF1, etc., is necessary because MASM is brain-dead.
IF1
IFNDEF FP_DEFINED
FixedPoint	struc
	fpF	dw	?	;fractional part of fixed point
	fpI	dw	?	;integer part of fixed point
FixedPoint	ends
FP_DEFINED	equ	1
FP_WPGIDEF	equ	1
ENDIF
ELSE
IFDEF	FP_WPGIDEF
FixedPoint	struc
	fpF	dw	?	;fractional part of fixed point
	fpI	dw	?	;integer part of fixed point
FixedPoint	ends
ENDIF
ENDIF

TransVal	struc
	fp	db	size FixedPoint	dup(?)	;low word and fraction
	hw	dw	?	;high word of translation value
TransVal	ends

;Transformation Matrix Structure
TransMatrix STRUC
	Tm11	db	size FixedPoint dup(?)	;element 1,1 in matrix
	Tm12	db	size FixedPoint dup(?)	;element 1,2 in matrix
	Tm13	db	size FixedPoint	dup(?)	;element 1,3 in matrix
	Tm21	db	size FixedPoint dup(?)	;element 2,1 in matrix
	Tm22	db	size FixedPoint dup(?)	;element 2,2 in matrix
	Tm23	db	size FixedPoint	dup(?)	;element 2,3 in matrix
	Tm31	db	size TransVal	dup(?)	;element 3,1 in matrix
	Tm32	db	size TransVal	dup(?)	;element 3,2 in matrix
	Tm33	db	size FixedPoint	dup(?)	;element 3,3 in matrix
TransMatrix	ENDS


;--- The following is necessary because BoundRect is also
;--- defined in WPDEF.INC
;--- The wierdness with IF1, etc., is necessary because MASM is brain-dead.
IF1
IFNDEF BR_DEFINED
BoundRect	struc
	BRLeft		dw	?	;rectangle left bound
	BRBottom	dw	?	;rectangle bottom bound
	BRRight		dw	?	;rectangle right bound
	BRTop		dw	?	;rectangle top bound
BoundRect	ends
BR_DEFINED	equ	1
BR_WPGIDEF	equ	1
ENDIF
ELSE
IFDEF	BR_WPGIDEF
BoundRect	struc
	BRLeft		dw	?	;rectangle left bound
	BRBottom	dw	?	;rectangle bottom bound
	BRRight		dw	?	;rectangle right bound
	BRTop		dw	?	;rectangle top bound
BoundRect	ends
ENDIF
ENDIF


;Structures

;Bitmap Structure
Bitmaps	STRUC
BmP1x		dw	?	; x coord of upper left corner of bitmap
BmP1y		dw	?	; y coord of upper left corner of bitmap
BmP2x		dw	?	; x coord of upper right corner of bitmap
BmP2y		dw	?	; y coord of upper right corner of bitmap
BmP3x		dw	?	; x coord of lower left corner of bitmap
BmP3y		dw	?	; y coord of lower left corner of bitmap
BmSWdth		dw	?	; width of the source bitmap in device coordinates
BmSHght		dw	?	; height of the source bitmap in device coordinates
BmDpiX		dw	?	; source bitmap dots per inch in x
BmDpiY		dw	?	; source bitmap dots per inch in y
BmFrmt		db	?	; format of the bitmaps data.
BmFlg		db	?	; clipping format 0 = normal, 1 = color, 2 = mask
BmClpClr	dd	?	; if BmFlg = 1 then
				;    pointer to clip color array
				; else
				;    not used

Bitmaps	ENDS

;Encapsulate file parameter structure
EncapFileS	struc
EfP1x	dw	?	; x coord of upper left corner of rectangle
EfP1y	dw	?	; y coord of upper left corner of rectangle
EfP2x	dw	?	; x coord of upper right corner of rectangle
EfP2y	dw	?	; y coord of upper right corner of rectangle
EfP3x	dw	?	; x coord of lower left corner of rectangle
EfP3y	dw	?	; y coord of lower left corner of rectangle
EfSBounds	db	size BoundRect dup(?)	;Bounding box of source rectangle
					;in device coordinates
EfReadId dw	?	;application dependent - passed to EfRead routine
EfRead	dd	?	;pointer to read routine
			;The parameters to this routine are:
			; bx = ps handle
			; ds = psseg
			; ax = read routine id (EfReadId)
			; cx = bytes to read
			; es:si->dd->buffer to place data into
			;The output is:
			;  cx = bytes actually read
			;  jz if end encapsulated file
			;  jc if error
			;  ax = error code if error
EncapFileS	ends

;Ellipse variable structure
CirVar	STRUC
Cvxps		dw	?	; x position
Cvyps		dw	?	; y position
Cvmjax		dw	?	; major axis radius
Cvmiax		dw	?	; minor axis radius
CvRotAng	db	size FixedPoint dup(?)	;rotation angle
CvBegAng	db	size FixedPoint dup(?)	;begining angle
CvEndAng	db	size FixedPoint dup(?)	;ending angle
Cvflg		db	?	; flag	bit 0 = connect ends to center
				;	bit 1 = connect ends of arc
CirVar	ENDS

;****************************************************************
;	Input variables
;
;****************************************************************


;Graphic Cursor Structure
GraphCur  STRUC
CrWdth	dw	?	; cursor width
CrHght	dw	?	; cursor height
CrXHS	dw	?	; hotspot x position
CrYHS	dw	?	; hotspot y position
GraphCur  ENDS



;Rectangle Target/Source structure
Rectts	STRUC
RTLeft	dw	?	; coordinate of left side of target rectangle
RTBtm	dw	?	; coordinate of bottom side of target rectangle
RTRght	dw	?	; coordinate of right side of target rectangle
RTTop	dw	?	; coordinate of top side of target rectangle
RSLeft	dw	?	; coordinate of left side of source rectangle
RSBtm	dw	?	; coordinate of bottom side of source rectangle
RSRght	dw	?	; coordinate of right side of source rectangle
RSTop	dw	?	; coordinate of top side of source rectangle
Rectts	ENDS

;Copy Rectangle structure
CpyRec	STRUC
CRLeft	dw	?	; coordinate of left side of source rectangle
CRBot	dw	?	; coordinate of bottom side of source rectangle
CRRight	dw	?	; coordinate of right side of source rectangle
CRTop	dw	?	; coordinate of top side of source rectangle
CRpg1	dw	?	; source rectangle page
CRLeft1	dw	?	; coordinate of left side of destination rectangle
CRBot1	dw	?	; destination rectangle y coordinate
CRpg2	dw	?	; destination rectangle page
CpyRec	ENDS

;Target/Source Structure
TargSor	STRUC
SrcHnd1	dw	?	; first source handle
SrcHnd2	dw	?	; second source handle
TrgtHnd	dw	?	; target handle
TargSor	ENDS

;Circle/Ellipse Structure
CirElli	STRUC
CiMjAx	dw	?	; major axis size
CiMnAx	dw	?	; minor axis size
CiRot	dw	?	; rotation angle
CirElli	ENDS

;Arc Structure
Arcstruc  STRUC
AcMjAx	dw	?	; major axis size
AcMnAx	dw	?	; minor axis size
AcRot	dw	?	; rotation angle
AcBgAng	dw	?	; begining angle
AcEdAng	dw	?	; ending angle
AcFlg	db	?	; bit 0 connect ends to center
			; bit 1 connect ends
Arcstruc  ENDS

;Character blit structure
Chbltstc	STRUC
ChX	dw	?	; x coordinate
ChY	dw	?	; y coordinate
ChdX	dw	?	; delta x
ChdY	dw	?	; delta y
Chbltstc	ENDS

;Scroll structure
Scrlstruc	STRUC
SbDelta	dw	?	;
SbX	dw	?	;
SbY	dw	?	; x coordinate
SbX1	dw	?	; x1 coordinate
SbY1	dw	?	; y1 coordinate
Scrlstruc	ENDS

;-- cursor table entry
CurTabElement	struc
CursorSeg	dw	?	;segment of device-specific cursor data
CursorOfs	dw	?	;offset of device-specific cursor data
CursorPid	dw	?	;cache pid of device-specific cursor data
CursorWidth	dw	?	;width of cursor in pixels
CursorHeight	dw	?	;height of cursor in pixels
CursorHotX	dw	?	;hot spot x, 0-relative to upper left corner
CursorHotY	dw	?	;hot spot y, 0-relative to upper left corner
CursorSPid	dw	?	;cursor save area pid (if multiple active
				;cursors)
CursorXPos	dw	?	;current x position of cursor
CursorYPos	dw	?	;current y position of cursor
CursorRect	db	size BoundRect dup(?);not currently implemented.
CursorFlg	db	?	; cursor flag
				; Bit	0, 0 = disabled, 1 = enabled.
				;	1, 0 = cursor off, 1 = cursor on.
				;	2, 0 = cursor not drawn yet
CurTabElement	ends

;-- equates for CursorFlg
CFLG_ENABLED	equ	1
CFLG_ON		equ	2
CFLG_INIT	equ	4

;Build Matrix Structure
BuildMat  STRUC
BmRotation	db	size FixedPoint dup(?)	;angle of rotation
BmScaleX	db	size FixedPoint	dup(?)	;x scaling factor
BmScaleY	db	size FixedPoint	dup(?)	;y scaling factor
BmTransX	db	size FixedPoint dup(?)	;x translation factor
BmTransY	db	size FixedPoint dup(?)	;y translation factor
BuildMat  ENDS

;Path Structure
GIPathS	STRUC
EndPtr		dw	?	;points to next byte beyond end of the list
NumEntries	dw	?	;number of entries in the path
PathData	db	?	;Beginning of path data
GIPathS	ENDS

;Variables common to all path record types
PCommon	STRUC
RecType		db	?	;Polyline record identifier
PCommon	ENDS

;Path Polyline and PolySpline Structures
PPolyline	STRUC
		db	size PCommon dup(?)	;common identifiers
NumoPnts	dw	?	;Number of points in polyline
CurPntX		dw	?	;Current X value
CurPntY		dw	?	;Current Y value
PointsData	db	?	;Beginning of points data
PPolyline	ENDS

;//jbo*	;Path Arc Structure
;//jbo*	PArc	STRUC
;//jbo*			db	size PCommon dup(?)	;common identifiers
;//jbo*	ArcData		db	size CirVar dup(?)	;arc structure
;//jbo*	PArc	ENDS
;//jbo*	
;//jbo*	;Path Box Structure
;//jbo*	PBox	STRUC
;//jbo*			db	size PCommon dup(?)	;common identifiers
;//jbo*	BoxRect		db	size BoundRect dup(?)	;Box extents
;//jbo*	HorizRad	dw	?	;corner horizontal radius
;//jbo*	VertiRad	dw	?	;corner vertical radius
;//jbo*	PBox	ENDS

; equates


;------------------------ COLOR MODELS ---------------------------------
;--- The following equates are valid values for ps.ColorModel and
;--- ps.ColorEnhance.  The matrix shows which combinations are valid
;
;                                       Model
;                       Mono     Indexed     RGB      CMYK    CMY
;                    +---------+----------+--------+-------+-------+
; E           None   |   Yes   |   Yes    |  Yes   |  Yes  |  Yes  | 
; n                  +---------+----------+--------+-------+-------+
; h M       Dither   |   Yes   |   Yes    |   No   |   No  |   No  | 
; a o                +---------+----------+--------+-------+-------+ 
; n d     Halftone   |   Yes   |    No    |  Yes   |  Yes  |  Yes  | 
; c e                +---------+----------+--------+-------+-------+
; e    Gray Shades   |   Yes   |    No    |   No   |   No  |   No  | 	
;                    +---------+----------+--------+-------+-------+
;
;--- The color models are:
;
;	Mono	Bits in the raster buffer can be either on or off, or
;		there are multiple levels of gray available.
;
;	Indexed	There are multiple colors available, referenced through
;		an index number.  The colors the indexes refer to are
;		able to be set through a palette mapping method.
;
;	RGB	This is the standard Red/Green/Blue model.
;
;	CMYK	This is the standard Cyan/Magenta/Yellow/Black model.
;		Black generation is performed by GI.
;
;	CMY	This is the standard Cyan/Magenta/Yellow model
;
;--- The enhancement methods are:
;
;	None	No dithering, halftoning, or mapping to shades of gray
;		is performed.  However, a color fit is performed for
;		monochrome and indexed models, and an RGB to CMY(K) 
;		conversion is performed for the CMY(K) models
;
;	Dither	Monochrome dithering is performed for the monochrome
;		model, and 16 or 256 color dithering is performed for
;		the indexed model, depending on ps.NumClr.
;
;	Half-	A halftone is computed for each color plane, depending on 
;	Tone	model:  1 plane for monochrome, 3 planes for RGB and CMY,
;		and 4 planes for CMYK.
;
;	Gray	A luminosity calculation is preformed to map the RGB into
;	Shades	the number of gray shades specified by ps.NumClrs.
;

CMOD_MONO	equ	0	;Monochrome color model
CMOD_INDEXED	equ	1	;Indexed color model
CMOD_RGB	equ	2	;RGB color model
CMOD_CMYK	equ	3	;CMYK color model
CMOD_CMY	equ	4	;CMY color model

CENH_NONE	equ	0	;No color enhancement
CENH_DITHER	equ	1	;Dithering for color enhancement
CENH_HALFTONE	equ	2	;Halftoning for color enhancement
CENH_GRAYSHADES	equ	3	;Shades of gray for color enhancement

;NumClr equates
NumClrMono	equ	2	;number of colors set in ps.NumClr is mono
NumClr16	equ	16	;number of colors set in ps.NumClr is 16
NumClr256	equ	256	;number of colors set in ps.NumClr is 256
NumClrTC	equ	0	;number of colors set in ps.NumClr is True Color

;GIFlag equates
GIDEVCOORD	equ	1h	;don't do transform on coords (treat as device)
GILNSTYNOSCL	equ	2h	;don't scale line style based on line width
GIHTBITMAPS	equ	4h	;halftone bitmaps, regardless of color
				;enhancement type
GIMULCURSORS	equ	8h	;allow multiple active cursors (separate
				;save area for each).
GTIXFORM	equ	10h	;do transforms using GTIMaster matrix
GIYTOP		equ	20h	;set if 0 y coord. is top
GIXRIGHT	equ	40h	;set if 0 x coord. is right
GIARC		equ	80h	;set if arcs are to draw counter clock wise
GITXTPATH	equ	100h	;set if doing a text path
GIPATH		equ	200h	;set if doing a path
GTIDEVOUT	equ	400h	;set if GTOutChar Should output device fonts
GTIDEVFONT	equ	800h	;set by GTI if it encounters a device font
GTIDEVABLE	equ	1000h	;set if outputting device fonts is enabled
GTICLRGRAY	equ	2000h	;if set all color set routines will result in a gray shade color
GIDIFDITH	equ	4000h	;if set error diffusion dithering will take place. If reset noremal dithering
GIORDDITH	equ	8000h	;if set ordered dithering will take place. If reset noremal dithering

;----- bitmap clipping equates
BMCLPNORMAL	equ	0	; normal clipping only
BMCLPCOLOR	equ	1	; normal clipping and color transparentcey
BMCLMASK	equ	2	; normal and bit mask clipping.

		
;--- equates for encapsulated file type support
ENCAP_INQUIRE	equ	0	;call to EncapFileA is to inquire about support
ENCAP_OUTPUT	equ	1	;call to EncapFileA is to output encapsulated file

ENCAPFMT_NONE	equ	0	;no encapsulated file support
ENCAPFMT_EPS	equ	1	;EPS file support
ENCAPFMT_TIFF	equ	2	;Encapsulated TIFF file support
ENCAPFMT_BMP	equ	3	;Encapsulated Windows BMP file support


;--- equates for HTFlag in HTScreenDef structure
HTF_NONE	equ	0	;.HTSpotF points at nothing
HTF_UMATRIX	equ	1	;.HTSpotF (low word) points at user-defined
				;matrix in psseg
HTF_SPOT	equ	2	;.HTSpotF points at spot function 
HTF_SPOTS	equ	3	;.HTSpotF points at spot function string
HTF_IMATRIX	equ	4	;.HTSpotF (low word) has offset of internal
				;matrix

;Point Tranformation Modes
POI		equ	1	; Translation added to points
VEC		equ	0	; Translation not added to points

;Master transformation matrix change flags
INVMCHG		equ	1	;Master matrix changed, Inverse needs updating
GTMCHG		equ	2	;Master changed, character matrix needs update

;	Options flag
CLR_INDEX	equ	0	;.ColorMp->word (mapped index)
CLR_DITHER	equ	1	;.ColorMp->dither matrices
CLR_HALFTONE	equ	2	;.ColorMp->word,word,halftone matrix(es)
CLR_RGB		equ	3	;.ColorMp->byte,byte,byte,byte (RGBT)
CLR_CMYK	equ	4	;.ColorMp->byte,byte,byte,byte (CMYK)
CLR_CMY		equ	5	;.ColorMp->byte,byte,byte (CMY)

;Line End Attribute Equates
LINEND_DFLT	equ	0	; Use the default for the device 
				; context.
LINEND_FLAT	equ	1	; Flat. The line is ended at the end 
				; point of the original path.
LINEND_RND	equ	2	; Round. The line is ended as if a 
				; circle having a diameter equal to 
				; the line width is drawn centered on
				; the end point of the original path.
LINEND_SQU	equ	3	; Square. The line is ended as if a 
				; square having the same width as the
				; line is drawn centered on the end 
				; point of the original path.

;Line Join Attributes Equates
LINJOIN_DFLT	equ	0	; Default (Mitre for GI)
LINJOIN_MTRE	equ	1	; Mitre
LINJOIN_RND	equ	2	; Round
LINJOIN_BEVL	equ	3	; Bevel

;Line Style Attribute Equates
LNSTL_SOLID	equ	0	; Solid line
LNSTL_RLE	equ	1	; Run length encoded style

;Area Pattern Equates
PTRN_SOLID	equ	0	; solid	
PTRN_CUSTOM	equ	1	; custom fill pattern

;Area Flag Equates
AF_INUSE	equ 	1 shl 0	; set if area in use
AF_CMPLX_M	equ	1 shl 1 ; set if area used for complex object
AF_TXTINUSE	equ 	1 shl 2	; set if test path in use

;Area Fill Method Equates
AF_EVNODD	equ	0	; Even/Odd fill method
AF_WINDING	equ	1	; Winding fill method

;Area Fill type Equates
AF_NOGRAD	equ	0	; no gradient fill
AF_GRAD		equ	02h	; gradient fill 

;Gradient Fill type Equates
GR_HORIZTL	equ	0
GR_RCTNGULR	equ	1
GR_RADIAL	equ	2
GR_LINEARV	equ	3
GR_LINEARA	equ	4
GR_LINEARH	equ	5

;Color/Mix Change flags
CMC_AREA	equ	01h	; area
CMC_LINE	equ	02h	; line/curve
CMC_CHARF	equ	04h	; character fill attributes
CMC_CHARO	equ	08h	; character outline attributes
CMC_CURSOR	equ	10h	; cursor attributes
CMC_ALL		equ	1fh	; change all
CMC_SOLID	equ	80h	; set colors to nearest solid

;Mix Modes
MM_OVERPAINT	equ	0	; Mix Mode REPLACE
MM_TRNSPRNT	equ	1	; Mix Mode transparent
MM_AND		equ	2	; Mix Mode AND
MM_XOR		equ	6	; Mix Mode XOR

;Attribute change flags common to different attribute sets
FCLRATR		equ	0001h	;foreground color flag
BCLRATR		equ	0002h	;background color flag
FMIXATR		equ	0004h	;foreground mix mode
BMIXATR		equ	0008h	;background mix mode
PATATR		equ	0010h	;fill pattern flag
RESERVEDATR	equ	0020h	;reserved

; Line attribute change flags (LnAttrFlg)
				;0001h-0020h reserved
LNWDHATR	equ	0400h	; line width flag
LNSTYATR	equ	0800h	; line style flag
LNENDATR	equ	4000h	; line end flag
LNJNATR		equ	8000h	; line join flag

; Area attribute change flags (AaAttrFlg)
				;0001h-0020h reserved
AAFMATR		equ	8000h	; area fill method flag

; Cursor attribute change flags (CrAttrFlg)
				;0001h-0020h reserved
CRFCLRATR	equ	0001h	; cursor foreground color flag
CRBCLRATR	equ	0002h	; cursor background color flag

; Halftone attribute change flags (HTAttrFlg)
HTLPIA		equ	0001h	; halftone LPI or angle
HTSPOT		equ	0002h	; halftone spot function
HTDMATRIX	equ	0004h	; halftone defining matrix

; Color table attribute change flags
CTDDXFER	equ	0001h	; device-dependent transfer array change
CTDIXFER	equ	0002h	; device-independent transfer array change

; Cursor Use flags
CUREN		equ	01h	; curosr enabled flag
CURON		equ	02h	; cursor on flag

;----------------- Error numbers are as follows: ---------------------------
;---- high bit not set = application error number
;---- 8000h (-32768) = Device context supplied message text
;---- 8001h to GIERRMAX = Internal GI error number
;---- -1 to GIERRMAX in descending order: = negative of error message
;-----   number from external device error message packet (-1 is 1st message)
;
;---- The application can control what GI internal message numbers are 
;---- passed back through the required GIMsgTbl.  There is a word entry in
;---- this table for each GIERR* message number.  If the entry is non-zero,
;---- GI will pass back that number instead of the internal GI number.  If
;---- the number is zero, GI will pass back the internal GI number.
;
;---- When the application receives an error number from GI, there are 4
;---- possibilities:
;----	1. High bit set and in GIERR* range (signed num <= GIERRMAX)
;----   2. High bit set and equal to GIDCERR.  This means es:si points
;----	   to the error message text
;----	3. High bit set and signed num > GIERRMAX.  This means that the
;----	   error number is the negative of a message number from the 
;----	   device context file.
;----	4. High bit not set.  This means the error message is an application
;----	   error message, either passed to GI or the device context by an
;----	   application routine that GI or the device context has called
;----	   (file i/o routines, for example), or an application error number
;----	   that has been translated via GIMsgTbl from an internal GI error
;----	   number

;--- GI error number equates (must be negative numbers, consecutive
;--- in ascending order from GIERRBASE)
GIERRBASE	equ	8001h
GIERRNOCACHE	equ	GIERRBASE	;cache or gcmem allocate failed
GIERRCACHE	equ	GIERRNOCACHE+1	;cache error (gtpck or ftpck failed)
GIERRNOSTATIC	equ	GIERRCACHE+1	;static memory allocate failed
GIERRDCHANDLE	equ	GIERRNOSTATIC+1	;invalid device context handle or none free
GIERRAPPABORT	equ	GIERRDCHANDLE+1	;application abort (AppPeriodic caused abort)
GIERRPSHANDLE	equ	GIERRAPPABORT+1	;no free ps handles, or invalid handle
GIERRLIMIT	equ	GIERRPSHANDLE+1	;some GI limit reached
GIERRINTERNAL	equ	GIERRLIMIT+1	;catch-all
GIERRFORMAT	equ	GIERRINTERNAL+1	;unsupported data format 
GIERRNODEVICE	equ	GIERRFORMAT+1	;device not present
GIERRMAX	equ	GIERRNODEVICE	;last GI error number

GIDCERR		equ	8000h		;DC internally-supplied error message


;Coordinates Space Constants
CS_WORLD	equ	0	; world coordinates
CS_MODEL	equ	1	; model coordinates
CS_PAGE		equ	2	; page coordinates
CS_DEVICE	equ	3	; device coordinates

;Transformation Matrix Constants
T_MATRX_SIZ	equ	36	; transformation matrix size in bytes
TRANS_ADD	equ	0	; Adds the model transformation to
				; the instance transformation (MODEL
				; * INSTANCE).
TRANS_PRE	equ	1	; Adds the instance transformation to
				; the model transformation (INSTANCE
				; * MODEL).
TRANS_REP	equ	2	; Replaces the model transformation
				; with the instance transformation.

;Transfer array constants

TRANSFER_ADD	equ	0	;accumulate effects of old and new transfer 
				;arrays
TRANSFER_REP	equ	1	;simply replace old transfer array with new

;Units of Measurement Constants
CAUTO		equ	0	; Page and device set in dpi to max values
CWPU		equ	1	; Word Perfect Units = 1200ths of an inch
CPIXL		equ	2	; Pixels (dots) per inch
CCM		equ	3	; Centimeters (472 wpu's)
CINCH		equ	4	; Inches (1200 wpu's)
CPOINT		equ	5	; Points = 1/72 of an inch (16 & 2/3 wpu's)
COTHER		equ	6	; Arbitrary units, caller must supply
				;   conversion factors

;Region combine options
RG_AND		equ	00	; Logical and regions 1 and 2 to form region 3
RG_OR		equ	01	; Logical or regions 1 and 2 to from region 3 
RG_XOR		equ	02	; Logical xor regions 1 and 2 to form region 3
RG_REPL		equ	03	; Logical subtract. of region 2 from region 1
RG_SUB		equ	04	; Copy region 1 into region 3

;Cursor table size
CURTABINC	equ	2	;number of cursors table entries to allocate
				;at a time

HTULIBMAX	equ	8	;maximum number of user-defined halftone
				;matrices to allow in a presentation space

;Color Table Constants
;	Format flag
CTF_CONSC	equ	0	; Creates a color table having consecutive
				; entries. The first entry has the index
				; specified by BX, with ES:SI pointing to
				; an array of RGB values CX being the
				; number of entries.
CTF_INDX	equ	1	; Creates a color table. The entries are
				; not required to be consecutive. ES:SI
				; points to an array that contains the
				; index followed by the RGB value. CX will
				; contained the number of entries.
;	Options
CTO_DFLT	equ	0	; Creates a logical color table having the
				; entries specified. The locical color
				; table entries map to existing device
				; colors in the physical palette or to
				; dithered colors if no matching device
				; color is in the pallette. This means
				; that the table is not realized.
CTO_PURE	equ	1	; Creates a logical color table whose
				; entries map to pure (nondithered) colors
				; only. If an exact match is no possible
				; then a closest fit is done.
CTO_REAL	equ	2	; Creates a logical color table that is
				; realized into the physical color table.
				; This is only useful for devices that
				; allow color map manipulation.
CTO_RESET	equ	3	; Resets all color table entries to their
				; default value.

;Line Set Attribute Equates
PL_COLOR	equ	0001h	; foreground color index value
PL_BK_CLR	equ	0002h	; background color index value
PL_MIX		equ	0004h	; foreground mix mask value
PL_BK_MIX	equ	0008h	; background mix mask value
PL_WIDTH	equ	0010h	; line width in x mask value
PL_STYLE	equ	0020h	; line style mask value
PL_END		equ	0040h	; line end mask value
PL_JOIN		equ	0080h	; line join mask value
PL_COLORRGB	equ	0100h	; foreground color rgb value
PL_BK_CLRRGB	equ	0200h	; background color rgb value
PL_PATTERN	equ	0400h	; pattern mask value
PL_ALL		equ	07ffh	;all line attributes

;Area Set Attribute Equates
PA_COLOR	equ	0001h	; foreground color mask value
PA_BK_CLR	equ	0002h	; background color mask value
PA_MIX		equ	0004h	; foreground mix mask value
PA_BK_MIX	equ	0008h	; background mix mask value
PA_PATTERN	equ	0010h	; pattern mask value
PA_FLLMTHD	equ	0020h	; area fill method
PA_COLORRGB	equ	0040h	; foreground color rgb value
PA_BK_CLRRGB	equ	0080h	; background color rgb value
PA_XOFFSET	equ	0100h	; area offset in x mask value
PA_YOFFSET	equ	0200h	; area offset in y mask value
PA_ALL		equ	03ffh	;all area attributes

;Character Outline Set Attribute Equates
CO_COLOR	equ	0001h	; foreground color index value
CO_BK_CLR	equ	0002h	; background color index value
CO_MIX		equ	0004h	; foreground mix mask value
CO_BK_MIX	equ	0008h	; background mix mask value
CO_WIDTH	equ	0010h	; line width in x mask value
CO_STYLE	equ	0020h	; line style mask value
CO_END		equ	0040h	; line end mask value
CO_JOIN		equ	0080h	; line join mask value
CO_COLORRGB	equ	0100h	; foreground color rgb value
CO_BK_CLRRGB	equ	0200h	; background color rgb value
CO_PATTERN	equ	0400h	; pattern mask value
CO_ALL		equ	07ffh	;all char outline attributes

;Character Fill Set Attribute Equates
CF_COLOR	equ	0001h	; foreground color mask value
CF_BK_CLR	equ	0002h	; background color mask value
CF_MIX		equ	0004h	; foreground mix mask value
CF_BK_MIX	equ	0008h	; background mix mask value
CF_PATTERN	equ	0010h	; pattern mask value
CF_FLLMTHD	equ	0020h	; area fill method
CF_COLORRGB	equ	0040h	; foreground color rgb value
CF_BK_CLRRGB	equ	0080h	; background color rgb value
CF_ALL		equ	00ffh	;all char fill attributes

;BitBlt Set Attribute Equates
PB_MIX		equ	0001h	; mix mode mask value
PB_COMP		equ	0002h	; compression mode mask value
PB_ALL		equ	0003h	;all bit blit attributes

;Cursor attributes Set Attribute Equates
CR_COLOR	equ	0001h	; foreground color mask value
CR_BK_CLR	equ	0002h	; background color mask value
CR_COLORRGB	equ	0004h	; foreground color rgb value
CR_BK_CLRRGB	equ	0008h	; background color rgb value
CR_ALL		equ	000fh	;all cursor attributes

;Set Attributes Equates
PRIM_AREA	equ	CMC_AREA	; area
PRIM_LINE	equ	CMC_LINE	; line/curve
PRIM_CHARF	equ	CMC_CHARF	; character fill
PRIM_CHARO	equ	CMC_CHARO	; character outline
PRIM_CURSOR	equ	CMC_CURSOR	; cursor attributes
PRIM_ALL	equ	CMC_ALL		;all attributes

;Clipping Equates
GICLIP		equ	1 shl 0
GICLIPRECT	equ	1 shl 1
GICLIPPATH	equ	1 shl 2
GICLIPREGION	equ	1 shl 3
;//jbo*	GICLIPBITMAP	equ	1 shl 4
GIWORLDVP	equ	1 shl 5
GIMODELVP	equ	1 shl 6
GIPAGEVP	equ	1 shl 7
GIHNDLCHG	equ	1 shl 8

;Path Equates
PATHPLINE	equ	1 shl 0
PATHPSPLINE	equ	1 shl 1
PATHARC		equ	1 shl 2
PATHBOX		equ	1 shl 3

;Miscellaneous Equates
GINOHANDLE	equ	-1		;handle is not a valid packet handle

;GILvl equates
GILVL_INGI	equ	1		;inside a GI call

IF1			;if pass 1
GIQLINC1 equ 1		;then define
ELSE			;if pass 2
GIQLINC2 equ 1
ENDIF

ENDIF	;if GIQLSKIP == 0

