/*C_SOURCE_FILE********************************************* 
File	qckfind.h
Header file used in the QckFind sample api

		  Copyright (C) 1994 WordPerfect Corp., All Rights Reserved
		  COMPANY CONFIDENTIAL -- NOT FOR DISTRIBUTION
-----------------------------------------------------------


*END*********************************************************/



/* level of document hits allowed for variable DocumentLevel in 
QFSearchIndex()*/
#define		QF_DOCUMENT_LEVEL_HITS 		1
#define		QF_ALL_LEVEL_HITS				0


/* QFSearchIndex() valid return code errors*/
#define		QF_NO_IDX_FILE					-1
#define		QF_IDX_FILE_CORRUPT			-2
#define		QF_INC_FILE_CORRUPT			-3
#define		QF_ESCAPE_PRESSED				-4


/* Scope defined for the IndexScope variable in QFIndexInfo() */
#define		QF_SCOPE_TEXT					0x01
#define		QF_SCOPE_SUMMARY				0x02
#define		QF_SCOPE_SUM_MLTPL			0x04
#define		QF_SCOPE_GATED_TEXT			0x08
#define		QF_SCOPE_FILE_PATH_ONLY		0x10000L
#define		QF_SCOPE_WP_DOCS_ONLY		0x10
#define		QF_SCOPE_INCLUDE_NUMS		0x20
#define		QF_SCOPE_NO_EXT_CHARS		0x40
#define		QF_SCOPE_EXT_CHARS_ASCII	0x80
#define		QF_SCOPE_EXT_CHARS_ANSI		0x100


/* Index level defined for the IndexLevel variable in QFIndexInfo() */
#define		QF_INDEX_LINE					1
#define		QF_INDEX_SENTENCE	 			2
#define		QF_INDEX_PARAGRAPH			3
#define		QF_INDEX_PAGE					4
#define		QF_INDEX_SECTION				5
#define		QF_INDEX_FIELD					6
#define		QF_INDEX_RECORD				7
#define		QF_INDEX_DOCUMENT				8



/* typedefs for returning functions */
typedef	int far QFFILEHITCALLBACK(char far * FilePath,
			void far * _ParmDataArea, unsigned long _HitNumber);

typedef	int far QFWITHINHITCALLBACK(char far * FilePath,
			void far * _ParmDataArea, unsigned long _HitNumber,
			unsigned long _FileByteOffset );


/* API set for search and retrieval of hits */
int QFIndexInfo(char far * _IndexFile,
		int far * _pIndexLevel,
		int far * _pIndexScope,
		unsigned long * _pNumberUniqueWordsIdx,
		unsigned long * _pNumberUniqueWordsInc,
		unsigned long * _pIndexTotalBytesIdx,
		unsigned long * _pIndexTotalBytesIncAndIdx,
		char far * _pIndexLongName, int far * _pIndexLenLongName);

long QFSearchIndex(char far * _IndexFile, unsigned char far * _QueryLine,
		int _DocumentLevel, char far * _ParmArea, long _ParmSize,
		QFFILEHITCALLBACK * _QFFileHitCallBack_Func,
		QFWITHINHITCALLBACK * _QFWithinHitCallBack_Func);


