Name	LNCLIB
Title	Launcher C Interface Library
;
;  Copyright (C) 1993 WordPerfect Corp., All Rights Reserved
;------------------------------------------------------------
; Launcher Interface C library.
; 
; This library should be generic enough for most C programs to
; plug in directly with no modification to the library.  Includes routine to
; remove entire program from memory and reload on top of launcher with same
; cmd line parameters.  Leaves behind 300 - 400 byte stub (not including
; environment), but guarantees that program will be run from launcher - if
; desired.
;
; ASSUMPTIONS:	(only used by LNC_EXC)
;
;		SCOPY_F  - copies null terminated string from DS:SI to ES:DI
;		FNDLNC_F - DS:SI = filename to find
;			    if successful (JNC), DS:SI = found path\filename
;			    DS can NOT be changed, SI must change - if found
;		LNCLEAN	 - far routine to clean up any open files, cach, or
;			    allocated resources.  Only called if we are going
;			    to remove current program and reload it after
;			    launcher.
;		MYPSP:WORD  (programs PSP)
;
;segments:	cs = codeseg
;		ds = dataseg
;		es = 
;

	.model	large

include	lcdef.inc

;The following functions must be provided for in the users program.  Launcher
;will make calls to these functions if the LNC_EXC_F call is made.  Currently
;the interface requires these programs to exist.  If LNC_EXC_F is not used
;the functions may return without doing anything.

extrn	_FNDLNC:far
extrn	_LNCLEAN:far
	.code
;Various variables needed by both the C and asm sections of this code
mypsp	dw	?		;holds current PSP
dshold	dw	?		;hold C's data segment
lncpth	db 80 dup (?)		;Path/File name to launcher
cmdblk	cmd_load <>		;Structure defined in LCDEF.INC
lcstr	db "LC.EXE",0		;identifying string to check for LNCHR
envltrs	dw 	0		;ENV filename letters ??{WPC}.ENV
req	db	0		;holds AX value for GetState Func
lchdat	dd	?		;holds the pinter to Launcher string Information
lnchflg	dw	0		;Flags returned by the Launcher
lnchpid	dw	-1		;ID returned by the Launcher
;The following code is called by C program to put info from C stack to correct
;system registers.  Then they are passed on to ASM routines.

;_LNC_STM
;desc:	routine for calling lnc_stm_f from C
;in:	menu - Menu name to set
;out:	none
;ret:	error code (0 = OK)
;
.menu	equ	[bp+6]
public	_LNC_STM
_LNC_STM	proc	far
	push	bp		;save stack's base pointer
	mov	bp,sp		;set up for reading C parameters
	push	si		;save SI, DI registers
	push	ds
	lds	si,.menu	;get menu address off C stack
	call	lnc_stm_f	;set launcher menu name
	 jc	lstm80		;error?
	xor	ax,ax		;no error
lstm80:	pop	ds		;restore registers and base pointer
	pop	si
	pop	bp
	ret			;return to C
_LNC_STM	endp
;_LNC_GTM
;desc:	routine for calling lnc_gtm_f from C
;in:	menu - buffer for menu name
;out:	none
;ret:	error code (0 = OK)
;
.menu	equ	[bp+6]

public	_LNC_GTM
_LNC_GTM	proc	far
	push	bp		;save stack's base pointer
	mov	bp,sp		;setup to get parameters off stack
	push	si		;save SI & DS registers
	push	ds
	lds	si,.menu	;pointer to menu name buffer from C
	call	lnc_gtm_f	;get menu name
	 jc	lgtm80		;error?
	xor	ax,ax		;no error
lgtm80:	pop	ds		;restore registers
	pop	si
	pop	bp
	ret			;return to C
_LNC_GTM	endp
;_LNC_STP
;desc:	routine for calling lnc_stp_f from C
;in:	Program of choice description
;out:	none
;ret:	error code (0 = OK)
;
.desc	equ	[bp+6]
public	_LNC_STP
_LNC_STP	proc	far
	push	bp		;save stack's base pointer
	mov	bp,sp		;setup to get C parameters off stack
	push	si		;save SI, DS registers
	push	ds
	lds	si,.desc	;Program of choice description from C
	call	lnc_stp_f	;set description
	 jc	lstp80		;error?
	xor	ax,ax		;no error
lstp80:	pop	ds		;restore registers
	pop	si
	pop	bp
	ret			;return to C
_LNC_STP	endp
;_LNC_GTP
;desc:	routine for calling lnc_gtp_f from C
;in:	buffer for Program of choice description
;out:	none
;ret:	error code (0 = OK)
;
.desc	equ	[bp+6]
public	_LNC_GTP
_LNC_GTP	proc	far
	push	bp		;save stack's base pointer
	mov	bp,sp		;setup for getting C parameters
	push	si		;save SI, DS registers
	push	ds
	lds	si,.desc	;get buffer for description from C
	call	lnc_gtp_f	;get program of choice description
	 jc	lgtp80		;error?
	xor	ax,ax		;no error
lgtp80:	pop	ds		;restore registers
	pop	si
	pop	bp
	ret			;return to C
_LNC_GTP	endp
;_LNC_REG
;desc:	routine for calling lnc_reg_f from C
;in:	Application state communications routine
;out:	none
;ret:	error code (0 = OK)
;
.rgflg	equ	[bp+6]
.func	equ	[bp+10]
public	_LNC_REG
_LNC_REG	proc	far
	push	bp		;save stack's base pointer
	mov	bp,sp		;setup for getting C parameters
	push	bx      	;save registers
	push	es
	push	di
	mov	cs:dshold,ds	;store C's data seg for use in StateFunc
	les	di,.func	;es:di -> far state communication function
	mov	ax,es		;Check for function or zero
	or	ax,di		;null pointer?
	 jnz	lreg60		; no - register function
	mov	di,-1		; yes - no communication function
lreg60:	call	lnc_reg_f	;register with launcher
	 jne	lreg80		;error?
	xor	ax,ax		;no error
lreg80:	les	di,.rgflg
	mov	bx,cs:lnchflg
	mov	es:[di],bx
	pop	di		;restore registers
	pop	es
	pop	bx
	pop	bp
	ret			;return to C
_LNC_REG	endp
;_LNC_CHK
;desc:	routine for calling lnc_chk_f from C
;in:	none
;out:	none
;ret:	return code (0 = Launcher resident)
;
.lnettype	equ	[bp+6]
.linital	equ	[bp+10]
.lnetid	equ	[bp+14]
public	_LNC_CHK
_LNC_CHK	proc	far
	push	bp		;save stack's base pointer
	mov	bp,sp		;setup for getting C parameters
	push	es		;save registers
	push	di
	push	ds
	push	si
	push	bx
	call	lnc_chk_f	;is launcher resident?
	mov	ax,0		;assume yes
	 je	lchk80		; yes - launcher is resident
	mov	ax,-1		; no - launcher is not resident
	jmp	lchk90		; if no, skip to end of routine
lchk80:	lds	si,cs:lchdat	; DS:SI -> Launcher info strings
	add	si,2		; move to network number byte of strings
	cmp	byte ptr ds:[si],"N"	; Check for network flag
	 jne	lchk90		; if there is none, skip to end of routine
	inc	si		; move to byte after "N" marker
	les	di,.lnettype	; ES:DI -> C integer variable
	mov	bl,ds:[si]	; get network number from Launcher strings
	xor	bh,bh		; zero BX high byte
	mov	es:[di],bx	; pass value to C integer variable
	inc	si		; move past net number to next byte
	les	di,.linital	; get C string var. far pointer
	call	scopy_f		; copy 5 char user initials From LC to C
	add	si,6		; move to byte after of 5 character initals
	les	di,.lnetid	; get far ptr to C string variable (Net ID)
	call	scopy_f		; copy 32 byte network ID to C string var.
lchk90:	pop	bx		; restore registers
	pop	si
	pop	ds
	pop	di
	pop	es
	pop	bp
	ret			;return back to C
_LNC_CHK	endp
;_LNC_EXC
;desc:	routine for using lnc_exc_f from C
;in:	env - ENV file name letters ("WP", "OF", "PR", ...)
;out:	none
;ret:	none
;
.env	equ	[bp+6]
public	_LNC_EXC
_LNC_EXC	proc	far
	push	bx		;save BX register
	mov	ax,6200h	;get current PSP command
	int	21h		;execute command
	mov	cs:mypsp,bx	;sto PSP in the var. MYPSP
	pop	bx		;restore BX
	push	bp		;save stack's base pointer
	mov	bp,sp		;setup for getting C parameters off stack
	push	ds		;save DS register
	mov	cs:dshold,ds	;Save C's DS for use by FNDLNC & LNCLEAN
	push	di		;save DI, ES registers
	push	es
	push	cs		;make DS register...
	pop	ds		;...equal to CS register
	les	di,.env		;ES:DI -> buffer with 2 characters (ie. "WP")
	mov	ax,es:[di]	;sto initials in AX
	push	cs		;ES=CS
	pop	es
	jmp	exc_f		;load launcher
lcex90:	pop	es		;restore registers
	pop	di
	pop	ds
	pop	bp
	ret			;unable to run launcher, return to C

;************ Main Launcher Exec. Code in ASM ***************
;lnc_exc_f
;desc:	Shrink as small as possible, then load launcher and reload me
;in:	AX=ENV file name letters ("WP", "OF", "PR", ...)
;out:	
;ret:	if return, couldn't do it, just continue w/o Launcher
;type:	
;notes:	Launcher is not resident, so find it, load it, and tell it to reload
;	current program.  The STACK MAY NOT be first in memory.  Uses the PSP
;	plus a couple hundred bytes immediately following the PSP to exec
;	Launcher and restart the current program with the same command line.
;
exc_f:	mov	envltrs, ax		;save environment letters
	mov	ah, 30h
	int	21h			;get DOS revision
	cmp	al, 3			;DOS 3.x or later?
	 jnb	lcex15			;  no, return
	jmp	lcex90			;if no, return to C
lcex15:	 ja	lcex20			;if later, OK to load launcher
	cmp	ah, 1			;if 3.x, check minor version 
	 jnb	lcex20			;if not less than 3.1, continue
	jmp	lcex90			;else return to C
lcex20:	call	chkDL			;Check for /DL (Disable Launcher)
	 jnc	lcex23			;if not found, continue
	jmp	lcex90			;if found do not load launcher
lcex23:	call	chkcom			;if loaded as .EXE, try for <name>.COM
	 jc	lcex90			;Lancher was not found by C program
lcex25:	push	ds			;save DS register
	mov	ds,cs:dshold		;restore C's data seg
	call	_LNCLEAN		;free C pgm resources before exiting
	pop	ds			;restore DS to DS=CS
	mov	es, mypsp		;point ES at the PSP
	cli				;put stack in PSP area
	mov	ss, mypsp		;we have a 128+ byte stack to use now
	mov	sp, 100h
	sti
	push	si			;save -> to found name from fndlnc_f
assume	es:nothing
	mov	ax, es:[2Ch]		;get Environment segment
	mov	word ptr es:[6Ch], ax	;put PBLOCK on top of FCB2
	mov	word ptr es:[6Ch+2], 100h	;pointer to command line
	mov	word ptr es:[6Ch+4], es	;pointer to PSP
	mov	word ptr es:[6Ch+6], -1	;null out FCB1 pointer
	mov	word ptr es:[6Ch+8], -1
	mov	word ptr es:[6Ch+10], -1	;null out FCB2 pointer
	mov	word ptr es:[6Ch+12], -1
	mov	es, ax			;find end of environment
	xor	di, di			;zero DI and AL
	xor	al, al
	mov	cx, -1			;move 0xFFFF into CX register
lcex30:	repne	scasb			;scan string at ES:DI for zero
	scasb				;Is it followed by 2nd zero (end ENV)?
	jne	lcex30			;no, continue scan
	mov	si, di			;yes, copy prog name to build cmd line
	lodsw				;move past count word
	push	ds			;save DS register on new stack
	push	es			;push ES register for move to DS reg.
	mov	es, mypsp		;ES -> C's PSP
	pop	ds			;DS:SI -> original cmdline (pgm name)
	mov	di, 101h		;ES:DI -> 1 byte after end of PSP
	cmp	cs:envltrs, 0		;are there any letters? (DS=env seg)
	 je	lcex35			;  no, skip
	mov	ax, "E/"		;put "/E" in AX
	stosw				;sto it in ES:DI (just after PSP) "/E"
	mov	ax, "=V"		;put "V=" in AX
	stosw				;sto in ES:DI ("/EV=")
	mov	ax, cs:envltrs		;put initials (ie WP, etc.) in ax
	stosw				;sto in ES:DI (ie "/EV=WP")
	mov	al, 20h			;move a space into AL
	stosb				;sto in ES:DI (ie "/EV=WP ")
lcex35:	call	scopy_f			;copy DS:SI (orig. pgm name) to ES:DI
	push	es			;DS=ES
	pop	ds			;DS=PSP
	mov	al, 20h			;put in a space delimeter...
	stosb				;...to ES:DI
	mov	si, 80h			;DS:SI (PSP) -> cmdlin length
	lodsb				;get length byte from DS:SI to AL
	xor	ah, ah			;zero AH
	mov	cx, ax			;move length to CX
	 jcxz	lcex38			;fix for some machines
	rep	movsb			;move DS:SI (rest orig cmdlin) to ES:DI
lcex38:	mov	word ptr es:[di], 0Dh	;terminate with CR & NULL
	pop	ds			;restore DS to DS=CS
	mov	ax, di			;AX gets end of new cmdlin position
	sub	ax, 101h		;compute new cmdlin length
	mov	es:[100h], al		;and store it
	add	di, 2			;move past 0xD,zero put in above
	mov	dx, di			;save end of complete cmdline in DX
	pop	si			;restore SI to start of LNCHR name
	call	scopy_f			;copy DS:SI (LNCHR name) to ES:DI
	inc	di			;leave NULL on end (move past 1 char)
	mov	bx, di			;save pointer to code destination
	mov	ax, cs			;sure DS=CS
	mov	ds, ax
	mov	si, offset execlc	;DS:SI point to LNCHR exec code stub
	mov	cx, codemov		;CX=length of exec code stub
	rep	movsb			;copy code stub after new cmdline
	mov	cl, 4			;calculate paragraphs
	shr	di, cl
	inc	di			;add one for roundoff
	xchg	bx, di			;BX = paragraphs to keep, DI = code
	push	es			;set DS:DX = program name
	pop	ds
	push	es			;so return takes us to execlc stub
	push	di
	ret				;bounce to stub and execute code
_LNC_EXC	endp
;_LNC_SLD
;desc:	routine for calling lnc_sld_f from C
;in:	path, cmdline, default dir, umid, hotkey, macroflg
;out:	none
;
.path equ 	[bp+6]
.cmdline equ	[bp+10]
.defltdir equ	[bp+14]
.umid equ	[bp+18]
.hotkey equ	[bp+20]
.macroflg equ	[bp+22]
public	_LNC_SLD
_LNC_SLD	proc	far
	push	bp		;save stack's base pointer
	mov	bp,sp		;setup for getting C parameters
	push	es		;save registers
	push	di
	push	bx
	push	dx
	push	cx
	mov	cs:cmdblk.ld_flag, 0	;clear flag
lsld00:	les	di,.path	;get path and program file name...
	mov	word ptr cs:cmdblk.ld_path, di	;set offset...
	mov	word ptr cs:cmdblk.ld_path[2], es	;...and seg of path
	mov	bx,es		;save ES for NULL values
	les	di,.cmdline	;command line parameters (double zero term)...
	mov	word ptr cs:cmdblk.ld_parm, di	;set cmdlin parameter offset
	mov	word ptr cs:cmdblk.ld_parm[2], bx	;assume es=0
	mov	ax,es
	cmp	ax,0		;is ES zero?
	 je	Csld20		;yes
	mov	word ptr cs:cmdblk.ld_parm[2], es ;no, set cmdlin par. seg
Csld20:	les	di,.defltdir	;default directory...
	mov	word ptr cs:cmdblk.ld_ddir, di	;set default directory offset
	mov	word ptr cs:cmdblk.ld_ddir[2], bx	;assume ES=0
	mov	ax,es
	cmp	ax,0		;is ES zero?
	 je	Csld30		;yes
	mov	word ptr cs:cmdblk.ld_ddir[2], es	;no, set def dir seg
Csld30:	mov	ax,.umid	;unique menu id...
	mov	dx,.hotkey	;hotkey...
	mov	cx,.macroflg	;... and macro flags, all from C
	call	lnc_slf_f	;load/run program
	pop	cx		;restore registers
	pop	dx
	pop	bx
	pop	di
	pop	es
	pop	bp
	ret			;return to C
_LNC_SLD	endp
;_LNC_SLF
;desc:	routine for loading program from C
;in:	path, cmdline, default dir, umid, hotkey, macro flag
;out:	none
;
.path equ 	[bp+6]
.cmdline equ	[bp+10]
.defltdir equ	[bp+14]
.umid equ	[bp+18]
.hotkey equ	[bp+20]
.macroflg equ	[bp+22]
public	_LNC_SLF
_LNC_SLF	label	far
	push	bp		;save stack's base pointer
	mov	bp,sp		;setup for getting C parameters
	push	es		;save registers
	push	di
	push	bx
	push	dx
	push	cx
	jmp	short lsld00	;go back to SLD function
;_LNC_PRV
;desc:	routine for loading privite program from C
;in:	path, cmdline, default dir, umid, hotkey, macro flag
;out:	none
;
.path equ 	[bp+6]
.cmdline equ	[bp+10]
.defltdir equ	[bp+14]
.umid equ	[bp+18]
.hotkey equ	[bp+20]
.macroflg equ	[bp+22]
public	_LNC_PRV
_LNC_PRV	label	far
	push	bp		;save stack's base pointer
	mov	bp,sp		;set up for getting C parameters
	push	es		;save registers
	push	di
	push	bx
	push	dx
	push	cx
	mov	cs:cmdblk.ld_flag, ?ld_prv	;set flag to correct value
	jmp	short lsld00	;go back to SLD function
;_LNC_XCL
;desc:	routine for loading exclusive from C
;in:	path, cmd line, default dir, umid, hotkey, macro flag
;out:	none
;
.path equ 	[bp+6]
.cmdline equ	[bp+10]
.defltdir equ	[bp+14]
.umid equ	[bp+18]
.hotkey equ	[bp+20]
.macroflg equ	[bp+22]
public	_LNC_XCL
_LNC_XCL	label	far
	push	bp		;save stack's base pointer
	mov	bp,sp		;setup for getting C parameters
	push	es		;save registers
	push	di
	push	bx
	push	dx
	push	cx
	mov	cs:cmdblk.ld_flag, ?ld_xcl+?ld_prv	;set val in flag
	jmp	lsld00		;go back to SLD function
;_LNC_DIO
;desc:	routine for calling lnc_dio_f from C
;in:	mode - direct I/O mode for launcher; 0/1 enable/disable
;out:	none
;ret:	none
;
.mode	equ	[bp+6]
public	_LNC_DIO
_LNC_DIO	proc	far
	push	bp		;save stack's base pointer
	mov	bp,sp		;setup for getting C parameters
	mov	ax,.mode	;get mode to set, from C
	call	lnc_dio_f	;set new I/O mode
	pop	bp		;restore registers
	ret			;return to C
_LNC_DIO	endp
;_LNC_HKS
;desc:	routine for calling lnc_hks_f from C
;in:	mode - hot key swapping; 0/1 enable/disable
;out:	none
;ret:	none
;
.mode	equ	[bp+6]
public	_LNC_HKS
_LNC_HKS	proc	far
	push	bp		;save stack's base pointer
	mov	bp,sp		;setup for getting C parameters
	mov	ax,.mode	;get mode to set, from C
	call	lnc_hks_f	;set new I/O mode
	pop	bp		;restore registers
	ret			;return back to C
_LNC_HKS	endp
;_LNC_HKU
;desc:	routine for calling lnc_hku_f from C
;in:	mode - hot key swapping (user programs only); 0/1 enable/disable
;out:	none
;ret:	none
;
.mode	equ	[bp+6]
public	_LNC_HKU
_LNC_HKU	proc	far
	push	bp		;save stack's base pointer
	mov	bp,sp		;settup for getting C parameters
	mov	ax,.mode	;get mode to set, from C
	call	lnc_hku_f	;set new I/O mode
	pop	bp		;restore registers
	ret			;return to C
_LNC_HKU	endp
;_LNC_CAP
;desc:	routine for calling lnc_cap_f from C
;in:	none
;out:	proglist - list of currently active programs (running or swapped)
;ret:	error code - (0 = OK)
;
.proglist	equ [bp+6]
.progCnt	equ [bp+10]
public	_LNC_CAP
_LNC_CAP	proc	far
	push	bp			;save stack's base pointer
	mov	bp,sp			;setup for getting C parameters
	push	es			;save registers
	push	si
	push	ds
	lds	si,.proglist		;buffer offset for program list ret val
	call	lnc_cap_f		;get list of active programs
	 jc	lcap80			; error? - error code in ax
	les	si,.progCnt		;no, get number of entries in list var
	mov	ax,cs:cmdblk.st_cnt	;return number of programs in ax
	mov	es:[si],ax		;sto in C far pointer
	xor	ax,ax			;no error
lcap80:	pop	ds			;restore registers
	pop	si
	pop	es
	pop	bp
	ret				;return to C
_LNC_CAP	endp
;_LNC_ELD
;desc:	routine for calling lnc_eld_f from C
;in:	none
;out:	proglist - list of currently active ELD programs (running or swapped)
;ret:	error code - (0 = OK)
;
.proglist	equ [bp+6]
.progCnt	equ [bp+10]
public	_LNC_ELD
_LNC_ELD	proc	far
	push	bp		;push stack's base pointer
	mov	bp,sp		;setup for getting C parameters
	push	es		;save registers
	push	si
	push	ds
	lds	si,.proglist	;buffer offset for ELD program list return
	call	lnc_eld_f	;get list of active programs
	 jc	leld80		; error? - error code in ax
	les	si,.progCnt	;no, get number of entries in list var from C
	mov	ax,cs:cmdblk.st_cnt	;put number of ELD's in AX
	mov	es:[si],ax	;sto number in C far pointer
	xor	ax,ax		;no error
leld80:	pop	ds		;restore registers
	pop	si
	pop	es
	pop	bp
	ret			;return to C
_LNC_ELD	endp
;_LNC_LST
;desc:	routine for calling lnc_lst_f from C
;in:	none
;out:	none
;ret:	last - umid of last active program
;
public	_LNC_LST
_LNC_LST	proc	far
	call	lnc_lst_f		;get last active program
	mov	ax,cs:cmdblk.st_cnt	;return umid in ax
	ret				;retrun to C
_LNC_LST	endp
;_LNC_MEX
;desc:	routine for calling lnc_mex_f from C
;in:	macro - filename of keystorke macro
;out:	none
;ret:	error code (0 = OK)
;
.macro	equ	[bp+6]
public	_LNC_MEX
_LNC_MEX	proc	far
	push	bp		;save stack's base pointer
	mov	bp,sp		;setup for getting C parameters
	push	si		;save registers
	push	ds
	lds	si,.macro	;get filename of macro from C
	call	lnc_mex_f	;play macro
	 jc	lmex80		; error? (returned in ax)
	xor	ax,ax		;no error
lmex80:	pop	ds		;restore registers
	pop	si
	pop	bp
	ret			;return to C
_LNC_MEX	endp
;_LNC_MDF
;desc:	routine for calling lnc_mdf_f from C
;in:	macro - filename of keystorke macro
;	description - macro description
;out:	none
;ret:	error code (0 = OK)
;
.macro	equ	[bp+6]
.desc	equ	[bp+10]
.descsz	equ	[bp+14]
public	_LNC_MDF
_LNC_MDF	proc	far
	push	bp		;save stack's base pointer
	mov	bp,sp		;setup for getting C parameters
	push	si		;save registers
	push	di
	push	cx
	push	ds
	lds	si,.macro	;get filename of macro...
	mov	di,.desc	;macro description...
	mov	cx,.descsz	;... and description size, all from C
	call	lnc_mdf_f	;start macro define
	 jc	lmdf80		; error? (returned in ax)
	xor	ax,ax		;no error
lmdf80:	pop	ds		;save registers
	pop	cx
	pop	di
	pop	si
	pop	bp
	ret			;return to C
_LNC_MDF	endp
;_LNC_MDS
;desc:	routine for calling lnc_mds_f from C
;in:	remkeys - number of keys to remove
;out:	none
;ret:	none
;
.remkey	equ	[bp+6]
public	_LNC_MDS
_LNC_MDS	proc	far
	push	bp		;save stack's base pointer
	mov	bp,sp		;setup for getting C parameters
	push	cx		;save registers
	mov	cx,.remkey	;number of keys to remove, from C
	call	lnc_mds_f	;end macro record
	pop	cx		;restore registers
	pop	bp
	ret			;return to C
_LNC_MDS	endp
;_LNC_CRD
;desc:	routine for calling lnc_crd_f from C
;in:	none
;out:	none
;ret:	last - umid of last active program
;
.clpfmt	equ	[bp+6]
.clpfn	equ	[bp+8]
public	_LNC_CRD
_LNC_CRD	proc	far
	push	bp		;save stack's base pointer
	mov	bp,sp		;setup for getting C parameters
	push	es		;save registers
	push	di
	push	ds
	push	si
	mov	ax,.clpfmt	;get clipbrd fmt from C
	call	lnc_crd_f	;clipboard read
	 jc	lcrd80		;error? (returned in AX)
	les	di,.clpfn	;no, get C's clipbrd filename pointer
	mov	ax,word ptr cs:cmdblk.cb_flnm	;get fname offset address
	mov	si,ax		;sto in SI
	mov	ax,word ptr cs:cmdblk.cb_flnm+2	;get fname segment address
	mov	ds,ax		;sto in DS
	call scopy_f		;copy file name to C string
	xor	ax,ax		;no error
lcrd80:	pop	si		;restore registers
	pop	ds
	pop	di
	pop	es
	pop	bp
	ret			;return to C
_LNC_CRD	endp
;_LNC_CPD
;desc:	routine for calling lnc_cpd_f from C
;in:	none
;out:	none
;ret:	last - umid of last active program
;
.clpfmt	equ	[bp+6]
.clpfn	equ	[bp+8]
public	_LNC_CPD
_LNC_CPD	proc	far
	push	bp		;save stack's base pointer
	mov	bp,sp		;setup for getting C parameters
	push	es		;save registers
	push	di
	push	ds
	push	si
	mov	ax,.clpfmt	;get clipbrd fmt from C
	call	lnc_cpd_f	;clipboard read
	 jc	lcpd80		;error? (returned in AX)
	les	di,.clpfn	;no, get C's clipbrd filename pointer
	mov	ax,word ptr cs:cmdblk.cb_flnm	;get fname offset address
	mov	si,ax		;sto in SI
	mov	ax,word ptr cs:cmdblk.cb_flnm+2	;get fname segment address
	mov	ds,ax		;sto in DS
	call scopy_f		;copy filename to C string var.
	xor	ax,ax		;no error
lcpd80:	pop	si		;restore registers
	pop	ds
	pop	di
	pop	es
	pop	bp
	ret			;return to C
_LNC_CPD	endp
;_LNC_CWR
;desc:	routine for calling lnc_cwr_f from C
;in:	none
;out:	none
;ret:	last - umid of last active program
;
.clpfmt	equ	[bp+6]
.clpfn	equ	[bp+8]
public	_LNC_CWR
_LNC_CWR	proc	far
	push	bp		;save stack's base pointer
	mov	bp,sp		;setup for getting C parameters
	push	es		;save registers
	push	di
	push	ds
	push	si
	mov	ax,.clpfmt	;get clipbrd fmt from C
	call	lnc_cwr_f	;clipboard read
	 jc	lcwr80		;error? (returned in AX)
	les	di,.clpfn	;no, get C's clipbrd filename pointer
	mov	ax,word ptr cs:cmdblk.cb_flnm	;get fname offset address
	mov	si,ax		;sto in SI
	mov	ax,word ptr cs:cmdblk.cb_flnm+2	;get fname segment address
	mov	ds,ax		;sto in DS
	call scopy_f		;copy file name to C string
	xor	ax,ax		;no error
lcwr80:	pop	si		;restore registers
	pop	ds
	pop	di
	pop	es
	pop	bp
	ret			;return to C
_LNC_CWR	endp
;_LNC_CSN
;desc:	routine for calling lnc_csn_f from C
;in:	clipboard - new clipboard name/number
;out:	none
;ret:	last - umid of last active program
;
.clpnm	equ	[bp+6]
.clpfn	equ	[bp+10]
public	_LNC_CSN
_LNC_CSN	proc	far
	push	bp		;save stack's base pointer
	mov	bp,sp		;setup for getting C parameters
	push	es		;save registers
	push	si
	push	ds
	push	di
	les	di,.clpnm	;get clipbrd number from C
	mov	ah,es:[di]	;get ASCII representation of Clip number
	mov	al,es:[di+1]
	call	lnc_csn_f	;set clipboard name/number
	les	di,.clpfn	;get C filename buffer in ES:DI
	mov	si,word ptr cs:cmdblk.cb_flnm	;get Clip filename in DS:SI
	mov	ds,word ptr cs:cmdblk.cb_flnm+2
	call	scopy_f		;copy filename to C
	pop	di		;restore registers
	pop	ds
	pop	si
	pop	es
	pop	bp
	ret			;return to C
_LNC_CSN	endp
;_LNC_CRN
;desc:	routine for calling lnc_crn_f from C
;in:	none
;out:	clipboard - current clipboard number
;ret:	none
;
.clpnm	equ	[bp+6]
.clpfn	equ	[bp+10]
public	_LNC_CRN
_LNC_CRN	proc	far
	push	bp		;save stack's base pointer
	mov	bp,sp		;setup for getting C parameters
	push	es		;save registers
	push	si
	push	ds
	push	di
	call	lnc_crn_f	;set clipboard name/number
	les	di,.clpnm	;get C clipboard number buffer
	mov	es:[di],ah	;put ASCII of clip number to C
	mov	es:[di+1],al
	les	di,.clpfn	;point ES:DI to C file name buffer
	mov	si,word ptr cs:cmdblk.cb_flnm	;Point DS:SI to file name
	mov	ds,word ptr cs:cmdblk.cb_flnm+2
	call	scopy_f		;copy filename to C
	pop	di		;restore registers
	pop	ds
	pop	si
	pop	es
	pop	bp
	ret			;return to C
_LNC_CRN	endp
;_LNC_CFM
;desc:	routine for calling lnc_cfm_f from C
;in:	none
;out:	clipboard - current clipboard number
;ret:	none
;
public	_LNC_CFM
_LNC_CFM	proc	far
	push	bp		;save stack's base pointer
	mov	bp,sp		;setup for getting C parameters
	push	es		;save registers
	push	di
	push	ds
	push	si
	call	lnc_cfm_f	;get clipboard foramt
	les	di,[bp+6]	;ES:DI -> C filename buffer
	mov	si,word ptr cs:cmdblk.cb_flnm	;DS:SI -> filename
	mov	ds,word ptr cs:cmdblk.cb_flnm+2
	call	scopy_f		;copy filename to C
	pop	si		;restore registers
	pop	ds
	pop	di
	pop	es
	pop	bp
	ret			;return to C
_LNC_CFM	endp
;_LNC_RQX
;desc:	routine for calling lnc_rqx_f from C
;in:	none
;out:	clipboard - current clipboard number
;ret:	none
;
public	_LNC_RQX
_LNC_RQX	proc	far
	call	lnc_rqx_f	;request permission to exit
	 jc	lrqx80		;error? (returned in AX)
	xor	ax,ax		;no error
lrqx80:	ret			;return to C
_LNC_RQX	endp

;_LNC_SWC
;desc:	routine for calling LC_SWAP from C
;in:	none
;out:	the swapping recorses availiability & place to swap next pgm flags
;ret:	none
;
public	_LNC_SWC
_LNC_SWC	proc	far
	mov	cs:cmdblk.lc_func, lc_swap	;signal the function to use
	call	lc_scmd		;tell launcher to execute func request
	mov	ax,cs:cmdblk.st_cnt	;get flags into AX for return to C
	ret			;return to C
_LNC_SWC	endp

;_LNC_XALL
;desc:	tell Launcher to close all running prgs
;in:	status values
;out:	none
;ret:	none
;
.xa_stat	equ	[bp+6]
public	_LNC_XALL
_LNC_XALL	proc	far
	push	bp		;save stack's base pointer
	mov	bp,sp		;setup for getting C parameters
	mov	ax,.xa_stat	;get XA_STAT from C
	mov	cs:cmdblk.st_cnt,ax	;sto in correct struct element
	mov	cs:cmdblk.lc_func, lc_xall	;val of LNCHR func to use
	call	lc_scmd		;command launcher to use function
	pop	bp		;restore registers
	ret			;return to C
_LNC_XALL	endp

;_LNC_KALT
;desc:	enable/disable ALT key swapping
;in:	enable/disable switch
;out:	none
;ret:	none
;
.toggle	equ	[bp+6]
public	_LNC_KALT
_LNC_KALT	proc	far
	push	bp		;save stack's base pointer
	mov	bp,sp		;setup for getting C parameters
	mov	ax,.toggle	;get enable/disable value from C
	mov	cs:cmdblk.st_cnt,ax	;sto in struct element
	mov	cs:cmdblk.lc_func, lc_kalt	;specify LNCHR func to use
	call	lc_scmd		;execute function
	pop	bp		;restore registers
	ret			;return to C
_LNC_KALT	endp

;_LNC_KSTF
;desc:	Stuff 1-2 keystrokes into keybrd buff
;in:	# of bytes being passed (3 or 6 only)
;	keystroke bytes
;out:	none
;ret:	none
;
.count	equ	[bp+6]
.keys	equ	[bp+8]
public	_LNC_KSTF
_LNC_KSTF	proc	far
	push	bp		;save stack's base pointer
	mov	bp,sp		;setup for getting C parameters
	push	ds		;save registers
	push	si
	mov	ax,.count	;get # of key codes (3 or 6) from C
	lds	si,.keys	;get far pointer to key code buffer from C
	mov	cs:cmdblk.st_cnt,ax	;sto # of key codes in struct member
	mov	cs:cmdblk.lc_func,lc_kstf	;specify correct function used
	call	lc_strn		;execute launcher function
	pop	si		;restore registers
	pop	ds
	pop	bp
	ret			;return to C
_LNC_KSTF	endp

;_LNC_PATH
;desc:	returns a pointer to launcher's path
;in:	none
;out:	DD pointer to launcher's env path
;ret:	none
;
.lcpth	equ	[bp+6]
public	_LNC_PATH
_LNC_PATH	proc	far
	push	bp		;save stack's base pointer
	mov	bp,sp		;setup for getting C data off stack
	push	ds		;save registers
	push	si
	push	es
	push	di
	mov	cs:cmdblk.lc_func, lc_path	;set correct function
	call	lc_scmd		;execute function
	les	di,.lcpth	;get C's path buffer
	mov	ds,word ptr cs:cmdblk.st_strz[2]	;get path seg in DS
	mov	si,word ptr cs:cmdblk.st_strz	;get path offset in SI
	call	scopy_f		;copy string to C
	pop	di		;restore registers
	pop	es
	pop	si
	pop	ds
	pop	bp
	ret			;return to C
_LNC_PATH	endp

;_LNC_NPID
;desc:	Get the pid that will be assigned to next pgm
;in:	none
;out:	next available pid
;ret	none
;
public	_LNC_NPID
_LNC_NPID	proc	far
	mov	cs:cmdblk.lc_func, lc_npid	;set correct function
	call	lc_scmd		;execute function
	mov	ax,cs:cmdblk.st_cnt	;return next PID in AX
	ret			;return to C
_LNC_NPID	endp
;_LNC_NHKY
;desc:	Change hot keys from C
;in:	umid
;	New Hot key
;	Flag
;out:	none
;ret:	jc = invalid umid
;
.umid	equ	[bp+6]
.hotkey	equ	[bp+8]
.nhflag	equ	[bp+10]
public	_LNC_NHKY
_LNC_NHKY	proc	far
	push	bp		;save stack's base pointer
	mov	bp,sp		;setup for getting C parameters
	mov	ax,.umid	;get umid from C
	mov	cs:cmdblk.st_cnt,ax	;sto it in structure
	mov	ax,.hotkey		;get new hot key from C
	mov	cs:cmdblk.st_wrd2,ax	;sto it in structure
	mov	ax,.nhflag		;get hot key flag from C
	mov	cs:cmdblk.st_wrd3,ax	;sto it in structure
	mov	cs:cmdblk.lc_func, lc_nhky	;set the command
	call	lc_strn		;send command to Launcher
	 jc	nhk80		;error?
	xor	ax,ax		;no, zero return value
	jmp	nhk90		;continue on
nhk80:	mov	ax,-1		;yes, set return value to -1
nhk90:	pop	bp		;restore base pointer
	ret			;return to C
_LNC_NHKY	endp
;_SETMACS
;desc:	load the 4 automatic macro pointers of cmdblk from C
;in:	4 far pointers to file name of 4 macros or null bufs
;out:	none
;ret:	always zero
;
.eolmac	equ	[bp+6]
.gosmac	equ	[bp+10]
.rtsmac	equ	[bp+14]
.dirmac	equ	[bp+18]
public _SETMACS
_SETMACS	proc	far
	push	bp			;save stack's base pointer
	mov	bp,sp			;setup for getting C parameters
	push	es			;save registers
	push	di
	les	di,.eolmac		;ES:DI -> filename of EOL macro
	mov	word ptr cs:cmdblk.ld_eolm,di	;save pointer in structure
	mov	word ptr cs:cmdblk.ld_eolm+2,es
	les	di,.gosmac		;ES:DI -> filename of "Go Shell" macro
	mov	word ptr cs:cmdblk.ld_gosh,di	;save pointer in structure
	mov	word ptr cs:cmdblk.ld_gosh+2,es
	les	di,.rtsmac		;ES:DI -> filename of "Ret frm Shell" 
	mov	word ptr cs:cmdblk.ld_rtsh,di	;save pointer in structure
	mov	word ptr cs:cmdblk.ld_rtsh+2,es
	les	di,.dirmac		;ES:DI -> path of above file names
	mov	word ptr cs:cmdblk.ld_macd,di	;save pointer in structure
	mov	word ptr cs:cmdblk.ld_macd+2,es
	xor	ax,ax			;zero AX for return value (always 0)
	pop	di			;restore registers
	pop	es
	pop	bp
	ret				;return to C program
_SETMACS	endp

;_SETLOAD
;desc:	get the load flags from C for SLF call
;in:	unsigned int byte flags
;out:	none
;
.lodflg	equ	[bp+6]
public	_SETLOAD
_SETLOAD	proc	far
	push	bp			;save stack's base pointer
	mov	bp,sp			;setup for getting C parameters
	mov	ax,.lodflg		;get load flag values from C
	mov 	cs:cmdblk.ld_flag,ax	;save in structure
	pop	bp			;restore base pointer
	ret				;return to C
_SETLOAD	endp

;_LNC_XCHK
;desc:	show ld_flags to C
;in:	none
;out:	ld_flags
;
public	_LNC_XCHK
_LNC_XCHK	proc	far
	mov	ax,cs:cmdblk.ld_flag	;get ld_flag in AX (C return value)
	ret				;return back to C
_LNC_XCHK	endp
;************************************************************************
;********************* Main ASM LNC_Functions ***************************
;*********************** (Transparent to C) *****************************
;************************************************************************

;Variables used specificly by the ASM functions (not used in C)
lnchids	db	"WPLAUNCH",0	;Launcher ID string
lnchuid	dw	0		;Umid of program registered
getst	dd	0		;Far pointer to C get state func

;scopy_f
;in:	ds:si	= pointer to source string
;	es:di	= pointer to destination string
;out:	di	= pointer to terminating null in destination
;ret:	none
;type:	String,Copy Copy,String
;
scopy_f	proc	near
	push	ax		;save registers
	pushf
	push	si
	cld			;make sure we're going up
scop10:	lodsb			;al = byte from source string (DS:SI)
	stosb			;store it in destination string (ES:DI)
	or	al,al		;end of string? (is last byte zero?)
	 jnz	scop10		; no, repeat
	dec	di		; yes, dec pointer to null in dest
	pop	si		;restore registers
	popf
	pop	ax
	ret			;return to calling routine
scopy_f	endp
;fndlnc_f
;desc:	Get Lancher name var to C's find routine, translate returned results
;in:	none
;out:	Path/Name in Incpth
;ret:	jc = error
;
fndlnc_f	proc	near
	push	ds		;save registers
	push	cx
	mov	ds,cs:dshold	;restore C's data segment (for small models)
	push	cs		;push far pointer parameter on stack
	push	si
	call	_FNDLNC		;call C's find function
	cmp	ax,0		;was name found?
	 je	fnd20		;yes
	stc			;no, set carry flag
	jmp	fnd90		;go end
fnd20:	clc			;clear cary flag
fnd90:	pop	cx		;restore registers
	pop	cx
	pop	cx
	pop	ds
	ret			;return to calling program
fndlnc_f	endp
;lnc_sld_f
;desc:	Switch to specified program if resident, otherwise try and load it
;in:	LNCHPID = Launcher assigned PID
;	AX = UMID (Unique Menu ID) of program to load
;	DX = Hot-Key
;	CX = macro dirs flag
;		0: already set
;	non-zero : set all null strings (ld_macd, ld_eolm, ld_gosh, ld_rtsh)
;	ES:BX = Program's full path\name
;	ES:SI = Command line parameters to be passed (must have extra word)
;	ES:DI = Default directory (to be CD'd to before EXEC'ing)
;out:	none
;type:	
;notes:	AX (UMID) must always be valid.  If the program is already resident
;	(swapping to an active program) none of the other parameters are
;	necessary (may be left blank).
;
;	This is the same function used by the SLF sub function only the
;	ld_flag member is not reset.
;
lnc_slf_f	proc	near
	push	si			;save register
	mov	cs:cmdblk.ld_umid, ax	;set the UMID
	mov	cs:cmdblk.lc_func, lc_load	;Load function
	mov	cs:cmdblk.ld_hotk, dx	;and set the hot key
	 jcxz	lsld30			;should we set macro directories?
	mov	ax, cs			; yes
	mov	cx, offset cs:lnchpid+1	;no,set hi byte is always 0 - NULL
	mov	word ptr cs:cmdblk.ld_macd, cx	;point all 4 automatic...
	mov	word ptr cs:cmdblk.ld_macd[2], ax ;...macro pointers to ...
	mov	word ptr cs:cmdblk.ld_eolm, cx	;...a null pointer.
	mov	word ptr cs:cmdblk.ld_eolm[2], ax
	mov	word ptr cs:cmdblk.ld_gosh, cx
	mov	word ptr cs:cmdblk.ld_gosh[2], ax
	mov	word ptr cs:cmdblk.ld_rtsh, cx
	mov	word ptr cs:cmdblk.ld_rtsh[2], ax
lsld30:	call	lc_scmd		;execute function
	pop	si		;restore registers
	ret			;return to calling program
lnc_slf_f	endp

;lc_strn
;desc:	Generic routine called by several string/buffer Launcher commands
;in:	DS:SI = string/buffer to pass
;out:	
;ret:	
;type:	
;notes:	
;
lc_strn	proc	near
	mov	word ptr cs:cmdblk.st_strz, si	;set generic buffer offset
	mov	word ptr cs:cmdblk.st_strz[2], ds	;set gen buf segment
	call	lc_scmd		;execute a function
	ret			;return to calling program
lc_strn	endp
;lnc_gtm_f
;desc:	Get the Launcher Menu name
;in:	LNCHPID = Launcher assigned PID
;	DS:SI = buffer for menu name (at least 80 bytes wide)
;out:	
;ret:	JC = none set yet
;	  cmdblk.lc_err = AX = error code
;type:	
;notes:	This returns the full path/name of the menu being used by the PoC to
;	launch and switch to other programs.  Only one menu may ever be
;	active at once.  Any programs supporting the "Run" menu must use this
;	to get the list of programs that are available.  Should be called ONCE
;	at startup time.
;
lnc_gtm_f	proc	near
	mov	cs:cmdblk.lc_func, lc_getm	;set function
	call	lc_strn		;execute function
	ret			;return to calling program
lnc_gtm_f	endp
;lnc_gtp_f
;desc:	Get the Launcher Program of Choice description
;in:	LNCHPID = Launcher assigned PID
;	DS:SI = buffer for Program of Choice (PoC) description (40 byte max)
;out:	
;ret:	JC = none set yet
;	  cs:cmdblk.lc_err = AX = error code
;type:	
;notes:	For programs that support the Menu but are NOT the PoC, this returns
;	the string that should be used to describe the PoC on the menu
;	displayed to the user.  Need only be called once, so it is in EDITSEG
;

lnc_gtp_f	proc	near
	mov	cs:cmdblk.lc_func, lc_getp	;set function
	call	lc_strn		;execute function
	ret			;return to calling program
lnc_gtp_f	endp
;lnc_cap_f
;desc:	Get list of Currently Active Programs (running or swapped)
;in:	LNCHPID = Launcher assigned PID
;	DS:SI = buffer for list
;out:	cmdblk.st_cnt = number of programs resident - including PoC
;	cmdblk.st_wrd2 = current programs UMID
;ret:	JC = couldn't complete request
;	  cmdblk.lc_err = AX = error code
;type:	
;notes:	Returns a list of "3 word wide" entries: (1) UMID, (2) memory used (in
;	paragraphs), (3) where program is swapped to.  This can be used to
;	generate a memory map, check for child (private) launches, ...
;
lnc_cap_f	proc	near
	mov	cs:cmdblk.lc_func, lc_resp	;set function to use
	call	lc_strn		;execute function
	ret			;return to calling program
lnc_cap_f	endp
;lnc_eld_f
;desc:	Get list of Currently Active ELD Programs (running or swapped)
;in:	LNCHPID = Launcher assigned PID
;	DS:SI = buffer for list
;out:	cmdblk.st_cnt = number of programs resident - including PoC
;ret:	JC = couldn't complete request
;	  cmdblk.lc_err = AX = error code
;type:	
;notes:	Returns a list of "3 word wide" entries: (1) UMID, (2) memory used (in
;	paragraphs), (3) where program is swapped to.  This can be used to
;	generate a memory map, check for child (private) launches, ...
;
lnc_eld_f	proc	near
	mov	cs:cmdblk.lc_func, lc_reld	;set function
	call	lc_strn		;execute function
	ret			;return to calling program
lnc_eld_f	endp
;lnc_mdf_f
;desc:	Begin Launcher's Macro define feature
;in:	DS:SI = filename to save keystrokes in
;	DS:DI = macro description to store in file header
;	CX = length of macro description string
;out:	
;ret:	JC = error code
;	cmdblk.lc_err = AX = error code
;type:	
;notes:	
;
lnc_mdf_f	proc	near
	mov	cs:cmdblk.lc_func, lc_defm	;set function
	mov	word ptr cs:cmdblk.st_wrd2, di	;pass in descrip, name handled
	mov	word ptr cs:cmdblk.st_wrd2[2], ds	;in lc_strn as far ptr
	mov	word ptr cs:cmdblk.st_cnt, cx	;pass in description length
	call	lc_strn		;execute function
	ret			;return to calling program
lnc_mdf_f	endp
;lnc_mex_f
;desc:	Begin Launchers Macro play feature
;in:	DS:SI = filename to read keystrokes from
;out:	
;ret:	JC = error code
;	cmdblk.lc_err = AX = error code
;type:	
;notes:	
;
lnc_mex_f	proc	near
	mov	cs:cmdblk.lc_func, lc_exem	;set function
	call	lc_strn		;execute function
	ret			;return to calling program
lnc_mex_f	endp
;lnc_mds_f
;desc:	Stop the Macro define
;in:	CX = number of keystrokes to remove from end of macro
;out:	
;ret:	
;type:	
;notes:	
;
lnc_mds_f	proc	near
	mov	cs:cmdblk.lc_func, lc_defs	;set function
	mov	cs:cmdblk.st_cnt, cx	;set # of keys to remove from mac end
	call	lc_scmd		;execute function
	ret			;return to calling program
lnc_mds_f	endp
;lnc_dio_f
;desc:	Set the direct IO mode of Launcher
;in:	AX = 0/1 enable/disable macro support
;out:	
;ret:	
;type:	
;notes:	
;
lnc_dio_f	proc	near
	mov	cs:cmdblk.lc_func, lc_dio	;set function
	mov	cs:cmdblk.st_cnt, ax	;set state (enable/disable)
	call	lc_scmd		;execute function
	ret			;return to calling program
lnc_dio_f	endp
;lnc_hks_f
;desc:	Set the Hot Key enable/disable flag in Launcher
;in:	AX = 0/1 enable/disable Hot Key swapping
;out:	
;ret:	
;type:	
;notes:	
;
lnc_hks_f	proc	near
	mov	cs:cmdblk.lc_func, lc_hksw	;set function
	mov	cs:cmdblk.st_cnt, ax	;set state (enable/disable)
	call	lc_scmd		;execute function
	ret			;return to calling program
lnc_hks_f	endp
;lnc_hku_f
;desc:	Set the Hot Key enable/disable flag in Launcher (User Programs only)
;in:	AX = 0/1 enable/disable Hot Key swapping
;out:	
;ret:	
;type:	
;notes:	
;

lnc_hku_f	proc	near
	mov	cs:cmdblk.lc_func, lc_hksu	;set function
	mov	cs:cmdblk.st_cnt, ax	;set state (enable/disable)
	call	lc_scmd		;execute function
	ret			;return to calling program
lnc_hku_f	endp
;lnc_lst
;desc:	Get the last active program (where swapped from)
;in:	
;out:	cmdblk.st_cnt = UMID of last active program
;ret:	
;type:	
;notes:	
;
lnc_lst_f	proc	near
	mov	cs:cmdblk.lc_func, lc_lact	;get Last ACTive program
	call	lc_scmd		;execute function
	ret			;return to calling program
lnc_lst_f	endp
;lnc_crd_f
;desc:	Clipboard Read
;in:	AX = requested format
;out:	cmdblk.cb_flnm = clipboard filename
;ret:	
;type:	
;notes:	
;
lnc_crd_f	proc	near
	mov	cs:cmdblk.lc_func, lc_cbrd	;Read from the clipboard
	jmp	short lcpd30	;jump forward to CPD routine
lnc_crd_f	endp
;lnc_cwr_f
;desc:	Clipboard Write
;in:	AX = requested format
;out:	cmdblk.cb_flnm = clipboard filename
;ret:	
;type:	
;notes:	
;
lnc_cwr_f	proc	near
	mov	cs:cmdblk.lc_func, lc_cbwr	;Request Write to the Clipboard
	jmp	short lcpd30	;jump forward to CPD routine
lnc_cwr_f	endp
;lnc_cpd
;desc:	Clipboard Append
;in:	AX = requested format
;out:	cmdblk.cb_flnm = clipboard filename
;ret:	
;type:	
;notes:	
;
lnc_cpd_f	proc	near
	mov	cs:cmdblk.lc_func, lc_cbap	;Request Append to Clipboard
lcpd30:	mov	cs:cmdblk.cb_frmt, ax	;pass requested format
	call	lc_scmd		;execute function
	ret			;return to calling program
lnc_cpd_f	endp
;lnc_cfm
;desc:	Clipboard Format check
;in:	
;out:	AX = format
;	cmdblk.cb_flnm = clipboard filename
;ret:	
;type:	
;notes:	
;
lnc_cfm_f	proc	near
	mov	cs:cmdblk.lc_func, lc_cbfm	;Request Append to Clipboard
lcfm30:	call	lc_scmd		;execute function
	mov	ax, cs:cmdblk.cb_frmt	;return current format
	ret			;return to calling program
lnc_cfm_f	endp
;lnc_crn_f
;desc:	Check current clipboard name/number
;in:	
;out:	AX = current clipboard number
;ret:	
;type:	
;notes:	
;
lnc_crn_f	proc	near
	mov	cs:cmdblk.lc_func, lc_cbrn	;Request Append to Clipboard
	jmp	short lcfm30	;jump back to CFM routine
lnc_crn_f	endp
;lnc_csn_f
;desc:	Set new current clipboard name/number
;in:	AX = new clipboard name/number
;out:	
;ret:	
;type:	
;notes:	
;
lnc_csn_f	proc	near
	mov	cs:cmdblk.lc_func, lc_cbsn	;set function
	jmp	short lcpd30	;jump back to CPD routine
lnc_csn_f	endp
;lnc_rqx_f
;desc:	Request permission to Exit
;in:	LNCHPID = Launcher assigned PID
;out:	
;ret:	JC = can't exit
;	cmdblk.lc_err = AX = error code
;type:	
;notes:	ERROR (can't exit) happens IFF requestor is Program of Choice and
;	other programs are still active.
;
lnc_rqx_f	proc	near
	mov	cs:cmdblk.lc_func, lc_reqx	;check if it is OK to exit now
	call	lc_scmd		;execute function
	ret			;return to calling program
lnc_rqx_f	endp
;lc_scmd
;desc:	Local routine to perform Simple, no parameter, function request
;in:	
;out:	
;ret:	
;type:	
;notes:	
;
lc_scmd	proc	near
	push	si		;entry point for parameterless commands
	push	ds		;save registers
	mov	ax, cs:lnchpid	;get current PID
	mov	cs:cmdblk.lc_pid, ax	;set it in structure member
	mov	cs:cmdblk.lc_err, 0	;Always clear the error code field
	mov	ax, 5C00h	;command for accessing launcher func services
	push	cs		;DS=CS so DS:SI will -> structure
	pop	ds
	mov	si, offset cmdblk	;point SI to structure
	int	1Ah		;execute launcher function service
	pop	ds		;restore registers
	pop	si
	ret			;return to calling program
lc_scmd	endp
;lnc_chk_f
;desc:	Check if Launcher is resident and active
;in:	
;out:	AX = version number
;ret:	JE = Launcher resident
;type:	
;notes:	
;
lnc_chk_f	proc	near
	push	si		;save registers
	push	ds
	push	es
	mov	ax, 5C00h	;Launcher communication function
	mov	cs:cmdblk.lc_func, lc_res	;Check if Launcher resident
	push	cs
	pop	ds		;DS:SI = id string
	mov	si, offset cmdblk	;pass in the command block
	int	1Ah		;execute launcher service
	les	di, [si].st_strz	;get pointer to id string
	mov	si, offset lnchids	;get pointer to check string
	mov	cx, 8		;set CX to number of characters in check str.
	rep	cmpsb		;compare both strings
	mov	ax, es:[di+1]	;get the version number
	xchg	ah, al		;put major in AH, minor in AL
	pushf
	mov	word ptr cs:lchdat,di
	mov	word ptr cs:lchdat+2,es
	inc	word ptr cs:lchdat
	popf
	pop	es		;restore registers
	pop	ds
	pop	si
	ret			;return to calling pgm (zero flg set on err.)
lnc_chk_f	endp
;lnc_reg_f
;desc:	Register with the Launcher
;in:	ES:DI = Applications STATE communication - like Shell (DI=-1: none)
;out:	AX = Launcher PID (Program ID)
;	cmdblk.lc_pid = AX = PID
;ret:	
;type:	
;notes:	If Launcher is resident, will not fail.
;
lnc_reg_f	proc	near
	push	si		;save registers
	push	ds
	push	cs
	pop	ds
	mov	ax, 5C00h	;Launcher communication function
	mov	cmdblk.lc_func,lc_ckin	;Check-in/register  with Launcher
	cmp	di,0ffffh	;No GetState function?
	 je	regf20		;No state func, set values from ES:DI
	mov	word ptr cs:getst,di	;Yes state func, save state func ptr 
	mov	word ptr cs:getst[2],es
	mov	word ptr cmdblk.rg_stat,offset transtat_f ;set pointer to...
	mov	word ptr cmdblk.rg_stat[2], cs	;...sub state function
	jmp	regf40		;skip to cmdblk pass
regf20:	mov	word ptr cmdblk.rg_stat, di	;set STATE routine
	mov	word ptr cmdblk.rg_stat[2], es
regf40:	mov	si, offset cmdblk	;pass in the command block
	int	1Ah		;execute launcher func service
	mov	cs:lnchpid, ax	;save current PID
	push	si		;save si
	mov	si,[si].rg_flag	;get launcher flags into SI
	mov	lnchflg,si	;save launcher flags
	pop	si		;restore SI
	mov	si,[si].rg_umid	;get current umid into SI
	mov	lnchuid,si	;save umid
	pop	ds		;restore registers
	pop	si
	ret			;return to calling program
lnc_reg_f	endp

;transtat_f
;desc:	Called by Launcher for state requests to C
;in:	AX=Launcher request
;	CX=destination unique menu ID (umid)
;	DX=screen flags
;out:	Either long AX DX, DS:SK, or void
;
transtat_f	proc	far
	push	es		;save registers
	push	di
	push	bx
	push	cx
	push	ds
	push	si
	push	dx
	mov	cs:req,al	;save value in AL for later
	cmp	ax,5		;does AX=5
	 jne	tns05		;no, continue
	push	ds		;yes, push DS & SI on stack for transport...
	push	si		;...to C state function
	jmp	tns15		;go to last parameter
tns05:	cmp	ax,8		;does AX=8?
	 jne	tns10		;no, continue
	push	dx		;push CX & DX on stack for...
	push	cx		;... transport to C state function
	jmp	tns15		;go to last parameter
tns10:	mov	cx,0		;AX != 5 or 8, set CX to zero
	push	cx		;zero first 2 parameters to C function &...
	push	cx		;...then go to last parameter
tns15:	push	ax		;put last parameter on stack for C function
	mov	ds,cs:dshold	;restore C's data segment
	call	dword ptr cs:getst		;call C state function
	pop	cx		;clear stack
	pop	cx
	pop	cx
	mov	bl,cs:req	;since AX may have value, get old AL val in BL
	cmp	bl,0		;is this a #0 request?
	 jne	tns20		;no, check next possible request with output
	pop	cx		;yes, clear old DX value off stack
	pop	si		;restore old SI and DS register values
	pop	ds
	jmp	tns90		;continue on
tns20:	cmp	bl,5		;is this a #5 request?
	 jne	tns40		;no, check next possible output
	mov	ds,dx		;yes, get DS:SI address out of DX & AX
	mov	si,ax
	pop	dx		;restore DX to old value
	pop	cx		;clear old DS & SI values off stack
	pop	cx
	jmp	tns90		;continue on
tns40:	cmp	bl,8		;is this a #8 request?
	 jne	tns60		;no, restore all registers
	xor	cx,cx		;zero CX
	or	ax,dx		;assures that both AX and DX are/aren't zero
	cmp	ax,0		;did function say it could swap out now
	 jne	tns44		;no, set carry
	clc			;yes, clear carry flag
	jmp tns46		;continue on
tns44:	stc			;set carry flag
tns46:	pop	dx		;restore old DX,DS, & DI values
	pop	si
	pop	ds
	pop	bx		;clear old CX value off stack
	jmp	tns95		;special continue on after CX clear
tns60:	pop	dx		;At this point there are no values to ret...
	pop	si		;... so restore DX, SI & DS to old values
	pop	ds
tns90:	pop	cx		;restore the rest of the registers
tns95:	pop	bx
	pop	di
	pop	es
	ret			;return to calling program
transtat_f	endp

;lnc_stm_f
;desc:	Set the Launcher Menu name
;in:	LNCHPID = Launcher assigned PID
;	DS:SI = menu name to set
;out:	
;ret:	JC = couldn't set it (probably NOT PoC)
;	  cmdblk.lc_err = AX = error code
;type:	
;notes:	The PoC should always set this so other programs can use the same menu
;	file for their "Run" menus.  ONLY the PoC may successfully make this
;	call.
;
lnc_stm_f	proc	near
	mov	cs:cmdblk.lc_func, lc_setm	;set function
	call	lc_strn		;execute function
	ret			;return to calling program
lnc_stm_f	endp
;lnc_stp_f
;desc:	Set the Launcher Program of Choice description
;in:	LNCHPID = Launcher assigned PID
;	DS:SI = Program of Choice (PoC) description to set
;out:	
;ret:	JC = couldn't set it (probably NOT PoC)
;	  cmdblk.lc_err = AX = error code
;type:	
;notes:	This routine should be called ONLY by the PoC.  Others will always get
;	an error.  This is the string that will be displayed on the "Run"
;	menus displayed by Launcher aware programs.
;
lnc_stp_f	proc	near
	mov	cs:cmdblk.lc_func, lc_setp	;set function
	call	lc_strn		;execute function
	ret			;return to calling program
lnc_stp_f	endp
;execlc
;desc:	EXEC LC
;in:	BX=number of paragraphs for size of PSP, temp stack, and this routine
;	ES -> PSP
;out:	
;ret:	
;type:	
;notes:	This function is never used "as is" in this point in the code.  It is
;	copied from this point to a point just after a new, reconstructed,
;	command line.  This new command line is just above the original PSP
;	of the starting program.  LNC_EXC copies this routine to its new
;	position, then sets up its registers for the correct input values.
;	Then it sets up its stack & address registers so that the last "ret"
;	command will jump to the start of this routine (in this routine's new
;	position).
;
execlc	proc	near
	mov	ah, 4Ah		;shrink down to smallest possible
	int	21h
	mov	ax, 4B00h	;load and execute program at new command line	
	mov	bx, 6Ch		;ES:BX = pblock, DX = program name
	int	21h
	mov	ax, 4C00h	;exit upon return
	int	21h
	ret			;never really used
execlc	endp

codemov	equ $-execlc		;size of EXECLC, for copying code to new pos
;chkdl
;desc:	Check for /DL Disable Launcher switch on command line
;in:	
;out:	
;ret:	JC = found, do not run launcher
;type:	
;notes:	
;
chkdl	proc	near
	push	ax		;save registers
	push	bx
	push	cx
	push	es
	mov	es, mypsp	;ES:DI = command line
	mov	di, 81h
	xor	cx, cx		;zero CX
	mov	cl, es:[80h]	;get length of command line
	mov	al, "/"
ckdl30:	repne	scasb		;scan for any switches
	clc			;if no switches, clear carry flag...
	 jcxz	ckdl90		;... and continue on
	mov	bx, es:[di]	;if switch found, get next two bytes
	and	bx, 0DFDFh	;force to upper case
	cmp	bx, "LD"	;is it /DL?
	 jne	ckdl30		;continue cmdline scan until end or next swtch
	stc			;if "/DL" found, return carry set
ckdl90:	pop	es		;restore registers
	pop	cx
	pop	bx
	pop	ax
	ret			;return to calling program
chkdl	endp
;chkcom
;desc:	Find Program.EXE and search for Program.COM
;in:	
;out:	
;ret:	
;type:	
;notes:	
;
chkcom	proc	near
	push	ds		;save current DS
	mov	ds, mypsp	;move PSP into DS
	mov	ds, ds:[2Ch]	;get environment segment
assume	ds:nothing
	xor	si,si		;zero SI (move to start of Environment area)
ckcm20:	lodsb			;start scan for end of env vars, DS:SI into AL
	or	al, al		;is it a null
	 jnz	ckcm20		;no, continue scan
	cmp	byte ptr [si], 0	;yes, is it followed by a 2nd null?
	 jne	ckcm20		;no, continue scan
	add	si, 3		;yes (end env vars), point at executed string
	mov	di, si		;save pointer to start of command line
ckcm25:	lodsb			;find end of the program name string, DS:SI-AL
	or	al, al		;is AL zero?
	 jnz	ckcm25		;no, continue scan
	sub	si, 4		;Y, mov bak 4 to ext (to dot [.] aft nam)
	mov	cx, si		;save end of name pos
ckcm27:	dec	si		;move back one character (scan for start o nam)
	cmp	si, di		;is start & end of pgm name the same?
	 je	ckcm30		;  yes
	cmp	byte ptr [si-1], '\'	;start of pgm name & end of path?
	 je	ckcm30		;  yes
	cmp	byte ptr [si-1], ':'	;start of name, no path, end of vol?
	 jne	ckcm27		;  no, back up one and try again
ckcm30:	pop	es		;restore ES (ES=CS)
	push	es		;setup for ES value transfer
	sub	cx, si		;compute length of name w/out extention
	mov	di, offset cmdblk	;DI -> structure
	rep	movsb		;mov DS:SI (env pgm name) to ES:DI (structure)
	pop	ds		;DS=ES
	mov	word ptr [di], "OC"	;copy "CO" to end of pgm name in strct
	mov	word ptr [di+2], "M"	;copy "M",0 to end of "CO" (for "COM")
	mov	si, offset cmdblk	;DS:SI -> launcher structure
	call	fndlnc_f		;let C see if it is correct or change
	ret			;if C not like or find lancher nam, stc & ret
chkcom	endp			;to calling program

	end
