/*
name	LCDEF.H
title	Launcher specific equates & defines

  Copyright (C) 1992 WordPerfect Corp., All Rights Reserved
------------------------------------------------------------*/

/************************************************************************
 * This header contains useful and necessary defines for C programs to  *
 * use the LNCLIB.OBJ library.  The contents of this file are listed    *
 * below in the order they appear in the file.                          *
 *                                                                      *
 * CONTENTS                                                             *
 *    TypeDefs to WP Corp. Standard Names                               *
 *    Reserved UMID's                                                   *
 *    Clipboard Formats                                                 *
 *    RG_FLAG bit values (from LNC_REG)                                 *
 *    STATE Function Requests                                           *
 *    Defines used by required function FNDLNC                          *
 *    Currently Active Programs entry structure                         *
 *    Defines used by "cap_ent" structure                               *
 *    Flags set in LNC_NHKY Function                                    *
 *    Error returns from Launcher                                       *
 *    Available Swapping Recorses Flags                                 *
 *    Where Current Program will be Swapped to Flags                    *
 *    Possible Status for Closing Pgms on Force Launcher Exit (used by  *
 *    XALL & XCHK)                                                      *
 *    Direct I/O Function Toggles                                       *
 *    Enable/Disable Switches for Toggle Functions                      *
 *    Flag Definition for ScreenFlag Parameter of StateFunc             *
 *    All possible program load flags used by SETLOAD                   *
 *    Codes for all possible Standard Hot Keys                          *
 *    Codes for all possible Alternate Hot Keys                         *
 *    Union used by Optional State Function below                       *
 *    Prototype of Optional State Function & Far Pointer to Function    *
 *    Prototypes for launcher 'C' interface (LNCLIB.OBJ)                *
 *    Prototypes of the 2 Functions you are required to provide         *
 ************************************************************************/

/***   TypeDefs to WP Corp. Standard Names   ***/
typedef unsigned char	ubyte;
typedef unsigned short	uword;
typedef unsigned long	udword;

/***	Reserved UMID's   ***/
#define	INVumid	0		// Invalid - flag External Drivers to Exit
#define	PoCumid	1		// Program of Choice
#define	SCSumid	2		// Screen Saver
#define	CLPumid	3		// Clipboard
#define	DOSumid	4		// Macros
#define	Opnumid	5		// First Open reserved UMID
#define	Maxumid	20		// Last reserved UMID
// 5 .. 20		// reserved for future use

// ***	Clipboard Formats
#define	cf_NATV	1		// Machine Native format - usually ASCII
#define	cf_BNRY	2		// Binary (universal) format - no conversion
#define	cf_WP42	3		// WordPerfect 4.2 format text
#define	cf_WP5X	4		// WordPerfect 5.X format - file w/prefix
#define	cf_WP60	5		// WordPerfect 6.0 format - file w/prefix
#define	cf_last	cf_WP60	// Always equal to the last defined clipboard format
		// These two are internal use only - can be changed
#define	cf_mac	(cf_last+1)	// Shell Macro format - Internal only
#define	cf_kyst	(cf_last+2)	// 3 byte BIOS Keystroke format - Internal only

// ***	RG_FLAG bit values (from LNC_REG)
#define	rg_scs	1		// set if ELD Screen swapper available
#define	rg_clp	2		// set if ELD clipboard available
#define	rg_3rd	4		// set if ELD Screen Blanker available
#define	rg_mac	8		// set if Advanced Macro Engine available
#define	rg_hid	0x10		// set if File ID was generated with a HASH
#define	rg_res	0x8000		// set if program is supposed to start resident

// ***	STATE Function Requests
#define	gs_stat	0		// request for program state
#define	gs_mnrm	1 		// macro termination status (normal)
#define	gs_mcan	2		// macro termination status (cancel)
#define	gs_merr	3		// macro termination status (error)
#define	gs_mntf	4		// macro termination status (not found)
#define	gs_sysv	5		// evaluate a SYSTEM variable
#define	gs_don	6		// turn display ON
#define	gs_doff	7		// turn display OFF
#define	gs_swot	8		// Notify program swapping out
#define	gs_swin	9		// Notify program swapping back in

// Defines used by required function FNDLNC
#define	LNCNotFOUND	1	// function could not find Launcher
#define	LNCFOUND	0	// function found Launcher

// Currently Active Programs entry structure
struct	cap_ent {
	uword	ce_umid;
	uword	ce_size;
	uword	ce_swap;
	};

// Defines used by "cap_ent" structure
#define	ce_emm	lt_emm		// program swapped to Expanded Memory
#define	ce_xms	lt_xms		// program swapped to eXtended Memory
#define	ce_dsk	lt_dsk		// program swapped to Disk

// Flags set in LNC_NHKY Function
#define	ei_nsc	1			// Flag to NOT modify screen before swapping
#define	ei_sc	0			// Flag to modify screen before swapping

// ***	Error returns from Launcher
#define	lce_invalid_PID	-1		// Invalid PID - not in range
#define	lce_invalid_CMD	-2		// Invalid command - unsupported
#define	lce_too_many	-3		// too many programs have registered
#define	lce_menu	-4		// THE menu has NOT been set yet
#define	lce_NOT_PoC	-5		// program requesting is NOT PoC
#define	lce_no_exit	-6		// can't exit, child programs resident
#define	lce_file	-7		// File IO Error
#define	lce_macro_exe	-8		// Macro execution is/not already going
#define	lce_invalid_UMID -9		// invalid UMID specified
#define	lce_no_clip	-10		// Clipboard ELD not loaded
#define	lce_macro_def	-11		// Macro definition was/not on
#define	lce_noswap_left	-12		// No swap area left (XMS/EMS/DSK gone)
#define	lce_bad_clp_fmt	-13		// Invalid Format conversion request

// Available Swapping Recorses Flags
#define EMM_AVAL	0x100		// EMM Memroy available
#define XMS_AVAL	0x200		// EXS Memory available
#define DSK_AVAL	0x400		// Disk Space available

// Where Current Program will be Swapped to Flags
#define GO_EMM		0x1			// Will go to EMM memory
#define GO_XMS		0x2			// Will go to XMS memory
#define GO_DSK		0x4			// Will go to Disk space

// Possible Status for Closing Pgms on Force Launcher Exit (used by XALL & XCHK)
#define XA_OFF		0			// Not exiting any more
#define XA_NOSV		1			// Exit without saving
#define XA_SAVE		2			// Save changes and exit

// Direct I/O Function Toggles
#define DIO_OFF		0			// Direct IO is off
#define DIO_ON		1			// Direct IO forced on

// Enable/Disable Switches for Toggle Functions
#define ENABLE		0
#define DISABLE		1

// Flag Definition for ScreenFlag Parameter of StateFunc
#define HOLDSCREEN	0x4000
// Other flags should be disregarded

// All possible program load flags used by SETLOAD
#define	LOAD_PRV	0x40		// this is a private invocation
//setting LOAD_PRV is the same as calling LNC_PRV
#define	LOAD_XCL	0x80		// exclusive incovation - only valid w/ private
//(LOAD_PRV | LOAD_XCL) is the same as calling LNC_XCL
#define	LOAD_RES	0x200		// Start this program resident
#define	LOAD_DIS	0x400		// DISALLOW preemptive swapping
#define	LOAD_PAS	0x800		// PAUSE after program termination
#define	LOAD_BAT	0x2000		// Running a batch file (Batch file needs to be deleted)

// Codes for all possible Standard Hot Keys
#define   S_0  0x8100
#define   S_1  0x7800
#define   S_2  0x7900
#define   S_3  0x7A00
#define   S_4  0x7B00
#define   S_5  0x7C00
#define   S_6  0x7D00
#define   S_7  0x7E00
#define   S_8  0x7F00
#define   S_9  0x8000
#define   S_A  0x1E00
#define   S_B  0x3000
#define   S_C  0x2E00
#define   S_D  0x2000
#define   S_E  0x1200
#define   S_F  0x2100
#define   S_G  0x2200
#define   S_H  0x2300
#define   S_I  0x1700
#define   S_J  0x2400
#define   S_K  0x2500
#define   S_L  0x2600
#define   S_M  0x4200
#define   S_N  0x4100
#define   S_O  0x1800
#define   S_P  0x1900
#define   S_Q  0x1000
#define   S_R  0x1300
#define   S_S  0x1F00
#define   S_T  0x1400
#define   S_U  0x1600
#define   S_V  0x3F00
#define   S_W  0x1100
#define   S_X  0x2D00
#define   S_Y  0x1500
#define   S_Z  0x2C00
#define   S_F1 0x6800
#define   S_F2 0x6900
#define   S_F3 0x6A00
#define   S_F4 0x6B00
#define   S_F5 0x6C00
#define   S_F6 0x6D00
#define   S_F7 0x6E00
#define   S_F8 0x6F00
#define   S_F9 0x7000
#define   S_F10     0x7100
#define   S_F11     0x8B00
#define   S_F12     0x8C00

// Codes for all possible Alternate Hot Keys
#define   A_0  0xB30
#define   A_1  0x231
#define   A_2  0x332
#define   A_3  0x433
#define   A_4  0x534
#define   A_5  0x635
#define   A_6  0x736
#define   A_7  0x837
#define   A_8  0x938
#define   A_9  0xA39
#define   A_A  0x1E41
#define   A_B  0x3042
#define   A_C  0x2E43
#define   A_D  0x2044
#define   A_E  0x1245
#define   A_F  0x2146
#define   A_G  0x2247
#define   A_H  0x2348
#define   A_I  0x1749
#define   A_J  0x244A
#define   A_K  0x254B
#define   A_L  0x264C
#define   A_M  0x424D
#define   A_N  0x414E
#define   A_O  0x184F
#define   A_P  0x1950
#define   A_Q  0x1051
#define   A_R  0x1352
#define   A_S  0x1F53
#define   A_T  0x1454
#define   A_U  0x1655
#define   A_V  0x3F56
#define   A_W  0x1157
#define   A_X  0x2D58
#define   A_Y  0x1559
#define   A_Z  0x2C5A
#define   A_F1 0x3B00
#define   A_F2 0x3C00
#define   A_F3 0x3D00
#define   A_F4 0x3E00
#define   A_F5 0x3F00
#define   A_F6 0x4000
#define   A_F7 0x4100
#define   A_F8 0x4200
#define   A_F9 0x4300
#define   A_F10     0x4400
#define   A_F11     0x8500
#define   A_F12     0x8600

// Union used by Optional State Function below
union StateUnion
{
	unsigned long Long0;			//used by Req 0 (Get State Flags)
	char far *FarPtr5;				//used by Req 5 (System Var. Request)
	unsigned int Array8;			//used by Req 8 (Swap Out)
}StateType;

// Prototype of Optional State Function & Far Pointer to Function
union StateUnion far StateFunc (int Req,
							union StateUnion StateType);
union StateUnion (far *StateFuncPtr)();

// Prototypes for launcher 'C' interface (LNCLIB.OBJ)
extern	int	far LNC_REG(unsigned int far *lnchflg,
						union StateUnion (far * func)());	// register program with launcher
extern	int	far LNC_STM(char far * menu);			// set Launcher menu
extern	int	far LNC_GTM(char far * menu);			// get Launcher menu
extern	int	far LNC_STP(char far * desc);			// set PoC description
extern	int	far LNC_GTP(char far * desc);			// get PoC description
extern	int	far LNC_CHK(int	far * NetType,
						char far * Initials,
						char far * NetID);			// check to see if launcher is loaded
extern	void	far LNC_EXC(char far * ENV);		// load launcher
extern	void	far LNC_PRV(char far * path,
						char far * cmdln,
						char far * defltdir,
						unsigned int UMID,
						unsigned int hotkey,
						int macroflg);				// load/swap private program
extern	void	far LNC_XCL(char far * path,        
						char far * cmdln,
						char far * defltdir,
						unsigned int UMID,
						unsigned int hotkey,
						int macroflg);				// load/swap exclusive program
extern	void	far LNC_SLD(char far * path,
						char far * cmdln,
						char far * defltdir,
						unsigned int UMID,
						unsigned int hotkey,
						int macroflg);				// load/swap a program
extern	void	far LNC_SLF(char far * path,
						char far * cmdln,
						char far * defltdir,
						unsigned int UMID,
						unsigned int hotkey,
						int macroflg);				// load/swap a program
extern	void	far LNC_DIO(int mode);				// direct IO mode
extern	void	far LNC_HKS(int mode);				// hot key swapping
extern	void	far LNC_HKU(int mode);				// hot key swapping (users prog)
extern	int	far LNC_CAP(int far * proglist,int far * progcnt);	// currently active programs
extern	int	far LNC_ELD(int far * proglist,int far * progcnt);	// currently active ELD programs
extern	int	far LNC_LST(void);						// last active program
extern	int	far LNC_MEX(char far * macro);			// macro execute
extern	int	far LNC_MDF(char far * macro,
					char far * desc,
					int descsize);					// begin macro record
extern	int	far LNC_MDS(int remkey);				// end macro record
extern	int	far LNC_CRD(int format,
						char far *clipfnm);			// clipboard read
extern	int	far LNC_CPD(int format,
						char far *clipfnm);			// clipboard append
extern	int	far LNC_CWR(int format,
						char far *clipfnm);			// clipboard write
extern	void	far LNC_CSN(char far *number,
							char far *clipfnm);		// set new clipboard number
extern	void	far LNC_CRN(char far *number,
						char far *clipfnm);			// get clipboard number
extern	int	far LNC_CFM(char far *clipfnm);			// get clipboard format
extern	int	far LNC_RQX(void);						// request permission to exit
extern	int	far	LNC_SWC(void);						// check where next swapped pgm will go
extern	void	far	LNC_XALL(int ExitStat);			// Close all Lnchr pgms before exit
extern	void	far	LNC_KALT(int Toggle);			// Toggle ALT key swapping on/off
extern	void	far	LNC_KSTF(int KeyCnt,
							char far *Keys); 		// Stuff 1-2 keys to LNCHR
extern	void far LNC_PATH(char far *lcpath);		// Get Launcher's env path string
extern	unsigned int far LNC_NPID(void);			// Get the NEXT PID number to be assigned 
extern	int	far	LNC_NHKY (unsigned int UMID,
						unsigned int NewHotKey,
						unsigned int NHKYFlags); 	// Change program's hot key
extern	unsigned int far LNC_XCHK (void);			// Exit flag check.

extern	int	far SETMACS (char far *EOLMac,
							char far *GoSMac,
							char far *RtSMac,
							char far *MacPath);		// used with SLF/SLD/PRV/XCL for setup of auto macors
extern	void far SETLOAD (unsigned int LoadFlag);	// used with LNC_SLF for custom loads

// Prototypes of the 2 Functions you are required to provide
void	far LNCLEAN (void);							// do final clean for reload
int		far FNDLNC (char far *lcpath);				// find launcher
