<?xml version="1.0"?>

<xsl:stylesheet 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- Make sure we get HTML -->
<xsl:output method="html" encoding="latin1" version="4"/>

<xsl:template match="/">
<!-- select all text -->
<html>
<head>
<title>
	<xsl:value-of select="//teiHeader/fileDesc/titleStmt/author"/> 
	<xsl:text>: </xsl:text>
	<xsl:value-of select="//teiHeader/fileDesc/titleStmt/title"/>
</title>
<link type="text/css" rel="Stylesheet" href="pg.css"/>
</head>
<body>
	<xsl:apply-templates select="//text"/>
</body>
</html>	
</xsl:template>

<xsl:template match="//p">
<p><xsl:apply-templates/></p>
<xsl:if test="note[@place='foot']">
    <ol class="footnotes">
    <xsl:for-each select="note[@place='foot']">
        <li><xsl:copy><xsl:apply-templates/></xsl:copy></li>
    </xsl:for-each>
    </ol>
</xsl:if>
</xsl:template>

<xsl:template match="//p/note[@place='foot']">
<xsl:text>[*]</xsl:text>
</xsl:template>

<xsl:template match="//front|//back">
<pre><xsl:apply-templates/></pre>
</xsl:template>

<xsl:template match="//list">
<ul><xsl:apply-templates/></ul>
</xsl:template>

<xsl:template match="//item">
<li><xsl:apply-templates/></li>
</xsl:template>

<xsl:template match="//div0/head">
<h1><xsl:apply-templates/></h1>
</xsl:template>

<xsl:template match="//div1/head">
<h2><xsl:apply-templates/></h2>
</xsl:template>

<xsl:template match="//div2/head">
<h3><xsl:apply-templates/></h3>
</xsl:template>

<xsl:template match="//div3/head">
<h4><xsl:apply-templates/></h4>
</xsl:template>

<xsl:template match="//div4/head">
<h5><xsl:apply-templates/></h5>
</xsl:template>

<xsl:template match="//div5/head">
<h6><xsl:apply-templates/></h6>
</xsl:template>

<xsl:template match="//div6/head">
<h6><xsl:apply-templates/></h6>
</xsl:template>

<xsl:template match="//div7/head">
<h6><xsl:apply-templates/></h6>
</xsl:template>

<xsl:template match="//figure">
<img src="{@entity}" alt=""><xsl:apply-templates/></img>
</xsl:template>

<xsl:template match="//*[@rend='italic']">
<i><xsl:apply-templates/></i>
</xsl:template>

<xsl:template match="//*[@rend='bold']">
<b><xsl:apply-templates/></b>
</xsl:template>

<!-- other rend values: smaller, center, right, left, pre -->

<xsl:template match="//*[@rend='pre']">
<pre><xsl:copy><xsl:apply-templates/></xsl:copy></pre>
</xsl:template>

<xsl:template match="//table">
<table border="1" cellspacing="0" cellpadding="2" summary=""><xsl:apply-templates/></table>
</xsl:template>

<xsl:template match="//row">
<tr><xsl:apply-templates/></tr>
</xsl:template>

<xsl:template match="//cell[@rend='left']|//cell[@rend='center']|//cell[@rend='right']">
<td align="{@rend}"><xsl:apply-templates/></td>
</xsl:template>

<xsl:template match="//cell">
<td><xsl:apply-templates/></td>
</xsl:template>

</xsl:stylesheet>
