/* Copyright (c) 2017, The Linux Foundation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifndef _CAM_HW_CDM170_REG_H_
#define _CAM_HW_CDM170_REG_H_

#define CAM_CDM_REG_OFFSET_FIRST 0x0
#define CAM_CDM_REG_OFFSET_LAST 0x200
#define CAM_CDM_REGS_COUNT 0x30
#define CAM_CDM_HWFIFO_SIZE 0x40

#define CAM_CDM_OFFSET_HW_VERSION 0x0
#define CAM_CDM_OFFSET_TITAN_VERSION 0x4
#define CAM_CDM_OFFSET_RST_CMD 0x10
#define CAM_CDM_OFFSET_CGC_CFG 0x14
#define CAM_CDM_OFFSET_CORE_CFG 0x18
#define CAM_CDM_OFFSET_CORE_EN 0x1c
#define CAM_CDM_OFFSET_FE_CFG 0x20
#define CAM_CDM_OFFSET_IRQ_MASK 0x30
#define CAM_CDM_OFFSET_IRQ_CLEAR 0x34
#define CAM_CDM_OFFSET_IRQ_CLEAR_CMD 0x38
#define CAM_CDM_OFFSET_IRQ_SET 0x3c
#define CAM_CDM_OFFSET_IRQ_SET_CMD 0x40

#define CAM_CDM_OFFSET_IRQ_STATUS 0x44
#define CAM_CDM_IRQ_STATUS_INFO_RST_DONE_MASK 0x1
#define CAM_CDM_IRQ_STATUS_INFO_INLINE_IRQ_MASK 0x2
#define CAM_CDM_IRQ_STATUS_INFO_BL_DONE_MASK 0x4
#define CAM_CDM_IRQ_STATUS_ERROR_INV_CMD_MASK 0x10000
#define CAM_CDM_IRQ_STATUS_ERROR_OVER_FLOW_MASK 0x20000
#define CAM_CDM_IRQ_STATUS_ERROR_AHB_BUS_MASK 0x40000

#define CAM_CDM_OFFSET_BL_FIFO_BASE_REG 0x50
#define CAM_CDM_OFFSET_BL_FIFO_LEN_REG 0x54
#define CAM_CDM_OFFSET_BL_FIFO_STORE_REG 0x58
#define CAM_CDM_OFFSET_BL_FIFO_CFG 0x5c
#define CAM_CDM_OFFSET_BL_FIFO_RB 0x60
#define CAM_CDM_OFFSET_BL_FIFO_BASE_RB 0x64
#define CAM_CDM_OFFSET_BL_FIFO_LEN_RB 0x68
#define CAM_CDM_OFFSET_BL_FIFO_PENDING_REQ_RB 0x6c
#define CAM_CDM_OFFSET_IRQ_USR_DATA 0x80
#define CAM_CDM_OFFSET_WAIT_STATUS 0x84
#define CAM_CDM_OFFSET_SCRATCH_0_REG 0x90
#define CAM_CDM_OFFSET_SCRATCH_1_REG 0x94
#define CAM_CDM_OFFSET_SCRATCH_2_REG 0x98
#define CAM_CDM_OFFSET_SCRATCH_3_REG 0x9c
#define CAM_CDM_OFFSET_SCRATCH_4_REG 0xa0
#define CAM_CDM_OFFSET_SCRATCH_5_REG 0xa4
#define CAM_CDM_OFFSET_SCRATCH_6_REG 0xa8
#define CAM_CDM_OFFSET_SCRATCH_7_REG 0xac
#define CAM_CDM_OFFSET_LAST_AHB_ADDR 0xd0
#define CAM_CDM_OFFSET_LAST_AHB_DATA 0xd4
#define CAM_CDM_OFFSET_CORE_DBUG 0xd8
#define CAM_CDM_OFFSET_LAST_AHB_ERR_ADDR 0xe0
#define CAM_CDM_OFFSET_LAST_AHB_ERR_DATA 0xe4
#define CAM_CDM_OFFSET_CURRENT_BL_BASE 0xe8
#define CAM_CDM_OFFSET_CURRENT_BL_LEN 0xec
#define CAM_CDM_OFFSET_CURRENT_USED_AHB_BASE 0xf0
#define CAM_CDM_OFFSET_DEBUG_STATUS 0xf4
#define CAM_CDM_OFFSET_BUS_MISR_CFG_0 0x100
#define CAM_CDM_OFFSET_BUS_MISR_CFG_1 0x104
#define CAM_CDM_OFFSET_BUS_MISR_RD_VAL 0x108
#define CAM_CDM_OFFSET_PERF_MON_CTRL 0x110
#define CAM_CDM_OFFSET_PERF_MON_0 0x114
#define CAM_CDM_OFFSET_PERF_MON_1 0x118
#define CAM_CDM_OFFSET_PERF_MON_2 0x11c
#define CAM_CDM_OFFSET_SPARE 0x200

/*
 * Always make sure below register offsets are aligned with
 * enum cam_cdm_regs offsets
 */
struct cam_cdm_reg_offset cam170_cpas_cdm_register_offsets[] = {
	{ CAM_CDM_OFFSET_HW_VERSION, CAM_REG_ATTR_READ },
	{ CAM_CDM_OFFSET_TITAN_VERSION, CAM_REG_ATTR_READ },
	{ CAM_CDM_OFFSET_RST_CMD, CAM_REG_ATTR_WRITE },
	{ CAM_CDM_OFFSET_CGC_CFG, CAM_REG_ATTR_READ_WRITE },
	{ CAM_CDM_OFFSET_CORE_CFG, CAM_REG_ATTR_READ_WRITE },
	{ CAM_CDM_OFFSET_CORE_EN, CAM_REG_ATTR_READ_WRITE },
	{ CAM_CDM_OFFSET_FE_CFG, CAM_REG_ATTR_READ_WRITE },
	{ CAM_CDM_OFFSET_IRQ_MASK, CAM_REG_ATTR_READ_WRITE },
	{ CAM_CDM_OFFSET_IRQ_CLEAR, CAM_REG_ATTR_READ_WRITE },
	{ CAM_CDM_OFFSET_IRQ_CLEAR_CMD, CAM_REG_ATTR_WRITE },
	{ CAM_CDM_OFFSET_IRQ_SET, CAM_REG_ATTR_READ_WRITE },
	{ CAM_CDM_OFFSET_IRQ_SET_CMD, CAM_REG_ATTR_WRITE },
	{ CAM_CDM_OFFSET_IRQ_STATUS, CAM_REG_ATTR_READ },
	{ CAM_CDM_OFFSET_IRQ_USR_DATA, CAM_REG_ATTR_READ_WRITE },
	{ CAM_CDM_OFFSET_BL_FIFO_BASE_REG, CAM_REG_ATTR_READ_WRITE },
	{ CAM_CDM_OFFSET_BL_FIFO_LEN_REG, CAM_REG_ATTR_READ_WRITE },
	{ CAM_CDM_OFFSET_BL_FIFO_STORE_REG, CAM_REG_ATTR_WRITE },
	{ CAM_CDM_OFFSET_BL_FIFO_CFG, CAM_REG_ATTR_READ_WRITE },
	{ CAM_CDM_OFFSET_BL_FIFO_RB, CAM_REG_ATTR_READ_WRITE },
	{ CAM_CDM_OFFSET_BL_FIFO_BASE_RB, CAM_REG_ATTR_READ },
	{ CAM_CDM_OFFSET_BL_FIFO_LEN_RB, CAM_REG_ATTR_READ },
	{ CAM_CDM_OFFSET_BL_FIFO_PENDING_REQ_RB, CAM_REG_ATTR_READ },
	{ CAM_CDM_OFFSET_WAIT_STATUS, CAM_REG_ATTR_READ },
	{ CAM_CDM_OFFSET_SCRATCH_0_REG, CAM_REG_ATTR_READ_WRITE },
	{ CAM_CDM_OFFSET_SCRATCH_1_REG, CAM_REG_ATTR_READ_WRITE },
	{ CAM_CDM_OFFSET_SCRATCH_2_REG, CAM_REG_ATTR_READ_WRITE },
	{ CAM_CDM_OFFSET_SCRATCH_3_REG, CAM_REG_ATTR_READ_WRITE },
	{ CAM_CDM_OFFSET_SCRATCH_4_REG, CAM_REG_ATTR_READ_WRITE },
	{ CAM_CDM_OFFSET_SCRATCH_5_REG, CAM_REG_ATTR_READ_WRITE },
	{ CAM_CDM_OFFSET_SCRATCH_6_REG, CAM_REG_ATTR_READ_WRITE },
	{ CAM_CDM_OFFSET_SCRATCH_7_REG, CAM_REG_ATTR_READ_WRITE },
	{ CAM_CDM_OFFSET_LAST_AHB_ADDR, CAM_REG_ATTR_READ },
	{ CAM_CDM_OFFSET_LAST_AHB_DATA, CAM_REG_ATTR_READ },
	{ CAM_CDM_OFFSET_CORE_DBUG, CAM_REG_ATTR_READ_WRITE },
	{ CAM_CDM_OFFSET_LAST_AHB_ERR_ADDR, CAM_REG_ATTR_READ },
	{ CAM_CDM_OFFSET_LAST_AHB_ERR_DATA, CAM_REG_ATTR_READ },
	{ CAM_CDM_OFFSET_CURRENT_BL_BASE, CAM_REG_ATTR_READ },
	{ CAM_CDM_OFFSET_CURRENT_BL_LEN, CAM_REG_ATTR_READ },
	{ CAM_CDM_OFFSET_CURRENT_USED_AHB_BASE, CAM_REG_ATTR_READ },
	{ CAM_CDM_OFFSET_DEBUG_STATUS, CAM_REG_ATTR_READ },
	{ CAM_CDM_OFFSET_BUS_MISR_CFG_0, CAM_REG_ATTR_READ_WRITE },
	{ CAM_CDM_OFFSET_BUS_MISR_CFG_1, CAM_REG_ATTR_READ_WRITE },
	{ CAM_CDM_OFFSET_BUS_MISR_RD_VAL, CAM_REG_ATTR_READ },
	{ CAM_CDM_OFFSET_PERF_MON_CTRL, CAM_REG_ATTR_READ_WRITE },
	{ CAM_CDM_OFFSET_PERF_MON_0, CAM_REG_ATTR_READ },
	{ CAM_CDM_OFFSET_PERF_MON_1, CAM_REG_ATTR_READ },
	{ CAM_CDM_OFFSET_PERF_MON_2, CAM_REG_ATTR_READ },
	{ CAM_CDM_OFFSET_SPARE, CAM_REG_ATTR_READ_WRITE }
};

struct cam_cdm_reg_offset_table cam170_cpas_cdm_offset_table = {
	.first_offset = 0x0,
	.last_offset = 0x200,
	.reg_count = 0x30,
	.offsets = cam170_cpas_cdm_register_offsets,
	.offset_max_size = (sizeof(cam170_cpas_cdm_register_offsets)/
		sizeof(struct cam_cdm_reg_offset)),
};

#endif /* _CAM_HW_CDM170_REG_H_ */
