/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.interceptors;

import com.amazonaws.services.simpleworkflow.flow.DecisionContextProviderImpl;
import com.amazonaws.services.simpleworkflow.flow.WorkflowClock;
import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.amazonaws.services.simpleworkflow.flow.core.Settable;
import com.amazonaws.services.simpleworkflow.flow.core.TryFinally;
import com.amazonaws.services.simpleworkflow.flow.interceptors.AsyncRunnable;
import com.amazonaws.services.simpleworkflow.flow.interceptors.AsyncScheduledExecutor;
import com.amazonaws.services.simpleworkflow.flow.interceptors.Decorator;
import com.amazonaws.services.simpleworkflow.flow.interceptors.InvocationSchedule;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScheduleDecorator
implements Decorator {
    private final AsyncScheduledExecutor scheduledExecutor;

    public ScheduleDecorator(InvocationSchedule schedule, WorkflowClock clock) {
        this.scheduledExecutor = new AsyncScheduledExecutor(schedule, clock);
    }

    public ScheduleDecorator(InvocationSchedule schedule) {
        this(schedule, new DecisionContextProviderImpl().getDecisionContext().getWorkflowClock());
    }

    @Override
    public final <V> V decorate(Class<V> interfaces, V object) {
        Class[] interfazes = new Class[]{interfaces};
        return (V)Proxy.newProxyInstance(object.getClass().getClassLoader(), interfazes, (InvocationHandler)new DecoratorInvocationHandler(object));
    }

    @Override
    public final <V> V decorate(Class<?>[] interfaces, V object) {
        return (V)Proxy.newProxyInstance(object.getClass().getClassLoader(), interfaces, (InvocationHandler)new DecoratorInvocationHandler(object));
    }

    private boolean isDecorated(Method method, Object[] args) {
        return !method.getDeclaringClass().equals(Object.class);
    }

    private final class DecoratorInvocationHandler
    implements InvocationHandler {
        private final Object object;

        public DecoratorInvocationHandler(Object object) {
            this.object = object;
        }

        public Object invoke(Object proxy, final Method method, final Object[] args) throws Throwable {
            try {
                if (!ScheduleDecorator.this.isDecorated(method, args)) {
                    return method.invoke(this.object, args);
                }
            }
            catch (InvocationTargetException ite) {
                throw ite.getTargetException();
            }
            Class<?> returnType = method.getReturnType();
            boolean isVoidReturnType = Void.TYPE.equals(returnType);
            final Settable result = isVoidReturnType ? null : new Settable();
            new TryFinally(new Promise[0]){
                Object r;

                protected void doTry() throws Throwable {
                    ScheduleDecorator.this.scheduledExecutor.execute(new AsyncRunnable(){

                        public void run() throws Throwable {
                            try {
                                r = method.invoke(DecoratorInvocationHandler.this.object, args);
                            }
                            catch (InvocationTargetException ite) {
                                throw ite.getTargetException();
                            }
                        }
                    });
                }

                protected void doFinally() throws Throwable {
                    if (result != null) {
                        result.set(this.r);
                    }
                }
            };
            return result;
        }
    }
}

