/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow;

import com.amazonaws.services.simpleworkflow.AmazonSimpleWorkflow;
import com.amazonaws.services.simpleworkflow.flow.DataConverter;
import com.amazonaws.services.simpleworkflow.flow.JsonDataConverter;
import com.amazonaws.services.simpleworkflow.flow.StartWorkflowOptions;
import com.amazonaws.services.simpleworkflow.flow.WorkflowClientFactoryExternal;
import com.amazonaws.services.simpleworkflow.flow.generic.GenericWorkflowClientExternal;
import com.amazonaws.services.simpleworkflow.flow.worker.GenericWorkflowClientExternalImpl;
import com.amazonaws.services.simpleworkflow.model.WorkflowExecution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WorkflowClientFactoryExternalBase<T>
implements WorkflowClientFactoryExternal<T> {
    private GenericWorkflowClientExternal genericClient;
    private DataConverter dataConverter = new JsonDataConverter();
    private StartWorkflowOptions startWorkflowOptions = new StartWorkflowOptions();

    public WorkflowClientFactoryExternalBase(AmazonSimpleWorkflow service, String domain) {
        this(new GenericWorkflowClientExternalImpl(service, domain));
    }

    public WorkflowClientFactoryExternalBase() {
        this(null);
    }

    public WorkflowClientFactoryExternalBase(GenericWorkflowClientExternal genericClient) {
        this.genericClient = genericClient;
    }

    @Override
    public GenericWorkflowClientExternal getGenericClient() {
        return this.genericClient;
    }

    public void setGenericClient(GenericWorkflowClientExternal genericClient) {
        this.genericClient = genericClient;
    }

    @Override
    public DataConverter getDataConverter() {
        return this.dataConverter;
    }

    public void setDataConverter(DataConverter dataConverter) {
        this.dataConverter = dataConverter;
    }

    @Override
    public StartWorkflowOptions getStartWorkflowOptions() {
        return this.startWorkflowOptions;
    }

    public void setStartWorkflowOptions(StartWorkflowOptions startWorkflowOptions) {
        this.startWorkflowOptions = startWorkflowOptions;
    }

    @Override
    public T getClient() {
        this.checkGenericClient();
        String workflowId = this.genericClient.generateUniqueId();
        WorkflowExecution workflowExecution = new WorkflowExecution().withWorkflowId(workflowId);
        return this.getClient(workflowExecution, this.startWorkflowOptions, this.dataConverter, this.genericClient);
    }

    @Override
    public T getClient(String workflowId) {
        if (workflowId == null || workflowId.isEmpty()) {
            throw new IllegalArgumentException("workflowId");
        }
        WorkflowExecution workflowExecution = new WorkflowExecution().withWorkflowId(workflowId);
        return this.getClient(workflowExecution, this.startWorkflowOptions, this.dataConverter, this.genericClient);
    }

    @Override
    public T getClient(WorkflowExecution workflowExecution) {
        return this.getClient(workflowExecution, this.startWorkflowOptions, this.dataConverter, this.genericClient);
    }

    @Override
    public T getClient(WorkflowExecution workflowExecution, StartWorkflowOptions options) {
        return this.getClient(workflowExecution, options, this.dataConverter, this.genericClient);
    }

    @Override
    public T getClient(WorkflowExecution workflowExecution, StartWorkflowOptions options, DataConverter dataConverter) {
        return this.getClient(workflowExecution, options, dataConverter, this.genericClient);
    }

    @Override
    public T getClient(WorkflowExecution workflowExecution, StartWorkflowOptions options, DataConverter dataConverter, GenericWorkflowClientExternal genericClient) {
        this.checkGenericClient();
        return this.createClientInstance(workflowExecution, options, dataConverter, genericClient);
    }

    private void checkGenericClient() {
        if (this.genericClient == null) {
            throw new IllegalStateException("The required property genericClient is null. It could be caused by instantiating the factory through the default constructor instead of the one that takes service and domain arguments.");
        }
    }

    protected abstract T createClientInstance(WorkflowExecution var1, StartWorkflowOptions var2, DataConverter var3, GenericWorkflowClientExternal var4);
}

