/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.elasticbeanstalk.model.ConfigurationOptionValueType;
import com.amazonaws.services.elasticbeanstalk.model.OptionRestrictionRegex;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationOptionDescription
implements Serializable {
    private String namespace;
    private String name;
    private String defaultValue;
    private String changeSeverity;
    private Boolean userDefined;
    private String valueType;
    private ListWithAutoConstructFlag<String> valueOptions;
    private Integer minValue;
    private Integer maxValue;
    private Integer maxLength;
    private OptionRestrictionRegex regex;

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public ConfigurationOptionDescription withNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ConfigurationOptionDescription withName(String name) {
        this.name = name;
        return this;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public ConfigurationOptionDescription withDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public String getChangeSeverity() {
        return this.changeSeverity;
    }

    public void setChangeSeverity(String changeSeverity) {
        this.changeSeverity = changeSeverity;
    }

    public ConfigurationOptionDescription withChangeSeverity(String changeSeverity) {
        this.changeSeverity = changeSeverity;
        return this;
    }

    public Boolean isUserDefined() {
        return this.userDefined;
    }

    public void setUserDefined(Boolean userDefined) {
        this.userDefined = userDefined;
    }

    public ConfigurationOptionDescription withUserDefined(Boolean userDefined) {
        this.userDefined = userDefined;
        return this;
    }

    public Boolean getUserDefined() {
        return this.userDefined;
    }

    public String getValueType() {
        return this.valueType;
    }

    public void setValueType(String valueType) {
        this.valueType = valueType;
    }

    public ConfigurationOptionDescription withValueType(String valueType) {
        this.valueType = valueType;
        return this;
    }

    public void setValueType(ConfigurationOptionValueType valueType) {
        this.valueType = valueType.toString();
    }

    public ConfigurationOptionDescription withValueType(ConfigurationOptionValueType valueType) {
        this.valueType = valueType.toString();
        return this;
    }

    public List<String> getValueOptions() {
        if (this.valueOptions == null) {
            this.valueOptions = new ListWithAutoConstructFlag();
            this.valueOptions.setAutoConstruct(true);
        }
        return this.valueOptions;
    }

    public void setValueOptions(Collection<String> valueOptions) {
        if (valueOptions == null) {
            this.valueOptions = null;
            return;
        }
        ListWithAutoConstructFlag valueOptionsCopy = new ListWithAutoConstructFlag(valueOptions.size());
        valueOptionsCopy.addAll(valueOptions);
        this.valueOptions = valueOptionsCopy;
    }

    public ConfigurationOptionDescription withValueOptions(String ... valueOptions) {
        if (this.getValueOptions() == null) {
            this.setValueOptions(new ArrayList<String>(valueOptions.length));
        }
        for (String value : valueOptions) {
            this.getValueOptions().add(value);
        }
        return this;
    }

    public ConfigurationOptionDescription withValueOptions(Collection<String> valueOptions) {
        if (valueOptions == null) {
            this.valueOptions = null;
        } else {
            ListWithAutoConstructFlag valueOptionsCopy = new ListWithAutoConstructFlag(valueOptions.size());
            valueOptionsCopy.addAll(valueOptions);
            this.valueOptions = valueOptionsCopy;
        }
        return this;
    }

    public Integer getMinValue() {
        return this.minValue;
    }

    public void setMinValue(Integer minValue) {
        this.minValue = minValue;
    }

    public ConfigurationOptionDescription withMinValue(Integer minValue) {
        this.minValue = minValue;
        return this;
    }

    public Integer getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(Integer maxValue) {
        this.maxValue = maxValue;
    }

    public ConfigurationOptionDescription withMaxValue(Integer maxValue) {
        this.maxValue = maxValue;
        return this;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    public ConfigurationOptionDescription withMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
        return this;
    }

    public OptionRestrictionRegex getRegex() {
        return this.regex;
    }

    public void setRegex(OptionRestrictionRegex regex) {
        this.regex = regex;
    }

    public ConfigurationOptionDescription withRegex(OptionRestrictionRegex regex) {
        this.regex = regex;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNamespace() != null) {
            sb.append("Namespace: " + this.getNamespace() + ",");
        }
        if (this.getName() != null) {
            sb.append("Name: " + this.getName() + ",");
        }
        if (this.getDefaultValue() != null) {
            sb.append("DefaultValue: " + this.getDefaultValue() + ",");
        }
        if (this.getChangeSeverity() != null) {
            sb.append("ChangeSeverity: " + this.getChangeSeverity() + ",");
        }
        if (this.isUserDefined() != null) {
            sb.append("UserDefined: " + this.isUserDefined() + ",");
        }
        if (this.getValueType() != null) {
            sb.append("ValueType: " + this.getValueType() + ",");
        }
        if (this.getValueOptions() != null) {
            sb.append("ValueOptions: " + this.getValueOptions() + ",");
        }
        if (this.getMinValue() != null) {
            sb.append("MinValue: " + this.getMinValue() + ",");
        }
        if (this.getMaxValue() != null) {
            sb.append("MaxValue: " + this.getMaxValue() + ",");
        }
        if (this.getMaxLength() != null) {
            sb.append("MaxLength: " + this.getMaxLength() + ",");
        }
        if (this.getRegex() != null) {
            sb.append("Regex: " + this.getRegex());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNamespace() == null ? 0 : this.getNamespace().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultValue() == null ? 0 : this.getDefaultValue().hashCode());
        hashCode = 31 * hashCode + (this.getChangeSeverity() == null ? 0 : this.getChangeSeverity().hashCode());
        hashCode = 31 * hashCode + (this.isUserDefined() == null ? 0 : this.isUserDefined().hashCode());
        hashCode = 31 * hashCode + (this.getValueType() == null ? 0 : this.getValueType().hashCode());
        hashCode = 31 * hashCode + (this.getValueOptions() == null ? 0 : this.getValueOptions().hashCode());
        hashCode = 31 * hashCode + (this.getMinValue() == null ? 0 : this.getMinValue().hashCode());
        hashCode = 31 * hashCode + (this.getMaxValue() == null ? 0 : this.getMaxValue().hashCode());
        hashCode = 31 * hashCode + (this.getMaxLength() == null ? 0 : this.getMaxLength().hashCode());
        hashCode = 31 * hashCode + (this.getRegex() == null ? 0 : this.getRegex().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationOptionDescription)) {
            return false;
        }
        ConfigurationOptionDescription other = (ConfigurationOptionDescription)obj;
        if (other.getNamespace() == null ^ this.getNamespace() == null) {
            return false;
        }
        if (other.getNamespace() != null && !other.getNamespace().equals(this.getNamespace())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDefaultValue() == null ^ this.getDefaultValue() == null) {
            return false;
        }
        if (other.getDefaultValue() != null && !other.getDefaultValue().equals(this.getDefaultValue())) {
            return false;
        }
        if (other.getChangeSeverity() == null ^ this.getChangeSeverity() == null) {
            return false;
        }
        if (other.getChangeSeverity() != null && !other.getChangeSeverity().equals(this.getChangeSeverity())) {
            return false;
        }
        if (other.isUserDefined() == null ^ this.isUserDefined() == null) {
            return false;
        }
        if (other.isUserDefined() != null && !other.isUserDefined().equals(this.isUserDefined())) {
            return false;
        }
        if (other.getValueType() == null ^ this.getValueType() == null) {
            return false;
        }
        if (other.getValueType() != null && !other.getValueType().equals(this.getValueType())) {
            return false;
        }
        if (other.getValueOptions() == null ^ this.getValueOptions() == null) {
            return false;
        }
        if (other.getValueOptions() != null && !other.getValueOptions().equals(this.getValueOptions())) {
            return false;
        }
        if (other.getMinValue() == null ^ this.getMinValue() == null) {
            return false;
        }
        if (other.getMinValue() != null && !other.getMinValue().equals(this.getMinValue())) {
            return false;
        }
        if (other.getMaxValue() == null ^ this.getMaxValue() == null) {
            return false;
        }
        if (other.getMaxValue() != null && !other.getMaxValue().equals(this.getMaxValue())) {
            return false;
        }
        if (other.getMaxLength() == null ^ this.getMaxLength() == null) {
            return false;
        }
        if (other.getMaxLength() != null && !other.getMaxLength().equals(this.getMaxLength())) {
            return false;
        }
        if (other.getRegex() == null ^ this.getRegex() == null) {
            return false;
        }
        return other.getRegex() == null || other.getRegex().equals(this.getRegex());
    }
}

