/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudtrail;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.cloudtrail.AWSCloudTrailAsync;
import com.amazonaws.services.cloudtrail.AWSCloudTrailClient;
import com.amazonaws.services.cloudtrail.model.CreateTrailRequest;
import com.amazonaws.services.cloudtrail.model.CreateTrailResult;
import com.amazonaws.services.cloudtrail.model.DeleteTrailRequest;
import com.amazonaws.services.cloudtrail.model.DeleteTrailResult;
import com.amazonaws.services.cloudtrail.model.DescribeTrailsRequest;
import com.amazonaws.services.cloudtrail.model.DescribeTrailsResult;
import com.amazonaws.services.cloudtrail.model.GetTrailStatusRequest;
import com.amazonaws.services.cloudtrail.model.GetTrailStatusResult;
import com.amazonaws.services.cloudtrail.model.StartLoggingRequest;
import com.amazonaws.services.cloudtrail.model.StartLoggingResult;
import com.amazonaws.services.cloudtrail.model.StopLoggingRequest;
import com.amazonaws.services.cloudtrail.model.StopLoggingResult;
import com.amazonaws.services.cloudtrail.model.UpdateTrailRequest;
import com.amazonaws.services.cloudtrail.model.UpdateTrailResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AWSCloudTrailAsyncClient
extends AWSCloudTrailClient
implements AWSCloudTrailAsync {
    private ExecutorService executorService;
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;

    public AWSCloudTrailAsyncClient() {
        this(new DefaultAWSCredentialsProviderChain());
    }

    public AWSCloudTrailAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSCloudTrailAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AWSCloudTrailAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        super(awsCredentials);
        this.executorService = executorService;
    }

    public AWSCloudTrailAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AWSCloudTrailAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AWSCloudTrailAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AWSCloudTrailAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSCloudTrailAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }

    @Override
    public Future<GetTrailStatusResult> getTrailStatusAsync(final GetTrailStatusRequest getTrailStatusRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetTrailStatusResult>(){

            @Override
            public GetTrailStatusResult call() throws Exception {
                return AWSCloudTrailAsyncClient.this.getTrailStatus(getTrailStatusRequest);
            }
        });
    }

    @Override
    public Future<GetTrailStatusResult> getTrailStatusAsync(final GetTrailStatusRequest getTrailStatusRequest, final AsyncHandler<GetTrailStatusRequest, GetTrailStatusResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetTrailStatusResult>(){

            @Override
            public GetTrailStatusResult call() throws Exception {
                GetTrailStatusResult result;
                try {
                    result = AWSCloudTrailAsyncClient.this.getTrailStatus(getTrailStatusRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getTrailStatusRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DeleteTrailResult> deleteTrailAsync(final DeleteTrailRequest deleteTrailRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteTrailResult>(){

            @Override
            public DeleteTrailResult call() throws Exception {
                return AWSCloudTrailAsyncClient.this.deleteTrail(deleteTrailRequest);
            }
        });
    }

    @Override
    public Future<DeleteTrailResult> deleteTrailAsync(final DeleteTrailRequest deleteTrailRequest, final AsyncHandler<DeleteTrailRequest, DeleteTrailResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteTrailResult>(){

            @Override
            public DeleteTrailResult call() throws Exception {
                DeleteTrailResult result;
                try {
                    result = AWSCloudTrailAsyncClient.this.deleteTrail(deleteTrailRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteTrailRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateTrailResult> createTrailAsync(final CreateTrailRequest createTrailRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateTrailResult>(){

            @Override
            public CreateTrailResult call() throws Exception {
                return AWSCloudTrailAsyncClient.this.createTrail(createTrailRequest);
            }
        });
    }

    @Override
    public Future<CreateTrailResult> createTrailAsync(final CreateTrailRequest createTrailRequest, final AsyncHandler<CreateTrailRequest, CreateTrailResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateTrailResult>(){

            @Override
            public CreateTrailResult call() throws Exception {
                CreateTrailResult result;
                try {
                    result = AWSCloudTrailAsyncClient.this.createTrail(createTrailRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createTrailRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<UpdateTrailResult> updateTrailAsync(final UpdateTrailRequest updateTrailRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateTrailResult>(){

            @Override
            public UpdateTrailResult call() throws Exception {
                return AWSCloudTrailAsyncClient.this.updateTrail(updateTrailRequest);
            }
        });
    }

    @Override
    public Future<UpdateTrailResult> updateTrailAsync(final UpdateTrailRequest updateTrailRequest, final AsyncHandler<UpdateTrailRequest, UpdateTrailResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateTrailResult>(){

            @Override
            public UpdateTrailResult call() throws Exception {
                UpdateTrailResult result;
                try {
                    result = AWSCloudTrailAsyncClient.this.updateTrail(updateTrailRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(updateTrailRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeTrailsResult> describeTrailsAsync(final DescribeTrailsRequest describeTrailsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeTrailsResult>(){

            @Override
            public DescribeTrailsResult call() throws Exception {
                return AWSCloudTrailAsyncClient.this.describeTrails(describeTrailsRequest);
            }
        });
    }

    @Override
    public Future<DescribeTrailsResult> describeTrailsAsync(final DescribeTrailsRequest describeTrailsRequest, final AsyncHandler<DescribeTrailsRequest, DescribeTrailsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeTrailsResult>(){

            @Override
            public DescribeTrailsResult call() throws Exception {
                DescribeTrailsResult result;
                try {
                    result = AWSCloudTrailAsyncClient.this.describeTrails(describeTrailsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeTrailsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<StopLoggingResult> stopLoggingAsync(final StopLoggingRequest stopLoggingRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<StopLoggingResult>(){

            @Override
            public StopLoggingResult call() throws Exception {
                return AWSCloudTrailAsyncClient.this.stopLogging(stopLoggingRequest);
            }
        });
    }

    @Override
    public Future<StopLoggingResult> stopLoggingAsync(final StopLoggingRequest stopLoggingRequest, final AsyncHandler<StopLoggingRequest, StopLoggingResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<StopLoggingResult>(){

            @Override
            public StopLoggingResult call() throws Exception {
                StopLoggingResult result;
                try {
                    result = AWSCloudTrailAsyncClient.this.stopLogging(stopLoggingRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(stopLoggingRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<StartLoggingResult> startLoggingAsync(final StartLoggingRequest startLoggingRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<StartLoggingResult>(){

            @Override
            public StartLoggingResult call() throws Exception {
                return AWSCloudTrailAsyncClient.this.startLogging(startLoggingRequest);
            }
        });
    }

    @Override
    public Future<StartLoggingResult> startLoggingAsync(final StartLoggingRequest startLoggingRequest, final AsyncHandler<StartLoggingRequest, StartLoggingResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<StartLoggingResult>(){

            @Override
            public StartLoggingResult call() throws Exception {
                StartLoggingResult result;
                try {
                    result = AWSCloudTrailAsyncClient.this.startLogging(startLoggingRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(startLoggingRequest, result);
                return result;
            }
        });
    }
}

