/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.services.cloudfront.model.StreamingLoggingConfig;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamingLoggingConfigStaxUnmarshaller
implements Unmarshaller<StreamingLoggingConfig, StaxUnmarshallerContext> {
    private static StreamingLoggingConfigStaxUnmarshaller instance;

    @Override
    public StreamingLoggingConfig unmarshall(StaxUnmarshallerContext context) throws Exception {
        StreamingLoggingConfig streamingLoggingConfig = new StreamingLoggingConfig();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return streamingLoggingConfig;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Enabled", targetDepth)) {
                    streamingLoggingConfig.setEnabled(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Bucket", targetDepth)) {
                    streamingLoggingConfig.setBucket(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Prefix", targetDepth)) continue;
                streamingLoggingConfig.setPrefix(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return streamingLoggingConfig;
    }

    public static StreamingLoggingConfigStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new StreamingLoggingConfigStaxUnmarshaller();
        }
        return instance;
    }
}

