
        STITLE  FlagBrow v3.0 Main Code
*****************************************************************
*****************************************************************
**
** Name: FlagBrow Main Code segment.
**
** Category: Display
**
** Abstract: Displays the 64 System flags at startup, NXT changes to
**           User flags, [+/-] toggles flag (indicated by a "tick")
**
** Entry:    xFNT1, FlagTab, Buffer$
**
** Exit:     xFNT1, FlagTab, Buffer$
**
** Error Exits: None
**
** Alters: CPU - Just about everything
**         RAM - SysFlags, UserFlags, ABUFF, Buffer$
**
** Calls:    SAVPTR     : saves RPL registers
**           GETPTRLOOP : restores RPL registers and continues RPL
**           getBPOFF   : sets ST flag 4 if beep
**           RCKBp      : C.B = fd  f= freq ctrl,  d= duration ctrl
**           showbusy   : sets the "busy" annun.
**           clrbusy    : clears the "busy" annun.
**           setannun	:
**           
**           AINRTN     : does A=IN on and even addr to avoid hardware bug
**           POPKEY     : Pops key into C.B
**           Kbd_OR     : CS is a key is down
**           
**           MOVEDOWN   : block copy, D0= src, D1= target, C.A = nibs (size)
**           MOVEUP     : block copy
**           WIPEOUT	: clears C.A nibs starting at D1
**           
**           AllowIntr  : Allows interupts
**           DisableIntr: Disables interupts eg Keyboard
**           
**           D0=DSTK    : D0 = 
**           D0->Row1   : machine independent D0 = first nib of ABUFF
**           
**           GetTimChk  :
**           clrtimeout :
**           chk_timeout:
**
**           
** Stack Levels: .....

** History	: written 5 September 1994 (original)
**
**     Date     Prog             Modification
**   --------   ----   ------------------------------------------
**  6 Sept.94   RHS    commented code
** 27 Sept.94   RHS    added GX only flags & changed flagtable
**  4 Oct. 94   RHS    added user flags, BEEP fix
**  5 Oct. 94   RHS    added key release check on [NXT]
** Version 1.0 now released
**    Dec. 94   RHS    complete rewrite of ALL code except =WriteLp
** Version 2.0 now released
** 20 Jan. 95   RHS    bug fix (beep did not turn RS off)
**                     added keys 0 to 6 for jump to flag
**                     changed OFF to use embedded RPL word =TurnOff
** 20 Feb. 95  RHS     added "help" screen, up'ed version to 3.0
**                     fixed unreported RS + ENTER bug (shift stayed on)
** 24 Feb. 95  RHS     added page 2 of help/info screen for credits/help
** Version 3.0 now released
** 20 Nov. 96  RHS     ALLOC -> mALLOC for gnutools compilation
**                     changed to version 4.0 for UFL
** Version 4.0 now released
**===============================================================

ASSEMBLE
**** Unsupported entry points ************************************************
SystemFlagsSX	EQU	#706C5
UserFlagsSX	EQU	(SystemFlagsSX)+16
SystemFlagsGX	EQU	#80843
UserFlagsGX	EQU	(SystemFlagsGX)+16

TIMERCTRL.1	EQU	#0012E
clrbusy		EQU	#42359
showbusy	EQU	#42333
Kbd_OR		EQU	#00E0B
chk_timeout	EQU	#049DB
setannun	EQU	#01E79
WIPEOUT		EQU	#0675C
lineOne		EQU	4		line offset, page 1, help menu
lineTwo		EQU	0		line offset, page 2, help menu
**TimeOut	EQU	8192*30*1	30 second timeout
TimeOut		EQU	8192*60*10	10 minute timeout
**** Macros ******************************************************************
** Start data allocation
DSECT	MACRO	$label,$pos
curpos	= $2			Init start location
$1	= curpos
DSECT	ENDM
** Allocate slot
mALLOC	MACRO	$label,$size
$1	= curpos
curpos	= (curpos)+($2)
mALLOC	ENDM
**** Buffer Allocation *******************************************************
* Start data area allocation
	DSECT	FlagBdat,0		Start from even page (0-offset)
* Allocate memory for variables:
	mALLOC	FlagTop,2		Flag at top of display
	mALLOC	SysFlagTab,5		Flag description jump table (System)
	mALLOC	UsrFlagTab,5		Flag description jump table (User)
	mALLOC	FNT1,5			Font address
	mALLOC	Row0,5			top of screen
	mALLOC	Row1,5			offsets into hardbuff
	mALLOC	Row2,5
	mALLOC	Row3,5
	mALLOC	Row4,5
	mALLOC	Row5,5
	mALLOC	Row6,5
	mALLOC	Row7,5
	mALLOC	Row8,5
	mALLOC	Row9,5
	mALLOC	Row10,5
	mALLOC	RowEnd,5
	mALLOC	KeyState,5		machine independent KEYSTATE address
	mALLOC	Line,5			temporary storage in ShowScreen
	mALLOC	Flag,5			temporary storage in ShowScreen
	mALLOC	SystemFlags,16		copies of the flags
	mALLOC	UserFlags,16		NOTE: we set and clear THESE ones!

*      IFPOS	(curpos)-#180+#FF	Only #17B needed
      IFPOS	(curpos)-#F1
	MESSAGE	BUFFER$ overflow!
      ENDIF

**** ST Flags ****************************************************************
sFAST		EQU	0		fast mode on ?
sUSER		EQU	1		User flags displayed
sREPEAT		EQU	2		repeat enabled
sDELAY		EQU	3		delay enabled
sBEEP		EQU	4		BEEP on ? (BEEP MUST BE ST=4 !!! )
sGX		EQU	5		GX = set
sOFF		EQU	6		set = OFF pressed (not timeout)


**** REGISTER USAGE **********************************************************
**
** R4 : 0|00000|00000|00000
**      ^ 			current flag highlighted
**                    ^^^^^ 	address of data buffer
** R3 : 000|0000000000000
**	    ^^^^^^^^^^^^^	timeout value
** R2 : 000|00000000|00000
**		     ^^^^^	current flag on the top of the display
** R1 : NOT USED
**      
** R0 : 0|00000|00000|00000
**                    ^^^^^ 	$ @ for Write$ / general purpose

** Stack on Entry:

** STK3 : xFNT1
** STK2 : FlagTab
** STK1 : String buffer in case of a call to =TurnOff


	GOSBVL	=SAVPTR		save registers
	CLRST
	GOSUB	InitBuffer	initialize the address buffer and =sGX
	GOSUBL	InitClk		initialize TimeOut
	GOSBVL	=getBPOFF	sets/clears sBEEP according to beep flag
start	GOSUB	GetAnns
	GOSUB	clrmodrs	clear RS
	LC(5)	1		start at line 1
	GOSUB	C->Row		store line number
	R2=C.F	A		save flag at top of display
	GOTO	ShowScreen	display the screen
*******************************************************************************
**** MAIN LOOP ****************************************************************

main	GOSUBL	WaitKey
	ST=1	=sREPEAT	Set key repeat

** Now check for keys
	LA(2)	#C0			RS
	?A#C	B
	GOYES	NSplane
	GOSUB	EdModRS
NSplane
	LA(2)	#0B
	?A#C	B
	GOYES	ns1
	GOTO	UpArrow
********************************
ns1	LA(2)	#11
	?A#C	B
	GOYES	ns2
	GOTO	DnArrow
********************************
ns2	LA(2)	#0C			NXT key
	?A#C	B
	GOYES	ns3
	GOTO	TogDisp
********************************
ns3	LA(2)	#1A			[+/-] key
	?A#C	B
	GOYES	ns4
	GOTO	TogFlag
********************************
ns4	LA(2)	45			Attn? (checks for OFF too)
	?A#C	B
	GOYES	ns5
	GOTO	exit?
********************************
ns5	LA(2)	#19			ENTER = save & exit
	?A#C	B
	GOYES	ns6
	GOTO	Save&Exit
********************************
ns6	LA(2)	#2E			[0]
	?A#C	B
	GOYES	ns7
	LC(2)	1
	GOTO	key0
********************************
ns7	LA(2)	#29			[1]
	?A#C	B
	GOYES	ns8
	LC(2)	11
	GOTO	key0
********************************
ns8	LA(2)	#2A			[2]
	?A#C	B
	GOYES	ns9
	LC(2)	21
	GOTO	key0
********************************
ns9	LA(2)	#2B			[3]
	?A#C	B
	GOYES	ns10
	LC(2)	31
	GOTO	key0
********************************
ns10	LA(2)	#24			[4]
	?A#C	B
	GOYES	ns11
	LC(2)	41
	GOTO	key0
********************************
ns11	LA(2)	#25			[5]
	?A#C	B
	GOYES	ns12
	LC(2)	51
	GOTO	key0
********************************
ns12	LA(2)	#26			[6]
	?A#C	B
	GOYES	ns13
	LC(2)	64-9
	GOTO	key0
********************************
ns13	LA(2)	#08			[H]
	?A#C	B
	GOYES	ns14
	GOLONG	helpkey
********************************
ns14	LA(2)	#C0			RS
	?C#A	B
	GOYES	EndMain			make sure it does not beep for RS
	GOTO	main
EndMain
	GOTO	Beep			is was some other key -> DoBadKey

**** END MAIN LOOP ***********************************************************
******************************************************************************

**** key0 ********************************************************************
* local jump table for 0 to 6 keys
******************************************************************************
key0	R2=C.F	A		save flag at top of display
	GOSUB	GetAnns
	GOSUB	clrmodrs	clear RS
	ST=0	=sREPEAT	clear key repeat
	GOTO	ShowScreen
**** TogDisp *****************************************************************
* Toggles current display between User/Sys Flags
******************************************************************************
TogDisp	GOSUB	GetAnns
	?ABIT=0	5		RS clear ?
	GOYES	tgnxt
	GOSUB	clrmodrs	RS is set, so clear it
tgnxt	?ST=0	=sUSER		system flags displayed?
	GOYES	stusr
	ST=0	=sUSER		no, set them
	GOTO	cnt1
stusr	ST=1	=sUSER		yes, set User
cnt1	C=R2.F	A		get current row at top, reshow screen
	GOTO	key0

**** exit? *******************************************************************
* Waits until no keys are pressed, then exits
******************************************************************************
exit?	GOSBVL	=Kbd_OR
	GOC	exit?
* check if we must sleep
	GOSUB	GetAnns
	?ABIT=0	5		RS clear ?
	GOYES	exit
	GOSUB	clrmodrs	Clear RS
	ST=1	=sOFF
	GOLONG	OwnDeepSleep	Sleep
exit	GOVLNG	=GETPTRLOOP

**** Save&Exit ***************************************************************
* waits for no more keys to be pressed, then saves flags & exits
******************************************************************************
Save&Exit
	GOSBVL	=Kbd_OR
	GOC	Save&Exit		wait until ENTER no longer pressed
	GOSUB	GetAnns
	GOSUB	clrmodrs
	C=R4.F	A
	D0=C
	GOSUB	Flag->D1		get addr of Flags in RAM
	D0=(2)	=SystemFlags
	C=DAT0	W			get SystemFlags from Buffer$
	DAT1=C	W			save them to RAM
	D1=D1+	16			point to USER flags
	D0=(2)	=UserFlags
	C=DAT0	W			do the same
	DAT1=C	W
	GOTO	exit

**** Beep ********************************************************************
* Checks =sBEEP flag, then maybe does beep, kills the key repeat
******************************************************************************
Beep	ST=0	=sREPEAT	key clear repeat
	?ST=1	=sBEEP		don't beep ?
	GOYES	noBeep
	LC(2)	#FB
	GOSBVL	=RCKBp		Beeps with the tonw in C.B
noBeep
* clear RS and key repeat
	GOSUB	GetAnns
	GOSUB	clrmodrs
	ST=0	=sREPEAT
	GOTO	main

**** EdModRS *****************************************************************
* From Mika's ED
******************************************************************************
EdModRS	GOSUB	GetAnns		get annun. data into A.B
	?ABIT=1	5		flag set ?
	GOYES	clrmodrs	then clear it
	ABIT=1	5		set flag
	ABIT=0	4		set "an annun. is on" bit
	GONC	edmodok		save A.B
clrmodrs
	ABIT=0	5		clear RS annun. bit
* Note: REPEAT IS ENABLED!
edmodok
	ST=1	=sREPEAT
	DAT0=A	B		save/write bits
	RTN
**** GetAnns *****************************************************************
* gets annun. state into A.B, annun addr into D0
* From Mika's ED
******************************************************************************
GetAnns	D0=(5)	(=showbusy)+2
	A=DAT0	A
	D0=A
	A=DAT0	B
	RTN
**** TogFlag *****************************************************************
* KEY DEFINITION
******************************************************************************
TogFlag
	GOSUB	GetAnns
	?ABIT=0	5		RS clear ?
	GOYES	tognxt
	GOSUB	clrmodrs
	GOTO	Beep
tognxt	GOSUB	Row->C		get current row
	A=C	A
	GOSUB	Invert!		kill scroll bar
	C=R4.F	A
	D0=C
	GOSUB	line->D1	get ABUFF address of line in A.A into A.A
	B=A	A
	B=B+1	A
	B=B+1	A		write address init'ed

	GOSUB	Row->C		get current row
	A=R2.F	A		
	A=A+C	A
	A=A-1	A		option base 0
	R0=A.F	A
	GOSUB	TestFlag	CS if set
	GOC	clflg
	A=R0.F	A
	GOSUB	SetFlag
	GOTO	tog1
clflg	A=R0.F	A
	GOSUB	ClrFlag
tog1
	GOSUB	ShowTick
	GOSUB	Row->C		get current row
	GOSUB	Invert!		set highlight bar again
	GOTO	main

**** ShowScreen **************************************************************
* ENTRY : C.A = starting flag at top
* 
* NOTE : Invert bar need not be turned off!
******************************************************************************
ShowScreen
	LA(5)	64-9
	?C<A	A
	GOYES	ss1
	LC(5)	64-9
ss1	A=R4.F	A
	D0=A
	D0=(2)	=Flag
	LA(5)	1
	C=C-1	A		Option base 0
	DAT0=C	A		save flag number
	D0=(2)	=Line
	A=0	A
	DAT0=A	A		save current line number to display
sslp
	A=R4.F	A
	D0=A
	D0=(2)	=Line
	A=DAT0	A		get line 
	A=A+1	A		add 1
	LC(2)	11		at line 10?
	?C=A	B
	GOYES	endss		then exit show screen loop
	DAT0=A	A		write new line
	D0=(2)	=Flag
	C=DAT0	A		get flag number
	C=C+1	A		add 1
	DAT0=C	A		save it
	GOSUB	ShowLine
	GOTO	sslp

endss	GOSUB	Row->C		get current row
	GOSUB	Invert!		turn on invert bar
	?ST=1	=sOFF		OFF key pressed ?
	GOYES	c1		timeout caused by OFF key being pressed
*	GOTO	Waited?		check to see if redisplay caused by timeout
c1	ST=0	=sOFF
	GOTO	main		continue

**** ShowLine ****************************************************************
* ENTRY : C.A = flag number
*	: A.A = line number
* 
******************************************************************************
ShowLine
	R0=C.F	A		AND IN R0.A for checking if flag is set
	CR4EX.F	A
	D0=C
	CR4EX.F	A		get addr of Buffer without modifying anything
	GOSUB	line->D1	Line number -> address of line in D1, A.A

** Now we need to convert a flag number in hex into decimal for display
** Time optimized:  best case (01) :  78 cycles
**		   worst case (64) : 173 cycles
** note, FlagBrow v 1.0 worst case was ~1700 cycles !!!!
** C.A is 000(flag number)
*
* Algorithm: SETDEC
*            tens * 16
*            IF single > 9 THEN single = single + 6 END
*            single + tens
*            SETHEX

	A=0	B
	D=C	B		store flag number in D.B
	CSR	B		C.0 = tens
	?C=0	B		if flag 1 to 9, then we don't bother
	GOYES	dosingle
	C=C-1	B		setup for carry at zero
	LA(2)	#16		#10h = #16d
	B=A	B
	A=0	B
	SETDEC
lnlp1	A=A+B	B
	C=C-1	B
	GONC	lnlp1
** At exit, C.B is decimal base of "tens", D.B is saved flag number
	SETHEX

dosingle
	B=A	B		save decimal value of "tens" in B.B
	C=0	A
	C=D	P		get "single", assumes P= 0
	LA(1)	9
	?A>=C	P
	GOYES	lnxt1
	LA(2)	6
	C=C+A	B
lnxt1	SETDEC
	C=C+B	B
	SETHEX

** C.B is now flag number in decimal

	D=0	A
	D=C	B		save decimal flag number
	CSR	B		only "tens" here
* check if in range 1 to 9, then we do a space
	?C#0	B
	GOYES	lnxt2
	LC(5)	32-48
lnxt2	LA(5)	48
	C=C+A	A
	GOSUB	Ca->D0		convert character number to bitmap address
	AD1EX
	B=A	A		save write address
	D1=A
** Now write first char to screen
	P=	16-6		initialize P
	GOSUB	doNib		write the single number to display
	C=D	A		get 000(tens,single)
	CPEX	1		kill "tens" (assumes P= 0)
	P=	0		zero P again
	LA(5)	48		add offset to character 0
	C=C+A	A		
	GOSUB	Ca->D0		get bitmap address
* restore write address + 1
	C=B	A
	D1=C
	P=	16-6		initialize P
* write second character
	GOSUB	doNib		write char to screen
* now write 3 spaces (easier, faster than writing space, tick/space, space)
	GOSUB	ShowTick
	B=B+1	A		incr. write address
	B=B+1	A
	GOSUB	Tab->Ca		FlagTab to C.A
	D=C	A
	C=R0.F	A		get flag number
	C=C-1	A		option base 0
	A=C	A		1 x flag #
	C=C+C	A		2 x flag #
	C=C+C	A		4 x flag #
	C=C+A	A		5 x flag #
	C=C+D	A		offset into FlagTab
	D0=C
	C=DAT0	A		get offset from addr in D0 to size|string
	AD0EX			A.A = address, C.A = offset
	C=C+A	A
	D0=C
	C=0	A
	C=DAT0	B
	D0=D0+	2		D0 is address of string data
	AD0EX
	R0=A.F	A		string data address initialized
* write address ALREADY initialized
	RSTK=C			number of chars initialized
* Setup number of chars to write
	LC(5)   32-5
	D=C     A		D.A = loop counter (32 chars max width)
**** WriteLp *****************************************************************
* AUTHOR: Dan Kirkland (modified)
* QUOTE	: mine WILL be better! (sorry Dan, could not resist!)  ;)
* INFO	: Writes the string data into the display
* ENTRY	: 
*	: A.A 
*	: B.A = write! address
*	: C.A 
*	: D.A = total number of chars -> #20h or #32d  ** (- 5) **
*
*	: RSTK= string length
*	: R0  = string data address
*
* Uses: B.A, C.A, D.A, R0.A, RSTK, C.S
******************************************************************************
WriteLp	C=RSTK						<-------
	C=C-1   A		C.A = string len		|
	GOC     nochars		no more chars...		|
	RSTK=C			store string len back..		|
	C=R0.F  A						|
	D1=C			String data address		|
	C=C+CON A,2						|
	R0=C.F  A		store back..			|
	C=0     A						|
	C=DAT1  B		get 2 nibs char data		|
	GOSUB   Write		write loop			|
	D=D-1   B		dec loop counter		|
	GONC    WriteLp		finished? no, then do again ----
	C=RSTK			pop string len
	C=C-1   A		
	GOC     exitwr		no more chars, so exit
	B=B-1   A
	LC(5)   #1F		more chars, so do elipsis
	GOSUB   Write		write loop
	GONC    exitwr		exit?
nochars				more to do still
	LC(5)   #20		space.
	GOSUB	Write		write
	D=D-1	B		sub width still to do.
	GONC    nochars		fill the rest of the line
*	***
exitwr	RTN			RETURN TO CALLER
*	***
Write	A=B     A
	D1=A			d1 = write!
	GOSUB	Ca->D0
	P=      16-6		6 rows
doNib	C=DAT0  S		read
	DAT1=C  S		write!
	D0=D0+  1		next data bit
	D1=D1+  16		\
	D1=D1+  16		 > next row
	D1=D1+  2		/
	P=P+1			
	GONC    doNib
	B=B+1   A		incr write address
	RTN

**** ShowTick ****************************************************************
* ENTRY: B.A is write address
*	 R0.F = flag number
* clears the 3 spaces and writes a "tick" if necessary
******************************************************************************
ShowTick
	C=B	A
	D1=C
	C=0	A		zero C.A 'cos we want to clear screen
	P=	16-6
lnxt3	DAT1=C	X
	D1=D1+	16
	D1=D1+	16
	D1=D1+	2
	P=P+1
	GONC	lnxt3
	B=B+1	A
* remember, R0.A was the flag number....
	C=B	A
	D1=C			restore screen write address
	A=R0.F	A
	GOSUB	TestFlag	CS if set
	GONC	skiptick
	LCHEX	000205080000	"tick" data (reversed)
	P=	16-6
setrwlp	DAT1=C	B		write 2 nibs
	D1=D1+	16		\
	D1=D1+	16		 > next line
	D1=D1+	2		/
	CSR	W		ditch those 2 nibs
	CSR	W			
	P=P+1			incr. loop counter
	GONC	setrwlp
skiptick
	RTN

**** TestFlag ****************************************************************
* ENTRY : A.A is flag to be checked, Usr/Sys depending on =sUSER
* EXIT : CS = flag set
******************************************************************************
TestFlag
        GOSUB   FlagSetup
        C=C&A   XS              Isolate the flag
        ?C#0    XS              Flag set?
        GOYES   flgset          Yep, set carry
flgset	RTN

**** SetFlag *****************************************************************
* ENTRY : A.A is flag to be checked, Usr/Sys depending on =sUSER
* calls Flags->Ca which trashes D0, C.A
******************************************************************************
SetFlag	GOSUB   FlagSetup
	C=C!A   XS              Set the flag
	DAT0=C  XS              Write new flag register
	RTN

**** ClrFlag *****************************************************************
* ENTRY : A.A is flag to be checked, Usr/Sys depending on =sUSER
* from the rom (rather neat code, so I pinched it!)
******************************************************************************
ClrFlag	GOSUB   FlagSetup
        A=-A-1  XS
        C=C&A   XS              Clear the flag
	DAT0=C	XS
	RTN

**** FlagSetup ***************************************************************
* sets up flags
* from the rom (rather neat code, so I pinched it!)
* calls Flags->Ca which trashes D0, C.A
******************************************************************************
FlagSetup
	A=A-1	A		Use option base 0
	LC(2)	3
	C=C&A	B
	CSRC			C[S]: 2 lsb of flag
	ASRB.F	B
	ASRB.F	B		A[A]: nib offset to flag
	GOSUB	Flags->Ca
set3	C=C+A	A	
	CD0EX			D0 -> desired flag nibble
	P=C	15		P: 2 lsb: 0-3
	P=P-1	
	LCHEX	1248
	P=	0
	A=C	XS		2 lsb: 0,1,2,3 ->A[XS]: 1,2,4,8
	C=DAT0	XS
        RTN
**** line->D1 ****************************************************************
* line number in A.B --> Address in D1,A
* ******
* CAVEAT : Assumes D0 points to address buffer !!!
* ******
* Trashes A.A, D1, D0						time optimised
******************************************************************************
line->D1
	D0=(2)	=Row0		Row1 - 5
	A=A-1	A		set up for carry at 0
lnlp	D0=D0+	5
	A=A-1	B
	GONC	lnlp
	A=DAT0	A		get address of line
	D1=A			write address initilised
	RTN

**** Ca->D0 ******************************************************************
* Character code in C.A --> Address of character data in D0
* Trashes C.A, A.A, D0						time optimised
******************************************************************************
Ca->D0	C=C+C	A		2 x char				[7]
	A=C	A							[14]
	C=C+C	A		4 x char				[21]
	C=C+A	A		6 x char				[28]
	A=R4.F	A							[39]
	D0=A								[47]
	D0=(2)	=FNT1							[51]
	A=DAT0	A							[69]
	C=C+A	A							[76]
	D0=C								[84]
	RTN								[93]

**** Tab->Ca ******************************************************************
* Returns the address of the current displayed FlagTab into C.A
* Trashes D1, C.A
*******************************************************************************
Tab->Ca	C=R4.F	A		get addr of data buffer
	D1=C			
	?ST=0	=sUSER		user flags not being shown ?
	GOYES	shwsys
	D1=(2)	=UsrFlagTab	
	GOTO	tbnxt
shwsys	D1=(2)	=SysFlagTab
tbnxt	C=DAT1	A		get Flag jump table addr
	RTN

**** Flags->Ca ****************************************************************
* Returns the address of the current displayed Flags into C.A
* Trashes D0, C.A
*******************************************************************************
Flags->Ca
	C=R4.F	A		get addr of data buffer
	D0=C			
	?ST=0	=sUSER		user flags not being shown ?
	GOYES	flgca
	D0=(2)	=UserFlags
	GOTO	flgca1
flgca	D0=(2)	=SystemFlags
flgca1	CD0EX			get Flags addr
	RTN

**** Invert! *****************************************************************
* C.B Line to invert/highlight
* Trashes: C.W, D0, P, Carry					time optimised
******************************************************************************
Invert!	C=C-1	B		initial decrement so carry will occur properly
	CR4EX.F	A
	D0=C
	CR4EX.F	A		get addr of buffer without trashing anything 
	D0=(2)	Row1
invlp	C=C-1	B
	GOC	invnxt
	D0=D0+	5
	GOTO	invlp
invnxt	C=DAT0	A		Get addr of line from buffer
	D0=C
	P=	16-6		6 lines
invtlp1	C=DAT0	W
	C=-C-1	W
	DAT0=C	W
	D0=D0+	16
	C=DAT0	W
	C=-C-1	W
	DAT0=C	W
	D0=D0+	16
	C=DAT0	B
	C=-C-1	B
	DAT0=C	B
	D0=D0+	2
	P=P+1
	GONC	invtlp1
	RTN
**** Row->C ******************************************************************
* returns the current row highlighted into C.A from R4.S
* uses C.S, C.A, P
******************************************************************************
Row->C	P=	15
	C=0	A
	C=R4.F	P
	CSLC	W
	P=	0
	RTN
**** C->Row ******************************************************************
* Stores the current row highlighted (given by C.1)
* uses C.S, C.A, P
******************************************************************************
C->Row	RSTK=C		make it non-destructive to row#
	CSRC	W
	P=	15
	R4=C.F	P	R4.S = row highlighted
	P=	0
	C=RSTK		restore row number
	RTN
**** InitBuffer **************************************************************
* Initialises the address buffer
* NOTE: beginning address will be at some random offset (from 0-FF) into the $
* version 2.1 changed to IRAMBuff with string as backup in case of OFF
******************************************************************************
* FONT
* FlagTab
* BUFFER$

InitBuffer

	D0=(5)	(=IRAM@)-4
	A=DAT0	A		High nibble of C[A] now has RAM base address
	LA(4)	#0100		Set buffer to RAM+#100
	R4=A.F	A		Save buffer address in R4[A]

*	GOSBVL	=D0=DSKTOP
*	A=DAT0	A
*	LC(5)	#FF+10
*	A=A+C	A
*	A=0	B		set Buffer$ start addr to even page eg 70A00h
*	R4=A.F	A		save in R4.A
	D0=A			point to begin of buffer$
* Set Flag at top to Flag 1
	LC(2)	1
	D0=(2)	=FlagTop
	DAT0=C	B
* Pop FlagTab
	D1=D1+	5		point to STK2
	C=DAT1	A
	LA(5)	10
	C=C+A	A
	D0=(2)	=SysFlagTab
	DAT0=C	A
	D0=(2)	=UsrFlagTab	this is 4 cycles, D0=D0+5 is 7 cycles
	LA(5)	64*5		64 flags with 5 nibs offsets each
	C=C+A	A
	DAT0=C	A
* Pop xFNT1
	D1=D1+	5		point to STK2
	C=DAT1	A
	LA(5)	10
	C=C+A	A
	D0=(2)	=FNT1
	DAT0=C	A
* get addr of ABUFF and write ABUFF table
	GOSBVL	=D0->Row1	A.A, D0 = Addr of 1st nib ABUFF
	C=R4.F	A
	D0=C
	D0=(2)	Row0
	DAT0=A	A		write address of ABUFF as Row0
	LC(5)	34*2
	A=A+C	A
	D0=(2)	Row1
	LC(5)	34*6		6 pixel rows down on ABUFF
	P=	16-10		10 rows
** Remember, A.A is addr of ABUFF
InitLp	DAT0=A	A		write addr
	D0=D0+	5		point to next address space in table
	A=A+C	A		Add 6 pixel rows down
	P=P+1	
	GONC	InitLp
** Now do end of display
	D0=(2)	=RowEnd
	DAT0=A	A
** Now do KeyState, as access from the buffer$ is faster than direct access
	D1=(5)	(=IRAM@)-4
	A=DAT1	A		get base address of RAM into high nib of A.A
	D1=(5)	(=addrKEYSTATE)+2
	A=DAT1	4		get other 4 nibs
	D0=(2)	=KeyState
	DAT0=A	A		save address of KeyState into buffer
** Test if GX or SX
	D1=(5)	=IRAM@
	C=DAT1	B
	?CBIT=1	3
	GOYES	setgx
	ST=0	=sGX		SX
	GOTO	init1
setgx	ST=1	=sGX		GX
init1	
** Now write Flags
	GOSUB	Flag->D1	D1= SystemFlags for this machine
	C=DAT1	W		read
	DAT0=C	W		store them in the Buffer$
	D1=D1+	16		point to User Flags
	D0=(2)	=UserFlags
	C=DAT1	W		read user flags
	DAT0=C	W		write user flags
	RTN	

**** Flag->D1 ****************************************************************
* sub routine for InitBuffer
* machine independent D1=(5)	=SystemFlags
******************************************************************************
Flag->D1
	D0=(2)	=SystemFlags
	?ST=1	=sGX
	GOYES	flgGX
	D1=(5)	=SystemFlagsSX
	GOTO	flgnxt
flgGX	D1=(5)	=SystemFlagsGX
flgnxt	RTN

**** UpArrow *****************************************************************
* Key Definition
******************************************************************************
UpArrow
	GOSUBL	GetAnns
	?ABIT=0	5		RS not set?
	GOYES	goUp
	GOTO	start		just restart at line 1
goUp	GOSUB	Row->C
** C.B = ROW HIGHLIGHTED
	C=C-1	B
	?C=0	B		highlight bar at the top of the screen ?
	GOYES	attop
** highlight bar in middle of display somewhere, so move it 1 line up
	A=C	B		save new highlight line
	C=C+1	B		revert to old value
	GOSUB	Invert!		turn off menu bar
	C=A	B		restore new
	GOSUB	Invert!		set new bar
	C=A	B
	GOSUB	C->Row		save new bar
	GOTO	main
attop
	B=C	A		save scroll bar in case we need to scroll
	C=R2.F	A
	LA(5)	1
	?A#C	A		are we NOT at the top of the flag list ?
	GOYES	copydn		At the top of the flag list, so beep
	GOTO	Beep
* Not at the top of the list, but at the top of display, so scroll "up" 
copydn	C=B	A		get highlight bar (new)
	C=C+1	A		get highlight bar (old)
	GOSUB	Invert!		turn bar off
* Now we copy the screen "down"
	C=R4.F	A
	D1=C
	D1=(2)	=RowEnd
	A=DAT1	A
	D1=A
	D0=C
	D0=(2)	=Row10
	C=DAT0	A
	D0=C
	LC(5)	34*54
	GOSBVL	=MOVEUP		from D0 to D1, C.A nibbs

** Now calc the flag number on the top line, then show the new line
	C=R2.F	A
	C=C-1	A
	R2=C.F	A		C.A is flag number
	LA(5)	1		A.A is line number
	GOSUB	ShowLine

	LC(2)	1		and reset the highlight bar....
	GOSUB	Invert!
	GOLONG	main

**** DnArrow *****************************************************************
* Key Definition
******************************************************************************
DnArrow
	GOSUBL	GetAnns
	?ABIT=0	5		RS Not set?
	GOYES	goDn		then move scroll bar down 1 line
** goto the bottom of the flag list
	GOSUBL	clrmodrs	clear the RS annun.
	LC(5)	10		set row 10 as highlighted row
	GOSUB	C->Row		
	LC(5)	64-9		last flag at top
	R2=C.F	A		save flag at top of display
	GOTO	ShowScreen	reshow screen, reset highlight bar & restart

goDn	GOSUB	Row->C
** C.B = ROW HIGHLIGHTED
	LA(2)	10		10 ROWS!
	?A=C	B		Are we at the bottem of the display ?
	GOYES	AtBotmS		at the bottom of the screen!
* not at the bottom of the screen, so move highlight bar down 1 line
	RSTK=C			save current row
	GOSUB	Invert!		turn highlight bar off
	C=RSTK			restore current line
	C=C+1	B		add 1 
	GOSUB	C->Row		save it
	GOSUB	Invert!		set highlight bar on
	GOLONG	main
AtBotmS	
** C.B is current row at the top
	C=R2.F	A		get current row at top of display
	LA(5)	64-9
	?C#A	A		NOT at the last row shown on top line yet?		
	GOYES	dn1ln
	GOTO	Beep		last row, beep and clear key repeat
dn1ln	LC(2)	10
	GOSUB	Invert!		kill the scroll bar

** Now copy the display "up"
	C=R4.F	A
	D1=C
	D1=(2)	=Row1
	A=DAT1	A
	D1=A
	D0=C
	D0=(2)	=Row2
	C=DAT0	A
	D0=C
	LC(5)	34*54
	GOSBVL	=MOVEDOWN

** Now calc the flag number on the bottom line, then show the new line
	C=R2.F	A		get old flag number at top of display
	C=C+1	A		add 1
	R2=C.F	A		save new flag number
	LA(5)	9
	C=C+A	A		C.A is flag number at bottom of display
	LA(5)	10		A.A is line number
	GOSUB	ShowLine

	LC(2)	10		and reset the highlight bar....
	GOSUB	Invert!
	GOLONG	main

**** InitClk *****************************************************************
* Initializes the timeout
* Edition History : from Mika's ED (modified)
******************************************************************************
InitClk	GOSBVL	=DisableIntr
*	GOSBVL	=GetTimChk
*	A=C	W
*	C=0	W
*	LC(13)	8192*10*60			10 minutes
*	LCHEX	3C000
*	LCHEX	4B0000
*	A=A+C	W
*	GOSBVL	(=clrtimeout)+3		writes A.W as timeout value
*	GOVLNG	=AllowIntr

	D1=(5)	#E745
	A=DAT1	A
	D1=A
	A=0	S
	DAT1=A	S
	GOSBVL	=clrtimeout
	GOVLNG	=AllowIntr

**** Delay? ******************************************************************
* Does the delay specified by the ST flags
* no key delay if =sREPEAT is SET
* otherwise, 4/10th of a second
* Edition History : from Mika's ED (modified)
******************************************************************************
Delay?	ST=0	15		kill keyboard
	A=R3			get timeout value
	C=0	W
	?ST=0	=sDELAY
	GOYES	Delay1
	LC(5)	8192*4/10	4/10th of a second delay before REPEAT is SET
Delay1	A=A+C	W
	R0=A			temporary save in R0
	ST=1	=sDELAY
Delaylp	GOSBVL	=AINRTN
	?A=0	X
	GOYES	Delayed
	GOSBVL	=GetTimChk
	A=R0			retrieve
	?C<A	W		more to wait ?
	GOYES	Delaylp
	ST=0	=sDELAY		reset delay flag
Delayed	GOVLNG	=AllowIntr

**** WaitKey *****************************************************************
* waits for a keypress and returns key into C.B
* Edition History : from Mika's ED (modified)
******************************************************************************
WaitKey	?ST=0	=sREPEAT		key repeat ?
	GOYES	igndly			then ignore key delay
	GOSUB	Delay?
igndly	GOSBVL	=showbusy
	GOSUB	PopKey
	RTNNC
	?ST=0	=sREPEAT
	GOYES	gosleep			no key and no repeat
	GOSBVL	=DisableIntr
	A=R4.F	A							[11]
	D0=A								[8]
	D0=(2)	KeyState						[4]
	A=DAT0	A							[18]
	D0=A								[8]
	A=DAT0	13
* This enables repeat with
* changing modifiers
*	LC(13)	#0000000820800	
	LCHEX	#0000000820800	
	A=A&C	W
	DAT0=A	13
Waited?	GOSBVL	=AllowIntr
waited?	GOSBVL	=showbusy
	GOSUB	PopKey
	RTNNC
gosleep	ST=0	15
	GOSBVL	=clrbusy
	GOSBVL	=setannun
sleep	ST=1	=sDELAY
	D0=(5)	=TIMER1
	LC(1)	7
	DAT0=C	1
	D0=(2)	=TIMERCTRL.1
	LC(2)	#75
	DAT0=C	B
*	******
	SHUTDN			nighty-night
*	******
	C=DAT0	B
	GOSBVL	=AllowIntr
timeout?
	GOSUB	TimeOut?
	GONC	waited?
timeout
*	GOSBVL	=DisableIntr
	ST=0	=sOFF
	GOTO	OwnDeepSleep
	
**** TimeOut? ****************************************************************
* checks for timeout, Carry if true
* Edition History : from Mika's ED (modified)
******************************************************************************
TimeOut?
	GOSBVL	=chk_timeout
	RTNC				timeout! CS
	D1=D1-	13
	A=0	W
	A=DAT1	13
	?A=0	W
	GOYES	enabtimeout
	RTNCC
enabtimeout
	GOSBVL	=DisableIntr
	GOSBVL	=GetTimChk
	A=C	W
	C=0	W
*	LC(13)	8192*60*10		10 minutes
*	LCHEX	3C000
	LC(6)	=TimeOut
	A=A+C	W
	GOSBVL	(=clrtimeout)+3		write A.W as timeout value
	GOSBVL	=AllowIntr
	RTNCC
**** OwnDeepSleep ************************************************************
* Turns of the '48
* Edition History : from Mika's ED (modified)
*		  : rewrite to get around GX port 2 with 1M card lockup
******************************************************************************
OwnDeepSleep
*	C=ST
*	RSTK=C			save ST flags
*	GOSBVL	=DeepSleep	turn off and sleep
*	C=RSTK
*	ST=C			restore ST flags
*	RTN

** Since we want to jump to RPL and use the RPL word =TurnOff, we will have to
** save all the working registers !!!  These are saved in a string on STK1.

** Now save working registers
	GOSBVL	=GETPTR
	C=DAT1	A
	D1=C
	D1=D1+	10		incr past prolog, len
* D1 now points to the 1st nib of the Buffer$
	C=R4			save R4.W (IRAMBUFF base addr, flag highlight)
	DAT1=C	W
	D1=D1+	16
	C=R2.F	A		save R2.A (flag at top of display )
	DAT1=C	A
	D1=D1+	5	
	C=ST			save ST flags
	DAT1=C	A
	D1=D1+	5
* now save IRAMBUFF (most of it anyway)
	C=R4.F	A
	D0=C
	LA(2)	124/2-1
sRPLlp	C=DAT0	B
	DAT1=C	B
	D1=D1+	2
	D0=D0+	2
	A=A-1	B
	GONC	sRPLlp
	GOSUB	InitClk		reset the timeout value or ver. R will wakeup ?
	GOSBVL	=GETPTR		restore RPL registers
	GOSUB	DoRPL
	CON(5)	=DOCOL
RPL
*	ROMPTR 3E0 9		( SHALT )
*	GARBAGE			( force GC to check GX port > 1 compatability )
*	DEEPSLEEP DROP		( works on J,K but causes spurious wakeup on R )
	TurnOff
	COLA
ASSEMBLE
	CON(5)	=DOCODE
	REL(5)	endFlagBrow
	GOSBVL	=SAVPTR
	C=DAT1	A
	D1=C
	D1=D1+	10		incr past prolog, len
* D1 now points to first nib in Buffer$
	C=DAT1	W
	R4=C			restore R4
	D1=D1+	16
	C=DAT1	A
	R2=C.F	A		restore R2.A
	D1=D1+	5
	C=DAT1	A
	ST=C			restore ST
	D1=D1+	5
	C=R4.F	A
	D0=C
	LA(2)	124/2-1
rRPLlp
	C=DAT1	B
	DAT0=C	B
	D1=D1+	2
	D0=D0+	2
	A=A-1	B
	GONC	rRPLlp
	GOSUB	InitClk		reinitialize the TimeOut value
	C=R2.F	A		C.A = flag to show at the top
	GOLONG	ShowScreen	display screen & restart main loop
*******************************************************************************
DoRPL	C=RSTK			pop addr of embedded RPL ob
	A=C	A		
	PC=(A)			start RPL

**** PopKey ******************************************************************
* Pops key into C.B (actually C.A)
* Edition History : from Mika's ED
******************************************************************************
PopKey	GOSUB	Attn?
	GONC	popkey10
	C=0	A
	DAT1=C	A		set number of ATTN presses to zero
	LC(2)	45		return with key code 45 for ATTN key
	GOC	popkey20
popkey10
	GOSBVL	=POPKEY		pop key into C.B
	RTNC
popkey20
	RSTK=C			save key code
	ST=0	15		kill keyboard
	GOSBVL	=clrtimeout
	GOSBVL	=GetTimChk
	R3=C			save timeout
	GOSBVL	=AllowIntr
	C=RSTK			restore key code
	RTNCC

**** Attn? *******************************************************************
* CS if ATTN was pressed
* Uses C, D1
* Edition History : from Mika's ED
******************************************************************************
Attn?	D1=(5)	(=addrATTNFLG)+2
	C=DAT1	A		get address of ATTN flag
	D1=C			put it into D1
	C=DAT1	A		get number of times ATTN pressed
	?C#0	A		attn pressed ?
	RTNYES			RTN with CS if ATTN was pressed
	RTN			CC

**** helpkey *****************************************************************
* Shows FlagBrow title and info
* Edition History : 20 Nov. 96 : updated grob to v 4.0
******************************************************************************
helpkey
	GOSUBL	GetAnns
	GOSUBL	clrmodrs	clear RS
	ST=0	=sREPEAT	clear repeat
	GOSUB	ClearDisp
* Now show the grob
	C=B	A		C.A = start ABUFF
	LA(5)	34*2+3
	C=C+A	A
	D0=C
	GOSUB	FBgrob
** FlagBrow Grob 112 x 23
	NIBHEX	00FF00000008F7000000000
	NIBHEX	000000FFF0000000FFF1000
	NIBHEX	0000000000CFFF030000CFF
	NIBHEX	F10000000000000EF3E8300
	NIBHEX	00EF0E10000000000000E30
	NIBHEX	6C30000E36C100000000000
	NIBHEX	00F007E10000FE3E0000000
	NIBHEX	0000000F103F100000C9330
	NIBHEX	00000C10C0000083F0C007C
	NIBHEX	FF8F3E0700C16EF000089F0
	NIBHEX	F1C3CF0CFBF9763E1FEF000
	NIBHEX	0C978F3FD0BFCFDB93B3F9D
	NIBHEX	E7000EFF3CD97E838FDD9DB
	NIBHEX	9BDD667008FFD1FCD37C18F
	NIBHEX	EECEDDDCE3B300003C97EC9
	NIBHEX	FF1E76ECFECFDF0B910083C
	NIBHEX	DFFEDFEFF17FEFFEFFFCDD0
	NIBHEX	00C1CFFFFF7EF70FF7EF7CF
	NIBHEX	EFC7000E083EE9B38F10FC3
	NIBHEX	CD387C3C30087000000C100
	NIBHEX	0000000000000000C300000
	NIBHEX	0E00000A0002004120000E1
	NIBHEX	FFFFF3FCFFFFA4CE033415E
	NIBHEX	F00600FFFF97EFFFFAE22A4
	NIBHEX	5C15E3000000EFF83FFFFF4
	NIBHEX	22CA45015E0000000000C10
	NIBHEX	00004C2E235052000000000
	NIBHEX	00C00000000000000000000
FBgrob
	C=RSTK
	D1=C			D1 = address of embedded data
	LA(2)	23-1		23 lines, option base 0
GWlp	C=DAT1	W
	DAT0=C	W
	D0=D0+	16
	D1=D1+	16
	C=DAT1	12
	DAT0=C	12
	D0=D0+	16
	D0=D0+	2
	D1=D1+	12
	A=A-1	B
	GONC	GWlp
	GOSUB	txt1

** Now show the text.
*		 0        1         2         3
*		 12345678901234567890123456789012
	CON(2)	31		len of string for reg. RSTK
	CON(1)	(=lineOne)+0	number of lines down
	NIBASC	\ FlagBrow is Postcard-ware.  If\
txt1	C=RSTK
	GOSUB	ShowTxt
	GOSUB	txt2
	CON(2)	32	
	CON(1)	(=lineOne)+1	
	NIBASC	\you like or use it a lot, please\
** See?  I did NOT say you *MUST* send a postcard...
txt2	C=RSTK
	GOSUB	ShowTxt
	GOSUB	txt3
	CON(2)	32
	CON(1)	(=lineOne)+2	
	NIBASC	\ send a postcard to me (Richard)\
txt3	C=RSTK
	GOSUB	ShowTxt
	GOSUB	txt4
	CON(2)	25
	CON(1)	(=lineOne)+3	
	NIBASC	\      7 Sun Valley Avenue\
txt4	C=RSTK
	GOSUB	ShowTxt
	GOSUB	txt5
	CON(2)	21
	CON(1)	(=lineOne)+4	
	NIBASC	\      Constantia 7800\
txt5	C=RSTK
	GOSUB	ShowTxt
	GOSUB	txt6
	CON(2)	18
	CON(1)	(=lineOne)+5	
	NIBASC	\      South Africa\
txt6	C=RSTK
	GOSUB	ShowTxt
** Now wait for a key to be pressed & released
	GOSUB	HelpWait
	GOSUB	ClearDisp

*******************************
** Now we show the second page.
*******************************
** Which should look like this:
** 0        1         2         3
** 12345678901234567890123456789012
** Thanks to:
** Mika,Joe,Mozz,DanK,sj,JonP,#hp48
**
** Keys :
** Cursors = up/down
**  [+/-]  = toggle flag
**  [NXT]  = swap System/User flags
** [ENTER] = Save & exit
**   [ON]  = abort/exit
** [0]\->[6] = jump to flag base
**
	GOSUB	txt7
	CON(2)	11		len of string for reg. RSTK
	CON(1)	(=lineTwo)+0	number of lines down
	NIBASC	\Thanks to :\
txt7	C=RSTK
	GOSUB	ShowTxt
	GOSUB	txt8
	CON(2)	33
	CON(1)	(=lineTwo)+1	
	NIBASC	\Mika,Joe,Mozgy,DanK,sj,JonP,#hp48\
txt8	C=RSTK
	GOSUB	ShowTxt
	GOSUB	txt9
	CON(2)	6
	CON(1)	(=lineTwo)+3
	NIBASC	\Keys :\
txt9	C=RSTK
	GOSUB	ShowTxt
	GOSUB	txt10
	CON(2)	17
	CON(1)	(=lineTwo)+4	
	NIBASC	\Cursors = up/down\
txt10	C=RSTK
	GOSUB	ShowTxt
	GOSUB	txt11
	CON(2)	21
	CON(1)	(=lineTwo)+5	
	NIBASC	\ [+/-]  = toggle flag\
txt11	C=RSTK
	GOSUB	ShowTxt
	GOSUB	txt12
	CON(2)	32
	CON(1)	(=lineTwo)+6	
	NIBASC	\ [NXT]  = swap System/User flags\
txt12	C=RSTK
	GOSUB	ShowTxt
	GOSUB	txt13
	CON(2)	27
	CON(1)	(=lineTwo)+7
	NIBASC	\[ENTER] = Save flags & exit\
txt13	C=RSTK
	GOSUB	ShowTxt
	GOSUB	txt14
	CON(2)	20
	CON(1)	(=lineTwo)+8
	NIBASC	\  [ON]  = exit/abort\
txt14	C=RSTK
	GOSUB	ShowTxt
	GOSUB	txt15
	CON(2)	27
	CON(1)	(=lineTwo)+9
	NIBASC	\[0]\
	NIBHEX	D8
	NIBASC	\[6] = jump to flag base\
txt15	C=RSTK
	GOSUB	ShowTxt

** Now wait for a key to be pressed & released
	GOSUB	HelpWait

	C=R2.F	A		setup flag at top of display
	GOLONG	ShowScreen	display the screen

**** ShowTxt *****************************************************************
* Sub-routine of "help" screen
* C.A = addr of data as such: 2nib len of string, 1 nib line offset, data
******************************************************************************
ShowTxt
	D0=C			get address of data
	C=0	A
	C=DAT0	B		get length
	RSTK=C			put in RSTK
	D0=D0+	2		point to offset
	LC(5)	34*6
	B=C	A		init B.A for offset calc.
	C=R4.F	A
	D1=C
	D1=(2)	=Row0		5 nib data at D1 is start of ABUFF
	C=DAT0	1		get offset
	A=0	A
	C=C-1	P		option base 0
	GOC	thisadr
offstlp	A=A+B	A
	C=C-1	P
	GONC	offstlp
thisadr	C=DAT1	A		get start of ABUFF
	C=C+A	A		add offset
	LA(5)	34*2		add any extra lines down you want
	C=C+A	A
	B=C	A		setup write address
* now setup string data addr
	D0=D0+	1
	CD0EX
	R0=C.F	A
	LC(5)	32
	D=C	A
	GOLONG	WriteLp		This sub-routine does a RTN

**** ClearDisp ***************************************************************
* clears the display
* !!!!! saves start address of ABUFF in B.A !!!!!
******************************************************************************
ClearDisp
* clear the display
	C=R4.F	A
	D1=C
	D1=(2)	=Row0
	C=DAT1	A
	D1=C			D1 = start address of ABUFF
	B=C	A		save start of ABUFF
	LC(5)	64*34
	GOVLNG	=WIPEOUT	clear C.A nibs starting at D1
* previous call does a RTN... so no need to include one... also save 2 nib

**** HelpWait ****************************************************************
* waits for keypress & release... maybe timeout
******************************************************************************
HelpWait
	GOSUBL	WaitKey		wait for a key to be pressed.. maybe timeout.
** wait for user to get off key
endhlp?	GOSBVL	=Kbd_OR		
	GOC	endhlp?		wait for user to get off the key
	RTN	
RPL
