**********************************************************************
* Name:		VARS
* Stack:	( --> {} )
* Notes:
*	Makes 1 pass only unless GC is forced.
*	This method is slower than Rick's 2 pass VARS if the context
*	is small ( ~< 20 variables ). In general the differences are
*	small though.
* Warning:
*	Invalid objects are not allowed in tempob area. Thus if the loop
*	runs out of room the allocated list must be destroyed before
*	calling GC.
*	The GC trick used here is employed so that the program will work
*	from tempob area too. This enables storing the program to a covered
*	card. Note that for the embedded RPL GARBAGE trick to work properly:
*	1) Skipping the code after GARBAGE call ( COLA CODE.. ) must
*	   lead to the end of the entire object. Ending the 2nd code object
*	   at the same place as the main code which it lies in is sufficient
*	   for this purpose.
**********************************************************************
ASSEMBLE
	CON(1)	8
RPL
xNAME VARS
::
  CK0	
  CONTEXT@ LastNonNull NOTcase NULL{}

ASSEMBLE
	CON(5)	=DOCODE
	REL(5)	->EndVars

=sGarb		EQU 10	* GC status bit

		ST=0	sGarb
VarsRestart	GOSBVL	=SAVPTR
		GOSBVL	=ROOM
		LA(5)	100
		C=C-A	A		* Ensure some working memory
		GOC	VarsNoMem2	* Try again after GC
		A=DAT1	A
		R1=A			R1[A] = ->lastram-word
		GOSBVL	=GETTEMP+	* Allocate (always succeeds!)

		D=C	A		D[A] = nibbles
		CD0EX
		R0=C			R0[A] = ->list
		D=D-CON	A,10		* Allocate DOLIST and SEMI
		GOC	VarsNoMem
		D1=C			D1 = ->list
		LC(5)	=DOLIST	
		DAT1=C	A
		D1=D1+	5
		A=R1
		D0=A			D0 = ->lastram-word
		GOSBVL	=TRAVERSE-
		AD0EX			A[A] = ->lastram-name
		GOTO	varscopylp

* Trash invalid slot at R0[A], call GC & restart
* Note that the allocated object is on top of tempob. Thus no
* pointers need to be adjusted. Doesn't really matter for speed
* though due to GC so might as well use MOVERSD directly to save memory.

VarsNoMem	GOSBVL	=GETPTR
		A=B	A		A[A] = [RSKTOP]
		C=R0			C[A] = ->list
		C=C-1	A		C[A] = ->slot
		C=A-C	A
		GOSBVL	=MOVERSD	* Destroy slot (is safe)

* Call GC & restart
VarsNoMem2	?ST=1	sGarb		* Already tried it?
		GOYES	MERR		* Yes - then error
		GOSBVL	=GETPTR
		A=PC
		A=A+CON	A,10
		PC=(A)
		CON(5)	=DOCOL
		CON(5)	=GARBAGE	* RPL Garbage
		CON(5)	=COLA		* COLA is necessary if the code is not
		CON(5)	=DOCODE		* embedded in a secondary.
		REL(5)	->EndVars
		ST=1	sGarb		* Mark GC done
		GOTO	VarsRestart
MERR		GOVLNG	=GPMEMERR
			
varscopylp	D0=A
		C=0	A
		C=DAT0	B
		?C=0	B
		GOYES	varsdone	* Any nullname stops scan like xVARS
		B=A	A		* Save ->name
		C=C+C	A		* chars
		C=C+CON	A,7		* chars+len+prolog
		D=D-C	A
		GOC	VarsNoMem
		C=C-CON	A,5		* Set prolog separately
		LA(5)	=DOIDNT
		DAT1=A	A
		D1=D1+	5
		GOSBVL	=MOVEDOWN	* Copy len+chars
		A=B	A		* Restore ->name
		A=A-CON	A,5
		D0=A			D0 = ->nextlink
		C=DAT0	A
		A=A-C	A
		?C#0	A
		GOYES	varscopylp	* Repeat until no more vars (link=0)

varsdone	LC(5)	=SEMI		* Add SEMI to finish list
		DAT1=C	A
		D1=D1+	5
	
* Shrink object at R0[A], new end address in D1
* Note that the object must be topmost in tempob area.

		AD1EX
		D0=A			D0 = ->listend
		GOSBVL	=ShrinkOb	* Shrink list to fit R0[A]-D0
		GOVLNG	=GPOverWrR0Lp
->EndVars
RPL
;
**********************************************************************
