program UnpackDemo;

{ ZiPPAS Demo  Copyright (c) 1994,95 by Solar Designer }

{$X+}
uses
   Unpack, Objects,
   CRT; { Never use the CRT unit in a real program! }

{$Define Debug}

var
   u               :TUnpackList;
   s               :TMemoryStream;

{$IfDef Debug}
   Info            :TPackedInfo;
{$EndIf}

   i               :Integer;

begin
   s.Init(0, 64);

   u.Init('ZIPDEMO.CMP', s); { Unpack a ZIP archive (created by PKZIP 2.06) }
(* u.ZipId:=$12345678; { A non-standard ZIP signature can be used } *)

(* u.InitOverlay; { Uncomment this if the archive is appended to the EXE file } *)

{$IfDef Debug}
   u.Messages:=True;
   u.GetInfo(Info);

   if Info.Ok then
   WriteLn(#13#10'The archive ', u.FileName^, ' contains ', Info.Files, ' file(s).'+
      #13#10'Unpacking to MEMORY ...');
{$EndIf}

   u.Unpack;

   if u.Status<>uzOk then
   begin
      WriteLn('Unable to unpack ', u.FileName^); Halt;
   end;

{$IfDef Debug}
   WriteLn(#13#10'Unpacked successfully.'#13#10);
   HighVideo;
   WriteLn('Note that these messages are now enabled for testing only.'#13#10+
      'They can easily be disabled.');
   LowVideo;
   WriteLn(#13#10'Press any key ...'); ReadKey;
{$EndIf}

   asm
      mov  ax,13h
      int  10h
   end;

   i:=0;
   repeat
      if Odd(i) then u.Seek('ZIPPAS2') else u.Seek('ZIPPAS1');
{ Names should be in upper case ! }

      s.Read(Mem[$A000:0], 64000);

      Delay(1000);
      Inc(i);
   until KeyPressed;
   while KeyPressed do ReadKey;

   asm
      mov  ax,LastMode
      int  10h
   end;

   u.Done;
   s.Done;
end.
