//
// fileview.cpp - J.E.C. File Viewer
// Version - 1.15
// 1/17/95 - 12:48:46am
// Michael Taylor
//
// zpb_begin AppRevisions 
//
// 16/1/95         Version 1.14
//		Second release
// --/1/95         Version 1.13
//		Intermediate version - bug testing only
// 16/11/94        Version 1.12
//      Fixed:	bug in displaying child windows on restore of parent window.
//		bug with restore of parent window having the wrong origin.
//      /94        Version 1.10 and 1.11
//      Added:	wordwrap
//		print setup
//	Rewrote read line and display line parts to aid in
//	supporting wordwrap.
// 18/09/94        Version 1.06
//      Added:	print
//		more icons to toolbar
// 16/08/94        Version 1.05
//      Changed:add '.' to filename if no extension
//		added find and help toolbar items
//  8/08/94        Version 1.04
//      Changed:uses ini file in windows directory if one exists
//      Added:	status bar item that shows rows by cols
// 27/07/94        Version 1.03
//      Fixed:	tidied up redraw and sundry other display bugs
// 19/07/94        Version 1.02
//      Fixed:  bug in file find introduced in Version 1.01
// 08/07/94        Version 1.01
//      Changed:Toolbar icons for open and close.
//              Redesigned dialogs to use zApp Interface Pack objects.
// 03/07/94        Version 1.00 Beta 		   Limited release
//      CONVERTED TO USE ZAPP FACTORY APPLICATION GENERATOR.
//      Fixed:  Lineno counting when doing a find/find next/prev.
//              Bug when displaying file in a window
//      Added:	Status Line, Toolbar.
// 16/06/94        Version 0.33 Beta               Limited release.
// 15/06/94        Version 0.32 Beta               Limited release.
//      Fixed:  Lineno counting.
// 14/06/94        Version 0.31 Beta               Limited release.
//      Fixed:  Revised scrollbar code.
//              Bug that stopped alt-tab key working.
//      Changed:Read file now calculates total lines.
//      Added:  Goto line.
// 10/06/94        Version 0.30 Beta               Limited release.
//      Changed:Make "Restore on DropFiles" the default.
//      Fixed:  When choosing a font the rows and cols is now recalculated.
//              When selecting text the copy menu item is now enabled.
// 09/06/94        Version 0.29 Beta               Limited release.
//      Changed:Source was restructured. The object heirachy was completely
//              changed.
//      Added:  Scrollbars now scroll the text.
//      Bugs:   When selecting text the copy menu item is not enabled.
//              When choosing a font the rows and cols is not recalculated.
// 03/06/94        Version 0.28 Beta               Limited release.
//      Added:  When dropping filenames on to the FileView icon then
//              activate and restore main window.
//              New config options to control adding of scroll bars and
//              restore on dropfile.
//      Fixed:  graying of menus when closing files.        
//      Changed:now uses a zPane instead of a zTextPane - font now changeable,
//              find highlight and selected highlights now stay as expected.
// 01/06/94        Version 0.27 Beta               Limited release.
//      Fixed:  display non-displayable characters as a '.'.
//              help file not found error.
// 18/05/94        Version 0.26 Beta               Limited release.
//      Fixed:  bug introduced in 0.25 which broke find next
//      Updated:help file - filled in some topics - still a lot to do.
// 16/05/94        Version 0.25 Beta               Limited release.
//      Fixed:  bug where shift right would not show certain long lines.
// 10/05/94        Version 0.24 Beta               Limited release.
//      Added:  font selection dialog box. Unfortunately zTextPane does
//              not allow the font to be changed.
//      Changed:move find/find next on to a Search menu.
//              updated the menu graying.
//      Fixed:  Find next not finding something on the first line of a
//              file after a page-up at ctrl-home.
// 09/05/94        Version 0.23 Beta               Limited release.
//      Fixed:  scroll right/left not showing characters that were off
//              the screen!
//              The highlighting was not working for Find/FindNext.
// 08/05/94        Version 0.22 Beta               Limited release.
//      added:  scroll right/left
// 07/05/94        Version 0.21 Beta               unreleased
//      Added:  Regular expression find 
//      updated:The help file was fixed to have contents page and a
//              couple of topics - topics need fleshing out...
//      Fixed:  some of the data was being written wrongly to the inifile.
//              page-up would display empty lines at top of screen.
//              highlighting while dragging with the mouse.
// 05/05/94        Version 0.20 Beta               Limited release.
//      Added:  Copy to clipboard - only does whole lines. Not very clever
//              about the startpoint being later than the endpoint or the
//              endpoint moving back up. Also can only mark current
//              screen i.e. screen doesn't scroll up or down or left or
//              right.
//      Bugs:   some values were not written to the inifile correctly. e.g.
//              editorname and lastsearch value.
//              highlighting is screwy.
// 04/05/94        Version 0.19 Beta               Limited release.
//      Intermediate version - copy was partially coded. Internal
//      restructuring to support highlighting with the mouse.
// 03/05/94        Version 0.18 Beta               Limited release.
//      Changed:Find to use resource file dialog and not common dialog.
//      Fixed:  now opens file window maximised when filename was a command
//              line parameter.
//              configuration dialog to use checkbox instead of
//              radiobutton for the open maximised option.
// 02/05/94        Version 0.17 Beta               Limited release.
//      Added:  options menu and configuration dialog box.
//              open filw windows maximised option.
//              set editor in configuration dialog box.
//              save screen sizes when moved/resized as well as at exit
//      Fixed:  bug with startmaximised overiding show as minimized flag in icon.
// 01/05/94        Version 0.16 Beta               Limited release.
//      Added:  Very Basic Help file.
//              prev window
// 28/04/94        Version 0.15 First Beta         Limited release.
//      Added:  Edit file, Next Window, Close
//      Missing:on-line way to specify editor
//              copy to clipboard
//      Fixed:  Find bug that stopped page-up working after a find-up.
// 27/04/94        Version 0.14 Pre-alpha          Limited release.
//      Added:  Alt-S and Ctrl-S accelerator keys for Find...
//      Changed:inifile to be in executables directory.
//      Fixed:  Now allows multiple instances.
// 26/04/94        Version 0.13 Pre-alpha          Limited release.
//      Added:  Find and Find Next
//      bugs:   No longer allows multiple instances
//              Find/Find Next not quite right.
//              - page-up/line-up do not work after a find in up
//              direction.
//              Match whole word does not do anything.
// 21/04/94        Version 0.12 Pre-alpha          Limited release.
//      Added:  Exit item on File menu
//              Todo.txt file
//      Fixed:  Tidied up accelerator keys
//              Alt-F4 now works when child windows are active.
// 19/04/94        Version 0.11 Pre-alpha          Limited release.
//      Fixed:  display of garbage past end of file
//              Page-up and lineup moving past start of file and showing
//              blank lines.
//      Added:  ctrl-pageup, ctrl-pagedn, ctrl-end, ctrl-home keys to
//              move straight to the top and bottom of the file.
//              Added edit menu - nothing behind the items yet.
// 19/10/93        Version 0.10 Pre-alpha          Initial limited release.
//      Added:  Drag and drop support, up, down, page-up, page-dn keys
//      bugs:   Displays before first line in file (blank lines) if
//              page-up or up are pressed.
//              Displays garbage lines after the end of file.
//              Random junk displayed on screen
//              Alt-F4 does not work if a child window is active (open).
//
// zpb_end 

#include "zapp.hpp"
#include "fileview.hpp"				// Main App Class Definitions & Includes

ZAPP_IMPL_ASSERTS;


// zpb_begin GlobalVars 
// zpb_end 

// ToolBar Member Functions - ToolBar 
tbFileViewToolBar::tbFileViewToolBar(zMDIMarginFrame *w, zSizer *sz, zBitmap *bmp)
	: zToolbar(w, sz) {
	theBmp = bmp;
	(ZNEW zToolButton(this, ZNEW zSizer(zPoint(5,2), zDimension(24,22)),
		0, IDM_FILEOPEN, theBmp, zRect(16, 0, 32, 15)))
		->show();
	(ZNEW zToolButton(this, ZNEW zSizer(zPoint(33,2), zDimension(24,22)),
		0, IDM_FILECLOSE, theBmp, zRect(32, 0, 48, 15)))
		->show();
	enableItem(IDM_FILECLOSE, 0);
	(ZNEW zToolButton(this, ZNEW zSizer(zPoint(63,2), zDimension(24,22)),
		0, IDM_FILEEDITFILE, theBmp, zRect(80, 0, 96, 15)))
		->show();
	enableItem(IDM_FILEEDITFILE, 0);
	(ZNEW zToolButton(this, ZNEW zSizer(zPoint(92,2), zDimension(24,22)),
		0, IDM_FILEPRINT, theBmp, zRect(48, 0, 64, 15)))
		->show();
	enableItem(IDM_FILEPRINT, 0);
	(ZNEW zToolButton(this, ZNEW zSizer(zPoint(121,2), zDimension(24,22)),
		0, IDM_EDITCOPY, theBmp, zRect(64, 0, 80, 15)))
		->show();
	enableItem(IDM_EDITCOPY, 0);
	(ZNEW zToolButton(this, ZNEW zSizer(zPoint(151,2), zDimension(24,22)),
		0, IDM_SEARCHFIND, theBmp, zRect(128, 0, 144, 15)))
		->show();
	enableItem(IDM_SEARCHFIND, 0);
	(ZNEW zToolButton(this, ZNEW zSizer(zPoint(179,2), zDimension(24,22)),
		0, IDM_HELPHELP, theBmp, zRect(112, 0, 128, 15)))
		->show();
	// zpb_begin tbFileViewToolBarConstructor 
	// zpb_end 
}

tbFileViewToolBar::~tbFileViewToolBar() {
	// zpb_begin tbFileViewToolBarDestructor 
	// zpb_end 
	if (theBmp)
		delete theBmp;
} 

//
// Frame Member Functions - FileView 
//
// Window Constructor
WFileView::WFileView(const char *title)
 : zMDIAppFrame(0,ZNEW zSizer(),zSTDFRAME, 
 	title, ZNEW zMenu(zResId(IDM_MDIWindowMenu))) {
	// zpb_begin WFileViewConstructor2 
        char *p;
        FILE *ifn;

        minimised = 0;
        tempx = tempy = -1;
        inifilename = (char *)malloc (MAXSLEN);
        editorname  = (char *)malloc (MAXSLEN);
        szFindWhat  = (char *)malloc (MAXSLEN);
#ifdef WINDOWS
	DragAcceptFiles (hWnd, TRUE);
	setHandler(this, (NotifyProc)&WFileView::DragDrop,WM_DROPFILES);
	// get application ini file name
	// check windows directory first. If no ini file in it
	// then create one in the fileview.exe directory
	memset (inifilename, ' ', MAXSLEN - 1);
	GetWindowsDirectory (inifilename, MAXSLEN - 1);
	strcat (inifilename, "\\fileview.ini");
	if (ifn = fopen (inifilename, "r"))
	        fclose (ifn);
	else {
		GetModuleFileName(app->instance (), inifilename, MAXSLEN - 1);
		for (p = inifilename + MAXSLEN - 1; p > inifilename; --p)
	        	if (*p == '.')
	                	break;
		memcpy (p+1, "ini", 3);	// replace .exe with .ini
	}
	wordwrap =0;
	hexmode = 0;
	// get application ini data
	topleftx = GetPrivateProfileInt ("Window", "TopLeftx", 0, inifilename);
	toplefty = GetPrivateProfileInt ("Window", "TopLefty", 0, inifilename);
	width    = GetPrivateProfileInt ("Window", "Width", 500, inifilename);
	height   = GetPrivateProfileInt ("Window", "Height", 300, inifilename);
	startmaximised = GetPrivateProfileInt ("Window", "Maximised", 0, inifilename);
	openmaximised = GetPrivateProfileInt ("Window", "OpenFilesMax", 0, inifilename);
	addvscroll = GetPrivateProfileInt ("Window", "AddVScroll", 0, inifilename);
	addhscroll = GetPrivateProfileInt ("Window", "AddHScroll", 0, inifilename);
	restore = GetPrivateProfileInt ("General", "RestoreOnDropFile", 1, inifilename);
	findoffset = GetPrivateProfileInt ("Find", "ShowOffset", 3, inifilename);
	matchcase = GetPrivateProfileInt ("Find", "MatchCase", 0, inifilename);
	regexp = GetPrivateProfileInt ("Find", "UseRegExp", 0, inifilename);
	GetPrivateProfileString ("Find", "LastSearch", "",
			szFindWhat, MAXSLEN - 1, inifilename);
	GetPrivateProfileString ("Editor", "Name", "Notepad",
			editorname, MAXSLEN - 1, inifilename);
	GetPrivateProfileString ("Font", "FaceName", "non available", 
			lf.lfFaceName, sizeof (lf.lfFaceName), inifilename);
	lf.lfHeight = GetPrivateProfileInt ("Font", "Height", 0, inifilename);
	lf.lfWidth = GetPrivateProfileInt ("Font", "Width", 0, inifilename);
	lf.lfEscapement = GetPrivateProfileInt ("Font", "Escapement", 0, inifilename);
	lf.lfOrientation = GetPrivateProfileInt ("Font", "Orientation", 0, inifilename);
	lf.lfWeight = GetPrivateProfileInt ("Font", "Weight", 0, inifilename);
	lf.lfItalic = GetPrivateProfileInt ("Font", "Italic", 0, inifilename);
	lf.lfUnderline = GetPrivateProfileInt ("Font", "Underline", 0, inifilename);
	lf.lfStrikeOut = GetPrivateProfileInt ("Font", "StrikeOut", 0, inifilename);
	lf.lfCharSet = GetPrivateProfileInt ("Font", "CharSet", 0, inifilename);
	lf.lfOutPrecision = GetPrivateProfileInt ("Font", "OutPrecision", 0, inifilename);
	lf.lfClipPrecision = GetPrivateProfileInt ("Font", "ClipPrecision", 0, inifilename);
	lf.lfQuality = GetPrivateProfileInt ("Font", "Quality", 0, inifilename);
	lf.lfPitchAndFamily = GetPrivateProfileInt ("Font", "PitchAndFamily", 0, inifilename);
	leftMargin = GetPrivateProfileInt ("PageSetup", "LeftMargin", 5, inifilename);
	rightMargin = GetPrivateProfileInt ("PageSetup", "RightMargin", 5, inifilename);
	topMargin = GetPrivateProfileInt ("PageSetup", "TopMargin", 3, inifilename);
	bottomMargin = GetPrivateProfileInt ("PageSetup", "BottomMargin", 3, inifilename);
	
	if (lf.lfHeight)
		Wfont = ZNEW zFontSpec (&lf);
	else
		Wfont = 0;
	// end of application ini data
	zWindow::move (topleftx, toplefty, width, height);
#else
	memcpy (szFindWhat, ' ', MAXSLEN-1);
     	memset (inifilename, ' ', MAXSLEN - 1);	
	Wfont = 0;
#endif
	// zpb_end 
	menu(ZNEW zMenu(this, zResId(IDM_FileViewMainMenu)));
	menu()->insertDropDown(MDImenu(),"&Window", 5);
	menu()->setCommand(this, (CommandProc)&WFileView::cmdMDIWindow, IDM_CASCADE, IDM_ARRANGEICONS);
	menu()->setCommand(this, (CommandProc)&WFileView::cmdFileOpen, IDM_FILEOPEN);
	menu()->setCommand(this, (CommandProc)&WFileView::cmdFileClose, IDM_FILECLOSE);
	menu()->setCommand(this, (CommandProc)&WFileView::cmdFileEditFile, IDM_FILEEDITFILE);
	menu()->setCommand(this, (CommandProc)&WFileView::cmdFilePrint, IDM_FILEPRINT);
	menu()->setCommand(this, (CommandProc)&WFileView::cmdFilePageSetup, IDM_FILEPAGESETUP);
	menu()->setCommand(this, (CommandProc)&WFileView::cmdFileExit, IDM_FILEEXIT);
	menu()->setCommand(this, (CommandProc)&WFileView::cmdEditCopy, IDM_EDITCOPY);
	menu()->setCommand(this, (CommandProc)&WFileView::cmdEditGotoLine, IDM_EDITGOTOLINE);
	menu()->setCommand(this, (CommandProc)&WFileView::cmdViewWordWrap, IDM_VIEWWORDWRAP);
	menu()->setCommand(this, (CommandProc)&WFileView::cmdViewHexMode, IDM_VIEWHEXMODE);
	menu()->setCommand(this, (CommandProc)&WFileView::cmdSearchFind, IDM_SEARCHFIND);
	menu()->setCommand(this, (CommandProc)&WFileView::cmdSearchFindNext, IDM_SEARCHFINDNEXT);
	menu()->setCommand(this, (CommandProc)&WFileView::cmdSearchFindPrev, IDM_SEARCHFINDPREV);
	menu()->setCommand(this, (CommandProc)&WFileView::cmdOptionsConfiguration, IDM_OPTIONSCONFIGURATION);
	menu()->setCommand(this, (CommandProc)&WFileView::cmdOptionsFont, IDM_OPTIONSFONT);
	menu()->setCommand(this, (CommandProc)&WFileView::cmdHelpAbout, IDM_HELPABOUT);
	menu()->setCommand(this, (CommandProc)&WFileView::cmdHelpHelp, IDM_HELPHELP);
	setIcon(ZNEW zIcon(zResId(IDI_FileView)));
	// Create Tool Bar Margin Frame
	zMDIMarginFrame *ToolFrame = ZNEW zMDIMarginFrame(this,
		ZNEW zGrowToFitSizer(ZGRAV_TOP, sizer()));
	ToolFrame->show();
	pTB = ZNEW tbFileViewToolBar(ToolFrame, ZNEW zGravSizer(ZGRAV_TOP, 26, ToolFrame->sizer()), ZNEW zBitmap(zResId(IDB_ToolBar)));
	pTB->show();
	zMDIMarginFrame *sf=ZNEW zMDIMarginFrame(this,ZNEW zGrowToFitSizer(ZGRAV_BOTTOM,sizer()));
	zStatusLineEZ* pSB = ZNEW zStatusLineEZ(sf, ZNEW zGravSizer(ZGRAV_BOTTOM,0, sf->sizer()), ZSL_CREATEMAINITEM|ZSL_MENUHELPITEM|ZSL_CLOCK);
	sf->show();
	ZNEW zStatusItemText(pSB, ZNEW zGravSizer(ZGRAV_RIGHT, 82, pSB->sizer()), ID_ROWSBYCOLS, ZALIGN_CENTER);
	ZNEW zStatusItemText(pSB, ZNEW zGravSizer(ZGRAV_RIGHT, 158, pSB->sizer()), ID_FILESTATUS, ZALIGN_LEFT);
	pSB->show();
 	sizer()->update();
	// zpb_begin WFileViewConstructor 
	MDImenu()->insertItem (IDM_NEXTWIN, 4, "&Next Window", MF_ENABLED | MF_STRING);
	MDImenu()->insertItem (IDM_PREVWIN, 5, "&Prev Window", MF_ENABLED | MF_STRING);
	menu()->setCommand(this, (CommandProc)&WFileView::cmdNextWin, IDM_PREVWIN);
	menu()->setCommand(this, (CommandProc)&WFileView::cmdNextWin, IDM_NEXTWIN);
	menu()->update ();
	sbar = pSB;
	// zpb_end 
	show();
}

WFileView::~WFileView() {
	// zpb_begin WFileViewDestructor1 
        updateIni ();
	if (inifilename)
	   free (inifilename);
        if (editorname)
           free (editorname);
        if (szFindWhat)
           free (szFindWhat);
	// zpb_end 
}

//
// Menu Item Selection Handlers
//
int WFileView::cmdMDIWindow(zCommandEvt* ev) {
	// zpb_begin WFileViewMDICmds 
	switch (ev->cmd()) {
	case IDM_CASCADE:
		cascade();
		break;
	case IDM_TILE:
		tile();
		break;
	case IDM_ARRANGEICONS:
		arrangeIcons();
		break;
	}
	resetMenu ();
	// zpb_end 
	return 1;
}

int WFileView::cmdFileOpen(zCommandEvt* ev) {
	// zpb_begin WFileViewcmdFileOpen 
	FileView *mFile = ZNEW FileView (this, Wfont, addvscroll, addhscroll);
	if (mFile->tWnd->completed()) {
		mFile->tWnd->Setfindoffset (findoffset);
        	mFile->tWnd->SetWordWrap (wordwrap);
		mFile->show ((openmaximised) ? SW_MAXIMIZE : SW_SHOW);
		resetMenu ();
    	} else 
		delete mFile;
	// zpb_end 
	return 1;
}

int WFileView::cmdFileClose(zCommandEvt* ev) {
	// zpb_begin WFileViewcmdFileClose 
	FileView * FV;
	if (0 != (FV = (FileView *)activeChild ())) {
		close (FV);
	}
	resetMenu ();
	// zpb_end 
	return 1;
}

int WFileView::cmdFileEditFile(zCommandEvt* ev) {
	// zpb_begin WFileViewcmdFileEditFile 
	char cmdstring[256];
	int result;
	FileView * FV;
	char *p, *q;
	
	if (0 != (FV = (FileView *)activeChild ())) {
	    	strcpy (cmdstring, editorname);
	    	strcat (cmdstring, " ");
	    	strcat (cmdstring, FV->tWnd->name ());
#ifdef WINDOWS
		// hack for notepad - add '.' if no extension
		for (q = (p = cmdstring) + strlen (cmdstring); p < q; ++p) {
		        if (*p == '.' && q - p <= 4)
		                break;
		}
		if (*p != '.')
		    	strcat (cmdstring, ".");
		// end hack for notepad
       		result = WinExec (cmdstring, SW_SHOW);
		if (result < 32) {
#else
     		result = system (cmdstring);
     		if (result == -1) {	       		
#endif
		        delete ZNEW zMessage (this, 
			/* message= */	"Could not run editor",  
			/* title=   */	"FileView", 
			MB_OK|MB_ICONINFORMATION);
		} else
		        close (FV);
       	}
	resetMenu ();
	// zpb_end 
	return 1;
}

int WFileView::cmdFilePrint(zCommandEvt* ev) {
	// zpb_begin WFileViewFilePrintPrintDlg 
	zPrinterDisplay *pr=ZNEW zPrinterDisplay;
	if (!pr->isValid()) {
		zMessage msg(this,"No Printer drivers installed","Unable to print");
		delete pr;
		return 1;
	} 
	if (pr->printerSetup()) {
		FileView * FV;
    	
		if (0 != (FV = (FileView *)activeChild ())) {
       			FV->tWnd->pageSetup (leftMargin, rightMargin, topMargin,
       					bottomMargin, Wfont);
       			FV->tWnd->printFile (pr);
       		}
	}
	//zpb_end 

	// zpb_begin WFileViewFilePrint 
	// zpb_end 
	return 1;
}

int WFileView::cmdFilePageSetup(zCommandEvt* ev) {
	DPageSetup* p=ZNEW DPageSetup(this, zResId(IDD_PageSetup));
	p->modal();
	if (p->completed()) {   
		// zpb_begin WFileViewFilePageSetup 
		leftMargin = p->_LeftMargin;
		rightMargin = p->_RightMargin;
		topMargin = p->_TopMargin;
		bottomMargin = p->_BottomMargin;
	        updateIni ();
//MessageBox (0, "1", "FileView", MB_OK);	
		// zpb_end 
	}
	delete p;
	return 1;
}

int WFileView::cmdFileExit(zCommandEvt* ev) {
	// zpb_begin WFileViewFileExit 
	// zpb_end 
	app->quit();
	return 1;
}

int WFileView::cmdEditCopy(zCommandEvt* ev) {
	// zpb_begin WFileViewcmdEditCopy 
	FileView * FV;
    	
	if (0 != (FV = (FileView *)activeChild ()))
       		FV->tWnd->copyToClip ();
	// zpb_end 
	return 1;
}

int WFileView::cmdEditGotoLine(zCommandEvt* ev) {
	DGotoDialog* p=ZNEW DGotoDialog(this, zResId(IDD_GotoDialog));
	p->modal();
	if (p->completed()) {   
		// zpb_begin WFileViewEditGotoLine 
		FileView * FV;
       		if (0 != (FV = (FileView *)activeChild ())) {
	        	FV->tWnd->moveToLineNo (p->_Lineno);
			FV->tWnd->setpageStart ();
	        	FV->tWnd->ShowCurrPage ();
	        	FV->tWnd->ResetScrollPos ();
		}
		resetMenu ();
		// zpb_end 
	}
	delete p;
	return 1;
}

int WFileView::cmdViewWordWrap(zCommandEvt* ev) {
	// zpb_begin WFileViewcmdViewWordWrap 
	FileView * FV;

	wordwrap = 1 - wordwrap;
	if (0 != (FV = (FileView *)activeChild ()))
        	FV->tWnd->SetWordWrap (wordwrap);

	resetMenu ();
	// zpb_end 
	return 1;
}

int WFileView::cmdViewHexMode(zCommandEvt* ev) {
	// zpb_begin WFileViewcmdViewHexMode 
	// zpb_end 
	return 1;
}

int WFileView::cmdSearchFind(zCommandEvt* ev) {
	DFindDialog* p=ZNEW DFindDialog(this, zResId(IDD_FindDialog));
	p->modal();
	if (p->completed()) {   
		// zpb_begin WFileViewSearchFind 
	    	FileView * FV;
	        matchcase = p->_Matchcase;
	        regexp =    p->_Regexp;
	        direction = (p->_UpGroup == ID_UP) ? PREV : NEXT;
		findflags = direction
    			  + matchcase * 0x02
    			  + regexp    * 0x04;
	     	if (0 != (FV = (FileView *)activeChild ())) {
    			if (!FV->tWnd->FindString (p->findstring (),
    					findflags, 0)) {
    				char str[256];
    				sprintf (str, "\"%s\" not found", 
    					p->findstring());
    				delete ZNEW zMessage (this, 
			    	/* message= */	str,
			    	/* title=   */	"Find", 
			    	MB_OK|MB_ICONINFORMATION);
			}
		}
		strcpy (szFindWhat, p->findstring ());
		resetMenu ();
		// zpb_end 
	}
	delete p;
	return 1;
}

int WFileView::cmdSearchFindNext(zCommandEvt* ev) {
	// zpb_begin WFileViewcmdSearchFindNext 
    	FileView * FV;
	findflags = direction
		  + matchcase * 0x02
		  + regexp    * 0x04;
       	if (0 != (FV = (FileView *)activeChild ()))
		if (!FV->tWnd->FindString (szFindWhat, findflags, 1)) {
			char str[256];
			sprintf (str, "\"%s\" not found", szFindWhat);
		    	delete ZNEW zMessage (this, 
	    			/* message= */	str, 
			    	/* title=   */	"Find Next", 
    				MB_OK|MB_ICONINFORMATION);
    			FV->tWnd->ShowCurrPage ();
    		}
	resetMenu ();
	// zpb_end 
	return 1;
}

int WFileView::cmdSearchFindPrev(zCommandEvt* ev) {
	// zpb_begin WFileViewcmdSearchFindPrev 
    	FileView * FV;
	findflags = direction ^ 0x01
		  + matchcase * 0x02
		  + regexp    * 0x04;
       	if (0 != (FV = (FileView *)activeChild ())) 
		if (!FV->tWnd->FindString (szFindWhat, findflags, 2)) {
			char str[256];
			sprintf (str, "\"%s\" not found", szFindWhat);
		    	delete ZNEW zMessage (this, 
    			/* message= */	str,
		    	/* title=   */	"Find", 
    			MB_OK|MB_ICONINFORMATION);
    		}
	resetMenu ();
	// zpb_end 
	return 1;
}

int WFileView::cmdOptionsConfiguration(zCommandEvt* ev) {
	DSetOptions* p=ZNEW DSetOptions(this, zResId(IDD_SetOptions));
	p->modal();
	if (p->completed()) {   
		// zpb_begin WFileViewOptionsConfiguration 
		openmaximised = p->_Openmax;
		restore = p->_Restore;
		addvscroll = p->_Addvscrollbar;
		addhscroll = p->_Addhscrollbar;
		strcpy (editorname, p->_Editorname);
		findoffset = p->_Findoffset;
	        updateIni ();
		// zpb_end 
	}
	delete p;
	return 1;
}

int WFileView::cmdOptionsFont(zCommandEvt* ev) {
	// zpb_begin WFileViewOptionsFontFontDlg 
	zColor fontColor(0,0,0);
	lf.lfPitchAndFamily = FF_DONTCARE | FIXED_PITCH;
	zFontSelForm *fontForm = ZNEW zFontSelForm(this, fontColor, 
					ZNEW zFontSpec (&lf));
	if (fontForm->completed()) {
	        LPLOGFONT lplf;
		zFont *font = ZNEW zFont(*fontForm->fontSpec());
		fontColor = fontForm->color();
		
		Wfont = fontForm->fontSpec();
		        
	        lplf = (LPLOGFONT) *fontForm->fontSpec ();
		        
		strcpy (lf.lfFaceName, lplf->lfFaceName);
		lf.lfHeight      	= lplf->lfHeight;
		lf.lfWidth       	= lplf->lfWidth;
		lf.lfEscapement  	= lplf->lfEscapement;
		lf.lfOrientation 	= lplf->lfOrientation;
		lf.lfWeight 		= lplf->lfWeight;
		lf.lfItalic 		= lplf->lfItalic;
		lf.lfUnderline		= lplf->lfUnderline;
		lf.lfStrikeOut		= lplf->lfStrikeOut;
		lf.lfCharSet		= lplf->lfCharSet;
		lf.lfOutPrecision	= lplf->lfOutPrecision;
		lf.lfClipPrecision	= lplf->lfClipPrecision;
		lf.lfQuality		= lplf->lfQuality;
		lf.lfPitchAndFamily	= lplf->lfPitchAndFamily;
    			
	        updateIni ();
					        
	        FileView *FV = (FileView *)activeChild ();
		if (FV) {
		        FV->tWnd->canvas ()->lock ();
		        FV->tWnd->canvas ()->pushFont (font);
		        FV->tWnd->canvas ()->unlock ();
			FV->tWnd->SetSize (FV->tWnd->sizer()->width (), 
					   FV->tWnd->sizer()->height ());
		        FV->tWnd->ShowCurrPage ();
		}
	}
	delete fontForm;
	resetMenu ();
	//zpb_end 

	// zpb_begin WFileViewOptionsFont 
	// zpb_end 
	return 1;
}

int WFileView::cmdHelpAbout(zCommandEvt* ev) {
	DAboutBox* p=ZNEW DAboutBox(this, zResId(IDD_AboutBox));
	p->modal();
	if (p->completed()) {   
		// zpb_begin WFileViewHelpAbout 
		// zpb_end 
	}
	delete p;
	return 1;
}

int WFileView::cmdHelpHelp(zCommandEvt* ev) {
	// zpb_begin WFileViewcmdHelpHelp 
#ifdef WINDOWS
   	char *p, cmdstring[MAXSLEN];
	int result;
	    	
	memset (cmdstring, ' ', sizeof (cmdstring));
	// get application help file name
	GetModuleFileName(app->instance (), 
			cmdstring, sizeof(cmdstring));
	for (p = cmdstring + sizeof (cmdstring); 
		 p > cmdstring; --p)
	if (*p == '.')
	   	break;
	memcpy (p+1, "hlp", 3);	// replace .exe with .hlp
       	result = WinHelp (hWnd, cmdstring, HELP_CONTENTS, 0L);
	if (!result) {
	    delete ZNEW zMessage (this, 
		/* message= */	"Could not find help file",  
		/* title=   */	"FileView", 
		MB_OK|MB_ICONINFORMATION);
	} 
#else	    
	delete ZNEW zMessage (this, 
	/* message= */	"Sorry no help yet",  
	/* title=   */	"Not Available", 
	MB_OK|MB_ICONINFORMATION);
#endif
	// zpb_end 
	return 1;
}

// zpb_begin WFileViewMemberFunctions 
int WFileView::cmdNextWin(zCommandEvt* ev) {
	FileView * FV;

	switch (ev->cmd()) {
	case IDM_NEXTWIN:
	       	if (0 != (FV = (FileView *)activeChild ()))
    	        	FV->next ();
		break;
	case IDM_PREVWIN:
	       	if (0 != (FV = (FileView *)activeChild  ()))
			if (0 != (FV = (FileView *)FV->prevWin  ()))
	    	        	FV->setActive ();
		break;
	}
	resetMenu ();
	return 1;
}

int WFileView::resetMenu() {
        char str[256];
	FileView * FV = (FileView *)activeChild ();

	menu()->checkItem (IDM_VIEWWORDWRAP, (wordwrap) ? TRUE : FALSE);
	if (FV) {
		menu()->grayItem (IDM_SEARCHFIND, FALSE);
		menu()->grayItem (IDM_SEARCHFINDNEXT, FALSE);
		menu()->grayItem (IDM_SEARCHFINDPREV, FALSE);
		if (FV->tWnd->highlight) {
			menu()->grayItem (IDM_EDITCOPY, FALSE);
			pTB->enableItem(IDM_EDITCOPY, TRUE);
		} else {
			menu()->grayItem (IDM_EDITCOPY, TRUE);
			pTB->enableItem(IDM_EDITCOPY, FALSE);
		}
		menu()->grayItem (IDM_EDITGOTOLINE, FALSE);
		menu()->grayItem (IDM_FILEEDITFILE, FALSE);
		menu()->grayItem (IDM_FILECLOSE, FALSE);
		menu()->grayItem (IDM_FILEPRINT, FALSE);
//		menu()->grayItem (IDM_FILEPAGESETUP, FALSE);
		pTB->enableItem(IDM_FILECLOSE, TRUE);
		pTB->enableItem(IDM_FILEEDITFILE, TRUE);
		pTB->enableItem(IDM_SEARCHFIND, TRUE);
		pTB->enableItem(IDM_FILEPRINT, TRUE);
		// set status line info
		sprintf (str, "Line %ld/%ld Col %d", FV->tWnd->StartLineNo (),
				               	     FV->tWnd->TotalLines (),
					    	     FV->tWnd->Offset () + 1);
		sbar->text (ID_FILESTATUS, str);
		sprintf (str, "%d by %d", FV->tWnd->Rows(), FV->tWnd->Cols());
//MessageBox (0, str, "FileView - 1", MB_OK);	
		sbar->text (ID_ROWSBYCOLS, str);
//sprintf (str, "Rows=%d Cols=%d", FV->tWnd->Rows(), FV->tWnd->Cols());
//MessageBox (0, str, "FileView - 2", MB_OK);	
	} else {
		menu()->grayItem (IDM_SEARCHFIND, TRUE);
		menu()->grayItem (IDM_SEARCHFINDNEXT, TRUE);
		menu()->grayItem (IDM_SEARCHFINDPREV, TRUE);
		menu()->grayItem (IDM_EDITCOPY, TRUE);
		menu()->grayItem (IDM_EDITGOTOLINE, TRUE);
		menu()->grayItem (IDM_FILEEDITFILE, TRUE);
		menu()->grayItem (IDM_FILECLOSE, TRUE);
		menu()->grayItem (IDM_FILEPRINT, TRUE);
//		menu()->grayItem (IDM_FILEPAGESETUP, TRUE);
		pTB->enableItem(IDM_FILECLOSE, FALSE);
		pTB->enableItem(IDM_FILEEDITFILE, FALSE);
		pTB->enableItem(IDM_EDITCOPY, FALSE);
		pTB->enableItem(IDM_SEARCHFIND, FALSE);
		pTB->enableItem(IDM_FILEPRINT, FALSE);
		// set status line info
		sprintf (str, "                      ");
		sbar->text (ID_FILESTATUS, str);
	}	

	return 0;
}

int WFileView::close (FileView *FV) {
        delete FV;
        resetMenu ();
        
	return 0;
}

int WFileView::DragDrop (zEvent* Ev) {
#ifdef WINDOWS
	POINT   gpointDrop = {0,0};  // Point where the files were dropped
	WORD    gwFilesDropped = 0;  // Total number of files dropped
    	HDROP	hFilesInfo;
    	WORD    wIndex;
    	char    szFileName [256];

	hFilesInfo = (HDROP) Ev->parm1 ();

        // Retrieve the window coordinates of the mouse
        // pointer when the drop was made
        DragQueryPoint (hFilesInfo, (LPPOINT) &gpointDrop);

        // Get the total number of files dropped
        gwFilesDropped = DragQueryFile (hFilesInfo,
					   (UINT)-1,
                                           (LPSTR)NULL,
                                           (UINT)0);

        // Retrieve each file name and open it
        for (wIndex=0; wIndex < gwFilesDropped; wIndex++) {
                DragQueryFile (hFilesInfo,
                               wIndex,
                               (LPSTR) szFileName,
                               (UINT)256);

		FileView *mFile = ZNEW FileView (this, Wfont, addvscroll, 
			addhscroll, szFileName);
		if (mFile->tWnd->completed()) {
			mFile->tWnd->Setfindoffset (findoffset);
	        	mFile->tWnd->SetWordWrap (wordwrap);
			mFile->show ((openmaximised) ? SW_MAXIMIZE : SW_SHOW);
		        if (restore && minimised)
		        	showSet (SW_SHOWNORMAL);
			resetMenu ();
	    	} else
			delete mFile;
	} 

        DragFinish (hFilesInfo);
#endif
	return 1;
}

int WFileView::size (zSizeEvt *ev) {
//delete ZNEW zMessage (app->rootWindow(), 
///* message= */	"size",  
///* title=   */	"WFileView", 
//MB_OK|MB_ICONINFORMATION);
	zRect screen;
        minimised = 0;
        if (tempx >= 0) { // NOTE: size () is called after move ()
                	  // so restore topleftx and toplefty 
                	  // just in case window was maximised or minimised
		topleftx = tempx;
		toplefty = tempy;
	}
                
	if (ev->parm1() == SIZE_MAXIMIZED)
	        maximised = 1;
	else if (ev->parm1() != SIZE_MINIMIZED) {
		getExterior (screen);		// get dimension of outer window
		topleftx = screen.topLeft().x();
		toplefty = screen.topLeft().y();
		width    = screen.width();
		height   = screen.height();
	        maximised = 0;
	} else
	        minimised = 1;
        tempx = tempy = -1;

        updateIni ();

	FileView * FV = (FileView *)activeChild ();
	if (FV && openmaximised)
		FV->showSet (SW_SHOWMAXIMIZED);
	return zMDIAppFrame::size (ev);
}

int WFileView::move (zMoveEvt *ev) {
//delete ZNEW zMessage (app->rootWindow(), 
///* message= */	"move",  
///* title=   */	"WFileView", 
//MB_OK|MB_ICONINFORMATION);
	if (!minimised) {
		zRect screen;
		tempx = topleftx;		// save for size method
		tempy = toplefty;

		getExterior (screen);		// get dimension of outer window
		topleftx = screen.topLeft().x();
		toplefty = screen.topLeft().y();

        	updateIni ();
	}
	return zMDIAppFrame::move (ev);
}

void WFileView::updateIni () {
#ifdef WINDOWS
	char saveString[80];
	
	sprintf (saveString, "%d", topleftx);
	WritePrivateProfileString ("Window", "TopLeftx", saveString, inifilename);
	sprintf (saveString, "%d", toplefty);
	WritePrivateProfileString ("Window", "TopLefty", saveString, inifilename);
	sprintf (saveString, "%d", width);
	WritePrivateProfileString ("Window", "Width", saveString, inifilename);
	sprintf (saveString, "%d", height);
	WritePrivateProfileString ("Window", "Height", saveString, inifilename);
	sprintf (saveString, "%d", maximised);
	WritePrivateProfileString ("Window", "Maximised", saveString, inifilename);
	sprintf (saveString, "%d", openmaximised);
	WritePrivateProfileString ("Window", "OpenFilesMax", saveString, inifilename);
	sprintf (saveString, "%d", addvscroll);
	WritePrivateProfileString ("Window", "AddVScroll", saveString, inifilename);
	sprintf (saveString, "%d", addhscroll);
	WritePrivateProfileString ("Window", "AddHScroll", saveString, inifilename);
	sprintf (saveString, "%d", restore);
	WritePrivateProfileString ("General", "RestoreOnDropFile", saveString, inifilename);
	sprintf (saveString, "%d", findoffset);
	WritePrivateProfileString ("Find", "ShowOffset", saveString, inifilename);
	sprintf (saveString, "%d", matchcase);
	WritePrivateProfileString ("Find", "MatchCase", saveString, inifilename);
	sprintf (saveString, "%d", regexp);
	WritePrivateProfileString ("Find", "UseRegExp", saveString, inifilename);
	WritePrivateProfileString ("Find", "LastSearch", szFindWhat, inifilename);
	WritePrivateProfileString ("Editor", "Name", editorname, inifilename);
	
	WritePrivateProfileString ("Font", "FaceName", lf.lfFaceName, inifilename);
	sprintf (saveString, "%d", lf.lfHeight);
	WritePrivateProfileString ("Font", "Height", saveString, inifilename);
	sprintf (saveString, "%d", lf.lfWidth);
	WritePrivateProfileString ("Font", "Width", saveString, inifilename);
	sprintf (saveString, "%d", lf.lfEscapement);
	WritePrivateProfileString ("Font", "Escapement", saveString, inifilename);
	sprintf (saveString, "%d", lf.lfOrientation);
	WritePrivateProfileString ("Font", "Orientation", saveString, inifilename);
	sprintf (saveString, "%d", lf.lfWeight);
	WritePrivateProfileString ("Font", "Weight", saveString, inifilename);
	sprintf (saveString, "%d", lf.lfItalic);
	WritePrivateProfileString ("Font", "Italic", saveString, inifilename);
	sprintf (saveString, "%d", lf.lfUnderline);
	WritePrivateProfileString ("Font", "Underline", saveString, inifilename);
	sprintf (saveString, "%d", lf.lfStrikeOut);
	WritePrivateProfileString ("Font", "StrikeOut", saveString, inifilename);
	sprintf (saveString, "%d", lf.lfCharSet);
	WritePrivateProfileString ("Font", "CharSet", saveString, inifilename);
	sprintf (saveString, "%d", lf.lfOutPrecision);
	WritePrivateProfileString ("Font", "OutPrecision", saveString, inifilename);
	sprintf (saveString, "%d", lf.lfClipPrecision);
	WritePrivateProfileString ("Font", "ClipPrecision", saveString, inifilename);
	sprintf (saveString, "%d", lf.lfQuality);
	WritePrivateProfileString ("Font", "Quality", saveString, inifilename);
	sprintf (saveString, "%d", lf.lfPitchAndFamily);
	WritePrivateProfileString ("Font", "PitchAndFamily", saveString, inifilename);
	sprintf (saveString, "%d", rightMargin);
	WritePrivateProfileString ("PageSetup", "RightMargin", saveString, inifilename);
	sprintf (saveString, "%d", leftMargin);
	WritePrivateProfileString ("PageSetup", "LeftMargin", saveString, inifilename);
	sprintf (saveString, "%d", topMargin);
	WritePrivateProfileString ("PageSetup", "TopMargin", saveString, inifilename);
	sprintf (saveString, "%d", bottomMargin);
	WritePrivateProfileString ("PageSetup", "BottomMargin", saveString, inifilename);
#endif	
}

/* the following function allows other classes to reset the menu without 
   knowing about the parent window class */
void ResetMenu () {
	((WFileView *)app->rootWindow ())->resetMenu ();
}
// zpb_end 


//
// Simple function to center window within parent or screen
//
void centerWindow(zWindow *w, BOOL fOnParent) {
	zRect winRect, parentRect;
	int xWin, yWin;

	w->getExterior(winRect);
	zSystemInfo screen;

	if (fOnParent && w->parent()) {
		// retrieve parent rectangle 
		w->parent()->getExterior(parentRect); 
		
		// center within parent window 
		xWin = parentRect.left() + ((parentRect.width() - winRect.width())/2);
		yWin = parentRect.top() + ((parentRect.height() - winRect.height())/2);
		
		// adjust win x-location for screen size
		if ( xWin+winRect.width() > screen.pixWidth() )
		 	xWin = screen.pixWidth() - winRect.width();
		
		// adjust win y-location for screen size
		if ( yWin+winRect.height() > screen.pixHeight() )
		 	yWin = screen.pixHeight() - winRect.height();
	}
	else {
   	// center within entire screen 
   	xWin = (screen.pixWidth() - winRect.width()) / 2;
   	yWin = (screen.pixHeight() - winRect.height()) / 2;
	}

	// move window to new location
	w->move( (xWin>0) ? xWin : 0,
			(yWin>0) ? yWin : 0,
			winRect.width(),
			winRect.height());
}

//
// Bitmap Pane Member Functions
//
zfBitmapPane::zfBitmapPane(zWindow* w, const zResId &id, zSizer* sz) 
	:	zPane(w, sz), theBitmap(id) {
	show();
}

int zfBitmapPane::draw(zDrawEvt *e) {
	zRect r;
	getInterior(r);		// Draw entire bitmap
	canvas()->lock();

	zBitmapDisplay *bd;
	bd = ZNEW zBitmapDisplay(&theBitmap);
	bd->lock();
	bd->copyTo(canvas(), r.left(), r.top(),
		theBitmap.size().width(), theBitmap.size().height(), 0, 0);
	bd->setBitmap(0);
	bd->unlock();
	delete bd;
	canvas()->unlock();
	return TRUE;
}

// zpb_begin AppUserCode 
// zpb_end 

//
// Application Entry Point
//
void zApp::main() {
	initIntPack();
	// zpb_begin AppMain 
        char *s, *q;
	// zpb_end 
	loadAccelerator(zResId(IDA_fileview));
	WFileView* p=ZNEW WFileView("J.E.C. File Viewer");
	// zpb_begin AppMain2 
     	p->showSet ((p->startmaximised && 
	        !(app->cmdShow() & SW_SHOWMINIMIZED)) ? 
		SW_SHOWMAXIMIZED : app->cmdShow ());
	loadAccelerator (zResId(IDA_Extra));
	 
	// parse command line for each (possible) file name
	q = cmdLine () + strlen (cmdLine());
        for ( s = cmdLine (); s < q; ++s )
        {
        	if (*s != ' ') {
        	        if (*s != '-') {
        	                char f[256], *r;
	        		for (	r = f; 
	        			s < q && *s != ' '; 
	        			*r++ = *s++);
	        		*r = '\0';
				FileView *mFile = ZNEW FileView (p, p->Wfont, 
					p->addvscroll, p->addhscroll, f);
				if (mFile->tWnd->completed()) {
					mFile->show ((p->openmaximised) ? 
						SW_MAXIMIZE : SW_SHOW);
					p->resetMenu ();
				} else
					delete mFile;
        	 	}
        	}
	}
	
	p->resetMenu ();
	
	// zpb_end 
	go();
	delete p;

	// zpb_begin AppMain3 
	// zpb_end 
}
