// MNT - lists and/or mounts Drives in Windows NT
// Version 1.00 (c) 1995, Christoph Hochsttter

#include <windows.h>
#include <string.h>
#include <stdio.h>
#include <winioctl.h>
#include <io.h>
#include <conio.h>
#include "mnt.h"

char zap = FALSE;

void __fastcall chmalloc(void **chpointer, const int bytes)
{
	if (!(*chpointer=malloc(bytes))) {
		fputs("Not enough memory.\n",stderr);
		ExitProcess(94);
	}
}

export char __fastcall ValidDrive(const char *drive)
{
	if ((drive[2] == 0) && (drive[1]==':') \
	&& ((*drive|0x20) > 0x60) && ((*drive|0x20) < 0x7b))
		return TRUE;
	else
		return FALSE;
}

export void __fastcall index(char *stringbuffer, char *stringlist[], register unsigned short *count)
{
	for (*count=0;;(*count)++) {
		stringlist[*count]=stringbuffer;
		while (*(++stringbuffer)!=0);
		if (*(++stringbuffer) == 0) break;
	}
}

export int __fastcall sort(char *stringlist[],const unsigned short count)
{
register char dirty;
register unsigned short i,j;
void *help;

	do {
		dirty=FALSE;
		for (i=1;i<=count;i++) {
			if (!ValidDrive(stringlist[i])) 
				continue;
			else
				j=i;
			if ((!ValidDrive(stringlist[i-1]))||*stringlist[i-1]>*stringlist[i]) {
				help=stringlist[i-1];
				stringlist[i-1]=stringlist[i];
				stringlist[i]=help;
				dirty=TRUE;
			}
		}
	} while (dirty);
	return j;
}

void __fastcall MyQueryDosDevice(const LPCTSTR s1,const LPTSTR s2,const DWORD i)
{
	if (!QueryDosDevice(s1,s2,i)) {
		fputs("QueryDosDevice failed.\n",stderr);
		ExitProcess(95);
	}
}

void __fastcall show(void)
{
register unsigned short i;
char *DeviceBuffer;
unsigned short MaxDevicelist;
char *Devicelist[MaxDosDevices];
char *DeviceItem;
char *CurrentItem;

	chmalloc(&DeviceBuffer,MaxDeviceBuffer);
	chmalloc(&DeviceItem,MaxDeviceItem);

	MyQueryDosDevice(NULL,DeviceBuffer,MaxDeviceBuffer);

	index(DeviceBuffer,Devicelist,&MaxDevicelist);
	MaxDevicelist=sort(Devicelist,MaxDevicelist);
	for (i=0;i<=MaxDevicelist;i++) {
		MyQueryDosDevice(Devicelist[i],DeviceItem,MaxDeviceItem);
		CurrentItem=DeviceItem;
		while (CurrentItem[0] != 0) {
			if (DeviceItem == CurrentItem)
				printf("%s => %s\n",Devicelist[i],CurrentItem);
			else
				printf("      %s\n",CurrentItem);
			CurrentItem+=lstrlen(CurrentItem)+1;
		}
	}
	free(DeviceBuffer);
	free(DeviceItem);
}

__inline void __fastcall DeleteDefinition(const char *drive)
{
char *DeviceItem;

	chmalloc(&DeviceItem,MaxDeviceItem);
	do {
		if (!DefineDosDevice(DDD_REMOVE_DEFINITION,drive,NULL)) {
			fputs("Remove definition failed.\n",stderr);
			ExitProcess(5);
		}
	} while (zap && QueryDosDevice(drive,DeviceItem,MaxDeviceItem));
	free(DeviceItem);
}

void __fastcall Usage(const char *a0)
{
	fprintf(stderr,"Usage: %s [-u | -z] [<drive>: [<Device>]]\n\n",a0);
	fprintf(stderr,"Examples: %s J: \\Dosdevices\\C:\\DOS\n",a0);
	fprintf(stderr,"          %s K: \\Device\\Harddisk0\\Partition1\n",a0);
	fprintf(stderr,"          %s -u L: (deletes current definition of L:)\n",a0);
	fprintf(stderr,"          %s -z M: (deletes all definitions of M:\n",a0);
	ExitProcess(87);
}

int main(int argc, char *argv[], char *envp[])
{

	switch (argc) {
		case 1:
			show();
			break;
		case 3:
		    switch (*argv[1]) {
				case '-':
				case '/':
					if (argv[1][2] != 0) Usage(argv[0]);
					switch (argv[1][1]|0x20) {
						case 'z':
							zap = TRUE;
							break;
						case 'u':
							break;
						default:
							Usage(argv[0]);
							break;
					}
					if (!ValidDrive(argv[2])) Usage(argv[0]);
					DeleteDefinition(argv[2]);
					break;
				default:
					if (!ValidDrive(argv[1])) Usage(argv[0]);
					DefineDosDevice(DDD_RAW_TARGET_PATH,argv[1],argv[2]);
					break;
			}
			break;
		default:
			Usage(argv[0]);
		}
	return 0;
}
