package vrml;

import vrml.Events;
import vrml.Node;
import vrml.Field;
import vrml.fields.*;
import vrml.exceptions.*;

//
// This is the general Script class, to be subclassed by all scripts.
// Note that the provided methods allow the script author to explicitly
// throw tailored exceptions in case something goes wrong in the
// script; thus, the exception codes for those exceptions are to be
// determined by the script author.
//

public abstract class Script implements Node {
  public native void processEvents(Events [] events)
    throws Exception; 
  public abstract void eventsProcessed()
    throws Exception; // Script:code is up to script author

  protected native Field getEventOut(String eventName)
    throws InvalidEventOutException;
  protected native Field getField(String fieldName)
    throws InvalidFieldException;

  public native ConstField getValue(String fieldName)
    throws InvalidFieldException;
  public native void postEventIn(String eventName, Field eventValue)
    throws InvalidEventInException;

}