import vrml.*;
import vrml.fields.*;
import vrml.fields.constfields.*;
import vrml.exceptions.*;

class VaultScript extends Script {

	// Declare fields
	private SFBool currentlyOpen;
	private SFString correctCombination;

	// Declare eventOuts
	private SFBool openVault;
	
	// Initialize fields and eventOuts	
	public VaultScript() throws InvalidFieldException, InvalidEventOutException {
		try {
			currentlyOpen = (SFBool) getField("currentlyOpen");
			correctCombination = (SFString) getField("correctCombination");
			openVault = (SFBool) getEventOut("openVault");
		}
		catch (InvalidFieldException f) {
			throw f;
		}
		catch (InvalidEventOutException e) {
			throw e;
		}
	}
	
	public void eventsProcessed() {
	}

	public void vaultClosed(ConstSFBool value, SFTime ts) {
		currentlyOpen.setValue(false);
	}

	public void combinationEntered(ConstSFString combo, SFTime ts) {
		if (currentlyOpen.getValue() == false &&
		combo.getValue() == correctCombination.getValue()) {
			currentlyOpen.setValue(true);
			openVault.setValue(true);
		}
	}
}

