/*************************************************************************
 *                   MediaView word-breaker API.
 *************************************************************************/

// FWORDCB is the word output callback for MediaView, passed to the word
// breaker's word breaking entry point in the lpfnOutWord member of a
// BRK_PARMS structure.
// After breaking a word, the custom word breaker's word breaking routine 
// must call the callback to pass words back to MediaView.
// during compile time when the compiler is indexing topic
// text and at run time when the MediaView search engine is parsing search 
// queries.

typedef BOOL (FAR PASCAL * FWORDCB)(
                                    LPBYTE lpbRaw,   /* An array of bytes containing
                                                        the raw text. First byte is
                                                        is the text's length.         */
                                    LPBYTE lpbNorm,  /* An array of bytes containing
                                                        the normalized text. First
                                                        byte is the array's length.   */
                                    DWORD dwOffset,  /* Actual offset of the first 
                                                        byte of the text.             */
                                    DWORD dwCBParm   /* Pass the value of the orginal
                                                        BRK_PARMS structure's dwCBParm
                                                        member in this parameter.     */
                                   );

typedef struct BRK_PARMS {
    DWORD    dwReserved;  // Reserved.Can be ignored.
    LPBYTE   lpbBuf;      // An input buffer containing the topic text.
    UINT     nBufCount;   // The size in bytes of the input buffer.
    DWORD    dwBufOffset; // Offset in the source text of the first byte of the input buffer.
    DWORD    dwCBParm;    // Parameter to be passed back to the output word callback.
    FWORDCB  lpfnOutWord; // Output word callback to which to send the normalized word.
    LPBYTE   lpReserved1; // Reserved.Can be ignored.
    LPBYTE   lpReserved2; // Reserved.Can be ignored.
    WORD     wReserved;   // Reserved.Can be ignored.
} BRK_PARMS, FAR *LPBRK_PARMS;


