VERSION 2.00
Begin Form frmDefineBookmark 
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   3  'Fixed Double
   Caption         =   "Define Bookmark"
   ClientHeight    =   3195
   ClientLeft      =   1500
   ClientTop       =   5445
   ClientWidth     =   6810
   Height          =   3720
   Left            =   1440
   LinkTopic       =   "Form2"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   3195
   ScaleWidth      =   6810
   Top             =   4980
   Width           =   6930
   Begin CommandButton cmdDelete 
      Caption         =   "&Delete"
      Enabled         =   0   'False
      Height          =   345
      Left            =   5280
      TabIndex        =   8
      Top             =   1635
      Width           =   1335
   End
   Begin CommandButton cmdAdd 
      Caption         =   "&Add"
      Enabled         =   0   'False
      Height          =   345
      Left            =   5280
      TabIndex        =   7
      Top             =   1065
      Width           =   1335
   End
   Begin CommandButton cmdClose 
      Caption         =   "&Close"
      Height          =   345
      Left            =   5280
      TabIndex        =   6
      Top             =   480
      Width           =   1335
   End
   Begin SSPanel pan3dBookmarks 
      BevelOuter      =   1  'Inset
      Height          =   1665
      Left            =   270
      TabIndex        =   4
      Top             =   1260
      Width           =   4755
      Begin ListBox lbBookmarks 
         Height          =   1590
         Left            =   15
         TabIndex        =   5
         Top             =   15
         Width           =   4725
      End
   End
   Begin SSPanel pan3dName 
      BevelOuter      =   1  'Inset
      Height          =   360
      Left            =   270
      TabIndex        =   1
      Top             =   480
      Width           =   4755
      Begin TextBox ebName 
         Height          =   330
         Left            =   15
         TabIndex        =   2
         Top             =   15
         Width           =   4725
      End
   End
   Begin Label lblBookmarks 
      BackColor       =   &H00C0C0C0&
      BackStyle       =   0  'Transparent
      Caption         =   "&Bookmarks:"
      Height          =   210
      Left            =   270
      TabIndex        =   3
      Top             =   1005
      Width           =   1815
   End
   Begin Label lblName 
      BackColor       =   &H00C0C0C0&
      BackStyle       =   0  'Transparent
      Caption         =   "&New Bookmark Name:"
      Height          =   255
      Left            =   270
      TabIndex        =   0
      Top             =   210
      Width           =   3075
   End
End
Option Explicit

Sub cmdAdd_Click ()
    Dim lTemp As Long

    'Convert the topic number of the current topic to an address
    lTemp = addrConvertTopicNumber(gblhTitle, frmMain.MediaView1.TopicIndex)
    If lTemp = ADDRNIL Then
        'Show the error message
        lTemp = ViewMVError(ERR_BADADDRESS, CStr(frmMain.MediaView1.TopicIndex))
    Else
        'Add the bookmark name and topic address to the list box
        lbBookmarks.AddItem ebName.Text
        lbBookmarks.ItemData(lbBookmarks.NewIndex) = lTemp
    End If
End Sub

Sub cmdClose_Click ()
    Dim nTemp, nCount As Integer
    Dim szFilename As String
    Dim szTemp As String

    Call WaitCursor
    'Get the filename of the currently open M12
    szFilename = frmMain.MediaView1.MediaViewTitle
    
    'Destroy the current bookmark menu
    Call DestroyBookmarkMenu
    'Change the file extension to BMK
    Call ChangeFileExtension(szFilename, BOOKMARKFILE_EXT, True)
    
    'Delete the old bookmark file. However, the file may not exist, which generates an error
    On Error Resume Next
    Kill szFilename
    On Error GoTo 0
    
    If lbBookmarks.ListCount > 0 Then
        'Step through list box and write out bookmarks
        For nCount = 0 To lbBookmarks.ListCount - 1
            'Get the bookmark name
            szTemp = lbBookmarks.List(nCount)
            'Write the bookmark name to the BMK file
            nTemp = WritePrivateProfileString("BOOKMARKS", ByVal Format$(nCount, "0"), ByVal szTemp, szFilename)
            If nTemp = 0 Then
                'Show the error message
                nTemp = ViewMVError(ERR_WRITEBOOKMARK, szTemp)
            Else
                'Get the topic address from the listbox
                szTemp = "ADDR" & Format$(nCount, "0")
                'Write the topic address to the BMK file
                nTemp = WritePrivateProfileString("BOOKMARKS", ByVal szTemp, ByVal Format$(lbBookmarks.ItemData(nCount)), szFilename)
                If nTemp = 0 Then
                    'Show the error message
                    nTemp = ViewMVError(ERR_WRITEBOOKMARK, "Address of bookmark " & lbBookmarks.List(nCount))
                End If
            End If
        Next nCount
    End If
    'Reload the bookmark menu
    Call LoadBookmarkMenu
    'Hide the form to continue execution in calling subroutine
    Me.Visible = False
    Call DefaultCursor
End Sub

Sub cmdDelete_Click ()
    Dim nTemp, nRetVal As Integer
    Dim szFilename As String

    Call WaitCursor
    nTemp = lbBookmarks.ListIndex
    
    'Remove bookmark from list box
    lbBookmarks.RemoveItem nTemp
    
    If lbBookmarks.ListCount = 0 Then
        'No more bookmarks, so disable Delete button
        cmdDelete.Enabled = False
    Else
        'This takes care of making sure the proper item gets selected after
        'an item is removed from the list box
        If nTemp > lbBookmarks.ListCount - 1 Then nTemp = nTemp - 1
        lbBookmarks.ListIndex = nTemp
    End If
    Call DefaultCursor
End Sub

Sub ebName_Change ()
    'If there is text in the ebName edit box, enable the Add button
    cmdAdd.Enabled = (ebName.Text <> "")
End Sub

Sub Form_Load ()
    
    'Load all bookmarks into the listbox
    Call LoadAllBookmarks(lbBookmarks)
    pan3dBookmarks.Height = lbBookmarks.Height + 30
    Me.Height = pan3dBookmarks.Top + pan3dBookmarks.Height + 750
    Me.Move frmMain.Left + (frmMain.Width - Me.Width) / 2, frmMain.Top + (frmMain.Height - Me.Height) / 2
End Sub

Sub Form_QueryUnload (Cancel As Integer, UnloadMode As Integer)
    'Stops an error if user closes form from control menu
    Cancel = (UnloadMode <> 1)
    Me.Visible = False
End Sub

Sub lbBookmarks_Click ()
    cmdDelete.Enabled = True
End Sub

