#ifdef __cplusplus
extern "C" {
#endif

/*****************************************************************************
*                                                                            *
*  MVEW12.H                                                                  *
*                                                                            *
*  Copyright (C) Microsoft Corporation 1990-1994.                            *
*  All Rights reserved.                                                      *
*                                                                            *
******************************************************************************
*                                                                            *
*  Module Intent                                                             *
*                                                                            *
*  Information regarding MediaView Embedded Window DLL handling.             *
*                                                                            *
*****************************************************************************/

#if defined(__MVEW12_H__)
#error MVEW12.H included more than once.
#else

/*****************************************************************************
* Use the following in window functions supporting embedded windows.         *
*****************************************************************************/

#define EWM_RESERVED1        0x706A
#define EWM_QUERYSIZE        0x706B
#define EWM_ASKPALETTE       0x706C
#define EWM_RESERVED2        0x706D
#define EWM_PRINT            0x706F
#define EWM_COPY             0x7070
#define EWM_ASKHOTSPOTS      0x7071
#define EWM_ACTIVATE         0x7072

// Structure pointed to by the parameter, lParam, passed to the
// window procedure controlling the embedded window upon receiving
// the EWM_PRINT or EWM_COPY messages.

typedef struct tagRenderInfo {
  RECT  rc;
  HDC   hdc;
} RENDERINFO, FAR * QRI, FAR *LPRENDERINFO;

// Callback type needed for mac so it will pass parameters.
typedef void (CALLBACK* MVCBPROC)();

// Structure passed to the window proceedure controlling the embedded
// window upon its creation.  This structure is pointed to by the
// lpCreateParams field of the structure, CREATESTRUCT, pointed to
// by the parameter, lParam, passed to the WM_CREATE message of the
// window proceedure controlling the embedded window.

typedef struct tagCreateInfo {
  short    idMajVersion;          // For MediaView, this field is set to 0.
  short    idMinVersion;          // For MediaView, this field is set to 2.
  LPSTR    szFileName;            // Current MediaView file
  LPSTR    szAuthorData;          // Text passed by the author
  HANDLE   hfs;                   // Handle to the current file system
  DWORD    coFore;                // Foreground color for this topic
  DWORD    coBack;                // Background color for this topic
  DWORD    dwFlags;               // Information flags (see below)
  MVCBPROC lpfnHotspotCallback;   // Hotspot Callback Function
  LPVOID   lpHotspotCallbackData; // Hotspot Callback Data
} EWDATA, FAR *QEWDATA, FAR *LPEWDATA;

// Values set in the EWDATA structure's dwFlags field giving
// information about the embedded window being created.

#define EWF_PRINT 0x00000001     // Embedded window is for printing
#define EWF_COPY  0x00000002     // Embedded window is for copying

/*****************************************************************************
* End of section regarding window functions supporting embedded windows.     *
*****************************************************************************/

#endif     /* !defined(__MVEW12_H__) */

#ifdef __cplusplus
}
#endif
