{$X+}

{
 Example program to show the use of:
  - GetImage
  - PutImage
  - ImageSize
}

PROGRAM example2;
USES
	VGraph,Crt;

CONST
	radius = 40;
   buffer = 3;

VAR
	i,j	: INTEGER;
   pal	: PaletteType;
   MaxX,MaxY : INTEGER;
   MaxColor	: LONGINT;

   x,y	: INTEGER;
   oldx 		: ARRAY[0..buffer-1] OF Integer;
   oldy		: ARRAY[0..buffer-1] OF Integer;
   circ		: POINTER;
   circsize	: WORD;
   flagx,flagy : BOOLEAN;

PROCEDURE NewXY(VAR x,y : INTEGER);
BEGIN
	IF flagx THEN BEGIN
   	IF x+radius < MaxX THEN
      	Inc(x)
      ELSE
      	flagx := FALSE;
   END
	ELSE BEGIN
   	IF x-radius > 0 THEN
      	Dec(x)
      ELSE
      	flagx := TRUE;
   END;
   IF flagy THEN BEGIN
   	IF y+radius < MaxY THEN
      	Inc(y)
      ELSE
      	flagy := FALSE;
   END
	ELSE BEGIN
   	IF y-radius > 0 THEN
      	Dec(y)
      ELSE
      	flagy := TRUE;
   END;
END;

BEGIN
{	InitVesa(V320x200x64k);					{ We need a mode with 3 pages }
	InitVesa(V640x480x256);
   MaxX := GetMaxX;
   MaxY := GetMaxY;
   MaxColor := GetMaxColor;
   SetWriteMode(XorPut);
   NewPal(pal);

   { Draw an object - invisible }
   SetVisualPage(1);
   x := MaxX DIV 2;
   y := MaxY DIV 2;
   FOR i := 0 TO radius DO BEGIN
   	SetColor(255);
      Circle(x,y,i);
   END;
   { Get object to memory }
   circsize := ImageSize(x-radius,y-radius,x+radius,y+radius);
   GetMem(circ,CircSize);
   GetImage(x-radius,y-radius,x+radius,y+radius,circ^);
   ClearDevice;
   SetVisualPage(0);

   { Draw a background }
   FOR i := 0 TO MaxY DO BEGIN
   	SetColor(i);
      FOR j := 0 TO buffer-1 DO BEGIN
   		SetActivePage(j);
      	LineH(0,i,MaxX,i);
      END;
   END;
   SetTextStyle(DefaultFont,HorizDir,4);
   SetTextJustify(CenterText,CenterText);
   SetColor(MaxColor);
   FOR j := 0 TO buffer-1 DO BEGIN
   	SetActivePage(j);
      OutTextXY(MaxX DIV 2,MaxY DIV 2,'Double/tripple!');
   END;

   { Let's start ! }
   FOR i := 0 TO buffer-1 DO BEGIN
   	SetActivePage(i);
   	PutImage(x-radius,y-radius,x+radius,y+radius,circ^);
   	oldx[i] := x;
   	oldy[i] := y;
   END;

   { Animate object }
   REPEAT
   	FOR i := 0 TO buffer-1 DO BEGIN
   		{ Delete old object }
      	SetActivePage(i);
      	PutImage(oldx[i]-radius,oldy[i]-radius,oldx[i]+radius,oldy[i]+radius,circ^);
   		{ Draw new object }
      	NewXY(x,y);
      	PutImage(x-radius,y-radius,x+radius,y+radius,circ^);
      	oldx[i] := x;
   		oldy[i] := y;
      	{ Make it visiable }
      	SetVisualPage(i);
         pushpal(pal);
      END;
   UNTIL KeyPressed;

   ReadKey;
   CloseVesa;
   FreeMem(circ,circsize);
END.