program PHANTOM_3D_ENGINE;
uses vga256,crt;
const SCRWIDTH=320;
      MWIDTH=128;
      MCENTRE=64;
      SIZE=160;           { veelvoud van 2!! }
      LINES=70;           { aantal lijnen voor vloer (MAX. 70) }
      KIM=29;             { hoogte tussen plafond en vloer }
      XPOS=0;
      DARK=1;             { donker in de verte }
      DIST=3500;          { 1769 voor SIZE=320 }

var s1,o1,s3,o3: word;
    p1,p3,font1: pointer;
    c,i,x,y,width: word;
    a1,a2,a3,x1,y1: word;
    sy,ss,w,bg: real;
    f: file;
    sn,cs: array[0..360] of real;
    a: char;
    b,q: byte;
    s,d,x2,y2,x3,y3,r,v: integer;
    cset: string;
    px,py: array[0..360] of integer;
    quit: boolean;
    t: array[0..32] of string[33];

procedure DummySource(var p: pointer);
var i,s,o,x: word;
    r,m: array[0..63] of string[64];
    t: string;
    q,w: word;
Function Conv(s: char): byte;
var i: byte;
begin
   for i:=1 to length(cset) do if cset[i]=s then Conv:=i;
end;

begin
   s:=Seg(p^);
   o:=Ofs(p^);
   Cset:='abcde$_@1234#[]&ABlDEFiHIjKLMNOPQRSTUnmxYZ*?.{u5678/0o-k :~';

   m[ 0]:='###########################################################&&&&&';
   m[ 1]:='###########################################################&&&&&';
   m[ 2]:='###........############################::..#..@:::::::::3##&&&&&';
   m[ 3]:='###........a##########################b:@..#..             {{{&&';
   m[ 4]:='###........::::::::::::::::::::::::::::::..#..@            {{{&&';
   m[ 5]:='###........:::@:@:@:@:@:@:@:@:@:@:@:@:@:@..#..             {{{&&';
   m[ 6]:='###........:::                           .....@:::::::::1#&{{{&&';
   m[ 7]:='###........::: ::                        .....:::::::::x##&{{{&&';
   m[ 8]:='###........### ::                        .....@::::::::x##&{{{&&';
   m[ 9]:='###........###         :::@:@:@:@:@:@:   .....:::::::::x##&{{{&&';
   m[10]:='###...........                           .....:::::::::x##&{{{&&';
   m[11]:='###...........         #2                .....:::::::::x##&{{{&&';
   m[12]:='###...........        1##                .....:::::::::x##&{{{&&';
   m[13]:='###...........BIZAR  1###~~~~~~~~cd::::::.....:::::::::x##&{{{&&';
   m[14]:='###:~~~~~~~...      1####~~~~~~~~##::::::#####:::::::::x##&{{{&&';
   m[15]:='###:~~~--~~...     1#####~~~&&~~~##::::::#####::::::ad:x##&{{{&&';
   m[16]:='###:~~~~~~~...    1######~~~~~~~~##::::::#####::::::ab:x##&{{{&&';
   m[17]:='##############c~~~#################                    x##&{{{&&';
   m[18]:='###############~~~3################                    x##&&&&&&';
   m[19]:='###############~~~~3######4~~~~3###____                x##&&&&&&';
   m[20]:='###############2~~~~3####4~~~~~~3##::::::c###d::    :::x##&&&&&&';
   m[21]:='           #####2~~~~3###~~@  @~~##::::::#####::    :::x##&&&&&&';
   m[22]:='           ######2~~~~~~~~~ 56 ~~###############----######&&&&&&';
   m[23]:='           #######2~~~~~~~~ 78 ~~###############----######&&&&&&';
   m[24]:='           #############d~~@  @~~##&&-------------------------&&';
   m[25]:=' PHANTOM   ##############2~~~~~~1##&&-------0--o------------o-&&';
   m[26]:=' 3DSPACE   ###############2~~~~1###&&--------------0----0----0&&';
   m[27]:='                         ##2~~1####&&----0------0----------o--&&';
   m[28]:=' world created on 5 may  ###ux#####&&--------0---o--o-----0000&&';
   m[29]:=' in the year of the Lord ###ux#####&&----------------0----0[[0&&';
   m[30]:='   1994, for the Bizar   ###~~#####&&-----------0------0--0[[0&&';
   m[31]:='    demo competition     ##4~~3####&&------0--o-----o----o0000&&';
   m[32]:='                         ##~~~~####&&-------------0--------o--&&';
   m[33]:='          ----           ##~~~~####&&&&&&&&&&&&&&&&&&&&&&&&&&&&&';
   m[34]:='                         ##~~~~####&&&&&&&&&&&&&&&&&&&&&&&&&&&&&';
   m[35]:='            ###############~~~~#################################';
   m[36]:='            ##############b~~~~#################################';
   m[37]:='     #########~~~~~~~~~~~~~~~~~###~~~~~~~~3############~~~######';
   m[38]:='     ########b~~@~~@~~@~~@~@~~~a#b~~ ~~~~~~3##########b~@~a#####';
   m[39]:='     ###~~~~~~~~~~~~~~~~~ ~ ~~~~~~~~~~~~~~~~~~~~~:~~~~~~~~~~3###';
   m[40]:='     ###~~~~~:~~~~~~~~~:~ ~ ~~~~ ~~~~~cd~~~:~~~~~~~~~~ ~~~~~~$##';
   m[41]:='     ###~~~~~~~~~~~ ~~~~~ ~ ~~~~~~~~~~ab~~~~~~~~~~~~~~~~~~~~~$##';
   m[42]:='     ###~~~~~~~~~_~~~_~~~_~ ~_~~~_~~_~~~~_~~~_~~~_~~~_~~~_~~1###';
   m[43]:='     ###~~~~~~c#################################################';
   m[44]:='     ###~ ~~~~#&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&';
   m[45]:='     ###~~~~~~#&----------------0-o-0-0---0---o--0-----------&&&';
   m[46]:='     ###2~~~~~#&0---o-----o--------0-0-0----------------00---&&&';
   m[47]:='     ####d~~ ~#&-------------0--o---0-0-----o-----0-----00---&&&';
   m[48]:='     #####~~~~#&--0-----o---------------0------------o-------&&&';
   m[49]:='     ####b~~~~#&o----------------o-------o-----o-----------o-&&&';
   m[50]:='     ###4~~~~~#&-o---o--0-----0------0------------------o----&&&';
   m[51]:='     ###~~~~~~#&----------------------o----------------------&&&';
   m[52]:='     ###~~~ ~~#&0---o------o--------------o-----o---------o--&&&';
   m[53]:='     ###~~~~~~#&--o--0-----------00--------------------0-----&&&';
   m[54]:='     ###~~~~~~&&-------o---------00-----o---------o----------&&&';
   m[55]:='     ###~~~~~~&&--0---------o-----------------0----0-0-0-0-0-&&&';
   m[56]:='     ###~~@~~~&&---------0----o-----o-----------0-o-0-0-0-0-0&&&';
   m[57]:='     ###~~~56~]]---o----------------------o----o-o-0-0-0-0-0-&&&';
   m[58]:='     ###~~~78~[[0-----o----0------o---0------o---0--0-0-0-0-0&&&';
   m[59]:='     ###~~@~~~&&-o-------o-----0---------------0---0-0-0-0-0-&&&';
   m[60]:='     ###~~~~~~&&----0------------o-------0----o-o-0-0-0-0-0-0&&&';
   m[61]:='     ###______&&------------0-----o--0------0------0-0-0-0-0-&&&';
   m[62]:='     #########&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&';
   m[63]:='     #########&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&';

   r[ 0]:='                                                                ';
   r[ 1]:='                                                                ';
   r[ 2]:='   ///////////////////////////////////////*?*////////////////m  ';
   r[ 3]:='   ///////////////////////////////////////*?*////////////////m  ';
   r[ 4]:='   /////////lllllllllllllllllllllllllll///*?*////////////////m  ';
   r[ 5]:='   ///////////////////////////////////////*?*////////////////m  ';
   r[ 6]:='   ///////////////////////////////////////*?*//////////////k/m  ';
   r[ 7]:='   ///////////////////////////////////////*?*//////////////k/m  ';
   r[ 8]:='   ///////////////////////////////////////*?*//////////////k/m  ';
   r[ 9]:='   ///////////////////////////////////////*?*//////////////k/m  ';
   r[10]:='   ///////////////////////////////////////*?*//////////////k/m  ';
   r[11]:='   ///////////////////////////////////////*?*//////////////k/m  ';
   r[12]:='   ///////////////////////////////////////*?*//////////////k/m  ';
   r[13]:='   ///////////////////////////////////////*?*//////////////k/m  ';
   r[14]:='   ////nn///////////////////nn//////////m/////k////////////k/m  ';
   r[15]:='   ///m**k/////////////////m**k/////////m/////k////////////k/m  ';
   r[16]:='   ////ll///////////////////ll//////////m/////k////////////k/m  ';
   r[17]:='               //////              //////lllll/////////////k/m  ';
   r[18]:='               //////    jjjjjjjj  ///////////////////////////  ';
   r[19]:='               //////   jjjjjjjjjj //////nnnnn////////////////  ';
   r[20]:='               ///////  jj*iiii*jj /////m/////m///////////////  ';
   r[21]:='               ///////??jjiiiiiijj /////m/////m///////////////  ';
   r[22]:='               ///////??jjii**iijj /////////////----//////////  ';
   r[23]:='               ///////??jjii**iijj /////////////----//////////  ';
   r[24]:='                        jjiiiiiijj //-------------------------  ';
   r[25]:='                        jj*iiii*jj //-------------------o-----  ';
   r[26]:='                         jjjjjjjj  //----------------o--------  ';
   r[27]:='                          jjjjjj   //-----------o---------0-0-  ';
   r[28]:='                           ????    //--------------------o-0-0  ';
   r[29]:='                           ????    //---------------o--o--0-0-  ';
   r[30]:='                           ////    //----------------------0-0  ';
   r[31]:='                           ////    //--------------o----o-0-0-  ';
   r[32]:='                           k//m      -----------------o----0-0  ';
   r[33]:='                           k//m                                 ';
   r[34]:='                           k//m                                 ';
   r[35]:='                           k//m                                 ';
   r[36]:='                           ////                                 ';
   r[37]:='              /////////////////   ///////////        ///////    ';
   r[38]:='             /////////////////// /////////////      ///lll///   ';
   r[39]:='        ?/////////////////////////////nn////ll/ll/ll//////////  ';
   r[40]:='        /////////?*?*?*?*?*?/////////m//k/////////////////////  ';
   r[41]:='        //*/*////////////////////////m//k/////////////////////  ';
   r[42]:='        //////////n//n//n//n//n//n////ll//////////////////////  ';
   r[43]:='        //*/*//                                                 ';
   r[44]:='        //////                                                  ';
   r[45]:='        //*/*/  ---------------------------------------------   ';
   r[46]:='        //////  ---------------------------------------------   ';
   r[47]:='        //////  ---------------------------------------------   ';
   r[48]:='        //////  ---------------------------------------------   ';
   r[49]:='        //////  ---------------------------------------------   ';
   r[50]:='        //////  ---------------------------------------------   ';
   r[51]:='        //////  ---------------------------------------------   ';
   r[52]:='        //*/*/  ---------------------------------------------   ';
   r[53]:='   -----//////  ---------------------------------------------   ';
   r[54]:='   -----//*/*/  ---------------------------------------------   ';
   r[55]:='   -----//////  ---------------------------------------------   ';
   r[56]:='   -----//////  ---------------------------------------------   ';
   r[57]:='   -----///////?---------------------------------------------   ';
   r[58]:='   -----///////?---------------------------------------------   ';
   r[59]:='   -----//////  ---------------------------------------------   ';
   r[60]:='   -----//////  ---------------------------------------------   ';
   r[61]:='   -----??????  ---------------------------------------------   ';
   r[62]:='                                                                ';
   r[63]:='                                                                ';

   q:=32*MWIDTH+32+o;
   w:=q+16384;
   for i:=0 to 63 do begin
      for x:=0 to 63 do begin
         mem[s:q+x]:=Conv(m[i][x]);
         mem[s:w+x]:=Conv(r[i][x]);
      end;
      inc(q,MWIDTH);
      inc(w,MWIDTH);
   end;
end;

procedure ConvertBitmap(s,o,n: word);
var x,y,a: word;
begin
   a:=n*1024+o;
   for x:=16 to 47 do for y:=16 to 47 do
      mem[s:a+(x mod 32)+(y mod 32)*32]:=mem[s:o+x+(y-16)*32-16];
end;

function Pixel(s,o: word; x,y: byte): byte;
begin
   Pixel:=0;
   if mem[s:o+x*4+y*128]=31 then Pixel:=1
end;

procedure MakeOutlines(s,o: word);
var z: byte;
    x,y,i,q,w: word;
begin
   for x:=1 to 7 do for y:=1 to 7 do begin
      q:=x*4-2+((y*4)-2)*32+o;
      if mem[s:q+34]=31 then begin
         z:=Pixel(s,o,x,y-1)+2*Pixel(s,o,x+1,y)+4*Pixel(s,o,x,y+1)+8*Pixel(s,o,x-1,y);
         if not (odd(z)) then meml[s:q]:=$8080808;
         if (z=1) or (z=4) or (z=5) or (z=8) or (z=9) or (z=12) or (z=13) or (z=0) then begin
            mem[s:q+35]:=8;
            mem[s:q+67]:=8;
            mem[s:q+99]:=8;
            mem[s:q+3]:=8;
         end;
         if (z=1) or (z=3) or (z=2) or (z=8) or (z=9) or (z=10) or (z=11) or (z=0) then
            meml[s:q+96]:=$8080808;
         if (z<8) then begin
            mem[s:q+32]:=8;
            mem[s:q+64]:=8;
            mem[s:q+96]:=8;
            mem[s:q]:=8;
         end;
      end;
   end;
end;

procedure MChar(b: byte; c: string; var s,o: word);
var i,x,y,x1,y1,a: word;
    t: char;
begin
   for i:=0 to 1023 do mem[s:o+i]:=random(3)+10;
   for y:=1 to 7 do for x:=1 to 7 do begin
     t:=c[y*8+x-8];
      if t='*' then for x1:=x*4-2 to x*4+1 do for y1:=y*4-2 to y*4+1 do
         mem[s:o+x1+y1*32]:=31;
   end;
   MakeOutlines(s,o);
   ConvertBitmap(s,o,b);
end;

procedure Wall(n: byte; t: string; s,o: word);
var i: byte;
begin
   for i:=0 to 31 do mem[s:o+i*32+n]:=ord(t[i+1])-ord('a');
end;

procedure ConvertSpecial(s,o,n: word);
var a,x,y: word;
begin
   for x:=0 to 31 do for y:=0 to 31 do begin
      if t[y][x+1]='o' then mem[s:x+y*32]:=0;
      if t[y][x+1]='-' then mem[s:x+y*32]:=random(3)+5;
      if t[y][x+1]='=' then mem[s:x+y*32]:=random(3)+10;
      if ((t[y][x+1]>='a') and (t[y][x+1]<'o'))
         then mem[s:x+y*32]:=ord(t[y][x+1])-ord('a');
   end;
   ConvertBitmap(s,o,n);
end;

procedure DummyBitmaps(var p: pointer);
var x,y,i,s,o,a,c: word;
    b: array[0..31] of string[32];
begin
   s:=Seg(p^);
   o:=Ofs(p^);
   {clear all bitmaps}
   for i:=0 to 256*63 do meml[s:o+i shl 2]:=0;
   {special bitmap 1:  }
   t[ 0]:='oooooooooooooooooooooooooooooooo';
   t[ 1]:='oooooooooooooooooooooooooooooooo';
   t[ 2]:='oooooooooooooooooooooooooooooooo';
   t[ 3]:='oooooooooooooooooooooooooooooooo';
   t[ 4]:='oooooooooooooooooooooooooooooooo';
   t[ 5]:='oooooooooooooooooooooooooooooooo';
   t[ 6]:='oooooooooooooooooooooooooooooooo';
   t[ 7]:='oooooooooooooooooooooooooooooooo';
   t[ 8]:='oooooooooooooooooooooooooooooooo';
   t[ 9]:='oooooooooooooooooooooooooooooooo';
   t[10]:='oooooooooooooooooooooooooooooooo';
   t[11]:='oooooooooooooooooooooooooooooooo';
   t[12]:='oooooooooooooooooooooooooooooooo';
   t[13]:='oooooooooooooooooooooooooooooooo';
   t[14]:='oooooooooooooooooooooooooooooooo';
   t[15]:='oooooooooooooooooooooooooooooooo';
   t[16]:='-ooooooooooooooooooooooooooooooo';
   t[17]:='-ooooooooooooooooooooooooooooooo';
   t[18]:='-ooooooooooooooooooooooooooooooo';
   t[19]:='--oooooooooooooooooooooooooooooo';
   t[20]:='--oooooooooooooooooooooooooooooo';
   t[21]:='---ooooooooooooooooooooooooooooo';
   t[22]:='---ooooooooooooooooooooooooooooo';
   t[23]:='----oooooooooooooooooooooooooooo';
   t[24]:='-----ooooooooooooooooooooooooooo';
   t[25]:='------oooooooooooooooooooooooooo';
   t[26]:='-------ooooooooooooooooooooooooo';
   t[27]:='--------oooooooooooooooooooooooo';
   t[28]:='---------ooooooooooooooooooooooo';
   t[29]:='-----------ooooooooooooooooooooo';
   t[30]:='-------------ooooooooooooooooooo';
   t[31]:='----------------oooooooooooooooo';
   ConvertSpecial(s,o,1);
   {special bitmap 2:  }
   t[ 0]:='oooooooooooooooooooooooooooooooo';
   t[ 1]:='oooooooooooooooooooooooooooooooo';
   t[ 2]:='oooooooooooooooooooooooooooooooo';
   t[ 3]:='oooooooooooooooooooooooooooooooo';
   t[ 4]:='oooooooooooooooooooooooooooooooo';
   t[ 5]:='oooooooooooooooooooooooooooooooo';
   t[ 6]:='oooooooooooooooooooooooooooooooo';
   t[ 7]:='oooooooooooooooooooooooooooooooo';
   t[ 8]:='oooooooooooooooooooooooooooooooo';
   t[ 9]:='oooooooooooooooooooooooooooooooo';
   t[10]:='oooooooooooooooooooooooooooooooo';
   t[11]:='oooooooooooooooooooooooooooooooo';
   t[12]:='oooooooooooooooooooooooooooooooo';
   t[13]:='oooooooooooooooooooooooooooooooo';
   t[14]:='oooooooooooooooooooooooooooooooo';
   t[15]:='oooooooooooooooooooooooooooooooo';
   t[16]:='oooooooooooooooooooooooooooooooo';
   t[17]:='ooooooooooooooooooooooooooooooo-';
   t[18]:='ooooooooooooooooooooooooooooooo-';
   t[19]:='ooooooooooooooooooooooooooooooo-';
   t[20]:='oooooooooooooooooooooooooooooo--';
   t[21]:='oooooooooooooooooooooooooooooo--';
   t[22]:='ooooooooooooooooooooooooooooo---';
   t[23]:='ooooooooooooooooooooooooooooo---';
   t[24]:='oooooooooooooooooooooooooooo----';
   t[25]:='ooooooooooooooooooooooooooo-----';
   t[26]:='oooooooooooooooooooooooooo------';
   t[27]:='ooooooooooooooooooooooooo-------';
   t[28]:='oooooooooooooooooooooooo--------';
   t[29]:='oooooooooooooooooooooo----------';
   t[30]:='oooooooooooooooooooo------------';
   t[31]:='ooooooooooooooooo---------------';
   ConvertSpecial(s,o,2);
   {special bitmap 3:  }
   t[ 0]:='-----------------ooooooooooooooo';
   t[ 1]:='--------------oooooooooooooooooo';
   t[ 2]:='------------oooooooooooooooooooo';
   t[ 3]:='----------oooooooooooooooooooooo';
   t[ 4]:='--------oooooooooooooooooooooooo';
   t[ 5]:='-------ooooooooooooooooooooooooo';
   t[ 6]:='------oooooooooooooooooooooooooo';
   t[ 7]:='-----ooooooooooooooooooooooooooo';
   t[ 8]:='----oooooooooooooooooooooooooooo';
   t[ 9]:='---ooooooooooooooooooooooooooooo';
   t[10]:='---ooooooooooooooooooooooooooooo';
   t[11]:='--oooooooooooooooooooooooooooooo';
   t[12]:='--oooooooooooooooooooooooooooooo';
   t[13]:='-ooooooooooooooooooooooooooooooo';
   t[14]:='-ooooooooooooooooooooooooooooooo';
   t[15]:='-ooooooooooooooooooooooooooooooo';
   t[16]:='oooooooooooooooooooooooooooooooo';
   t[17]:='oooooooooooooooooooooooooooooooo';
   t[18]:='oooooooooooooooooooooooooooooooo';
   t[19]:='oooooooooooooooooooooooooooooooo';
   t[20]:='oooooooooooooooooooooooooooooooo';
   t[21]:='oooooooooooooooooooooooooooooooo';
   t[22]:='oooooooooooooooooooooooooooooooo';
   t[23]:='oooooooooooooooooooooooooooooooo';
   t[24]:='oooooooooooooooooooooooooooooooo';
   t[25]:='oooooooooooooooooooooooooooooooo';
   t[26]:='oooooooooooooooooooooooooooooooo';
   t[27]:='oooooooooooooooooooooooooooooooo';
   t[28]:='oooooooooooooooooooooooooooooooo';
   t[29]:='oooooooooooooooooooooooooooooooo';
   t[30]:='oooooooooooooooooooooooooooooooo';
   t[31]:='oooooooooooooooooooooooooooooooo';
   ConvertSpecial(s,o,3);
   {special bitmap 4: round corner }
   t[ 0]:='oooooooooooooooo----------------';
   t[ 1]:='ooooooooooooooooooo-------------';
   t[ 2]:='ooooooooooooooooooooo-----------';
   t[ 3]:='ooooooooooooooooooooooo---------';
   t[ 4]:='oooooooooooooooooooooooo--------';
   t[ 5]:='ooooooooooooooooooooooooo-------';
   t[ 6]:='oooooooooooooooooooooooooo------';
   t[ 7]:='ooooooooooooooooooooooooooo-----';
   t[ 8]:='oooooooooooooooooooooooooooo----';
   t[ 9]:='ooooooooooooooooooooooooooooo---';
   t[10]:='ooooooooooooooooooooooooooooo---';
   t[11]:='oooooooooooooooooooooooooooooo--';
   t[12]:='oooooooooooooooooooooooooooooo--';
   t[13]:='ooooooooooooooooooooooooooooooo-';
   t[14]:='ooooooooooooooooooooooooooooooo-';
   t[15]:='ooooooooooooooooooooooooooooooo-';
   t[16]:='oooooooooooooooooooooooooooooooo';
   t[17]:='oooooooooooooooooooooooooooooooo';
   t[18]:='oooooooooooooooooooooooooooooooo';
   t[19]:='oooooooooooooooooooooooooooooooo';
   t[20]:='oooooooooooooooooooooooooooooooo';
   t[21]:='oooooooooooooooooooooooooooooooo';
   t[22]:='oooooooooooooooooooooooooooooooo';
   t[23]:='oooooooooooooooooooooooooooooooo';
   t[24]:='oooooooooooooooooooooooooooooooo';
   t[25]:='oooooooooooooooooooooooooooooooo';
   t[26]:='oooooooooooooooooooooooooooooooo';
   t[27]:='oooooooooooooooooooooooooooooooo';
   t[28]:='oooooooooooooooooooooooooooooooo';
   t[29]:='oooooooooooooooooooooooooooooooo';
   t[30]:='oooooooooooooooooooooooooooooooo';
   t[31]:='oooooooooooooooooooooooooooooooo';
   ConvertSpecial(s,o,4);
   {special bitmap 5: }
   {special bitmap 6: Wall decoration }
   t[ 0]:='oooooooooooooooooooooooooooooooo';
   t[ 1]:='--oooooooooooooooooooooooooooooo';
   t[ 2]:='------------oooooooooooooooooooo';
   t[ 3]:='-------------------ooooooooooooo';
   t[ 4]:='-----------------------ooooooooo';
   t[ 5]:='-------------------------ooooooo';
   t[ 6]:='---------------------------ooooo';
   t[ 7]:='----------------------------oooo';
   t[ 8]:='-----------------------------ooo';
   t[ 9]:='---------cccccc---------------oo';
   t[10]:='------ccccccccccc--------------o';
   t[11]:='----ccccoooooooccc-------------o';
   t[12]:='---cccooooooooooocc------------o';
   t[13]:='--cccooooooooooooocc------------';
   t[14]:='--ccooooooooooooooocc-----------';
   t[15]:='-ccoooooooooooooooooc-----------';
   t[16]:='-ccoooooooooooooooooc-----------';
   t[17]:='-ccoooooooooooooooooc-----------';
   t[18]:='-ccoooooooooooooooooc-----------';
   t[19]:='--ccooooooooooooooocc-----------';
   t[20]:='---ccooooooooooooocc------------';
   t[21]:='----ccoooooooooooccc-----------o';
   t[22]:='-----cccoooooooccc-------------o';
   t[23]:='------ccccccccccc-------------oo';
   t[24]:='--------ccccccc--------------ooo';
   t[25]:='---------------------------ooooo';
   t[26]:='-------------------------ooooooo';
   t[27]:='----------------------oooooooooo';
   t[28]:='------------------oooooooooooooo';
   t[29]:='------------oooooooooooooooooooo';
   t[30]:='--oooooooooooooooooooooooooooooo';
   t[31]:='oooooooooooooooooooooooooooooooo';
   ConvertSpecial(s,o,6);
   {special bitmap 7: Small square on wall }
   for x:=0 to 31 do for y:=0 to 31 do mem[s:o+x+y*32]:=random(3)+10;
   for x:=10 to 20 do for y:=22 to 31 do mem[s:o+x+y*32]:=0;
   ConvertBitmap(s,o,7);
   {special bitmap 8: Round pilar (yes yes) }
   t[ 0]:='-------------oooooo-------------';
   t[ 1]:='----------oooooooooooo----------';
   t[ 2]:='--------oooooooooooooooo--------';
   t[ 3]:='-------oooooooooooooooooo-------';
   t[ 4]:='------oooooooooooooooooooo------';
   t[ 5]:='-----oooooooooooooooooooooo-----';
   t[ 6]:='----oooooooooooooooooooooooo----';
   t[ 7]:='---oooooooooooooooooooooooooo---';
   t[ 8]:='--oooooooooooooooooooooooooooo--';
   t[ 9]:='--oooooooooooooooooooooooooooo--';
   t[10]:='-oooooooooooooooooooooooooooooo-';
   t[11]:='-oooooooooooooooooooooooooooooo-';
   t[12]:='-oooooooooooooooooooooooooooooo-';
   t[13]:='oooooooooooooooooooooooooooooooo';
   t[14]:='oooooooooooooooooooooooooooooooo';
   t[15]:='oooooooooooooooooooooooooooooooo';
   t[16]:='oooooooooooooooooooooooooooooooo';
   t[17]:='oooooooooooooooooooooooooooooooo';
   t[18]:='oooooooooooooooooooooooooooooooo';
   t[19]:='-oooooooooooooooooooooooooooooo-';
   t[20]:='-oooooooooooooooooooooooooooooo-';
   t[21]:='-oooooooooooooooooooooooooooooo-';
   t[22]:='--oooooooooooooooooooooooooooo--';
   t[23]:='--oooooooooooooooooooooooooooo--';
   t[24]:='---oooooooooooooooooooooooooo---';
   t[25]:='----oooooooooooooooooooooooo----';
   t[26]:='-----oooooooooooooooooooooo-----';
   t[27]:='------oooooooooooooooooooo------';
   t[28]:='-------oooooooooooooooooo-------';
   t[29]:='--------oooooooooooooooo--------';
   t[30]:='----------oooooooooooo----------';
   t[31]:='-------------oooooo-------------';
   ConvertSpecial(s,o,8);
   {special bitmap 9: 45 degree wall, north-west }
   for x:=0 to 31 do for y:=0 to 31 do mem[s:o+x+y*32]:=random(3)+5;
   for y:=0 to 31 do for c:=(31-y) to 31 do mem[s:o+c+y*32]:=0;
   ConvertBitmap(s,o,9);
   {special bitmap 10: 45 degree wall, north-east }
   for x:=0 to 31 do for y:=0 to 31 do mem[s:o+x+y*32]:=random(3)+5;
   for y:=0 to 31 do for c:=0 to y do mem[s:o+c+y*32]:=0;
   ConvertBitmap(s,o,10);
   {special bitmap 11: 45 degree wall, south-east }
   for x:=0 to 31 do for y:=0 to 31 do mem[s:o+x+y*32]:=random(3)+5;
   for y:=0 to 31 do for c:=y to 31 do mem[s:o+c+y*32]:=0;
   ConvertBitmap(s,o,11);
   {special bitmap 12: 45 degree wall, south-west }
   for x:=0 to 31 do for y:=0 to 31 do mem[s:o+x+y*32]:=random(3)+5;
   for y:=0 to 31 do for c:=0 to (31-y) do mem[s:o+c+y*32]:=0;
   ConvertBitmap(s,o,12);
   {special bitmap 13: Light wall }
   for x:=0 to 31 do for y:=0 to 31 do mem[s:o+x+y*32]:=0;
   ConvertBitmap(s,o,13);
   {special bitmap 14: elevator door 1 }
   for x:=0 to 31 do for y:=0 to 31 do mem[s:o+x+y*32]:=0;
   ConvertBitmap(s,o,14);
   {special bitmap 15: elevator door 2 }
   for x:=0 to 31 do for y:=0 to 31 do mem[s:o+x+y*32]:=0;
   ConvertBitmap(s,o,15);
   {special bitmap 16: muur }
   for x:=0 to 31 do for y:=0 to 31 do mem[s:o+x+y*32]:=0;
   ConvertBitmap(s,o,16);
   {Make a characterset }
   MChar(17,'---*--- --***-- -**-**- **---** ******* **---** **---**',s,o); {A}
   MChar(18,'*****-- **--**- **---** ******- **---** **--**- *****--',s,o); {B}
   {Ceiling texture - TL-2 }
   for x:=0 to 31 do for y:=0 to 31 do mem[s:o+x+y*32]:=random(3)+16;
   for x:=0 to 31 do mem[s:o+x]:=18;
   for x:=0 to 31 do mem[s:o+x+31*32]:=18;
   for y:=0 to 31 do mem[s:o+y*32]:=18;
   for y:=0 to 31 do mem[s:o+y*32+31]:=18;
   for x:=3 to 9 do for y:=3 to 28 do mem[s:o+y+x*32]:=1;
   for x:=4 to 8 do for y:=4 to 26 do mem[s:o+y+x*32]:=31;
   ConvertBitmap(s,o,19);
   { Rest of font }
   MChar(20,'*****-- **--**- **---** **---** **---** **--**- *****--',s,o); {D}
   MChar(21,'******* **----- **----- *****-- **----- **----- *******',s,o); {E}
   MChar(22,'******* **----- **----- *****-- **----- **----- **-----',s,o); {F}
   {Nice ceiling texture}
   for x:=0 to 31 do for y:=0 to 31 do mem[s:o+x+y*32]:=18;
   for x:=2 to 29 do for y:=2 to 29 do mem[s:o+x+y*32]:=19;
   ConvertBitmap(s,o,23);
   {Rest of font}
   MChar(24,'**---** **---** **---** ******* **---** **---** **---**',s,o); {H}
   MChar(25,'-*****- --***-- --***-- --***-- --***-- --***-- -*****-',s,o); {I}
   {Nice ceiling texture}
   for x:=0 to 31 do for y:=0 to 31 do mem[s:o+x+y*32]:=18;
   for x:=2 to 29 do for y:=2 to 29 do mem[s:o+x+y*32]:=20;
   ConvertBitmap(s,o,26);
   {Rest of font}
   MChar(27,'**--**- **-**-- ****--- ***---- ****--- **-**-- **--**-',s,o); {K}
   MChar(28,'**----- **----- **----- **----- **----- **----- *******',s,o); {L}
   MChar(29,'**---** **---** ***-*** ***-*** ******* ******* **-*-**',s,o); {M}
   MChar(30,'**---** **---** ***--** ****-** **-**** **--*** **---**',s,o); {N}
   MChar(31,'-*****- **---** **---** **---** **---** **---** -*****-',s,o); {O}
   MChar(32,'******- **---** **---** ******- **----- **----- **-----',s,o); {P}
   MChar(33,'-*****- **---** **---** **---** **---** **--*** -******',s,o); {Q}
   MChar(34,'******- **---** **---** ******- **-**-- **--**- *----**',s,o); {R}
   MChar(35,'-*****- **---** **----- -*****- -----** **---** -*****-',s,o); {S}
   MChar(36,'******* --***-- --***-- --***-- --***-- --***-- --***--',s,o); {T}
   MChar(37,'**---** **---** **---** **---** **---** **---** -*****-',s,o); {U}
   {Ceiling texture - TL-3 }
   for x:=0 to 31 do for y:=0 to 31 do mem[s:o+x+y*32]:=random(3)+16;
   for x:=0 to 31 do mem[s:o+x]:=18;
   for x:=0 to 31 do mem[s:o+x+31*32]:=18;
   for y:=0 to 31 do mem[s:o+y*32]:=18;
   for y:=0 to 31 do mem[s:o+y*32+31]:=18;
   for x:=22 to 28 do for y:=3 to 28 do mem[s:o+y+x*32]:=1;
   for x:=23 to 27 do for y:=4 to 26 do mem[s:o+y+x*32]:=31;
   ConvertBitmap(s,o,38);
   {Ceiling texture - TL-4 }
   for x:=0 to 31 do for y:=0 to 31 do mem[s:o+x+y*32]:=random(3)+16;
   for x:=0 to 31 do mem[s:o+x]:=18;
   for x:=0 to 31 do mem[s:o+x+31*32]:=18;
   for y:=0 to 31 do mem[s:o+y*32]:=18;
   for y:=0 to 31 do mem[s:o+y*32+31]:=18;
   for x:=22 to 28 do for y:=3 to 28 do mem[s:o+x+y*32]:=1;
   for x:=23 to 27 do for y:=4 to 26 do mem[s:o+x+y*32]:=31;
   ConvertBitmap(s,o,39);
   { bitmap 40: Red-white stripes (right) }
   for x:=0 to 15 do for y:=0 to 31 do mem[s:o+x+y*32]:=random(3)+5;
   for x:=16 to 31 do for y:=0 to 15 do mem[s:o+x+y*32]:=2;
   for x:=16 to 31 do for y:=16 to 31 do mem[s:o+x+y*32]:=31;
   ConvertBitmap(s,o,40);
   { Rest of font }
   MChar(41,'**---** **---** -**-**- -**-**- --***-- --***-- --***--',s,o); {Y}
   MChar(42,'******* -----** ----**- ---**-- --**--- -**---- *******',s,o); {Z}
   {Ceiling texture - Big lamp }
   for x:=0 to 31 do for y:=0 to 31 do mem[s:o+x+y*32]:=random(3)+16;
   for x:=0 to 31 do mem[s:o+x]:=18;
   for x:=0 to 31 do mem[s:o+x+31*32]:=18;
   for y:=0 to 31 do mem[s:o+y*32]:=18;
   for y:=0 to 31 do mem[s:o+y*32+31]:=18;
   for x:=4 to 28 do for y:=4 to 28 do mem[s:o+x+y*32]:=1;
   for x:=6 to 26 do for y:=6 to 26 do mem[s:o+x+y*32]:=31;
   ConvertBitmap(s,o,43);
   {Ceiling texture - Airco }
   for x:=0 to 31 do for y:=0 to 31 do mem[s:o+x+y*32]:=random(3)+16;
   for x:=0 to 31 do mem[s:o+x]:=18;
   for x:=0 to 31 do mem[s:o+x+31*32]:=18;
   for y:=0 to 31 do mem[s:o+y*32]:=18;
   for y:=0 to 31 do mem[s:o+y*32+31]:=18;
   for x:=2 to 29 do for y:=2 to 29 do mem[s:o+x+y*32]:=1;
   for i:=0 to 5 do for x:=0 to 3 do for y:=4 to 27 do mem[s:o+x+i*4+y*32+4]:=x+20;
   ConvertBitmap(s,o,44);
   { bitmap 45: lavastroompje (wordt naar links gescrolld) }
   c:=24;
   for x:=0 to 31 do for y:=0 to 31 do begin
      mem[s:o+x+y*32]:=c;
      if random(4)=1 then begin inc(c); if c=27 then c:=24 end;
   end;
   ConvertBitmap(s,o,45);
   {bitmap 46: Dark Checkers }
   for x:=0 to 15 do for y:=0 to 15 do mem[s:o+x+y*32]:=random(2)+20;
   for x:=0 to 15 do for y:=16 to 31 do mem[s:o+x+y*32]:=random(2)+21;
   for x:=16 to 31 do for y:=0 to 15 do mem[s:o+x+y*32]:=random(2)+21;
   for x:=16 to 31 do for y:=16 to 31 do mem[s:o+x+y*32]:=random(2)+20;
   ConvertBitmap(s,o,46);
   { bitmap 47: Red-white stripes }
   for x:=16 to 31 do for y:=0 to 31 do mem[s:o+x+y*32]:=random(3)+5;
   for x:=0 to 15 do for y:=0 to 15 do mem[s:o+x+y*32]:=31;
   for x:=0 to 15 do for y:=16 to 31 do mem[s:o+x+y*32]:=2;
   ConvertBitmap(s,o,47);
   {bitmap 59: Checkers }
   for x:=0 to 15 do for y:=0 to 15 do mem[s:o+x+y*32]:=random(3)+5;
   for x:=0 to 15 do for y:=16 to 31 do mem[s:o+x+y*32]:=random(3)+10;
   for x:=16 to 31 do for y:=0 to 15 do mem[s:o+x+y*32]:=random(3)+10;
   for x:=16 to 31 do for y:=16 to 31 do mem[s:o+x+y*32]:=random(3)+5;
   ConvertBitmap(s,o,59);
   {Bitmap 48-51: Big sign on floor (behind elevator doors) }
   {uses the information at [s3:o3] of the last bitmap}
   t[ 0]:='--------------------------======';
   t[ 1]:='----------------------==========';
   t[ 2]:='-------------------=============';
   t[ 3]:='-----------------========-------';
   t[ 4]:='---------------======-----------';
   t[ 5]:='--------------=====-------------';
   t[ 6]:='-------------====---------------';
   t[ 7]:='------------===-----------------';
   t[ 8]:='----------====------------------';
   t[ 9]:='---------====-------------------';
   t[10]:='--------====--------------------';
   t[11]:='-------====---------------------';
   t[12]:='-------===----------------------';
   t[13]:='------===-------================';
   t[14]:='-----===--------================';
   t[15]:='-----===--------================';
   t[16]:='----===---------================';
   t[17]:='---===----------================';
   t[18]:='---===----------=======---------';
   t[19]:='--===-----------=======---------';
   t[20]:='--===-----------=======---------';
   t[21]:='--===-----------=======---------';
   t[22]:='-===------------=======---------';
   t[23]:='-===------------=======---------';
   t[24]:='-===------------=======---------';
   t[25]:='===-------------=======---------';
   t[26]:='===-------------=======---------';
   t[27]:='===-------------=======---------';
   t[28]:='===-------------=======---------';
   t[29]:='===-------------=======---------';
   t[30]:='===-------------================';
   t[31]:='===-------------================';
   ConvertSpecial(s,o,48);
   {49}
   t[ 0]:='======--------------------------';
   t[ 1]:='==========----------------------';
   t[ 2]:='=============-------------------';
   t[ 3]:='-----==========-----------------';
   t[ 4]:='---------=======----------------';
   t[ 5]:='------------=====---------------';
   t[ 6]:='--------------=====-------------';
   t[ 7]:='---------------=====------------';
   t[ 8]:='-----------------====-----------';
   t[ 9]:='------------------=====---------';
   t[10]:='-------------------=====--------';
   t[11]:='---------------------===--------';
   t[12]:='----------------------===-------';
   t[13]:='===========-----------====------';
   t[14]:='=============----------====-----';
   t[15]:='==============----------===-----';
   t[16]:='===============----------===----';
   t[17]:='================---------====---';
   t[18]:='--------========----------===---';
   t[19]:='----------======-----------===--';
   t[20]:='-----------======----------===--';
   t[21]:='------------=====----------===--';
   t[22]:='------------=====-----------===-';
   t[23]:='------------=====-----------===-';
   t[24]:='------------=====-----------===-';
   t[25]:='------------=====-----------===-';
   t[26]:='------------=====------------===';
   t[27]:='-----------======------------===';
   t[28]:='----------======-------------===';
   t[29]:='--------========-------------===';
   t[30]:='================-------------===';
   t[31]:='===============--------------===';
   ConvertSpecial(s,o,49);
   {50}
   t[ 0]:='===-------------================';
   t[ 1]:='===-------------================';
   t[ 2]:='===-------------================';
   t[ 3]:='===-------------=======---------';
   t[ 4]:='===-------------=======---------';
   t[ 5]:='===-------------=======---------';
   t[ 6]:='-===------------=======---------';
   t[ 7]:='-===------------=======---------';
   t[ 8]:='-===------------=======---------';
   t[ 9]:='-===------------=======---------';
   t[10]:='--===-----------=======---------';
   t[11]:='--===-----------=======---------';
   t[12]:='--===-----------=======---------';
   t[13]:='---===----------=======---------';
   t[14]:='---===----------=======---------';
   t[15]:='----===---------=======---------';
   t[16]:='----====--------=======---------';
   t[17]:='-----====-----------------------';
   t[18]:='------===-----------------------';
   t[19]:='------====----------------------';
   t[20]:='-------====---------------------';
   t[21]:='--------====--------------------';
   t[22]:='---------====-------------------';
   t[23]:='----------====------------------';
   t[24]:='-----------=====----------------';
   t[25]:='-------------====---------------';
   t[26]:='--------------=====-------------';
   t[27]:='---------------======-----------';
   t[28]:='-----------------========-------';
   t[29]:='-------------------=============';
   t[30]:='----------------------==========';
   t[31]:='--------------------------======';
   ConvertSpecial(s,o,50);
   {51}
   t[ 0]:='==============---------------===';
   t[ 1]:='=============----------------===';
   t[ 2]:='===========------------------===';
   t[ 3]:='-----------------------------===';
   t[ 4]:='-----------------------------===';
   t[ 5]:='----------------------------====';
   t[ 6]:='----------------------------===-';
   t[ 7]:='----------------------------===-';
   t[ 8]:='----------------------------===-';
   t[ 9]:='---------------------------====-';
   t[10]:='---------------------------===--';
   t[11]:='--------------------------====--';
   t[12]:='--------------------------====--';
   t[13]:='--------------------------===---';
   t[14]:='-------------------------====---';
   t[15]:='-------------------------===----';
   t[16]:='------------------------====----';
   t[17]:='-----------------------====-----';
   t[18]:='----------------------====------';
   t[19]:='----------------------===-------';
   t[20]:='---------------------====-------';
   t[21]:='--------------------====--------';
   t[22]:='-------------------====---------';
   t[23]:='------------------====----------';
   t[24]:='----------------=====-----------';
   t[25]:='---------------====-------------';
   t[26]:='-------------=====--------------';
   t[27]:='----------=======---------------';
   t[28]:='------=========-----------------';
   t[29]:='=============-------------------';
   t[30]:='==========----------------------';
   t[31]:='======--------------------------';
   ConvertSpecial(s,o,51);
   {Bitmap 52: Ceiling texture }
   for x:=0 to 31 do for y:=0 to 31 do mem[s:o+x+y*32]:=random(3)+16;
   for x:=0 to 31 do mem[s:o+x]:=18;
   for x:=0 to 31 do mem[s:o+x+31*32]:=18;
   for y:=0 to 31 do mem[s:o+y*32]:=18;
   for y:=0 to 31 do mem[s:o+y*32+31]:=18;
   ConvertBitmap(s,o,52);
   {bitmap 53: Red square }
   for x:=0 to 31 do for y:=0 to 31 do mem[s:o+x+y*32]:=2;
   ConvertBitmap(s,o,53);
   {bitmap 54: Small red square }
   for x:=0 to 15 do for y:=0 to 15 do mem[s:o+x+y*32]:=2;
   ConvertBitmap(s,o,54);
   {bitmap 55: Black square }
   for x:=0 to 31 do for y:=0 to 31 do mem[s:o+x+y*32]:=1;
   ConvertBitmap(s,o,55);
   {bitmap 56: Ceiling - TL 1 }
   for x:=0 to 31 do for y:=0 to 31 do mem[s:o+x+y*32]:=random(3)+16;
   for x:=0 to 31 do mem[s:o+x]:=18;
   for x:=0 to 31 do mem[s:o+x+31*32]:=18;
   for y:=0 to 31 do mem[s:o+y*32]:=18;
   for y:=0 to 31 do mem[s:o+y*32+31]:=18;
   for x:=3 to 9 do for y:=3 to 28 do mem[s:o+x+y*32]:=1;
   for x:=4 to 8 do for y:=4 to 26 do mem[s:o+x+y*32]:=31;
   ConvertBitmap(s,o,56);
   {bitmap 57: Ordinary tile - light version }
   for x:=0 to 31 do for y:=0 to 31 do mem[s:o+x+y*32]:=random(3)+5;
   ConvertBitmap(s,o,57);
   {bitmap 58: Ordinary tile - darker version }
   for x:=0 to 31 do for y:=0 to 31 do mem[s:o+x+y*32]:=random(3)+10;
   ConvertBitmap(s,o,58);
   {wall-bitpattern: vertical line colors for special blocks (1-16) }
   Wall( 0,'nnnnnnnnnnnnnnnnnnnnnnnnnnoooppp',s,o);   { black walls }
   Wall( 1,'nnnnnnnnnnnnnnnnnnnnnnnnnnoooppp',s,o);   { door        }
   Wall( 2,'nnnnnnnnnnnnnnnnnnnnnnnnnnoooppp',s,o);
   Wall( 3,'nnnnnnnnnnnnnnnnnnnnnnnnnnoooppp',s,o);
   Wall( 4,'                                ',s,o);   { film doek   }
   Wall( 5,'pppppppppooooooooooooonnnnnnnnnn',s,o);   { wall decor  }
   Wall( 6,'tttttttttttttttttttttttttttttttt',s,o);   { wood blocks }
   Wall( 7,'nnnopponnnopponnnopponnnopponnnp',s,o);   { pilars }
   Wall( 8,'nnnnnnnnnnnnnnnnnnnnnnnnnnoooppp',s,o);   { 45 degree 1 }
   Wall( 9,'nnnnnnnnnnnnnnnnnnnnnnnnnnoooppp',s,o);   { 45 degree 2 }
   Wall(10,'nnnnnnnnnnnnnnnnnnnnnnnnnnoooppp',s,o);   { 45 degree 3 }
   Wall(11,'nnnnnnnnnnnnnnnnnnnnnnnnnnoooppp',s,o);   { 45 degree 4 }
   Wall(12,'nnnnnnnnnnnnnnnnnnnnnnnnnnoooppp',s,o);   { normal wall }
   Wall(13,'iiiiiiiiiiiiiiiijjjijiiiiiiijjjj',s,o);   { elevator door}
   Wall(14,'iiiiiiiiiiiiiiiijjjijiiiiiiijjjj',s,o);   { elevator door}
   Wall(15,'aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa',s,o);   { black wall  }
end;

procedure MakeTransTabel(r: word);
var s,o: word;
    w,sy,x1,y1: real;
    yb,yc,y,a2,x,a3,a4: word;
    x2,y2,x3,y3: real;
    f: file;
    hg: byte;
begin
   w:=SIZE div 2;
   a4:=o1+r*560+32768;
   r:=r*2;
   hg:=2*LINES+KIM+3;
   for y:=0 to LINES do begin
      y1:=(((65536*500)/w)-65536*3.125)/(-4);
      yb:=round(y1/-DIST);
      yc:=round(yb div 32)*32;
      x2:=MCENTRE*65536-(cs[r]*(SIZE div 2)*65536)/w-sn[r]*y1;
      y2:=65536*64+cs[r]*y1-(sn[r]*(SIZE div 2)*65536)/w;
      memw[s1:a4+y*8]:=round(x2/128);
      memw[s1:a4+y*8+2]:=round(y2/128);
      x3:=65536*MCENTRE+cs[r]*(65536*((SIZE div 2)-1))/w-sn[r]*y1-x2;
      y3:=65536*64+cs[r]*y1+sn[r]*(65536*((SIZE div 2)-1))/w-y2;
      memw[s1:a4+y*8+4]:=round(x3/SIZE);
      memw[s1:a4+y*8+6]:=round(y3/SIZE);
      w:=w-(SIZE/160);    { ongeveer 145 voor 65 regels }
      memw[s3:o3+y*2+65350]:=yc+yc shl 8;
      memw[s3:o3+y*2+64600]:=round(65536/hg);
      dec(hg,2);
   end;
end;

procedure Initialize;
begin
    clrscr;
    Writeln('Calculating new data... Wait a second.');
    for i:=0 to 360 do begin
       sn[i]:=sin((i*3.14159)/180);
       cs[i]:=cos((i*3.14159)/180);
    end;

    GetMem(p1,65535);
    GetMem(p3,65535);

    DummyBitmaps(p3);
    s3:=Seg(p3^);
    o3:=Ofs(p3^);
    DummySource(p1);
    s1:=Seg(p1^);
    o1:=Ofs(p1^);
    for i:=0 to 44 do MakeTransTabel(i);

    assign(f,'3dspace.wad');
    rewrite(f,1);
    BlockWrite(f,p1^,65535);
    BlockWrite(f,p3^,65535);
    close(f);

    Writeln('New datafile saved.');
end;

begin
  Initialize;
end.
