Unit Krush2;

Interface
uses dos;

type palname     =  array [0..255,0..2] of byte;
     virtua      =  array[0..64000] of byte;
     virpnt      =  ^virtua;

var  fseg, fofs  :  word;
     virscr      :  virpnt;
     virseg      :  word;


procedure screenmode (mode:byte);
procedure svgamode (svga:word);
procedure retrace;
procedure putpixel (x,y:word ; col:byte);
procedure Fast (x,y : word; col:byte);
function  getpixel (x,y:word) : byte;
procedure fetch_text (ftype:word);
procedure setcolor (color, red, green, blue : byte);
procedure getcolor (color:byte; var red, green, blue : byte);
{procedure storepal (pal1 : palname);}
procedure cls (color : byte);
procedure textit (x,y:word ; txt:string ; height,lenght,shadow,color,dither:byte ; on:boolean);
procedure line (x1,y1,x2,y2:word ; col:byte);
procedure circle (x,y,rad:integer;Col:Byte);

procedure V_Flip (source,dest:word);           { For the  }
procedure V_Putpixel (x,y,color,virseg:word);  { virtual  }
procedure V_Cls (virseg:word ; color:byte);    { screen.  }
function  V_GetPixel (x,y,virseg : word) : byte;

function  deg2rad (angledeg: real) : real;
function  keypressed : boolean;


Implementation


Procedure ScreenMode;    { Set screenmode }
Begin
  Asm
    Mov  AH,00
    Mov  AL,Mode
    Int  10h
  End;
End;


Procedure SVGAmode;      { Set SVGA-mode }
begin
  asm
    Mov  AX,4F02h
    Mov  BX,svga
    Int  10h
  end;
end;


procedure retrace; assembler;   { Wait for a vertical retrace. }
asm
        Mov  DX,3DAh;
@WAIT1: In   AL,DX;
        Test AL,8;
        Jz   @WAIT1
@RETR2: In   AL,DX;
        Test AL,8;
        Jnz  @RETR2;
end;


procedure PutPixel; assembler;     { Put Pixel }
asm
  Mov ax,0a000h
  Mov es,ax
  Mov ax,[Y]
  Mov bx,140h
  Mul bx
  Mov di,[X]
  Add di,ax
  Mov al,[col]
  stosb
end;

procedure FAST; assembler;       { Maybe just a bit faster... }
asm
  Mov  ax,0a000h
  Mov  es,ax
  mov  bx,[x]
  mov  dx,[y]
  mov  di,bx
  mov  bx,dx
  shl  dx,8
  shl  bx,6
  add  dx,bx
  add  di,dx
  mov  al, [Col]
  stosb
end;

function getpixel; assembler;     { Get Pixel }
asm
  Mov  ax,0a000h
  Mov  es,ax
  Mov  ax,[Y]
  Mov  bx,140h
  Mul  bx
  Mov  di,[X]
  Add  di,ax
  Mov  al, es:[di]
end;


procedure fetch_text;                     { Get font. }
var regs       : registers;
begin
  with regs do begin
    AX := $1130;
    BH := ftype;
  end;
  Intr($10,regs);
  Fseg := regs.es;
  Fofs := regs.bp;
end;


procedure Setcolor;                       { Setcolor }
Begin
  Port[$3C8] := Color;
  Port[$3C9] := Red;
  Port[$3C9] := Green;
  Port[$3C9] := Blue;
End;


Procedure Getcolor;                       { Getcolor }
Begin
   Port[$3c7] := Color;    { This procedure reads the values of    }
   Red   := Port[$3c9];    { Red, Green & Blue for a certain color }
   Green := Port[$3c9];    { from the [$3c9] port.                 }
   Blue  := Port[$3c9];
End;

{
Procedure StorePal;                                           { Stores the }
{var color : word;
begin                                                         { current    }
{  for color:=0 to 255 do                                      { pallette.  }
{    Getcolor (color,pal1[color,0],pal1[color,1],pal1[color,2]);
end;
 }

procedure Cls;       { Clear screen. }
begin
  FillChar(mem[$A000:0000],64000,color);
end;


procedure Textit;    { Text. }
var q,w,e:byte;
begin
  for q:=1 to length(txt) do
   for w:=0 to height {7 or 15} do
    for e:=0 to lenght {7} do
     if ((mem[fseg:fofs+w+(ord(txt[q])*(height+1))] shl e) and 128) <> 0 then
     begin
      if on=true then mem[$a000:(y+w+1)*320+(q*8)+x+e+1]:=shadow; { Shadow }
      mem[$A000:(y+w)*320+(q*8)+x+e]:= color+random(dither);      { Text   }
     end;
end;


procedure line; assembler;       {  Draws a line.                }
var ddx,ddy : word;
    sx,sy : word;                {  This procedure has not been  }
asm                              {  made by me... It came from   }
        mov     ax,0a000h        {  some nameless source.        }
        mov     es,ax
        mov     ax,[y1]
        mov     bx,320
        imul    bx
        mov     di,[x1]
        add     di,ax
        mov     ax,[x2]
        clc
        mov     bx,1
        sub     ax,[x1]
        jnc     @@1
        neg     ax
        mov     bx,0ffffh
@@1:    mov     [ddx],ax
        mov     [sx],bx
        mov     ax,[y2]
        clc
        mov     bx,320
        sub     ax,[y1]
        jnc     @@2
        neg     ax
        mov     bx,-320
@@2:    mov     [ddy],ax
        mov     [sy],bx

        cmp     ax,[ddx]
        ja      @@yGrtr
        mov     cx,[ddx]
        inc     cx
        mov     bx,[ddx]
        shr     bx,1
        mov     al,[col]
@@x1:   mov     byte ptr [es:di],al
        add     di,[sx]
        clc
        sub     bx,[ddy]
        jnc     @@xg
        add     di,[sy]
        add     bx,[ddx]
@@xg:   loop    @@x1
        jmp     @@ret
@@yGrtr:mov     cx,[ddy]
        inc     cx
        mov     bx,[ddy]
        shr     bx,1
        mov     al,[col]
@@y1:   mov     byte ptr [es:di],al
        add     di,[sy]
        clc
        sub     bx,[ddx]
        jnc     @@yg
        add     di,[sx]
        add     bx,[ddy]
@@yg:   loop    @@y1
@@ret:
end;


procedure circle;             { Draws a circle                       }
var deg:real;
    x1,y1,x2,y2 : longint;    { Weird things happen when the circle  }
begin                         { goes over the borders of the screen. }
  y2:= x+(y*320);             { eg. KRU$H10.PAS                      }

  deg:=0;
  repeat
    x1:=round(rad*cos (deg));
    y1:=round(rad*sin (deg));
    mem[$A000:y2+(y1*320)+x1] := col;
    deg:=deg+0.005;
  until (deg>6.4);
end;


procedure V_Flip;             { Flip virtual screen on normal screen }
begin                         { or vice versa.                       }
  Move(mem[source:0],mem[dest:0],64000);
end;

procedure V_Putpixel;         { Put a pixel on the virtual screen.   }
begin
  mem[virseg:(320*y)+x] := color;
end;

procedure V_Cls;              { Clear virtual screen                 }
begin
  Fillchar(mem[virseg:0],64000,color);
end;

function V_getpixel;
begin
  V_getpixel := mem[virseg:(y*320)+x];
end;


function deg2rad;             { Convert deg. to rad.                 }
begin
  deg2rad := angledeg * pi / 180;
end;

function keypressed; assembler;
asm
  mov ah,0bh;
  int 21h;
  and al,0feh;
end;


begin
end.