program Almost_real_3d;
uses  krush2,crt;

{ once again... by: Krush 95 }

const Dots : array [1..12,1..2,1..3] of integer =
             ( ((-10,-10,-10),(10,-10,-10)),   {  The points of the box  }
               ((-10,-10,-10),(-10,10,-10)),   {                         }
               ((-10,10,-10) ,(10,10,-10)),    {    Ŀ           }
               ((10,-10,-10),(10,10,-10)),     {    \       \          }
               ((-10,-10,10),(10,-10,10)),     {     \       \         }
               ((-10,-10,10),(-10,10,10)),     {      \       \        }
               ((-10,10,10),(10,10,10)),       {       Ŀ       }
               ((10,-10,10),(10,10,10)),       {                     }
               ((-10,-10,10),(-10,-10,-10)),   {                     }
               ((-10,10,10),(-10,10,-10)),     {              }
               ((10,10,10),(10,10,-10)),       {     \       \         }
               ((10,-10,10),(10,-10,-10)));    {      \       \        }
                                               {       \       \       }
type Point  = record X,Y,Z:real; end;          {               }
var  Lines  : array[1..12,1..2] of point;
     Trans  : array[1..12,1..2] of point;
     sintbl : array[0..360] of real;
     costbl : array[0..360] of real;
     X,Y,Z  : integer;


procedure Setpoints;
var i:integer;
begin
  X := 160;
  Y := 100;
  Z := -100;
  for i:=0 to 360 do begin
    Sintbl[i] := sin(i*pi/180);   { i (in deg.) := i*pi/180 (in rad.) }
    Costbl[i] := cos(i*pi/180);
  end;
  for i:=1 to 12 do begin
    Lines[i,1].X := Dots[i,1,1];
    Lines[i,1].Y := Dots[i,1,2];
    Lines[i,1].Z := Dots[i,1,3];
    Lines[i,2].X := Dots[i,2,1];
    Lines[i,2].Y := Dots[i,2,2];
    lines[i,2].Z := Dots[i,2,3];
  end;
end;

procedure Rotatepoints (Xdeg,Ydeg,Zdeg : integer);
var i,c:integer ; tmp:point;
begin
  for i:=1 to 12 do for c:=1 to 2 do begin

  tmp.x := lines[i,c].x;                                          { Rotation }
  tmp.y := costbl[xdeg]*lines[i,c].y - sintbl[xdeg]*lines[i,c].z; { on the X }
  tmp.z := sintbl[xdeg]*lines[i,c].y + costbl[xdeg]*lines[i,c].z; { axis.    }
  trans[i,c] := tmp;

  tmp.x := costbl[Ydeg]*trans[i,c].x - sintbl[Ydeg]*trans[i,c].z; { Rotation }
  tmp.z := sintbl[Ydeg]*trans[i,c].x + costbl[Ydeg]*trans[i,c].z; { on the Y }
  trans[i,c] := tmp;                                              { axis.    }

  tmp.x := costbl[Zdeg]*trans[i,c].x - sintbl[Zdeg]*trans[i,c].y; { Rotation }
  tmp.y := sintbl[Zdeg]*trans[i,c].x + costbl[Zdeg]*trans[i,c].y; { on the Z }
  trans[i,c] := tmp;                                              { axis.    }
  end;
end;

procedure Drawpoints (col,qwe : byte);
var i,tmp       : integer;
    x1,y1,x2,y2 : integer;
begin
  for i:=1 to 12 do begin

    tmp:= round(trans[i,1].z+z);             { Conversion to 2D }
    x1 := round(256*trans[i,1].x) div tmp+x; { ...              }
    y1 := round(256*trans[i,1].y) div tmp+y; { ...              }
    tmp:= round(trans[i,2].z+z);             { and another one  }
    x2 := round(256*trans[i,2].x) div tmp+x; { ...              }
    y2 := round(256*trans[i,2].y) div tmp+y; { ...              }

    if (qwe mod 2)<>0 then begin
      if (x1>0) and (x1<320) and (y1>0) and (y1<200) and
      (x2>0) and (x2<320) and (y2>0) and (y2<200) then line(x1,y1,x2,y2,col,$A000);
    end
    else begin
     if (x1>0) and (x1<320) and (y1>0) and (y1<200) and
     (x2>0) and (x2<320) and (y2>0) and (y2<200) then begin
       mem[$A000:y1*320+x1] := col;
       mem[$A000:y2*320+x2] := col;
     end;
    end;
  end;
end;


procedure Rotateimage;
var deg,i : integer;
begin
  deg:=0; i:=0;
  repeat
   repeat
     Rotatepoints (deg,deg,deg);
     Drawpoints(15,i); delay(10); retrace;
     Drawpoints(0,i);
     if deg=360 then deg:=-2;
     inc(deg,2);
   until keypressed; readkey;
   inc(i);
  until port[$60]=1;              { [ESC] to quit. }
end;


begin
  Screenmode($13); cls(0);
  Setpoints;
  Rotateimage;
  textmode(lastmode);
end.