program Starfield2;

 {   More simple effects...               }
 {                     Enjoy, Krush -95   }

uses krush2,crt;
type point  = record X,Y,Z:real; end;
     virtua = array[0..64000] of byte;
     virpnt = ^virtua;

const stars=200;

     mk: array[0..39] of integer =
         (-70,-35, -50,-35, -30,-15, -10,-35, +10,-35,
          +10,-05, +40,-35, +70,-35, +30,+00, +70,+35,
          +40,+35, +10,+05, +10,+35, -10,+35, -10,-05,
          -30,+15, -50,-05, -50,+35, -70,+35, -70,-35);

var     n  : integer;
      x,y  : array[0..stars] of real;
  x1,y1,z  : array[0..stars] of integer;
  ctb,stb  : array[0..360] of real;
  sp1,conv : array[0..25] of point;
  twod     : array[0..25] of record X,Y:integer; end;
  px,py,pz : integer;
  virscr   : virpnt;
  virseg   : word;
  xof,yof,zof : integer;

Procedure V_Setup; begin GetMem (VirScr,64000); virseg := seg(virscr^); end;
Procedure V_Free; begin FreeMem (VirScr,64000); end;
procedure V_Flip(source,dest:Word); assembler;
asm; push ds; mov ax, [Dest]; mov es, ax; mov ax, [Source]; mov ds, ax;
xor si, si; xor di, di; mov cx, 32000; rep movsw; pop ds; end;


procedure Setupsphere;
var i:word;
begin
  for i:=0 to 360 do begin
    stb[i] := sin(i*pi/180);
    ctb[i] := cos(i*pi/180);
  end;
  for i:=0 to 19 do begin
    sp1[i].x := mk[i*2];
    sp1[i].y := mk[i*2+1];
    sp1[i].z := 0;
  end;
  xof:=160; yof:=100; zof:=1800;
end;

procedure Rotatepoints(Xan,Yan,Zan : integer);
var i:integer ; tmp: point;
begin
  for i:=0 to 19 do begin
    tmp.x := sp1[i].X;
    tmp.y := sp1[i].Y*ctb[Xan] - sp1[i].Z*stb[Xan];
    tmp.z := sp1[i].Y*stb[Xan] + sp1[i].Z*ctb[Xan];
    conv[i] := tmp;

    tmp.x := conv[i].x*ctb[Yan] - conv[i].z*stb[Yan];
    tmp.z := conv[i].x*stb[Yan] + conv[i].z*ctb[Yan];
    conv[i] := tmp;

    tmp.x := conv[i].x*ctb[Zan] - conv[i].y*stb[Zan];
    tmp.y := conv[i].x*stb[Zan] + conv[i].y*ctb[Zan];
    conv[i] := tmp;
  end;
end;

procedure Drawpoints;
var i:integer;tmp:real;
begin
  for i:=0 to 19 do begin
    tmp := conv[i].z+zof;
    twod[i].x := round((256*conv[i].x) / tmp+xof);
    twod[i].y := round((256*conv[i].y) / tmp+yof);
  end;
  for i:=0 to 18 do line(twod[i].x,twod[i].y,twod[i+1].x,twod[i+1].y,255,virseg);
end;


begin
  Screenmode($13); Cls(0); randomize;
  V_Setup; Setupsphere; Fillchar(mem[virseg:0],64000,0);

  for n:=0 to 63 do setcolor(n,n,0,n div 2);
  for n:=64 to 127 do setcolor(n,63,0,n div 2);
  for n:=128 to 250 do setcolor(n,63,0,63);
  setcolor(255,0,0,63);

  for n:=0 to stars do begin
   x[n]:= random(320);   y[n]:= random(200);
   x[n]:= (x[n]-160)/2;  y[n]:= (y[n]-100)/2;
   z[n]:=random(63);
  end;

  repeat

   for n:=0 to stars do begin
    x1[n] := round(x[n]);     x[n]  := x[n]*1.03;
    y1[n] := round(y[n]);     y[n]  := y[n]*1.03;
    z[n]  := z[n]+1;  end;

   for n:=0 to stars do
     if (x[n]>159) or (x[n]<-159) or (y[n]>99) or (y[n]<-99) then begin
        x[n]:= random(320);        y[n]:= random(200);
        x[n]:= (x[n]-160)/5;      y[n]:= (y[n]-100)/5;
        z[n]:=0;
     end;

   for n:=0 to stars do mem[virseg:32160+x1[n]+320*y1[n]]:= 0;
   for n:=0 to stars do mem[virseg:32160+round(x[n])+round(y[n])*320]:= z[n];

   Rotatepoints(px,py,pz);
   Drawpoints;
   V_Flip(virseg,$A000);
   Fillchar(mem[virseg:0],64000,0);
   if px<360 then inc(px,2) else px:=0;
   if py<359 then inc(py,4) else py:=0;
   if pz<358 then inc(pz,4) else pz:=0;
   if zof>240 then dec(zof,3);

  until keypressed;
  Screenmode($3); textcolor(cyan);
  writeln('(This thing uses real math, and i haven''t really)');
  writeln('(optimized it, so it''s pretty slow.)'); writeln;
  writeln('This simple starfield and vector by Krush -95');
  writeln('                                    ... Enjoy');

end.

