type
  bin_ptr = ^byte;

function bin_get_key(bin_rn : integer) : bin_ptr ; forward;
function bin_less_than(bin_target, bin_current : bin_ptr) : boolean; forward;
function bin_equal_to(bin_target, bin_current : bin_ptr) : boolean; forward;

procedure setptr(var ptr1, ptr2);
{ Used to equate pointers of different types }

begin
  memw[seg(ptr1):ofs(ptr1)] := memw[seg(ptr2):ofs(ptr2)];
  memw[seg(ptr1):ofs(ptr1)+2] := memw[seg(ptr2):ofs(ptr2)+2]
end;

function bin_search(lo, hi : integer;
                    var bin_target) : integer;
{ Do a binary search from "lo" to "hi" looking for "bin_target".
  If found return the record number.
  If not found return the negative of the number of the next higher record. }

var
  mid,
  oldhi   : integer;
  current : bin_ptr;
  target  : bin_ptr;

begin
  if hi<lo
    then bin_search := -lo
    else begin
      target := addr(bin_target);
      oldhi := hi;
      repeat
        mid := (lo + hi) shr 1;
        { For debugging purposes:
        writeln(lo:5,'|',mid:5,'|',hi:5);}
        current := bin_get_key(mid);
        if bin_less_than(target,current)
          then hi := mid - 1
          else lo := mid + 1
      until bin_equal_to(target,current) or (lo>hi);
      if bin_equal_to(target,current)
        then bin_search := mid
        else if bin_less_than(target,current)
          then bin_search := -(mid)
          else bin_search := -(mid + 1)
    end
end;
