{E_MDM.INC          MODEM ROUTINES INCLUDE FILE BY MAJ AL MORRISON          }
{             latest version 1 Oct 86  changing hangup routine              }

{===========================================================================}
const
  aux_buffer_size     = 1024;
  num_aux_buffer_recs = 8;

type
  responsestr     = string[2];
  auxbuffertype   = array[1..aux_buffer_size] of char;

{ A block looks like:

  [ startblockchar | *length | seq no | startdatachar |
    packet... | enddatachar | *crcvalue ]

     (* => integer, all others byte)}

  preambletype    = record
                      length        : integer;
                      seqno         : byte;
                      startdatachar : char
                    end;

  postambletype   = record
                      enddatachar : char;
                      crc         : integer
                    end;


const
  host         : boolean = true;     {May be reset by main program}

{ Modem interface constants. }

  mdmdataport  = $EC;
  mdmstatport  = $ED;
  mdmmodeport  = $EE;
  mdmcmdport   = $EF;
  bd300        = 6;
  bd1200       = 8;

{ Communication protocol constants. }

  squeeze        = true;
  unsqueeze      = true;

  preamble_size  = 4;
  postamble_size = 3;

  null_char    = #00;
  cr           = ^M;
  lf           = ^J;

  startblock   = ^A;
  startdata    = ^B;
  enddata      = ^C;

  attention    = ^D;
    send_id         = ^E;
    send_hdr        = ^F;
    send_dist_list  = ^G;
    send_item       = ^H;
    recv_hdr        = ^I;
    recv_item       = ^J;
    goodbye         = ^K;

  abort        = ^U;
  affirmative  = ^V;
  negative     = ^W;

  recved_ok    = ^X;
  say_again    = ^Y;

  noresponse   = ^Z;

var

{NOTE:  The following variables must remain global in order to be accessed
        correctly by the aux_char_ready routine.  Also see the note in the
        aux_char_ready function.}

{ auxstatus,
  auxraw,
  auxqsize, }
  auxnumchar  : byte;

{===========================================================================}
function aux_char_ready : boolean;

begin
  inline
    ($B4/$02/              {MOV     AH,2                ; STATUS FUNCTION }
     $B0/$00/              {MOV     AL,0                ; GET STATUS      }
     $9A/$4E/$00/$40/$00/  {CALL    BIOS_AUXFUNC        ;                 }

{ Note that the following three are commented out.  They are not needed
  for the applications I have in mind but are left here in case they are
  ever needed.  By the way, the three variables referenced are also commented
  out at the top of the program. -- Prof }
{    $88/$26/auxstatus/   }{MOV     AUXSTATUS,AH        ;                 }
{    $88/$06/auxraw/      }{MOV     AUXRAW,AL           ;                 }
{    $88/$3E/auxqsize/    }{MOV     AUXQSIZE,BH         ;                 }

     $88/$1E/auxnumchar);  {MOV     AUXNUMCHAR,BL       ;                 }

  aux_char_ready := (auxnumchar>0)
end;
{===========================================================================}
function data_set_ready : boolean;

{ Note:  If switch 6 on the Smartmodem is up, then the presence/absence of
         a carrier causes DSR' to go hi/low (in that order).  This is
         the $80 bit in the status word.  Note that this conflicts with
         Zenith's documentation which indicates that bit $40 of the status
         word is DCD'.!! }

begin
  data_set_ready := ((port[mdmstatport] and $80)<>0)
end;
{===========================================================================}
procedure readaux(var c       : char;
                      howlong : integer;
                  var gotone  : boolean);

var
  i  : integer;
  ok : boolean;
  n  : integer;

begin
  if (not aux_char_ready) and (howlong<>0)
    then begin
      set_timer(n,howlong,ok);
      repeat
      until aux_char_ready or timeout(n) or not data_set_ready;
      release_timer(n)
    end;
  if aux_char_ready
    then begin
      read(aux,c);
      gotone := true;
    end
    else begin
      c := null_char;
      gotone := false
    end;
end;
{===========================================================================}
procedure flushmodem;

var
  c      : char;
  gotone : boolean;

begin
  repeat
    readaux(c,2*ten_milli_seconds,gotone)
  until not gotone
end;
{===========================================================================}
procedure sendaux(    sendstr       : anystr;
                      ok_chars      : responsestr;
                  var responsechar  : char);

var
  c        : char;
  gotone,
  ok       : boolean;
  trycount : integer;
  n        : integer;

begin
  trycount := 0;
  repeat
    flushmodem;
    write(aux,sendstr);
    if ok_chars=noresponse
      then responsechar := noresponse
      else begin
        responsechar := null_char;
        set_timer(n,3*seconds,ok);
        while (pos(responsechar,ok_chars)=0) and not timeout(n) do
          readaux(responsechar,1*seconds,gotone);
        release_timer(n);
        trycount := trycount + 1
      end
  until (pos(responsechar,ok_chars)<>0)
     or (trycount=10)
     or not data_set_ready
end;
{===========================================================================}
procedure hangup;

var
  c      : char;
  gotone : boolean;

begin
  while data_set_ready do begin
    write(aux,cr);
    delay(200);
    if host
      then write(aux,chr(28),chr(28),chr(28))
      else write(aux,chr(29),chr(29),chr(29));
    delay(200);
    write(aux,'ATH',cr);
    delay(200);
    flushmodem;
    delay(2000);             {2 second delay added for hangup purposes}

  end;
  flushmodem
end;
{===========================================================================}
procedure init_mdm(baud_rate : byte);

var
  modereg1,
  modereg2,
  dummy     : byte;
  c         : char;
  gotone    : boolean;
  ok        : boolean;
  n         : integer;

begin
  port[mdmcmdport] := 0;
  dummy := port[mdmcmdport];
  modereg1 := port[mdmmodeport];
  modereg2 := port[mdmmodeport];
  port[mdmmodeport] := $4E;
  port[mdmmodeport] := $70 or baud_rate;
  port[mdmcmdport] := $37;
  dummy := port[mdmdataport];
  dummy := port[mdmdataport];

  init_timer;
  hangup;
  write(aux,cr);
  delay(100);
  write(aux,'AT E0 F1 Q1 S12=5');
{              E0     => Do not echo characters in command state.
               F1     => Full-duplex (do not echo data characters).
               Q1     => Result codes not sent.
               S12=5  => Escape code guard time (100 msec).}
  if host
    then write(aux,' S2=28',cr)
{              S2=28  => Escape code character.}
    else write(aux,' S2=29',cr);
{              S2=29  => Escape code character.}
  delay(1000);
  flushmodem
end;
{===========================================================================}
procedure quit_mdm;

begin
  hangup;
  write(aux,'ATZ',cr);
  flushmodem;
  quit_timer
end;
{===========================================================================}
procedure awaitcall(howlong : integer);

var
  c      : char;
  gotone : boolean;
  n      : integer;
  ok     : boolean;

begin
  write(aux,cr);
  delay(100);
  write(aux,'AT S7=10 S0=1',cr);

  set_timer(n,howlong,ok);
  repeat
  until data_set_ready or keypressed or timeout(n);
  release_timer(n);

  if not data_set_ready
    then write(aux,'ATS0=0',cr)
end;
{===========================================================================}
procedure call(    phnum : ph_num_type;
               var ok    : boolean);

var
  c      : char;
  gotone : boolean;
  n      : integer;

begin
  write(aux,cr);
  delay(100);
  write(aux,'AT S7=30 DT',phnum,cr);    {added T after D'}
  set_timer(n,35*seconds,ok);           {changed 30 to 35 for hangup }
  repeat
  until data_set_ready
        or timeout(n)
        or keypressed;
  release_timer(n);
  if data_set_ready
    then begin
      ok := true;
    end
    else begin
      ok := false;
      write(aux,cr);
    end
end;
{===========================================================================}
function crc(oldcrc : integer;
             c      : char    ) : integer;

const
  poly  : integer = $8005;

var
  cval,
  tbit,
  bit   : integer;

begin
  cval := ord(c) shl 8;
  for bit := 0 to 7 do begin
    tbit := cval xor oldcrc;
    oldcrc := oldcrc shl 1;
    if tbit<0 {bit 15 on}
      then oldcrc := oldcrc xor poly;
    cval := cval shl 1
  end;
  crc := oldcrc
end;
{===========================================================================}
procedure start_xmission;

begin
  {Reset squeeze table}
end;
{===========================================================================}
procedure read_aux_packet(var packet    {: typeless};
                              size       : integer;
                              seqno      : byte;
                              unsqueezit : boolean;
                          var ok         : boolean);

label
  999;

var
  prebuffer       : array[1..preamble_size] of char;
  postbuffer      : array[1..postamble_size] of char;

  preamble        : preambletype absolute prebuffer;
  auxbuffer       : auxbuffertype absolute packet;
  postamble       : postambletype absolute postbuffer;

  auxbufptr       : integer;
  i               : integer;
  c,
  startblockchar  : char;
  mycrc           : integer;
  dummy           : char;

begin

  repeat
    repeat  {Await startblock/abort/carrier lost}
      readaux(startblockchar,5*seconds,ok);
    until (startblockchar in [startblock,abort]) or not data_set_ready;
    ok := (startblockchar=startblock);
    if not ok
      then exit {<--- NOTE EXIT!!!!!!! <---<---<---<---<---<---<---<---}
                {Must have been an abort code or carrier loss!}
      else write(aux,affirmative);  {Acknowledge startblock character}

    for i := 1 to preamble_size do begin  {Receive preamble stuff}
      readaux(prebuffer[i],1*seconds,ok);
      if not ok
        then goto 999
    end;

    if preamble.length>size  {This will neeeeevvveerr happen (trust me!)}
      then begin
        ok := false;
        goto 999
      end;

    mycrc := 0;
    for auxbufptr := 1 to preamble.length do begin  {Receive the data}
      readaux(auxbuffer[auxbufptr],5*seconds,ok);
      if not ok  {<--- NOTE: Need unsqueeze here <---}
        then goto 999;
      mycrc := crc(mycrc,auxbuffer[auxbufptr])
    end;

    for i := 1 to postamble_size do begin  {Receive the postamble stuff}
      readaux(postbuffer[i],3*seconds,ok);
      if not ok
        then goto 999
    end;

    ok :=      (mycrc=postamble.crc)
           and (preamble.startdatachar=startdata)
           and (postamble.enddatachar=enddata);

999: { <---<---<---<---<---<---<---<---<---<---<---<---<--- NOTE LABEL!!!!! }

    if ok
      then begin
        sendaux(recved_ok,noresponse,dummy);
        ok := (seqno=preamble.seqno)
      end
      else begin
        flushmodem;
        sendaux(say_again,noresponse,dummy)
      end

  until ok
end;
{===========================================================================}
procedure send_aux_packet(var packet  {: typeless};
                              size     : integer;
                              seqno    : byte;
                              squeezit : boolean;
                          var ok       : boolean);

label
  999;

var
  prebuffer       : array[1..preamble_size] of char;
  postbuffer      : array[1..postamble_size] of char;

  preamble        : preambletype absolute prebuffer;
  auxbuffer       : auxbuffertype absolute packet;
  postamble       : postambletype absolute postbuffer;

  auxbufptr     : integer;
  mycrc         : integer;
  tries         : integer;
  c             : char;

begin

  tries := 0;
  repeat

    sendaux(startblock,affirmative,c);  {Send startblock character and look
    ok := (c=affirmative);               for an affirmative response}
    if not ok
      then goto 999;

    preamble.length := size;  {Send preamble stuff}
    preamble.seqno := seqno;
    preamble.startdatachar := startdata;
    write(aux,prebuffer);

    mycrc := 0;
    for auxbufptr := 1 to size do begin {Send the buffer}
      write(aux,auxbuffer[auxbufptr]); {<--- NOTE: Need squeeze here <---}
      mycrc := crc(mycrc,auxbuffer[auxbufptr])
    end;

(*
    while aux_char_ready do  {Trash any garbage characters which may have
      read(aux,c);            accumulated while we were xmitting}
*)

    postamble.enddatachar := enddata;  {Send postamble stuff}
    postamble.crc := mycrc;
    write(aux,postbuffer);

    repeat  {Wait for response}
      readaux(c,5*seconds,ok)
    until not ok or (c in [recved_ok,say_again]);
    ok := ok and (c=recved_ok);
    tries := succ(tries)

  until ok or (tries=5);

999: { <---<---<---<---<---<---<---<---<---<---<---<---<--- NOTE LABEL!!!!! }

  if not ok
    then write(aux,abort,abort,abort)  {Must be holding the phone too far from
                                        his ear -- screw him!}

end;
{===========================================================================}

