{****************************************************************************

                        FPKPascal Runtime-Library
                          Copyright (c) 1994,96 by
                             Florian Klmpfl

 ****************************************************************************}

{
  History:
  5.6.1994: Version 0.1
            Unitheader geschrieben
  12.6.1994: Version 0.2
            erste erfolgreiche Ausgaben via PutPixel
  14.6.1994:
            Line prinzipiell implementiert
  12.8.1994:
            einige Erweiterungen im Unterbau vorgenommen,
            insbesonders Fontausgabe
  15.8.1994:
            Speicherverwaltung implementiert
            Fllmuster eingegeben
            Bar implementiert und getestet
  11.9.1994:
            Outtext funktioniert prinzipiell
  25.12.1994:
            Rectangle implementiert
  3.3.1995: Version 0.3
            PutImage implementiert
  21.1.1996:
            RegisterBGIdriver als Dummy implementiert
            DetectGraph implementiert
     	    schlechtes FloodFill implementiert
  27.1.1996: Version 0.31 
            Bar korrigiert
}

unit graph;

  interface

{$E-}
{$PACKRECORDS NORMAL}

    const
       { Fehlercodes }
       grOk =  0;
       grNoInitGraph = -1;
       grNotDetected = -2;
       grFileNotFound = -3;
       grInvalidDriver = -4;
       grNoLoadMem = -5;
       grNoScanMem = -6;
       grNoFloodMem = -7;
       grFontNotFound = -8;
       grNoFontMem = -9;
       grInvalidMode = -10;
       grError = -11;
       grIOerror = -12;
       grInvalidFont = -13;
       grInvalidFontNum = -14;
       grInvalidVersion = -18;

       { Graphiktreiber }
       CurrentDriver = -128;
       Detect = 0;
     
       { Graphikmodi }
       Default = 0;
       
       { Farben fr setpalette und setallpalette }
       black = 0;
       blue = 1;
       green = 2;
       cyan = 3;
       red = 4;
       magenta = 5;
       brown = 6;
       lightgray = 7;
       darkgray = 8;
       lightblue = 9;
       lightgreen = 10;
       lightcyan = 11;
       lightred = 12;
       lightmagenta = 13;
       yellow = 14;
       white = 15;

       { Linenart fr Get/SetLineStyle: }
       SolidLn = 0;
       DottedLn = 1;
       CenterLn = 2;
       DashedLn = 3;
       UserBitLn = 4;

       NormWidth = 1;
       ThickWidth = 3;
 
       { Set/GetTextStyle Konstanten: }
       DefaultFont = 0;
       TriplexFont = 1;
       SmallFont = 2;
       SansSerifFont = 3;
       GothicFont = 4;
       ScriptFont = 5;
       SimpleFont = 6;
       TSCRFont = 7;
       LCOMFont = 8;
       EuroFont = 9;
       BoldFont = 10;

       HorizDir = 0;
       VertDir = 1;

       UserCharSize = 0;

       ClipOn = true;
       ClipOff = false;

       { Bar3D Konstanten: }
       TopOn = true;
       TopOff = false;

       { Fllmuster fr Get/SetFillStyle: }
       EmptyFill = 0;
       SolidFill = 1;
       LineFill = 2;
       LtSlashFill = 3;
       SlashFill = 4;
       BkSlashFill = 5;
       LtBkSlashFill = 6;
       HatchFill = 7;
       XHatchFill = 8;
       InterleaveFill = 9;
       WideDotFill = 10;
       CloseDotFill = 11;
       UserFill = 12;

       { BitBlt-Operatoren  }
       NormalPut     = 0;
       CopyPut       = 0;
       XORPut        = 1;
       OrPut         = 2;
       AndPut        = 3;
       NotPut        = 4;

       { SetTextJustify-Konstanten }
       LeftText   = 0;
       CenterText = 1;
       RightText  = 2;

       BottomText = 0;
       TopText    = 2;

       MaxColors = 15;

    type
       PaletteType = record
          size : byte;
          Colors : array[0..MaxColors] of shortint;
       end;

       LineSettingsType = record
          linestyle : word;
          pattern : word;
          thickness : word;
       end;

       TextSettingsType = record
          font : word;
          direction : word;
          charsize : word;
          horiz : word;
          vert : word;
       end;

       FillSettingsType = record
          pattern : word;
          color : word;
       end;

       FillPatternType = array[1..8] of byte;

       PointType = record
          x,y : integer;
       end;

       ViewPortType = record
          x1,y1,x2,y2 : integer;
          Clip : boolean;
       end;

       ArcCoordsType = record
          x,y : integer;
          xstart,ystart : integer;
          xend,yend : integer;
       end;

    var
       GraphGetMemPtr  : Pointer;
       GraphFreeMemPtr : Pointer;

    function GraphErrorMsg(ErrorCode : integer) : String;
    function GraphResult : integer;

    procedure DetectGraph(var GraphDriver,GraphMode : integer);
    function GetDriverName : string;
    procedure InitGraph(var GraphDriver : integer;var GraphMode : integer;const PathToDriver : String);

    function RegisterBGIfont(font : pointer) : integer;
    function RegisterBGIdriver(driver : pointer) : integer;

    function InstallUserDriver(const DriverFileName : string;AutoDetectPtr : pointer) : integer;
    function InstallUserFont(const FontFileName : string) : integer;

    { setzt Gre des Hilfsspeichers }
    procedure SetGraphBufSize(BufSize : longint);

    function GetMaxMode : integer;
    procedure GetModeRange(GraphDriver : integer;var LoMode,HiMode : integer);
{
    function GetModeName(GraphMode : integer) : string;
}
    procedure SetGraphMode(mode : integer);
{
    function GetGraphMode : integer;
}
    { setzt alle Paramter des Graphikpakets zurck }
    procedure GraphDefaults;
    procedure RestoreCrtMode;

    { Schliet das Graphikpaket }
    procedure CloseGraph;

    { Position des Graphikcursors }
    function GetX : longint;
    function GetY : longint;

    { Abfrage der Bildschirmmae }
    function GetMaxX : longint;
    function GetMaxY : longint;

    { lscht den Bildschirm }
    procedure ClearDevice;

    { Ausgabebereich und Bildschirmseiten einstellen }
    procedure SetViewPort(x1,y1,x2,y2 : integer;clip : boolean);
    procedure GetViewSettings(var viewport : ViewPortType);
    procedure ClearViewPort;
    procedure SetVisualPage(page : word);
    procedure SetActivePage(page : word);

    { Graphikprimitivas }
    procedure PutPixel(x,y : longint;pixel : word);
    function GetPixel(x,y : longint) : word;

    { setzt den Schreibmodus fr Line, LineRel, LineTo, Rectangle und DrawPoly }
    procedure SetWriteMode(WriteMode : integer);

    procedure LineTo(x,y : longint);
    procedure LineRel(dx,dy : longint);

    { bewegt den Graphikcursor an die absolute Position (x;y) }
    procedure MoveTo(x,y : longint);

    { bewegt den Graphikcursor relativ um dx und dy }
    procedure MoveRel(dx,dy : longint);

    { zeichnet eine Linie von (x1;y1) nach (x2;y2) }
    procedure Line(x1,y1,x2,y2 : longint);

    { Unterprogramme zur Einstellung der Linienart }
    procedure GetLineSettings(var LineInfo : LineSettingsType);
    procedure SetLineStyle(LineStyle : word;pattern : word;thickness : word);

    procedure Rectangle(x1,y1,x2,y2 : integer);
    procedure bar(x1, y1, x2, y2 : integer);
{
    procedure bar3D(x1, y1, x2, y2 : integer;depth : word;top : boolean);
    procedure DrawPoly(NumPoints : word;var PolyPoints);
    procedure FillPoly(NumPoints : word;var PolyPoints);
}
    procedure GetFillSettings(var FillInfo : FillSettingsType);
    procedure GetFillPattern(var FillPattern : FillPatternType);
    procedure SetFillStyle(pattern : word;color : word);
    procedure SetFillPattern(pattern : FillPatternType;color : word);
    procedure FloodFill(x,y : integer;border : word);
{
    procedure Arc(x,y : integer;StAngle,EndAngle,radius : word);
    procedure GetArcCoords(var ArcCoords : ArcCoordsType);
    procedure Circle(x,y : integer;radius : word);
    procedure Ellipse(x,y : integer;StAngle,EndAngle : word;XRadius,YRadius : word);
    procedure FillEllipse(x,y : integer;xRadius,yRadius : word);
    procedure GetAspectRatio(var Xasp,Yasp : word);
    procedure SetAspectRatio(Xasp, Yasp : word);
    procedure PieSlice(x,y : integer;StAngle,EndAngle,Radius : word);
    procedure sector(X, Y : Integer;stAngle,EndAngle,xRadius,yRadius : word);
}
    { Farbeinstellungen }
    procedure SetBkColor(ColorNum : word);
    procedure SetColor(color : word);
    function GetBkColor : word;
    function GetColor : word;

{
    procedure SetAllPalette(var Palette);
    procedure SetPalette(ColorNum : word;Color : shortint);
    procedure GetPalette(var Palette : PaletteType);
    function GetPaletteSize : integer;
    procedure GetDefaultPalette(var Palette : PaletteType);
    function GetMaxColor : word;
    procedure SetRGBPalette(ColorNum,RedValue,GreenValue,BlueValue : integer);
}
    { Bitmapfunktionen }
    function  ImageSize(x1,y1,x2,y2 : integer) : word;
    procedure GetImage(x1,y1,x2,y2 : integer;var BitMap);
    procedure PutImage(x,y : integer;var BitMap;BitBlt : word);

    { Textausgabe }
    procedure GetTextSettings(var TextInfo : TextSettingsType);
    procedure OutText(const TextString : string);
    procedure OutTextXY(x,y : integer;const TextString : string);
    procedure SetTextJustify(horiz,vert : word);
    procedure SetTextStyle(Font, Direction : word; CharSize : word);
    procedure SetUserCharSize(Multx,Divx,Multy,Divy : word);
    function TextHeight(const TextString : string) : word;
    function TextWidth(const TextString : string) : word;

  implementation

    var
       { enthlt die Anzahl der Zeilen und Spalten des aktuellen }
       { Graphikmoduses }
       _maxx,_maxy : longint;
       { Videospeicherbereiche }
       wbuffer,rbuffer,wrbuffer : ^byte;
       { aktueller Ausgabebereich }
       aktviewport : ViewPortType;
       { der Graphikmodus, der beim Start gesetzt war }
       startmode : byte;
       { Position des Graphikcursors }
       curx,cury : longint;
       { true, wenn die Routinen des Graphikpaketes verwendet werden drfen }
       isgraphmode : boolean;
       { Einstellung zum Linien zeichnen }
       aktlineinfo : LineSettingsType;
       { Fehlercode, wird von graqphresult zurckgegeben }
       _graphresult : integer;
       { aktuell eingestellte Fllart }
       aktfillsettings : FillSettingsType;
       { aktuelles Fllmuster }
       aktfillpattern : FillPatternType;
       { aktuell eingestellte Farbe }
       aktcolor : word;
       { Hintegrundfarbe }
       aktbackcolor : word;
       { Schreibmodus }
       aktwritemode : integer;
       { Schrifteinstellung }
       akttextinfo : TextSettingsType;
       { momentan gesetzte Textskalierungswerte }
       aktmultx,aktdivx,aktmulty,aktdivy : word;
       { Pfad zu den Fonts }
       bgipath : string;
       { Pointer auf Hilfsspeicher }
       buffermem : pointer;
       { momentane Gre des Buffer }
       buffersize : longint;

    const
       fillpattern : array[0..12] of FillPatternType = (
           (0,0,0,0,0,0,0,0),                     { Hintergrundfarbe }
           ($ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff),     { Vordergrundfarbe }
           ($ff,$ff,0,0,$ff,$ff,0,0),             { --- }
           ($11,$22,$44,$88,$11,$22,$44,$88),     { /// }
           ($07,$0e,$1c,$38,$70,$e0,$c1,$83),     { /// als dicke Linien }
           ($07,$83,$c1,$e0,$70,$38,$1c,$0e),     { \\\ als dicke Linien }
           ($5a,$2d,$96,$4b,$a5,$d2,$69,$b4),     { \ \\ \ }
           ($ff,$88,$88,$88,$ff,$88,$88,$88),     { Kstchen }
           ($18,$24,$42,$81,$81,$42,$24,$18),     { Rauten }
           ($cc,$33,$cc,$33,$cc,$33,$cc,$33),     { "Mauermuster" }
           ($80,$00,$08,$00,$80,$00,$08,$00),     { weit auseinanderliegende }
                                                  { Punkte }
           ($88,$00,$22,$00,$88,$00,$22,$00),     { dichte Punkte}
           (0,0,0,0,0,0,0,0)                      { benutzerdefiniert }
          );

    procedure getmem(var p : pointer;size : longint);

      begin
         asm
            pushl 12(%ebp)
            pushl 8(%ebp)
            movl U_GRAPH_GRAPHGETMEMPTR,%eax
            call %eax
         end;
      end;

    procedure freemem(var p : pointer;size : longint);

      begin
         asm
            pushl 12(%ebp)
            pushl 8(%ebp)
            movl U_GRAPH_GRAPHGETMEMPTR,%eax
            call %eax
         end;
      end;

    procedure isnographmode;

      begin
         _graphresult:=grNoInitGraph;
      end;

    {$i modes.inc}

    { setzt einen erweiterten Graphikmodus }

    procedure setextendedmode(mode : byte;var sizex,sizey : longint);

      begin
         asm
            movb $0xff,%ah
            movb 8(%ebp),%al
            movl 10(%ebp),%esi
            movl (%esi),%ecx
            movl 14(%ebp),%edi
            movl (%edi),%edx
            int	$0x10
            movl %ecx,(%esi)
            movl %edx,(%edi)
         end;
      end;

    function GetMaxMode : integer;

      begin
         _graphresult:=grOk;
         GetMaxMode:=0;
      end;

    procedure GetModeRange(GraphDriver : integer;var LoMode,HiMode : integer);

      begin
         _graphresult:=grOk;
         lomode:=0;
         himode:=GetMaxMode;
      end;

    procedure ClearDevice;

      var
         bytes : longint;

      begin
         _graphresult:=grOk;
         if not isgraphmode then
           begin
              isnographmode;
              exit;
           end;
         curx:=0;
         cury:=0;
         bytes:=_maxx*_maxy;
         fillchar(wbuffer^,bytes,aktbackcolor);
      end;

    function GetDriverName : string;

      begin
         GetDriverName:='SuperVGA Driver';
      end;

    procedure DetectGraph(var GraphDriver,GraphMode : integer);

      begin
         GraphDriver:=Detect;
         GraphMode:=Default;
      end;

    procedure graphdefaults;

      var
         l : longint;

      begin
         _graphresult:=grOk;
         if not isgraphmode then
           begin
              isnographmode;
              exit;
           end;
         { Linientyp }
         aktlineinfo.linestyle:=solidln;
         aktlineinfo.thickness:=normwidth;

         { Fllmuster }
         aktfillsettings.color:=white;
         aktfillsettings.pattern:=solidfill;

         { Zeichenfarbe }
         aktcolor:=white;
         aktbackcolor:=black;

         { Viewport setzen }
         aktviewport.clip:=false;
         aktviewport.x1:=0;
         aktviewport.y1:=0;
         aktviewport.x2:=GetMaxX;
         aktviewport.y2:=GetMaxY;

         { normaler Schreibmodus }
         aktwritemode:=NormalPut;

         { Schriftart einstellen }
         akttextinfo.font:=DefaultFont;
         akttextinfo.direction:=HorizDir;
         akttextinfo.charsize:=1;
         akttextinfo.horiz:=LeftText;
         akttextinfo.vert:=TopText;
         {!!!!!!!!
          Vergrerungsfaktoren}
      end;

    procedure SetGraphMode(mode : integer);

      var
         lomode,himode : integer;

      begin
         _graphresult:=grOk;
         { auf erlaubten Modus prfen }
         GetModeRange(detect,lomode,himode);
         if (mode<lomode) or (mode>himode) then
           begin
              _graphresult:=grInvalidMode;
              exit;
           end;

         { physikalisch in den Graphikmodus schalten }
         setextendedmode(5,_maxx,_maxy);

         { wir sind im Graphikmodus }
         isgraphmode:=true;

         { alle Variablen zurcksetzten }
         GraphDefaults;

         { Bildschirm lschen }
         ClearDevice;
      end;

    procedure SetGraphBufSize(BufSize : longint);

      begin
         if assigned(buffermem) then
           freemem(buffermem,buffersize);
         getmem(buffermem,bufsize);
         if not assigned(buffermem) then
           buffersize:=0
         else buffersize:=bufsize;
      end;

    const
        { Vorgabegre fr Hilfsspeicher }
        bufferstandardsize = 64*8196;

    procedure InitGraph(var GraphDriver : integer;var GraphMode : integer;const PathToDriver : string);

      var
         i : longint;

      begin
         _graphresult:=grOk;
         if graphdriver<>detect then
           begin
           end;
         { Pfad zu den Fonts }
         bgipath:=PathToDriver;
         if bgipath[length(bgipath)]<>'\' then
           bgipath:=bgipath+'\';

         { Standartfonts installieren }
         InstallUserFont('TRIP');
         InstallUserFont('LITT');
         InstallUserFont('SANS');
         InstallUserFont('GOTH');
         InstallUserFont('SCRI');
         InstallUserFont('SIMP');
         InstallUserFont('TSCR');
         InstallUserFont('LCOM');
         InstallUserFont('EURO');
         InstallUserFont('BOLD');

         { Startmodus sichern }
         startmode:=getscreenmode;

         { Hilfsspeicher anfordern }
         SetGraphBufSize(bufferstandardsize);

         { nun in den Graphikmodus schalten }
         SetGraphmode(graphmode);
      end;

    { Dummyfunktion, BGI-Dateien werden -nicht- untersttzt }
    { es werden die Treiber des DOS-Externders verwendet    }
    function InstallUserDriver(const DriverFileName : string;AutoDetectPtr : pointer) : integer;

      begin
         _graphresult:=grOk;
         if not isgraphmode then
           begin
              isnographmode;
              InstallUserDriver:=grOK;
              exit;
           end;
      end;

    { dito. }
    function RegisterBGIdriver(driver : pointer) : integer;

      begin
         _graphresult:=grOk;
         if not isgraphmode then
           begin
              isnographmode;
              RegisterBGIdriver:=grOK;
              exit;
           end;
      end;

    procedure CloseGraph;

      var
         i : longint;

      begin
         _graphresult:=grOk;
         if not isgraphmode then
           begin
              isnographmode;
              exit;
           end;
         { den Graphikmodus setzen, der beim Start gesetzt war, }
         { falls wir im Graphikmodus sind                       }
         if isgraphmode then
            RestoreCrtMode;
      end;

    procedure RestoreCrtMode;

      begin
         _graphresult:=grOk;
         if not isgraphmode then
           begin
              isnographmode;
              exit;
           end;
         setscreenmode(startmode);

         { kein Graphikmodus eingeschaltet }
         isgraphmode:=false;
      end;

    function ImageSize(x1,y1,x2,y2 : integer) : word;

      begin
         _graphresult:=grOk;
         ImageSize:=(x2-x1+1)*(y2-y1+1)+4;
         { +4, da Breite und Hhe mit abgespeichert werden }
      end;

    procedure GetImage(x1,y1,x2,y2 : integer;var BitMap);

      type
         pinteger = ^integer;

      var
         nextpos,i,linesize : longint;

      begin
         { Standardeinleitung }
         _graphresult:=grOk;
         if not isgraphmode then
           begin
              isnographmode;
              exit;
           end;
         pinteger(@bitmap)^:=x2-x1+1;
         pinteger(@bitmap+2)^:=y2-y1+1;
         nextpos:=4;
         linesize:=x2-x1+1;
         for i:=y1 to y2 do
           begin
              move((rbuffer+(i*_maxx+x1))^,(pinteger(@bitmap)+nextpos)^,linesize);
              inc(nextpos,linesize);
           end;
      end;

    procedure PutImage(x,y : integer;var BitMap;BitBlt : word);

      type
         pinteger = ^integer;

      var
         height,width : integer;
         i,nextpos,j : longint;
         p,addr : ^byte;

      begin
         _graphresult:=grOk;
         if not isgraphmode then
           begin
              isnographmode;
              exit;
           end;
         width:=pinteger(@bitmap)^;
         height:=pinteger(@bitmap+2)^;
         case bitblt of
            normalput : begin
                           nextpos:=4;
                           for i:=y to y+height-1 do
                             begin
                                move((pinteger(@bitmap)+nextpos)^,(wbuffer+(i*_maxx+x))^,width);
                                inc(nextpos,width);
                             end;
                        end;
            xorput : begin
                        p:=@bitmap;
                        p:=p+4;
                        for i:=y to y+height-1 do
                          begin
                             addr:=wrbuffer+(i*_maxx+x);
                             for j:=x to x+width-1 do
                               begin
                                  addr^:=addr^ xor p^;
                                  addr:=addr+1;
                                  p:=p+1;
                               end;
                          end;
                     end;
            andput : begin
                        p:=@bitmap;
                        p:=p+4;
                        for i:=y to y+height-1 do
                          begin
                             addr:=wrbuffer+(i*_maxx+x);
                             for j:=x to x+width-1 do
                               begin
                                  addr^:=addr^ and p^;
                                  addr:=addr+1;
                                  p:=p+1;
                               end;
                          end;
                     end;
            orput : begin
                        p:=@bitmap;
                        p:=p+4;
                        for i:=y to y+height-1 do
                          begin
                             addr:=wrbuffer+(i*_maxx+x);
                             for j:=x to x+width-1 do
                               begin
                                  addr^:=addr^ or p^;
                                  addr:=addr+1;
                                  p:=p+1;
                               end;
                          end;
                     end;
            notput : begin
                        p:=@bitmap;
                        p:=p+4;
                        for i:=y to y+height-1 do
                          begin
                             addr:=wrbuffer+(i*_maxx+x);
                             for j:=x to x+width-1 do
                               begin
                                  addr^:=not(p^);
                                  addr:=addr+1;
                                  p:=p+1;
                               end;
                          end;
                     end;
         end;
      end;

    procedure SetWriteMode(WriteMode : integer);

      begin
         _graphresult:=grOk;
         if not isgraphmode then
           begin
              isnographmode;
              exit;
           end;
         if (writemode<>xorput) or (writemode<>normalput) then
           begin
              _graphresult:=grError;
              exit;
           end;
         aktwritemode:=writemode;
      end;

    procedure SetViewPort(x1,y1,x2,y2 : integer;clip : boolean);

      begin
         _graphresult:=grOk;
         if not isgraphmode then
           begin
              isnographmode;
              exit;
           end;
         { Daten berprfen }
         if (x1>=0) and (y1>=0) and (x2<_maxx) and (y2<_maxy) then
           begin
              aktviewport.x1:=x1;
              aktviewport.y1:=y1;
              aktviewport.x2:=x2;
              aktviewport.y2:=y2;
              aktviewport.clip:=clip;
           end;
      end;
      
    procedure GetViewSettings(var viewport : ViewPortType);

      begin
         _graphresult:=grOk;
         if not isgraphmode then
           begin
              isnographmode;
              exit;
           end;
         viewport:=aktviewport;
      end;

    procedure SetBkColor(ColorNum : word);

      begin
         _graphresult:=grOk;
         if not isgraphmode then
           begin
              isnographmode;
              exit;
           end;
         aktbackcolor:=colornum;
      end;

    procedure SetColor(color : word);

      begin
         _graphresult:=grOk;
         if not isgraphmode then
           begin
              isnographmode;
              exit;
           end;
         aktcolor:=color;
      end;

    function GetBkColor : word;

      begin
         _graphresult:=grOk;
         if not isgraphmode then
           begin
              isnographmode;
              exit;
           end;
         getbkcolor:=aktbackcolor;
      end;

    function GetColor : word;

      begin
         _graphresult:=grOk;
         if not isgraphmode then
           begin
              isnographmode;
              exit;
           end;
         getcolor:=aktcolor;
      end;

    procedure ClearViewPort;

       begin
         _graphresult:=grOk;
         if not isgraphmode then
           begin
              isnographmode;
              exit;
           end;
          {!!!!!!!!!}
       end;

    { mehrere Bildschirmseiten werden nicht untersttzt }
    { Dummy aus Kompatibilittsgrnden                  }
    procedure SetVisualPage(page : word);

      begin
         _graphresult:=grOk;
         if not isgraphmode then
           begin
              isnographmode;
              exit;
           end;
      end;

    { mehrere Bildschirmseiten werden nicht untersttzt }
    { Dummy aus Kompatibilittsgrnden                  }
    procedure SetActivePage(page : word);

      begin
         _graphresult:=grOk;
         if not isgraphmode then
           begin
              isnographmode;
              exit;
           end;
      end;

    procedure PutPixel(x,y : longint;pixel : word);

      begin
         _graphresult:=grOk;
         if not isgraphmode then
           begin
              isnographmode;
              exit;
           end;
         inc(x,aktviewport.x1);
         inc(y,aktviewport.y1);
         if aktviewport.Clip then
           begin
              if (x<aktviewport.x1) or
                 (y<aktviewport.y1) or
                 (x>aktviewport.x2) or
                 (y>aktviewport.y2) then
              exit;
           end;
         wbuffer[y*_maxx+x]:=pixel;
      end;

    function GetPixel(x,y : longint) : word;

      begin
         _graphresult:=grOk;
         if not isgraphmode then
           begin
              isnographmode;
              exit;
           end;
         getpixel:=rbuffer[y*_maxx+x];
      end;

    function GetX : longint;

      begin
         _graphresult:=grOk;
         if not isgraphmode then
           begin
              isnographmode;
              exit;
           end;
         GetX:=curx;
      end;

    function GetY : longint;

      begin
         _graphresult:=grOk;
         if not isgraphmode then
           begin
              isnographmode;
              exit;
           end;
         GetY:=cury;
      end;

    function GetMaxX : longint;

      begin
         _graphresult:=grOk;
         if not isgraphmode then
           begin
              isnographmode;
              exit;
           end;
         getmaxx:=_maxx-1;
      end;

    function GetMaxY : longint;

      begin
         _graphresult:=grOk;
         if not isgraphmode then
           begin
              isnographmode;
              exit;
           end;
         getmaxy:=_maxy;
      end;

    procedure MoveTo(x,y : longint);

      begin
         _graphresult:=grOk;
         if not isgraphmode then
           begin
              isnographmode;
              exit;
           end;
         curx:=x;
         cury:=y;
      end;

    procedure MoveRel(dx,dy : longint);

      begin
         _graphresult:=grOk;
         if not isgraphmode then
           begin
              isnographmode;
              exit;
           end;
         inc(curx,dx);
         inc(cury,dy);
      end;

    procedure LineTo(x,y : longint);

      begin
         _graphresult:=grOk;
         if not isgraphmode then
           begin
              isnographmode;
              exit;
           end;
         Line(curx,cury,x,y);
         MoveTo(x,y);
      end;

    procedure LineRel(dx,dy : longint);

      begin
         _graphresult:=grOk;
         if not isgraphmode then
           begin
              isnographmode;
              exit;
           end;
         Line(curx,cury,curx+dx,cury+dy);
         MoveRel(dx,dy);
      end;

    procedure Line(x1,y1,x2,y2 : longint);

      { wird nur fr dicke Linien verwendet }
      procedure dot(x,y : longint;color : word);

        begin
           if aktwritemode=normalput then
             putpixel(x,y,color)
           else if aktwritemode=xorput then
             putpixel(x,y,color xor getpixel(x,y));
        end;

      var
         step,delta,delta_x,delta_y,direction_x,direction_y : longint;
         _x,_y,wx,wy,wpos : longint;
         doclipping : boolean;

      begin
         if x1<x2 then direction_x:=1
         else direction_x:=-1;
         if y1<y2 then direction_y:=1
         else direction_y:=-1;
         delta_x:=abs(x1-x2);
         delta_y:=abs(y1-y2);
         wx:=x1+aktviewport.x1;
         wy:=y1+aktviewport.y1;
         wpos:=wy*_maxx+wx;
         doclipping:=not(aktviewport.clip);
         if (delta_x>=delta_y) then
           begin
              delta_y:=delta_y*2;
              delta:=delta_y-delta_x;
              delta_x:=delta_x*2;
              for step:=0 to delta_x div 2 do
                begin
                   if aktlineinfo.linestyle<>SolidLn then
                     begin
                        {!!!!!!!!!!}
                     end;
                   if doclipping or
                     ((wx>=aktviewport.x1) and (wy>=aktviewport.y1) and
                      (wx<=aktviewport.x2) and (wy<=aktviewport.y2)) then
                      if aktwritemode=normalput then
                        wbuffer[wpos]:=aktcolor
                      else if aktwritemode=xorput then
                        wbuffer[wpos]:=aktcolor xor wbuffer[wpos];
                   if aktlineinfo.thickness=3 then
                     begin
                        for _x:=-1 to 1 do
                          for _y:=-1 to 1 do
                            dot(x1+_x,y1+_y,aktcolor);
                     end;
                   if delta>0 then
                     begin
                        y1:=y1+direction_y;
                        if direction_y>0 then
                          wpos:=wpos+_maxx
                        else wpos:=wpos-_maxx;
                        delta:=delta-delta_x;
                        {???
                        dec(delta,delta_x);
                        }
                     end;
                   delta:=delta+delta_y;
                   x1:=x1+direction_x;
                   if direction_x>0 then
                     inc(wpos)
                   else dec(wpos)
                   {???
                   inc(delta,delta_y);
                   inc(x1,direction_x);
                   }
                end;
           end
         else
           begin
              delta_x:=delta_x*2;
              delta:=delta_x-delta_y;
              delta_y:=delta_y*2;
              for step:=0 to delta_y div 2 do
                begin
                   if aktlineinfo.linestyle<>SolidLn then
                     begin
                        {!!!!!!!!!!}
                     end;
                   if doclipping or
                     ((wx>=aktviewport.x1) and (wy>=aktviewport.y1) and
                      (wx<=aktviewport.x2) and (wy<=aktviewport.y2)) then
                      if aktwritemode=normalput then
                        wbuffer[wpos]:=aktcolor
                      else if aktwritemode=xorput then
                        wbuffer[wpos]:=aktcolor xor wbuffer[wpos];
                   if aktlineinfo.thickness=3 then
                     begin
                        for _x:=-1 to 1 do
                          for _y:=-1 to 1 do
                            dot(x1+_x,y1+_y,aktcolor);
                     end;
                   if delta>0 then
                     begin
                        x1:=x1+direction_x;
                        if direction_x>0 then
                          inc(wpos)
                        else dec(wpos);
                        delta:=delta-delta_y;
                        {??? dec(delta,delta_y);}
                     end;
                   delta:=delta+delta_x;
                   y1:=y1+direction_y;
                   if direction_y>0 then
                     wpos:=wpos+_maxx
                   else wpos:=wpos-_maxx;
                   {???
                   inc(delta,delta_x);
                   inc(y1,direction_y);
                   }
                end;
           end;
      end;

    procedure GetLineSettings(var LineInfo : LineSettingsType);

      begin
         _graphresult:=grOk;
         if not isgraphmode then
           begin
              isnographmode;
              exit;
           end;
         lineinfo:=aktlineinfo;
      end;

    procedure SetLineStyle(LineStyle : word;pattern : word;thickness : word);

      const
         linepatterns : array[0..3] of word =
           ($ffff,$aaaa,$fafa,$ffff);

      begin
         _graphresult:=grOk;
         if not isgraphmode then
           begin
              isnographmode;
              exit;
           end;
         if (linestyle<0) or (linestyle>4) or
           ((thickness<>1) and (thickness<>3)) then
           begin
              _graphresult:=grerror;
              exit;
           end;
         aktlineinfo.linestyle:=linestyle;
         if aktlineinfo.linestyle=UserBitLn then
           aktlineinfo.pattern:=pattern
         else
           aktlineinfo.pattern:=linepatterns[aktlineinfo.linestyle];
         aktlineinfo.thickness:=thickness;
      end;

    procedure Rectangle(x1,y1,x2,y2 : integer);

      begin
         line(x1,y1,x2,y1);
         line(x2,y1,x2,y2);
         line(x2,y2,x1,y2);
         line(x1,y2,x1,y1);
      end;

    function GraphErrorMsg(ErrorCode : integer) : String;

      begin
         case errorcode of
            grOk : grapherrormsg:='Fehlerfreie Ausfhrung';
            grNoInitGraph : grapherrormsg:='Graphiktreiber nicht geladen';
            grNotDetected : grapherrormsg:='Kein graphikfhiger Adapter vorhanden';
            grFileNotFound : grapherrormsg:='Graphiktreiberdatei nicht gefunden';
            grInvalidDriver : grapherrormsg:='Graphiktreiberdatei defekt';
            grNoLoadMem : grapherrormsg:='Zu wenig Hauptspeicher fr Graphiktreiber';
            grNoScanMem : grapherrormsg:='Zu wenig Hauptspeicher fr Bar, FillPoly, PieSlice oder Sector';
            grNoFloodMem : grapherrormsg:='Zu wenig Hauptspeicher fr FloodFill';
            grFontNotFound : grapherrormsg:='Schrift-Datei nicht gefunden';
            grNoFontMem : grapherrormsg:='Zu wenig Hauptspeicher fr die Schrift';
            grInvalidMode : grapherrormsg:='Graphikmodus wird vom Treiber nicht untersttzt';
            grError : grapherrormsg:='Nicht nher klassifizierbarer Fehler';
            grIOerror : grapherrormsg:='Ein-/Ausgabefehler beim Laden von Dateien';
            grInvalidFont : grapherrormsg:='Schriftdatei ungltig';
            grInvalidFontNum : grapherrormsg:='Kennziffer fr Zeichensatz nicht definiert';
            grInvalidVersion : grapherrormsg:='Ungltige Version der Schrift-Datei';
         end;
      end;
      
    function GraphResult : integer;
    
      begin
         graphresult:=_graphresult;
      end;
      
    procedure GetFillSettings(var FillInfo : FillSettingsType);
    
      begin
         _graphresult:=grOk;
         if not isgraphmode then
           begin
              isnographmode;
              exit;
           end;
         fillinfo:=aktfillsettings;
      end;

    procedure GetFillPattern(var FillPattern : FillPatternType);

      begin
         _graphresult:=grOk;
         if not isgraphmode then
           begin
              isnographmode;
              exit;
           end;
         fillpattern:=aktfillpattern;
      end;

    procedure SetFillStyle(pattern : word;color : word);

      begin
         _graphresult:=grOk;
         if not isgraphmode then
           begin
              isnographmode;
              exit;
           end;
         { gltige Paramter ? }
         if (pattern<0) or (pattern>12) then
           begin
              _graphresult:=grError;
              exit;
           end;
         { Muster laden }
         aktfillpattern:=fillpattern[pattern];
         aktfillsettings.pattern:=pattern;
         aktfillsettings.color:=color;
      end;

    procedure SetFillPattern(pattern : FillPatternType;color : word);

      begin
         _graphresult:=grOk;
         if not isgraphmode then
           begin
              isnographmode;
              exit;
           end;
         aktfillpattern:=pattern;
         fillpattern[12]:=pattern;
         aktfillsettings.pattern:=12;
         aktfillsettings.color:=color;
      end;

    procedure FloodFill(x,y : integer;border : word);

      var
         points,hx,hy : longint;

      type
         pword = ^word;

      begin
         _graphresult:=grOk;
         if not isgraphmode then
           begin
              isnographmode;
              exit;
           end;
         points:=4;
         if buffersize=0 then
           begin
              _graphresult:=grNoFloodMem;
              exit;
           end;
         pword(buffermem)[0]:=x;
         pword(buffermem)[2]:=y;
         while points>=0 do
           begin
              { Stack prfen }
              if buffersize<(points+8)*sizeof(word) then
                begin
                   _graphresult:=grNoFloodMem;
                   exit;
                end;
              { Punkt auslesen }
              hx:=pword(buffermem)[points-4];
              hy:=pword(buffermem)[points-2];
              points:=points-4;
              { Pixel setzen }
              putpixel(hx,hy,aktfillsettings.color);
              { Nachbarn prfen }
              if (hx<aktviewport.x2) and (getpixel(hx+1,hy)<>border) and
                 (getpixel(hx+1,hy)<>aktfillsettings.color) then
                begin
                   pword(buffermem)[points]:=hx+1;
                   pword(buffermem)[points+2]:=hy;
                   points:=points+4;
                end;
              if (hx>aktviewport.x1) and (getpixel(hx-1,hy)<>border) and
                 (getpixel(hx-1,hy)<>aktfillsettings.color) then
                begin
                   pword(buffermem)[points]:=hx-1;
                   pword(buffermem)[points+2]:=hy;
                   points:=points+4;
                end;
              if (hy<aktviewport.y2) and (getpixel(hx,hy+1)<>border) and
                 (getpixel(hx,hy+1)<>aktfillsettings.color) then
                begin
                   pword(buffermem)[points]:=hx;
                   pword(buffermem)[points+2]:=hy+1;
                   points:=points+4;
                end;
              if (hy>aktviewport.y1) and (getpixel(hx,hy-1)<>border) and
                 (getpixel(hx,hy-1)<>aktfillsettings.color) then
                begin
                   pword(buffermem)[points]:=hx;
                   pword(buffermem)[points+2]:=hy-1;
                   points:=points+4;
                end;
           end;
      end;

    procedure checkkoords(var x1,y1,x2,y2 : integer);

      begin
         { nur Werte>=0 zulassen }
         if x1<0 then x1:=0;
         if x2<0 then x2:=0;
         if y1<0 then y1:=0;
         if y2<0 then y2:=0;
         { auf Bildschirmkoordinaten umrechnen }
         inc(x1,aktviewport.x1);
         inc(y1,aktviewport.y1);
         inc(x2,aktviewport.x1);
         inc(y2,aktviewport.y1);
         { falls gewnscht Clipping durchfhren }
         if aktviewport.clip then
           begin
              if x1>aktviewport.x2 then x1:=aktviewport.x2;
              if y1>aktviewport.y2 then y1:=aktviewport.y2;
              if x2>aktviewport.x2 then x2:=aktviewport.x2;
              if y2>aktviewport.y2 then x1:=aktviewport.y2;
           end;
      end;

    procedure bar(x1,y1,x2,y2 : integer);

      var
         x,y : longint;
         hcolor,mask,patternline : byte;

      begin
         _graphresult:=grOk;
         if not isgraphmode then
           begin
              isnographmode;
              exit;
           end;
         checkkoords(x1,y1,x2,y2);
         case aktfillsettings.pattern of
            0,1 : begin
                     { kleine Mogelei, um eine hohe Ausgabegeschwindigkeit }
                     { bei den wohl am meisten verwendeten Mustern zu      }
                     { erreichen                                           }
                     if aktfillsettings.pattern=1 then
                       hcolor:=aktfillsettings.color
                     else
                       hcolor:=aktbackcolor;
                     for y:=y1 to y2 do
                       fillchar(wbuffer[y*_maxx+x1],x2-x1+1,hcolor);
                  end;
            else
               begin
                  patternline:=1;
                  for y:=y1 to y2 do
                    begin
                       mask:=$80;
                       for x:=x1 to x2 do
                         begin
                            if (aktfillpattern[patternline] and mask)<>0 then
                              wbuffer[y*_maxx+x]:=aktfillsettings.color
                            else
                              wbuffer[y*_maxx+x]:=aktbackcolor;
                            mask:=mask shr 1;
                            if mask=0 then
                              mask:=$80
                         end;
                       inc(patternline);
                       if patternline>8 then
                         patternline:=1;
                    end;
               end;
          end;
      end;

{***************************************************************************}
{                               Textausgabe                                 }
{***************************************************************************}

    const
       { maximal 16 Vektorfonts untersttzen }
       { um mehr Fonts laden zu knnen, mu  }
       { diese Variable erhht werden        }
       maxfonts = 16;

    type
       pword = ^word;
       pbyte = ^byte;

    {$PACKRECORDS 1}
       pfontdata = ^tfontdata;

       tfontdata = record
          filetyp : char;
          nr_chars : word;
          undefined1 : byte;
          value_first_char : byte;
          undefined2 : array[1..3] of byte;
          dist_origin_top : byte;
          dist_origin_baseline : byte;
          dist_origin_bottom : byte;
          undefined3 : array[91..95] of byte;
       end;

    {$PACKRECORDS NORMAL}

       tfontrec = record
          name : string[8];
          data : pointer;
          header : pfontdata;
          offsets : pword;
          widths : pbyte;
          instr : pbyte;
       end;

    var
       fonts : array[1..maxfonts] of tfontrec;
       installedfonts : longint;
       defaultfontdata : array[0..2047] of byte;

    { gibt true zurck, wenn p auf eine gltige Fontdatei zeigt }

    function testfont(p : pointer) : boolean;

      begin
         testfont:=(pchar(p)^='P') and
          (pchar(p+1)^='K') and
          (pchar(p+2)^=#8) and
          (pchar(p+3)^=#8);
      end;

    { setzt die Hilfsdaten fr den Font mit der Nr. font }
    { der Zeiger data mu schon gesetzt sein             }

    function setupfont(font : word) : integer;

      begin
         setupfont:=grOK;
         fonts[font].header:=fonts[font].data+$80;
         if fonts[font].header^.filetyp<>'+' then
           begin
              setupfont:=grInvalidFont;
              exit;
           end;
         fonts[font].offsets:=fonts[font].data+$90;
         fonts[font].widths:=pbyte(fonts[font].offsets+fonts[font].header^.nr_chars*2);
         fonts[font].instr:=fonts[font].widths+fonts[font].header^.nr_chars;
      end;

    function InstallUserFont(const FontFileName : string) : integer;

      begin
         _graphresult:=grOk;
         { es mu kein Graphikmodus gesetzt sein! }
         { ist noch Platz fr einen Font ? }
         if installedfonts=maxfonts then
           begin
              _graphresult:=grError;
              exit;
           end;
         inc(installedfonts);
         fonts[installedfonts].name:=FontFileName;
         fonts[installedfonts].data:=nil;
         InstallUserFont:=installedfonts;
      end;

    function RegisterBGIfont(font : pointer) : integer;

      var
         hp : pbyte;
         b : word;
         name : string[12];

      begin
         { noch nicht garantiert, da alles klappt }
         RegisterBGIfont:=grInvalidFontNum;
         { es mu kein Graphikmodus gesetzt sein! }
         if testfont(font) then
           begin
              hp:=pbyte(font);
              { Ende des Textheaders suchen }
              while hp^<>$1a do
                hp:=hp+1;
              { auf Start des Names springen }
              hp:=hp+3;
              { Namen lesen }
              name:='';
              for b:=0 to 3 do
                name:=name+char((hp+b)^);
              { richtigen Font suchen }
              for b:=1 to installedfonts do
                begin
                   if fonts[b].name=name then
                     begin
                        fonts[b].data:=font;
                        RegisterBGIfont:=grOK;
                        RegisterBGIfont:=setupfont(b);
                     end;
                end;
           end
         else
           RegisterBGIFont:=grInvalidFont;
      end;

    procedure GetTextSettings(var TextInfo : TextSettingsType);

      begin
         _graphresult:=grOk;
         if not isgraphmode then
           begin
              isnographmode;
              exit;
           end;
         textinfo:=akttextinfo;
      end;

    procedure OutText(const TextString : string);

      begin
         _graphresult:=grOk;
         if not isgraphmode then
           begin
              isnographmode;
              exit;
           end;
         OutTextXY(curx,cury,TextString);
         { wenn horizontal und linksbndig ausgegeben wird, dann }
         { Grafikcursor nachfhren }
         if (akttextinfo.direction=HorizDir) and
           (akttextinfo.horiz=LeftText) then
               inc(curx,textwidth(TextString));
      end;

    procedure OutTextXY(x,y : integer;const TextString : string);

      var
         b1,b2,c,instr : byte;
         i : longint;
         oldvalues : linesettingstype;
         nextpos : word;
         xpos,ypos : longint;

      begin
         _graphresult:=grOk;
         if not isgraphmode then
           begin
              isnographmode;
              exit;
           end;
         { wirkliche x- und y-Startposition berechnen }
         { !!!! }
         if akttextinfo.font=DefaultFont then
           begin
              {!!!}
           end
         else
           begin
              { Linienstil setzen }
              getlinesettings(oldvalues);
              setlinestyle(solidln,oldvalues.pattern,normwidth);
              moveto(xpos,ypos);
              for i:=1 to length(textstring) do
                begin
                   c:=byte(textstring[i]);
                   dec(c,fonts[akttextinfo.font].header^.value_first_char);
                   { definiertes Zeichen ? }
                   if (c<0) or (c>=fonts[akttextinfo.font].header^.nr_chars) then
                     continue;
                   nextpos:=fonts[akttextinfo.font].offsets[c];
                   while true do
                     begin
                         b1:=fonts[akttextinfo.font].instr[nextpos];
                         inc(nextpos);
                         b2:=fonts[akttextinfo.font].instr[nextpos];
                         inc(nextpos);
                         instr:=((b1 and $80) shr 6)+((b2 and $80) shr 7);
                         b1:=b1 and $7f;
                         b2:=b2 and $7f;
                         { Vorzeichen erweitern }
                         if (b1 and $40)<>0 then
                           b1:=b1 or $80;
                         if (b2 and $40)<>0 then
                           b2:=b2 or $80;
                         { neue Stiftposition berechnen und skalieren }
                         if akttextinfo.direction=VertDir then
                           begin
                              xpos:=x+(b2*aktmultx) div aktdivx;
                              ypos:=y+(b1*aktmulty) div aktdivy;
                           end
                         else
                           begin
                              xpos:=x+(b1*aktmultx) div aktdivx;
                              ypos:=y-(b2*aktmulty) div aktdivy;
                           end;
                         case instr of
                            0 : break;
                            2 : moveto(xpos,ypos);
                            3 : lineto(xpos,ypos);
                         end;
                     end;
                   if akttextinfo.direction=VertDir then
                     inc(y,(fonts[akttextinfo.font].widths[c]*aktmultx) div aktdivx)
                   else
                     inc(x,(fonts[akttextinfo.font].widths[c]*aktmultx) div aktdivx);
                end;
              setlinestyle(oldvalues.linestyle,oldvalues.pattern,oldvalues.thickness);
           end;
      end;

    function TextHeight(const TextString : string) : word;

      begin
         _graphresult:=grOk;
         if not isgraphmode then
           begin
              isnographmode;
              exit;
           end;
         case akttextinfo.font of
            DefaultFont : TextHeight:=8*akttextinfo.charsize;
            else
              TextHeight:=fonts[akttextinfo.font].header^.dist_origin_top-
                fonts[akttextinfo.font].header^.dist_origin_bottom;
         end;
      end;

    function TextWidth(const TextString : string) : word;

      begin
         _graphresult:=grOk;
         if not isgraphmode then
           begin
              isnographmode;
              exit;
           end;
         case akttextinfo.font of
            DefaultFont : TextWidth:=length(TextString)*8*akttextinfo.charsize;
            else
               begin
                  {!!!!!!}
               end;
         end;
      end;

    procedure SetTextJustify(horiz,vert : word);

      begin
         _graphresult:=grOk;
         if not isgraphmode then
           begin
              isnographmode;
              exit;
           end;
         if (horiz<0) or (horiz>2) or
            (vert<0) or (vert>2) then
           begin
              _graphresult:=grError;
              exit;
           end;
         akttextinfo.horiz:=horiz;
         akttextinfo.vert:=vert;
      end;

    procedure SetTextStyle(font,direction : word;charsize : word);

      var
         f : file;

      begin
         _graphresult:=grOk;
         if not isgraphmode then
           begin
              isnographmode;
              exit;
           end;
         { Parameter auf Gltigkeit berprfen }
         if font>installedfonts then
           begin
              _graphresult:=grInvalidFontNum;
              exit;
           end;
         akttextinfo.font:=font;
         if (direction<>HorizDir) or (direction<>VertDir) then
           direction:=HorizDir;
         akttextinfo.direction:=direction;
         akttextinfo.charsize:=charsize;
         { Skalierungsfaktoren auch setzen,  }
         { charsize wird nur bei der Ausgabe }
         { des Defaultfont ausgewertet       }
         aktmultx:=charsize;
         aktdivx:=1;
         aktmulty:=charsize;
         aktdivy:=1;
         { Fontdatei laden ? }
         if (font>0) and not assigned(fonts[font].data) then
           begin
              assign(f,bgipath+fonts[font].name+'.CHR');
              reset(f,1);
              if ioresult<>0 then
                begin
                   _graphresult:=grFontNotFound;
                   akttextinfo.font:=DefaultFont;
                   exit;
                end;
              getmem(fonts[font].data,filesize(f));
              if not assigned(fonts[font].data) then
                begin
                   _graphresult:=grNoFontMem;
                   akttextinfo.font:=DefaultFont;
                   exit;
                end;
              blockread(f,fonts[font].data^,filesize(f));

              if testfont(fonts[font].data) then
                _graphresult:=setupfont(font)
              else
                begin
                   _graphresult:=grInvalidFont;
                   akttextinfo.font:=DefaultFont;
                   freemem(fonts[font].data,filesize(f));
                end;
              close(f);
           end;
      end;

    procedure SetUserCharSize(Multx,Divx,Multy,Divy : word);

      begin
         _graphresult:=grOk;
         if not isgraphmode then
           begin
              isnographmode;
              exit;
           end;
         aktmultx:=Multx;
         aktdivx:=Divx;
         aktmulty:=Multy;
         aktdivy:=Divy;
      end;

    function getfontpointer(b : byte) : pointer;

      begin
         asm
            movw $0x1130,%ax
            movb 8(%ebp),%bh
            pushl %ebp
            int $0x10
            movl %ebp,%eax
            pop %ebp
            leave
            ret $2
         end;
      end;

begin
   { Bufferadressen setzen }
   wrbuffer:=pointer($d0000000);
   rbuffer:=pointer($d0100000);
   wbuffer:=pointer($d0200000);

   { noch kein Graphikmodus gesetzt }
   isgraphmode:=false;

   { keine Fonts installiert }
   installedfonts:=0;

   { 8x8-Defaultfont aus BIOS laden }
   move(getfontpointer(3)^,defaultfontdata[0],1024);
   move(getfontpointer(4)^,defaultfontdata[1024],1024);

   { Speicher ber Standardfunktionen anfordern }
   GraphGetMemPtr:=@system.getmem;
   GraphFreeMemPtr:=@system.freemem;

   { noch kein Speicher angefordert }
   buffermem:=nil;
   buffersize:=0;
end.
